/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;

public interface SDFItem {
    public String getContentAsString();

    default public String format(String format, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof SDFItem)) continue;
            args[i] = ((SDFItem)args[i]).getContentAsString();
        }
        return String.format(format, args);
    }

    default public String itemToString() {
        return this.getClass().getSimpleName() + ": " + this.getContentAsString();
    }

    public List<? extends SDFURIHolder> getURIHolders();

    public static List<SDFURIHolder> combineItemURIHolders(SDFItem ... sdfItems) {
        if (sdfItems == null || sdfItems.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SDFURIHolder> uriHolders = new ArrayList<SDFURIHolder>();
        for (SDFItem urdfItem : sdfItems) {
            if (urdfItem == null) continue;
            uriHolders.addAll(urdfItem.getURIHolders());
        }
        return uriHolders;
    }

    @SafeVarargs
    public static List<SDFURIHolder> combineItemListsURIHolders(List<? extends SDFItem> ... sdfItemLists) {
        if (sdfItemLists == null || sdfItemLists.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SDFURIHolder> uriHolders = new ArrayList<SDFURIHolder>();
        for (List<? extends SDFItem> urdfItemList : sdfItemLists) {
            if (urdfItemList == null) continue;
            for (SDFItem sDFItem : urdfItemList) {
                if (sDFItem == null) continue;
                uriHolders.addAll(sDFItem.getURIHolders());
            }
        }
        return uriHolders;
    }
}

