/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.scs2.definition.controller.interfaces.ControllerOutputBasics;
import us.ihmc.scs2.definition.state.JointState;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;

public class ControllerOutput
implements ControllerOutputBasics {
    private final MultiBodySystemReadOnly input;
    private final JointStateBasics[] jointOutputs;
    private final Map<String, JointStateBasics> jointOutputMap = new HashMap<String, JointStateBasics>();

    public ControllerOutput(MultiBodySystemReadOnly input) {
        this.input = input;
        List allJoints = input.getAllJoints();
        this.jointOutputs = new JointStateBasics[allJoints.size()];
        for (int i = 0; i < allJoints.size(); ++i) {
            JointReadOnly joint = (JointReadOnly)allJoints.get(i);
            JointStateBase output = joint instanceof OneDoFJointReadOnly ? new OneDoFJointState() : new JointState(joint.getConfigurationMatrixSize(), joint.getDegreesOfFreedom());
            this.jointOutputs[i] = output;
            this.jointOutputMap.put(joint.getName(), output);
        }
    }

    @Override
    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    @Override
    public JointStateBasics getJointOutput(String jointName) {
        return this.jointOutputMap.get(jointName);
    }

    @Override
    public JointStateBasics[] getJointOuputs() {
        return this.jointOutputs;
    }
}

