/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Ellipsoid3DDefinition
extends GeometryDefinition {
    private double radiusX;
    private double radiusY;
    private double radiusZ;
    private int resolution = 64;

    public Ellipsoid3DDefinition() {
        this.setName("ellipsoid");
    }

    public Ellipsoid3DDefinition(double radiusX, double radiusY, double radiusZ) {
        this();
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
    }

    public Ellipsoid3DDefinition(double radiusX, double radiusY, double radiusZ, int resolution) {
        this();
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.resolution = resolution;
    }

    public Ellipsoid3DDefinition(Tuple3DReadOnly radii) {
        this(radii.getX(), radii.getY(), radii.getZ());
    }

    public Ellipsoid3DDefinition(Tuple3DReadOnly radii, int resolution) {
        this(radii.getX(), radii.getY(), radii.getZ(), resolution);
    }

    public Ellipsoid3DDefinition(Ellipsoid3DDefinition other) {
        this.setName(other.getName());
        this.radiusX = other.radiusX;
        this.radiusY = other.radiusY;
        this.radiusZ = other.radiusZ;
        this.resolution = other.resolution;
    }

    public boolean isSphere() {
        return this.radiusX == this.radiusY && this.radiusX == this.radiusZ;
    }

    @XmlElement
    public void setRadiusX(double radiusX) {
        this.radiusX = radiusX;
    }

    @XmlElement
    public void setRadiusY(double radiusY) {
        this.radiusY = radiusY;
    }

    @XmlElement
    public void setRadiusZ(double radiusZ) {
        this.radiusZ = radiusZ;
    }

    public void setRadii(double radiusX, double radiusY, double radiusZ) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public Ellipsoid3DDefinition copy() {
        return new Ellipsoid3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.resolution);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Ellipsoid3DDefinition other = (Ellipsoid3DDefinition)object;
        if (Double.doubleToLongBits(this.radiusX) != Double.doubleToLongBits(other.radiusX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.radiusY) != Double.doubleToLongBits(other.radiusY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.radiusZ) != Double.doubleToLongBits(other.radiusZ)) {
            return false;
        }
        return this.resolution == other.resolution;
    }

    public String toString() {
        return EuclidCoreIOTools.getStringOf((String)("Ellipsoid: [name: " + this.getName() + ", radii: ("), (String)("), resolution: " + this.resolution + "]"), (String)", ", (double[])new double[]{this.radiusX, this.radiusY, this.radiusZ});
    }
}

