/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.Ramp3DDefinition;

public class STPRamp3DDefinition
extends Ramp3DDefinition {
    private double minimumMargin;
    private double maximumMargin;

    public STPRamp3DDefinition() {
    }

    public STPRamp3DDefinition(double sizeX, double sizeY, double sizeZ) {
        super(sizeX, sizeY, sizeZ);
    }

    public STPRamp3DDefinition(Tuple3DReadOnly size) {
        super(size);
    }

    public STPRamp3DDefinition(STPRamp3DDefinition other) {
        super(other);
        this.setMargins(other.minimumMargin, other.maximumMargin);
    }

    public void setMargins(double minimumMargin, double maximumMargin) {
        this.setMinimumMargin(minimumMargin);
        this.setMaximumMargin(maximumMargin);
    }

    @XmlElement
    public void setMinimumMargin(double minimumMargin) {
        this.minimumMargin = minimumMargin;
    }

    @XmlElement
    public void setMaximumMargin(double maximumMargin) {
        this.maximumMargin = maximumMargin;
    }

    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public STPRamp3DDefinition copy() {
        return new STPRamp3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.minimumMargin);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.maximumMargin);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        STPRamp3DDefinition other = (STPRamp3DDefinition)object;
        if (Double.doubleToLongBits(this.minimumMargin) != Double.doubleToLongBits(other.minimumMargin)) {
            return false;
        }
        return Double.doubleToLongBits(this.maximumMargin) == Double.doubleToLongBits(other.maximumMargin);
    }

    @Override
    public String toString() {
        return "STP" + super.toString().replace("]", "") + EuclidCoreIOTools.getStringOf((String)", margins: (", (String)")]", (String)", ", (double[])new double[]{this.minimumMargin, this.maximumMargin});
    }
}

