/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.LidarSensorDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.sdf.items.SDFRoot;
import us.ihmc.scs2.definition.robot.urdf.URDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class ValkyrieModelLoadingTest {
    private static final double EPSILON = 1.0E-5;
    private static final String LeftHipYawName = "leftHipYaw";
    private static final String LeftHipRollName = "leftHipRoll";
    private static final String LeftHipPitchName = "leftHipPitch";
    private static final String LeftKneePitchName = "leftKneePitch";
    private static final String LeftAnklePitchName = "leftAnklePitch";
    private static final String LeftAnkleRollName = "leftAnkleRoll";
    private static final String RightHipYawName = "rightHipYaw";
    private static final String RightHipRollName = "rightHipRoll";
    private static final String RightHipPitchName = "rightHipPitch";
    private static final String RightKneePitchName = "rightKneePitch";
    private static final String RightAnklePitchName = "rightAnklePitch";
    private static final String RightAnkleRollName = "rightAnkleRoll";
    private static final String TorsoYawName = "torsoYaw";
    private static final String TorsoPitchName = "torsoPitch";
    private static final String TorsoRollName = "torsoRoll";
    private static final String NeckLowerPitchName = "lowerNeckPitch";
    private static final String NeckYawName = "neckYaw";
    private static final String NeckUpperPitchName = "upperNeckPitch";
    private static final String HokuyoJointName = "hokuyo_joint";
    private static final String LeftShoulderPitchName = "leftShoulderPitch";
    private static final String LeftShoulderRollName = "leftShoulderRoll";
    private static final String LeftShoulderYawName = "leftShoulderYaw";
    private static final String LeftElbowPitchName = "leftElbowPitch";
    private static final String LeftForearmYawName = "leftForearmYaw";
    private static final String LeftWristPitchName = "leftWristPitch";
    private static final String LeftWristRollName = "leftWristRoll";
    private static final String RightShoulderPitchName = "rightShoulderPitch";
    private static final String RightShoulderRollName = "rightShoulderRoll";
    private static final String RightShoulderYawName = "rightShoulderYaw";
    private static final String RightElbowPitchName = "rightElbowPitch";
    private static final String RightForearmYawName = "rightForearmYaw";
    private static final String RightWristPitchName = "rightWristPitch";
    private static final String RightWristRollName = "rightWristRoll";
    private static final String PelvisName = "pelvis";
    private static final String LeftHipYawLinkName = "leftHipYawLink";
    private static final String LeftHipRollLinkName = "leftHipRollLink";
    private static final String LeftHipPitchLinkName = "leftHipPitchLink";
    private static final String LeftKneePitchLinkName = "leftKneePitchLink";
    private static final String LeftAnklePitchLinkName = "leftAnklePitchLink";
    private static final String LeftFootName = "leftFoot";
    private static final String RightHipYawLinkName = "rightHipYawLink";
    private static final String RightHipRollLinkName = "rightHipRollLink";
    private static final String RightHipPitchLinkName = "rightHipPitchLink";
    private static final String RightKneePitchLinkName = "rightKneePitchLink";
    private static final String RightAnklePitchLinkName = "rightAnklePitchLink";
    private static final String RightFootName = "rightFoot";
    private static final String TorsoYawLinkName = "torsoYawLink";
    private static final String TorsoPitchLinkName = "torsoPitchLink";
    private static final String TorsoName = "torso";
    private static final String NeckLowerPitchLinkName = "lowerNeckPitchLink";
    private static final String NeckYawLinkName = "neckYawLink";
    private static final String NeckUpperPitchLinkName = "upperNeckPitchLink";
    private static final String HokuyoLinkName = "hokuyo_link";
    private static final String LeftShoulderPitchLinkName = "leftShoulderPitchLink";
    private static final String LeftShoulderRollLinkName = "leftShoulderRollLink";
    private static final String LeftShoulderYawLinkName = "leftShoulderYawLink";
    private static final String LeftElbowPitchLinkName = "leftElbowPitchLink";
    private static final String LeftForearmLinkName = "leftForearmLink";
    private static final String LeftWristRollLinkName = "leftWristRollLink";
    private static final String LeftPalmName = "leftPalm";
    private static final String RightShoulderPitchLinkName = "rightShoulderPitchLink";
    private static final String RightShoulderRollLinkName = "rightShoulderRollLink";
    private static final String RightShoulderYawLinkName = "rightShoulderYawLink";
    private static final String RightElbowPitchLinkName = "rightElbowPitchLink";
    private static final String RightForearmLinkName = "rightForearmLink";
    private static final String RightWristRollLinkName = "rightWristRollLink";
    private static final String RightPalmName = "rightPalm";
    private static final String[] LeftLegJointNames = new String[]{"leftHipYaw", "leftHipRoll", "leftHipPitch", "leftKneePitch", "leftAnklePitch", "leftAnkleRoll"};
    private static final String[] RightLegJointNames = new String[]{"rightHipYaw", "rightHipRoll", "rightHipPitch", "rightKneePitch", "rightAnklePitch", "rightAnkleRoll"};
    private static final String[] TorsoJointNames = new String[]{"torsoYaw", "torsoPitch", "torsoRoll"};
    private static final String[] NeckJointNames = new String[]{"lowerNeckPitch", "neckYaw", "upperNeckPitch"};
    private static final String[] LeftArmJointNames = new String[]{"leftShoulderPitch", "leftShoulderRoll", "leftShoulderYaw", "leftElbowPitch", "leftForearmYaw", "leftWristRoll", "leftWristPitch"};
    private static final String[] LeftIndexFingerJointNames = new String[]{"leftIndexFingerPitch1", "leftIndexFingerPitch2", "leftIndexFingerPitch3"};
    private static final String[] LeftMiddleFingerJointNames = new String[]{"leftMiddleFingerPitch1", "leftMiddleFingerPitch2", "leftMiddleFingerPitch3"};
    private static final String[] LeftPinkyJointNames = new String[]{"leftPinkyPitch1", "leftPinkyPitch2", "leftPinkyPitch3"};
    private static final String[] LeftThumbJointNames = new String[]{"leftThumbRoll", "leftThumbPitch1", "leftThumbPitch2", "leftThumbPitch3"};
    private static final String[] RightArmJointNames = new String[]{"rightShoulderPitch", "rightShoulderRoll", "rightShoulderYaw", "rightElbowPitch", "rightForearmYaw", "rightWristRoll", "rightWristPitch"};
    private static final String[] RightIndexFingerJointNames = new String[]{"rightIndexFingerPitch1", "rightIndexFingerPitch2", "rightIndexFingerPitch3"};
    private static final String[] RightMiddleFingerJointNames = new String[]{"rightMiddleFingerPitch1", "rightMiddleFingerPitch2", "rightMiddleFingerPitch3"};
    private static final String[] RightPinkyJointNames = new String[]{"rightPinkyPitch1", "rightPinkyPitch2", "rightPinkyPitch3"};
    private static final String[] RightThumbJointNames = new String[]{"rightThumbRoll", "rightThumbPitch1", "rightThumbPitch2", "rightThumbPitch3"};
    private static final String[] AllJointNames = ValkyrieModelLoadingTest.concatenate({"pelvis", "hokuyo_joint"}, LeftLegJointNames, RightLegJointNames, TorsoJointNames, NeckJointNames, LeftArmJointNames, LeftIndexFingerJointNames, LeftMiddleFingerJointNames, LeftPinkyJointNames, LeftThumbJointNames, RightArmJointNames, RightIndexFingerJointNames, RightMiddleFingerJointNames, RightPinkyJointNames, RightThumbJointNames);
    private static final String[] LeftLegLinkNames = new String[]{"leftHipYawLink", "leftHipRollLink", "leftHipPitchLink", "leftKneePitchLink", "leftAnklePitchLink", "leftFoot"};
    private static final String[] RightLegLinkNames = new String[]{"rightHipYawLink", "rightHipRollLink", "rightHipPitchLink", "rightKneePitchLink", "rightAnklePitchLink", "rightFoot"};
    private static final String[] TorsoLinkNames = new String[]{"torsoYawLink", "torsoPitchLink", "torso"};
    private static final String[] NeckLinkNames = new String[]{"lowerNeckPitchLink", "neckYawLink", "upperNeckPitchLink"};
    private static final String[] LeftArmLinkNames = new String[]{"leftShoulderPitchLink", "leftShoulderRollLink", "leftShoulderYawLink", "leftElbowPitchLink", "leftForearmLink", "leftWristRollLink", "leftPalm"};
    private static final String[] LeftIndexFingerLinkNames = (String[])Stream.of(LeftIndexFingerJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] LeftMiddleFingerLinkNames = (String[])Stream.of(LeftMiddleFingerJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] LeftPinkyLinkNames = (String[])Stream.of(LeftPinkyJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] LeftThumbLinkNames = (String[])Stream.of(LeftThumbJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] RightArmLinkNames = new String[]{"rightShoulderPitchLink", "rightShoulderRollLink", "rightShoulderYawLink", "rightElbowPitchLink", "rightForearmLink", "rightWristRollLink", "rightPalm"};
    private static final String[] RightIndexFingerLinkNames = (String[])Stream.of(RightIndexFingerJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] RightMiddleFingerLinkNames = (String[])Stream.of(RightMiddleFingerJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] RightPinkyLinkNames = (String[])Stream.of(RightPinkyJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] RightThumbLinkNames = (String[])Stream.of(RightThumbJointNames).map(s -> s + "Link").toArray(String[]::new);
    private static final String[] AllLinkNames = ValkyrieModelLoadingTest.concatenate({"pelvis", "hokuyo_link"}, LeftLegLinkNames, RightLegLinkNames, TorsoLinkNames, NeckLinkNames, LeftArmLinkNames, LeftIndexFingerLinkNames, LeftMiddleFingerLinkNames, LeftPinkyLinkNames, LeftThumbLinkNames, RightArmLinkNames, RightIndexFingerLinkNames, RightMiddleFingerLinkNames, RightPinkyLinkNames, RightThumbLinkNames);
    private static final double Infinity = Double.POSITIVE_INFINITY;

    @Test
    public void testSDFTools() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/valkyrie/valkyrie_sim.sdf");
        SDFRoot sdfRoot = SDFTools.loadSDFRoot((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition robotDefinition = SDFTools.toFloatingRobotDefinition((SDFModel)((SDFModel)sdfRoot.getModels().get(0)));
        robotDefinition.transformAllFramesToZUp();
        this.performAssertionsOnRobotDefinition(robotDefinition);
    }

    @Test
    public void testURDFTools() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/valkyrie/valkyrie_sim.urdf");
        URDFModel urdfModel = URDFTools.loadURDFModel((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition robotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfModel);
        this.performAssertionsOnRobotDefinition(robotDefinition);
    }

    @Test
    public void testSDF_vs_URDFTools() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/valkyrie/valkyrie_sim.sdf");
        SDFRoot sdfRoot = SDFTools.loadSDFRoot((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition robotSDF = SDFTools.toFloatingRobotDefinition((SDFModel)((SDFModel)sdfRoot.getModels().get(0)));
        resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/valkyrie/valkyrie_sim.urdf");
        URDFModel urdfModel = URDFTools.loadURDFModel((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition robotURDF = URDFTools.toRobotDefinition((URDFModel)urdfModel);
        for (RigidBodyDefinition bodySDF : robotSDF.getAllRigidBodies()) {
            RigidBodyDefinition bodyURDF = robotSDF.getRigidBodyDefinition(bodySDF.getName());
            Assertions.assertNotNull((Object)bodyURDF, (String)"Couldn't find the rigid-body %s in the URDF robot definition.".formatted(bodySDF.getName()));
            ValkyrieModelLoadingTest.assertRigidBodyEquals(bodySDF, bodyURDF, 1.0E-5);
        }
        for (JointDefinition jointSDF : robotSDF.getAllJoints()) {
            if (jointSDF.getName().equals(HokuyoJointName)) continue;
            JointDefinition jointURDF = robotURDF.getJointDefinition(jointSDF.getName());
            Assertions.assertNotNull((Object)jointURDF, (String)"Couldn't find the joint %s in the URDF robot definition.".formatted(jointSDF.getName()));
            jointURDF.getSensorDefinitions().removeIf(sensor -> sensor instanceof WrenchSensorDefinition);
            ValkyrieModelLoadingTest.assertJointEquals(jointSDF, jointURDF, 1.0E-5);
        }
    }

    public static void assertRigidBodyEquals(RigidBodyDefinition expected, RigidBodyDefinition actual, double epsilon) {
        int i;
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Rigid-bodies do not have the same name", (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.equals((double)expected.getMass(), (double)actual.getMass())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Rigid-bodies (%s) do not have the same mass".formatted(expected.getName()), (String)Double.toString(expected.getMass()), (String)Double.toString(actual.getMass()));
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getMomentOfInertia(), (EuclidGeometry)actual.getMomentOfInertia(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Rigid-bodies (%s) do not have the same MoI".formatted(expected.getName()), (String)Objects.toString(expected.getMass()), (String)Objects.toString(actual.getMass()));
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getInertiaPose(), (EuclidGeometry)actual.getInertiaPose(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Rigid-bodies (%s) do not have the same inertia pose".formatted(expected.getName()), (String)Objects.toString(expected.getInertiaPose()), (String)Objects.toString(actual.getInertiaPose()));
        }
        if (!Objects.equals(expected.getChildrenJoints().size(), actual.getChildrenJoints().size())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Rigid-bodies (%s) do not have the same number of children".formatted(expected.getName()), (String)Integer.toString(expected.getChildrenJoints().size()), (String)Integer.toString(actual.getChildrenJoints().size()));
        }
        if (!Objects.equals(expected.getVisualDefinitions().size(), actual.getVisualDefinitions().size())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Rigid-bodies (%s) do not have the same number of visuals".formatted(expected.getName()), (String)Integer.toString(expected.getVisualDefinitions().size()), (String)Integer.toString(actual.getVisualDefinitions().size()));
        }
        for (i = 0; i < expected.getVisualDefinitions().size(); ++i) {
            VisualDefinition expectedVisual = (VisualDefinition)expected.getVisualDefinitions().get(i);
            VisualDefinition actualVisual = (VisualDefinition)actual.getVisualDefinitions().get(i);
            ValkyrieModelLoadingTest.assertVisualEquals("In rigid-body (%s)".formatted(expected.getName()), expectedVisual, actualVisual, epsilon);
        }
        if (!Objects.equals(expected.getCollisionShapeDefinitions().size(), actual.getCollisionShapeDefinitions().size())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Rigid-bodies (%s) do not have the same number of collisions".formatted(expected.getName()), (String)Integer.toString(expected.getCollisionShapeDefinitions().size()), (String)Integer.toString(actual.getCollisionShapeDefinitions().size()));
        }
        for (i = 0; i < expected.getCollisionShapeDefinitions().size(); ++i) {
            CollisionShapeDefinition expectedCollisionShape = (CollisionShapeDefinition)expected.getCollisionShapeDefinitions().get(i);
            CollisionShapeDefinition actualCollisionShape = (CollisionShapeDefinition)actual.getCollisionShapeDefinitions().get(i);
            ValkyrieModelLoadingTest.assertCollisionShapeEquals("In rigid-body (%s)".formatted(expected.getName()), expectedCollisionShape, actualCollisionShape, epsilon);
        }
    }

    public static void assertVisualEquals(String messagePrefix, VisualDefinition expected, VisualDefinition actual, double epsilon) {
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Visuals do not have the same name"), (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getOriginPose(), (EuclidGeometry)actual.getOriginPose(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Visuals (%s) do not have the same pose".formatted(expected.getName())), (String)Objects.toString(expected.getOriginPose()), (String)Objects.toString(actual.getOriginPose()));
        }
        if (!Objects.equals(expected.getGeometryDefinition(), actual.getGeometryDefinition())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Visuals (%s) do not have the same geometry".formatted(expected.getName())), (String)Objects.toString(expected.getGeometryDefinition()), (String)Objects.toString(actual.getGeometryDefinition()));
        }
        if (!Objects.equals(expected.getMaterialDefinition(), actual.getMaterialDefinition())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Visuals (%s) do not have the same material".formatted(expected.getName())), (String)Objects.toString(expected.getMaterialDefinition()), (String)Objects.toString(actual.getMaterialDefinition()));
        }
    }

    public static void assertCollisionShapeEquals(String messagePrefix, CollisionShapeDefinition expected, CollisionShapeDefinition actual, double epsilon) {
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Collisions do not have the same name"), (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getOriginPose(), (EuclidGeometry)actual.getOriginPose(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Collisions (%s) do not have the same pose".formatted(expected.getName())), (String)Objects.toString(expected.getOriginPose()), (String)Objects.toString(actual.getOriginPose()));
        }
        if (!Objects.equals(expected.getGeometryDefinition(), actual.getGeometryDefinition())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Collisions (%s) do not have the same geometry".formatted(expected.getName())), (String)Objects.toString(expected.getGeometryDefinition()), (String)Objects.toString(actual.getGeometryDefinition()));
        }
        if (expected.isConcave() != actual.isConcave()) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Collisions (%s) do not have the concave property".formatted(expected.getName())), (String)Objects.toString(expected.isConcave()), (String)Objects.toString(actual.isConcave()));
        }
        if (expected.getCollisionMask() != actual.getCollisionMask()) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Collisions (%s) do not have the collision mask".formatted(expected.getName())), (String)Objects.toString(expected.getCollisionMask()), (String)Objects.toString(actual.getCollisionMask()));
        }
        if (expected.getCollisionGroup() != actual.getCollisionGroup()) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Collisions (%s) do not have the collision group".formatted(expected.getName())), (String)Objects.toString(expected.getCollisionGroup()), (String)Objects.toString(actual.getCollisionGroup()));
        }
    }

    public static void assertJointEquals(JointDefinition expected, JointDefinition actual, double epsilon) {
        int i;
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints do not have the same name", (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getTransformToParent(), (EuclidGeometry)actual.getTransformToParent(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same transform".formatted(expected.getName()), (String)Objects.toString(expected.getTransformToParent()), (String)Objects.toString(actual.getTransformToParent()));
        }
        if (expected instanceof OneDoFJointDefinition) {
            OneDoFJointDefinition expectedOneDoFJoint = (OneDoFJointDefinition)expected;
            OneDoFJointDefinition actualOneDoFJoint = (OneDoFJointDefinition)actual;
            if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expectedOneDoFJoint.getAxis(), (EuclidGeometry)actualOneDoFJoint.getAxis(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same axis".formatted(expected.getName()), (String)Objects.toString(expectedOneDoFJoint.getAxis()), (String)Objects.toString(actualOneDoFJoint.getAxis()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getPositionLowerLimit(), (double)actualOneDoFJoint.getPositionLowerLimit(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same position lower limit".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getPositionLowerLimit()), (String)Double.toString(actualOneDoFJoint.getPositionLowerLimit()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getPositionUpperLimit(), (double)actualOneDoFJoint.getPositionUpperLimit(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same position upper limit".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getPositionUpperLimit()), (String)Double.toString(actualOneDoFJoint.getPositionUpperLimit()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getVelocityLowerLimit(), (double)actualOneDoFJoint.getVelocityLowerLimit(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same velocity lower limit".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getVelocityLowerLimit()), (String)Double.toString(actualOneDoFJoint.getVelocityLowerLimit()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getVelocityUpperLimit(), (double)actualOneDoFJoint.getVelocityUpperLimit(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same velocity upper limit".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getVelocityUpperLimit()), (String)Double.toString(actualOneDoFJoint.getVelocityUpperLimit()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getEffortLowerLimit(), (double)actualOneDoFJoint.getEffortLowerLimit(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same effort lower limit".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getEffortLowerLimit()), (String)Double.toString(actualOneDoFJoint.getEffortLowerLimit()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getEffortUpperLimit(), (double)actualOneDoFJoint.getEffortUpperLimit(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same effort upper limit".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getEffortUpperLimit()), (String)Double.toString(actualOneDoFJoint.getEffortUpperLimit()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getDamping(), (double)actualOneDoFJoint.getDamping(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same damping".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getDamping()), (String)Double.toString(actualOneDoFJoint.getDamping()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getStiction(), (double)actualOneDoFJoint.getStiction(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same stiction".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getStiction()), (String)Double.toString(actualOneDoFJoint.getStiction()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getKpSoftLimitStop(), (double)actualOneDoFJoint.getKpSoftLimitStop(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same kp soft limit stop".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getKpSoftLimitStop()), (String)Double.toString(actualOneDoFJoint.getKpSoftLimitStop()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getKdSoftLimitStop(), (double)actualOneDoFJoint.getKdSoftLimitStop(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same kd soft limit stop".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getKdSoftLimitStop()), (String)Double.toString(actualOneDoFJoint.getKdSoftLimitStop()));
            }
            if (!EuclidCoreTools.epsilonEquals((double)expectedOneDoFJoint.getDampingVelocitySoftLimit(), (double)actualOneDoFJoint.getDampingVelocitySoftLimit(), (double)epsilon)) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same damping velocity soft limit".formatted(expected.getName()), (String)Double.toString(expectedOneDoFJoint.getDampingVelocitySoftLimit()), (String)Double.toString(actualOneDoFJoint.getDampingVelocitySoftLimit()));
            }
        }
        if (!Objects.equals(expected.getSensorDefinitions().size(), actual.getSensorDefinitions().size())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same number of sensors".formatted(expected.getName()), (String)Objects.toString(expected.getSensorDefinitions().size()), (String)Objects.toString(actual.getSensorDefinitions().size()));
        }
        Collections.sort(expected.getSensorDefinitions(), (s1, s2) -> s1.getName().compareTo(s2.getName()));
        Collections.sort(actual.getSensorDefinitions(), (s1, s2) -> s1.getName().compareTo(s2.getName()));
        for (i = 0; i < expected.getSensorDefinitions().size(); ++i) {
            SensorDefinition expectedSensor = (SensorDefinition)expected.getSensorDefinitions().get(i);
            SensorDefinition actualSensor = (SensorDefinition)actual.getSensorDefinitions().get(i);
            ValkyrieModelLoadingTest.assertSensorEquals("In rigid-body (%s)".formatted(expected.getName()), expectedSensor, actualSensor, epsilon);
        }
        if (!Objects.equals(expected.getKinematicPointDefinitions().size(), actual.getKinematicPointDefinitions().size())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same number of kinematic points".formatted(expected.getName()), (String)Objects.toString(expected.getKinematicPointDefinitions().size()), (String)Objects.toString(actual.getKinematicPointDefinitions().size()));
        }
        for (i = 0; i < expected.getKinematicPointDefinitions().size(); ++i) {
            KinematicPointDefinition expectedKinematicPoint = (KinematicPointDefinition)expected.getKinematicPointDefinitions().get(i);
            KinematicPointDefinition actualKinematicPoint = (KinematicPointDefinition)actual.getKinematicPointDefinitions().get(i);
            ValkyrieModelLoadingTest.assertKinematicPointEquals("In rigid-body (%s)".formatted(expected.getName()), expectedKinematicPoint, actualKinematicPoint, epsilon);
        }
        if (!Objects.equals(expected.getExternalWrenchPointDefinitions().size(), actual.getExternalWrenchPointDefinitions().size())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same number of external wrench points".formatted(expected.getName()), (String)Objects.toString(expected.getExternalWrenchPointDefinitions().size()), (String)Objects.toString(actual.getExternalWrenchPointDefinitions().size()));
        }
        for (i = 0; i < expected.getExternalWrenchPointDefinitions().size(); ++i) {
            ExternalWrenchPointDefinition expectedExternalWrenchPoint = (ExternalWrenchPointDefinition)expected.getExternalWrenchPointDefinitions().get(i);
            ExternalWrenchPointDefinition actualExternalWrenchPoint = (ExternalWrenchPointDefinition)actual.getExternalWrenchPointDefinitions().get(i);
            ValkyrieModelLoadingTest.assertExternalWrenchPointEquals("In rigid-body (%s)".formatted(expected.getName()), expectedExternalWrenchPoint, actualExternalWrenchPoint, epsilon);
        }
        if (!Objects.equals(expected.getGroundContactPointDefinitions().size(), actual.getGroundContactPointDefinitions().size())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)"Joints (%s) do not have the same number of ground contact points".formatted(expected.getName()), (String)Objects.toString(expected.getGroundContactPointDefinitions().size()), (String)Objects.toString(actual.getGroundContactPointDefinitions().size()));
        }
        for (i = 0; i < expected.getGroundContactPointDefinitions().size(); ++i) {
            GroundContactPointDefinition expectedGroundContactPoint = (GroundContactPointDefinition)expected.getGroundContactPointDefinitions().get(i);
            GroundContactPointDefinition actualGroundContactPoint = (GroundContactPointDefinition)actual.getGroundContactPointDefinitions().get(i);
            ValkyrieModelLoadingTest.assertGroundContactPointEquals("In rigid-body (%s)".formatted(expected.getName()), expectedGroundContactPoint, actualGroundContactPoint, epsilon);
        }
    }

    public static void assertSensorEquals(String messagePrefix, SensorDefinition expected, SensorDefinition actual, double epsilon) {
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Sensors do not have the same name"), (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getTransformToJoint(), (EuclidGeometry)actual.getTransformToJoint(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Sensors (%s) do not have the same pose".formatted(expected.getName())), (String)Objects.toString(expected.getTransformToJoint()), (String)Objects.toString(actual.getTransformToJoint()));
        }
        if (expected.getUpdatePeriod() != actual.getUpdatePeriod()) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Sensors (%s) do not have the same udpate period".formatted(expected.getName())), (String)Objects.toString(expected.getUpdatePeriod()), (String)Objects.toString(actual.getUpdatePeriod()));
        }
    }

    public static void assertKinematicPointEquals(String messagePrefix, KinematicPointDefinition expected, KinematicPointDefinition actual, double epsilon) {
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Kinematic points do not have the same name"), (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getTransformToParent(), (EuclidGeometry)actual.getTransformToParent(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Kinematic points (%s) do not have the same pose".formatted(expected.getName())), (String)Objects.toString(expected.getTransformToParent()), (String)Objects.toString(actual.getTransformToParent()));
        }
    }

    public static void assertExternalWrenchPointEquals(String messagePrefix, ExternalWrenchPointDefinition expected, ExternalWrenchPointDefinition actual, double epsilon) {
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"External wrench points do not have the same name"), (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getTransformToParent(), (EuclidGeometry)actual.getTransformToParent(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"External wrench points (%s) do not have the same pose".formatted(expected.getName())), (String)Objects.toString(expected.getTransformToParent()), (String)Objects.toString(actual.getTransformToParent()));
        }
    }

    public static void assertGroundContactPointEquals(String messagePrefix, GroundContactPointDefinition expected, GroundContactPointDefinition actual, double epsilon) {
        if (!Objects.equals(expected.getName(), actual.getName())) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Ground contact points do not have the same name"), (String)expected.getName(), (String)actual.getName());
        }
        if (!EuclidCoreTools.epsilonEquals((EuclidGeometry)expected.getTransformToParent(), (EuclidGeometry)actual.getTransformToParent(), (double)epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Ground contact points (%s) do not have the same pose".formatted(expected.getName())), (String)Objects.toString(expected.getTransformToParent()), (String)Objects.toString(actual.getTransformToParent()));
        }
        if (expected.getGroupIdentifier() != actual.getGroupIdentifier()) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)"Ground contact points (%s) do not have the same group identifier".formatted(expected.getName())), (String)Integer.toString(expected.getGroupIdentifier()), (String)Integer.toString(actual.getGroupIdentifier()));
        }
    }

    @Test
    public void testSaveLoadRobotDefinitionXML() throws JAXBException, FileNotFoundException, IOException {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/valkyrie/valkyrie_sim.urdf");
        URDFModel urdfModel = URDFTools.loadURDFModel((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition exportedRobotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfModel);
        File testFile = new File("test.xml");
        DefinitionIOTools.saveRobotDefinition((OutputStream)new FileOutputStream(testFile), (RobotDefinition)exportedRobotDefinition);
        RobotDefinition importedRobotDefinition = DefinitionIOTools.loadRobotDefinition((InputStream)new FileInputStream(testFile));
        this.performAssertionsOnRobotDefinition(importedRobotDefinition);
        testFile.delete();
    }

    private void performAssertionsOnRobotDefinition(RobotDefinition robotDefinition) {
        for (String jointName : AllJointNames) {
            Assertions.assertNotNull((Object)robotDefinition.getJointDefinition(jointName), (String)jointName);
            if (jointName.equals(PelvisName)) continue;
            Assertions.assertEquals(RevoluteJointDefinition.class, robotDefinition.getJointDefinition(jointName).getClass());
        }
        for (String linkName : AllLinkNames) {
            Assertions.assertNotNull((Object)robotDefinition.getRigidBodyDefinition(linkName), (String)("Link: " + linkName));
        }
        Assertions.assertEquals((int)1, (int)robotDefinition.getRootJointDefinitions().size());
        Assertions.assertEquals(SixDoFJointDefinition.class, ((JointDefinition)robotDefinition.getRootJointDefinitions().get(0)).getClass());
        Assertions.assertEquals((Object)PelvisName, (Object)((JointDefinition)robotDefinition.getRootJointDefinitions().get(0)).getName());
        ValkyrieModelLoadingTest.assertKinematicsContinuity((JointDefinition)robotDefinition.getRootJointDefinitions().get(0), LeftLegJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity((JointDefinition)robotDefinition.getRootJointDefinitions().get(0), RightLegJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity((JointDefinition)robotDefinition.getRootJointDefinitions().get(0), TorsoJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(TorsoRollName), NeckJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(TorsoRollName), LeftArmJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(TorsoRollName), RightArmJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(LeftWristPitchName), LeftIndexFingerJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(LeftWristPitchName), LeftMiddleFingerJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(LeftWristPitchName), LeftPinkyJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(LeftWristPitchName), LeftThumbJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(RightWristPitchName), RightIndexFingerJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(RightWristPitchName), RightMiddleFingerJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(RightWristPitchName), RightPinkyJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(RightWristPitchName), RightThumbJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertPhysicalProperties(robotDefinition, ValkyrieModelLoadingTest.valkyrieProperties(), ValkyrieModelLoadingTest.subtract(AllJointNames, HokuyoJointName), AllLinkNames);
        ValkyrieModelLoadingTest.assertSensorsProperties(robotDefinition, ValkyrieModelLoadingTest.valkyrieSensorProperties(), AllJointNames);
    }

    public static void assertPhysicalProperties(RobotDefinition robotDefinition, Map<String, Map<String, Object>> robotProperties, String[] allJointNames, String[] allLinkNames) {
        for (String jointName : allJointNames) {
            Map<String, Object> jointProperties = robotProperties.get(jointName);
            JointDefinition jointDefinition = robotDefinition.getJointDefinition(jointName);
            String messagePrefix = "Joint: " + jointName;
            Orientation3DBasics rotation = jointDefinition.getTransformToParent().getRotation();
            Vector3D translation = jointDefinition.getTransformToParent().getTranslation();
            Assertions.assertTrue((boolean)rotation.isZeroOrientation(1.0E-5), (String)("Expected zero rotation, was: " + String.valueOf(rotation)));
            EuclidCoreTestTools.assertEquals((String)messagePrefix, (EuclidGeometry)((Tuple3DReadOnly)jointProperties.get("offsetFromParentJoint")), (EuclidGeometry)translation, (double)1.0E-5);
            if (!(jointDefinition instanceof OneDoFJointDefinition)) continue;
            OneDoFJointDefinition oneDoFJointDefinition = (OneDoFJointDefinition)jointDefinition;
            Assertions.assertEquals((double)((Double)jointProperties.get("positionLowerLimit")), (double)oneDoFJointDefinition.getPositionLowerLimit(), (String)messagePrefix);
            Assertions.assertEquals((double)((Double)jointProperties.get("positionUpperLimit")), (double)oneDoFJointDefinition.getPositionUpperLimit(), (String)messagePrefix);
            Assertions.assertEquals((double)((Double)jointProperties.get("velocityLowerLimit")), (double)oneDoFJointDefinition.getVelocityLowerLimit(), (String)messagePrefix);
            Assertions.assertEquals((double)((Double)jointProperties.get("velocityUpperLimit")), (double)oneDoFJointDefinition.getVelocityUpperLimit(), (String)messagePrefix);
            Assertions.assertEquals((double)((Double)jointProperties.get("effortLowerLimit")), (double)oneDoFJointDefinition.getEffortLowerLimit(), (String)messagePrefix);
            Assertions.assertEquals((double)((Double)jointProperties.get("effortUpperLimit")), (double)oneDoFJointDefinition.getEffortUpperLimit(), (String)messagePrefix);
            EuclidCoreTestTools.assertEquals((String)messagePrefix, (EuclidGeometry)((Tuple3DReadOnly)jointProperties.get("axis")), (EuclidGeometry)oneDoFJointDefinition.getAxis(), (double)1.0E-5);
            Assertions.assertEquals((double)((Double)jointProperties.get("damping")), (double)oneDoFJointDefinition.getDamping(), (String)messagePrefix);
            Assertions.assertEquals((double)((Double)jointProperties.get("stiction")), (double)oneDoFJointDefinition.getStiction(), (String)messagePrefix);
        }
        for (String linkName : allLinkNames) {
            String messagePrefix = "Link: " + linkName;
            Map<String, Object> linkProperties = robotProperties.get(linkName);
            RigidBodyDefinition rigidBodyDefinition = robotDefinition.getRigidBodyDefinition(linkName);
            Assertions.assertEquals((double)((Double)linkProperties.get("mass")), (double)rigidBodyDefinition.getMass(), (double)1.0E-5, (String)messagePrefix);
            EuclidCoreTestTools.assertEquals((String)messagePrefix, (EuclidGeometry)((Tuple3DReadOnly)linkProperties.get("centerOfMass")), (EuclidGeometry)rigidBodyDefinition.getCenterOfMassOffset(), (double)1.0E-5);
            EuclidCoreTestTools.assertMatrix3DEquals((String)messagePrefix, (Matrix3DReadOnly)((Matrix3DReadOnly)linkProperties.get("inertia")), (Matrix3DReadOnly)rigidBodyDefinition.getMomentOfInertia(), (double)1.0E-5);
        }
    }

    public static void assertSensorsProperties(RobotDefinition robotDefinition, Map<String, Map<String, Object>> robotSensorProperties, String[] allJointNames) {
        int actualNumberOfCameras = 0;
        int actualNumberOfIMUs = 0;
        int actualNumberOfLidars = 0;
        for (String jointName : allJointNames) {
            JointDefinition jointDefinition = robotDefinition.getJointDefinition(jointName);
            actualNumberOfCameras += jointDefinition.getSensorDefinitions(CameraSensorDefinition.class).size();
            actualNumberOfIMUs += jointDefinition.getSensorDefinitions(IMUSensorDefinition.class).size();
            actualNumberOfLidars += jointDefinition.getSensorDefinitions(LidarSensorDefinition.class).size();
            for (SensorDefinition sensorDefinition : jointDefinition.getSensorDefinitions()) {
                Map<String, Object> sensorProperties2 = robotSensorProperties.get(sensorDefinition.getName());
                ValkyrieModelLoadingTest.assertSensorProperties(sensorDefinition, sensorProperties2);
            }
        }
        int expectedNumberOfCameras = (int)robotSensorProperties.values().stream().flatMap(sensorProperties -> sensorProperties.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("imageWidth")).count();
        int expectedNumberOfIMUs = (int)robotSensorProperties.values().stream().flatMap(sensorProperties -> sensorProperties.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("accelerationNoiseMean")).count();
        int expectedNumberOfLidars = (int)robotSensorProperties.values().stream().flatMap(sensorProperties -> sensorProperties.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("sweepYawMin")).count();
        Assertions.assertEquals((int)expectedNumberOfCameras, (int)actualNumberOfCameras);
        Assertions.assertEquals((int)expectedNumberOfIMUs, (int)actualNumberOfIMUs);
        Assertions.assertEquals((int)expectedNumberOfLidars, (int)actualNumberOfLidars);
    }

    public static void assertSensorProperties(SensorDefinition sensorDefinition, Map<String, Object> sensorProperties) {
        if (sensorProperties == null) {
            return;
        }
        EuclidCoreTestTools.assertEquals((String)("Sensor: " + sensorDefinition.getName()), (EuclidGeometry)((RigidBodyTransform)sensorProperties.get("transformToJoint")), (EuclidGeometry)new RigidBodyTransform((RigidBodyTransformReadOnly)sensorDefinition.getTransformToJoint()), (double)1.0E-5);
        if (sensorDefinition instanceof CameraSensorDefinition) {
            CameraSensorDefinition cameraSensorDefinition = (CameraSensorDefinition)sensorDefinition;
            Assertions.assertEquals((double)((Double)sensorProperties.get("fieldOfView")), (double)cameraSensorDefinition.getFieldOfView());
            Assertions.assertEquals((double)((Double)sensorProperties.get("clipNear")), (double)cameraSensorDefinition.getClipNear());
            Assertions.assertEquals((double)((Double)sensorProperties.get("clipFar")), (double)cameraSensorDefinition.getClipFar());
            Assertions.assertEquals((int)((Integer)sensorProperties.get("imageWidth")), (int)cameraSensorDefinition.getImageWidth());
            Assertions.assertEquals((int)((Integer)sensorProperties.get("imageHeight")), (int)cameraSensorDefinition.getImageHeight());
        } else if (sensorDefinition instanceof IMUSensorDefinition) {
            IMUSensorDefinition imuSensorDefinition = (IMUSensorDefinition)sensorDefinition;
            Assertions.assertEquals((double)((Double)sensorProperties.get("accelerationNoiseMean")), (double)imuSensorDefinition.getAccelerationNoiseMean());
            Assertions.assertEquals((double)((Double)sensorProperties.get("accelerationNoiseStandardDeviation")), (double)imuSensorDefinition.getAccelerationNoiseStandardDeviation());
            Assertions.assertEquals((double)((Double)sensorProperties.get("accelerationBiasMean")), (double)imuSensorDefinition.getAccelerationBiasMean());
            Assertions.assertEquals((double)((Double)sensorProperties.get("accelerationBiasStandardDeviation")), (double)imuSensorDefinition.getAccelerationBiasStandardDeviation());
            Assertions.assertEquals((double)((Double)sensorProperties.get("angularVelocityNoiseMean")), (double)imuSensorDefinition.getAngularVelocityNoiseMean());
            Assertions.assertEquals((double)((Double)sensorProperties.get("angularVelocityNoiseStandardDeviation")), (double)imuSensorDefinition.getAngularVelocityNoiseStandardDeviation());
            Assertions.assertEquals((double)((Double)sensorProperties.get("angularVelocityBiasMean")), (double)imuSensorDefinition.getAngularVelocityBiasMean());
            Assertions.assertEquals((double)((Double)sensorProperties.get("angularVelocityBiasStandardDeviation")), (double)imuSensorDefinition.getAngularVelocityBiasStandardDeviation());
        } else if (sensorDefinition instanceof LidarSensorDefinition) {
            LidarSensorDefinition lidarSensorDefinition = (LidarSensorDefinition)sensorDefinition;
            Assertions.assertEquals((double)((Double)sensorProperties.get("sweepYawMin")), (double)lidarSensorDefinition.getSweepYawMin());
            Assertions.assertEquals((double)((Double)sensorProperties.get("sweepYawMax")), (double)lidarSensorDefinition.getSweepYawMax());
            Assertions.assertEquals((double)((Double)sensorProperties.get("heightPitchMin")), (double)lidarSensorDefinition.getHeightPitchMin());
            Assertions.assertEquals((double)((Double)sensorProperties.get("heightPitchMax")), (double)lidarSensorDefinition.getHeightPitchMax());
            Assertions.assertEquals((double)((Double)sensorProperties.get("minRange")), (double)lidarSensorDefinition.getMinRange());
            Assertions.assertEquals((double)((Double)sensorProperties.get("maxRange")), (double)lidarSensorDefinition.getMaxRange());
            Assertions.assertEquals((int)((Integer)sensorProperties.get("pointsPerSweep")), (int)lidarSensorDefinition.getPointsPerSweep());
            Assertions.assertEquals((int)((Integer)sensorProperties.get("scanHeight")), (int)lidarSensorDefinition.getScanHeight());
        }
    }

    public static void assertKinematicsContinuity(JointDefinition expectedParentJoint, String[] jointNames, RobotDefinition robotDefinition) {
        for (String jointName : jointNames) {
            JointDefinition joint = robotDefinition.getJointDefinition(jointName);
            Assertions.assertNotNull((Object)joint.getParentJoint(), (String)jointName);
            Assertions.assertTrue((expectedParentJoint == joint.getParentJoint() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)expectedParentJoint.getSuccessor().getChildrenJoints().contains(joint));
            expectedParentJoint = joint;
        }
    }

    public static <T> T[] concatenate(T[] ... arrays) {
        int length = Stream.of(arrays).mapToInt(array -> ((Object[])array).length).sum();
        Object[] ret = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), length);
        int currentIndex = 0;
        T[][] TArray = arrays;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] array2;
            for (T element : array2 = TArray[i]) {
                ret[currentIndex++] = element;
            }
        }
        return ret;
    }

    @SafeVarargs
    public static <T> T[] subtract(T[] source, T ... elementsToSubtract) {
        LinkedHashSet<Object> sourceSet = new LinkedHashSet<Object>(Arrays.asList(source));
        for (T elementToSubtract : elementsToSubtract) {
            sourceSet.remove(elementToSubtract);
        }
        return sourceSet.toArray((Object[])Array.newInstance(source.getClass().getComponentType(), sourceSet.size()));
    }

    private static Map<String, Map<String, Object>> valkyrieProperties() {
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        properties.put(PelvisName, new HashMap());
        properties.put(PelvisName, new HashMap());
        ((Map)properties.get(PelvisName)).put("mass", 8.22);
        ((Map)properties.get(PelvisName)).put("centerOfMass", new Vector3D(-0.00532, -0.003512, -0.0036));
        ((Map)properties.get(PelvisName)).put("inertia", new Matrix3D(0.118664, -1.43482E-4, 0.00327129, -1.43482E-4, 0.0979634, 0.00215955, 0.00327129, 0.00215955, 0.0838546));
        ((Map)properties.get(PelvisName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        properties.put(LeftHipYawName, new HashMap());
        properties.put(LeftHipYawLinkName, new HashMap());
        ((Map)properties.get(LeftHipYawLinkName)).put("mass", 2.39);
        ((Map)properties.get(LeftHipYawLinkName)).put("centerOfMass", new Vector3D(0.02176, -0.00131, 0.03867));
        ((Map)properties.get(LeftHipYawLinkName)).put("inertia", new Matrix3D(0.017261, 0.0, 0.0, 0.0, 0.0148662, 0.0, 0.0, 0.0, 0.0112382));
        ((Map)properties.get(LeftHipYawName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.1016, -0.1853));
        ((Map)properties.get(LeftHipYawName)).put("positionLowerLimit", -0.4141);
        ((Map)properties.get(LeftHipYawName)).put("positionUpperLimit", 1.1);
        ((Map)properties.get(LeftHipYawName)).put("velocityLowerLimit", -5.89);
        ((Map)properties.get(LeftHipYawName)).put("velocityUpperLimit", 5.89);
        ((Map)properties.get(LeftHipYawName)).put("effortLowerLimit", -190.0);
        ((Map)properties.get(LeftHipYawName)).put("effortUpperLimit", 190.0);
        ((Map)properties.get(LeftHipYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftHipYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftHipYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftHipYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(LeftHipYawName)).put("damping", 0.1);
        ((Map)properties.get(LeftHipYawName)).put("stiction", 0.0);
        properties.put(LeftHipRollName, new HashMap());
        properties.put(LeftHipRollLinkName, new HashMap());
        ((Map)properties.get(LeftHipRollLinkName)).put("mass", 3.665);
        ((Map)properties.get(LeftHipRollLinkName)).put("centerOfMass", new Vector3D(0.012959, 0.00755, -0.01595));
        ((Map)properties.get(LeftHipRollLinkName)).put("inertia", new Matrix3D(0.00597896, -2.34823E-4, 5.53962E-4, -2.34823E-4, 0.00937265, 7.78956E-4, 5.53962E-4, 7.78956E-4, 0.00819312));
        ((Map)properties.get(LeftHipRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(LeftHipRollName)).put("positionLowerLimit", -0.467);
        ((Map)properties.get(LeftHipRollName)).put("positionUpperLimit", 0.5515);
        ((Map)properties.get(LeftHipRollName)).put("velocityLowerLimit", -7.0);
        ((Map)properties.get(LeftHipRollName)).put("velocityUpperLimit", 7.0);
        ((Map)properties.get(LeftHipRollName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(LeftHipRollName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(LeftHipRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftHipRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftHipRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftHipRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftHipRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftHipRollName)).put("stiction", 0.0);
        properties.put(LeftHipPitchName, new HashMap());
        properties.put(LeftHipPitchLinkName, new HashMap());
        ((Map)properties.get(LeftHipPitchLinkName)).put("mass", 10.2);
        ((Map)properties.get(LeftHipPitchLinkName)).put("centerOfMass", new Vector3D(0.016691, 0.091397, -0.207875));
        ((Map)properties.get(LeftHipPitchLinkName)).put("inertia", new Matrix3D(0.240834, 3.5915E-5, 0.00369938, 3.5915E-5, 0.256897, -0.001333, 0.00369938, -0.001333, 0.0232764));
        ((Map)properties.get(LeftHipPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, -0.06090000000000001));
        ((Map)properties.get(LeftHipPitchName)).put("positionLowerLimit", -2.42);
        ((Map)properties.get(LeftHipPitchName)).put("positionUpperLimit", 1.619);
        ((Map)properties.get(LeftHipPitchName)).put("velocityLowerLimit", -6.11);
        ((Map)properties.get(LeftHipPitchName)).put("velocityUpperLimit", 6.11);
        ((Map)properties.get(LeftHipPitchName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(LeftHipPitchName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(LeftHipPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftHipPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftHipPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftHipPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftHipPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftHipPitchName)).put("stiction", 0.0);
        properties.put(LeftKneePitchName, new HashMap());
        properties.put(LeftKneePitchLinkName, new HashMap());
        ((Map)properties.get(LeftKneePitchLinkName)).put("mass", 6.2);
        ((Map)properties.get(LeftKneePitchLinkName)).put("centerOfMass", new Vector3D(-0.022183, 0.001703, -0.189418));
        ((Map)properties.get(LeftKneePitchLinkName)).put("inertia", new Matrix3D(0.0869357, 9.929E-5, 5.73207E-4, 9.929E-5, 0.0915841, 3.13745E-4, 5.73207E-4, 3.13745E-4, 0.0140173));
        ((Map)properties.get(LeftKneePitchName)).put("offsetFromParentJoint", new Vector3D(1.12225E-4, 0.036105, -0.430959));
        ((Map)properties.get(LeftKneePitchName)).put("positionLowerLimit", -0.083);
        ((Map)properties.get(LeftKneePitchName)).put("positionUpperLimit", 2.057);
        ((Map)properties.get(LeftKneePitchName)).put("velocityLowerLimit", -6.11);
        ((Map)properties.get(LeftKneePitchName)).put("velocityUpperLimit", 6.11);
        ((Map)properties.get(LeftKneePitchName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(LeftKneePitchName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(LeftKneePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftKneePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftKneePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftKneePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftKneePitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftKneePitchName)).put("stiction", 0.0);
        properties.put(LeftAnklePitchName, new HashMap());
        properties.put(LeftAnklePitchLinkName, new HashMap());
        ((Map)properties.get(LeftAnklePitchLinkName)).put("mass", 0.03);
        ((Map)properties.get(LeftAnklePitchLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(LeftAnklePitchLinkName)).put("inertia", new Matrix3D(4.377E-6, 0.0, 0.0, 0.0, 4.322E-6, 0.0, 0.0, 0.0, 7.015E-6));
        ((Map)properties.get(LeftAnklePitchName)).put("offsetFromParentJoint", new Vector3D(-0.010238125, 0.0, -0.40627099999999994));
        ((Map)properties.get(LeftAnklePitchName)).put("positionLowerLimit", -0.8644);
        ((Map)properties.get(LeftAnklePitchName)).put("positionUpperLimit", 0.875);
        ((Map)properties.get(LeftAnklePitchName)).put("velocityLowerLimit", -11.0);
        ((Map)properties.get(LeftAnklePitchName)).put("velocityUpperLimit", 11.0);
        ((Map)properties.get(LeftAnklePitchName)).put("effortLowerLimit", -205.0);
        ((Map)properties.get(LeftAnklePitchName)).put("effortUpperLimit", 205.0);
        ((Map)properties.get(LeftAnklePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftAnklePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftAnklePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftAnklePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftAnklePitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftAnklePitchName)).put("stiction", 0.0);
        properties.put(LeftAnkleRollName, new HashMap());
        properties.put(LeftFootName, new HashMap());
        ((Map)properties.get(LeftFootName)).put("mass", 2.37);
        ((Map)properties.get(LeftFootName)).put("centerOfMass", new Vector3D(0.0369087, 0.00494324, -0.0489279));
        ((Map)properties.get(LeftFootName)).put("inertia", new Matrix3D(0.00641532, 2.0788E-4, 0.00128536, 2.0788E-4, 0.0179943, -2.02908E-4, 0.00128536, -2.02908E-4, 0.0209358));
        ((Map)properties.get(LeftAnkleRollName)).put("offsetFromParentJoint", new Vector3D(0.0101259, 0.0, 0.0));
        ((Map)properties.get(LeftAnkleRollName)).put("positionLowerLimit", -0.349);
        ((Map)properties.get(LeftAnkleRollName)).put("positionUpperLimit", 0.348);
        ((Map)properties.get(LeftAnkleRollName)).put("velocityLowerLimit", -11.0);
        ((Map)properties.get(LeftAnkleRollName)).put("velocityUpperLimit", 11.0);
        ((Map)properties.get(LeftAnkleRollName)).put("effortLowerLimit", -205.0);
        ((Map)properties.get(LeftAnkleRollName)).put("effortUpperLimit", 205.0);
        ((Map)properties.get(LeftAnkleRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftAnkleRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftAnkleRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftAnkleRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftAnkleRollName)).put("damping", 0.3);
        ((Map)properties.get(LeftAnkleRollName)).put("stiction", 0.0);
        properties.put(RightHipYawName, new HashMap());
        properties.put(RightHipYawLinkName, new HashMap());
        ((Map)properties.get(RightHipYawLinkName)).put("mass", 2.39);
        ((Map)properties.get(RightHipYawLinkName)).put("centerOfMass", new Vector3D(0.02176, 0.00131, 0.03867));
        ((Map)properties.get(RightHipYawLinkName)).put("inertia", new Matrix3D(0.017261, 0.0, 0.0, 0.0, 0.0148662, 0.0, 0.0, 0.0, 0.0112382));
        ((Map)properties.get(RightHipYawName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.1016, -0.1853));
        ((Map)properties.get(RightHipYawName)).put("positionLowerLimit", -1.1);
        ((Map)properties.get(RightHipYawName)).put("positionUpperLimit", 0.4141);
        ((Map)properties.get(RightHipYawName)).put("velocityLowerLimit", -5.89);
        ((Map)properties.get(RightHipYawName)).put("velocityUpperLimit", 5.89);
        ((Map)properties.get(RightHipYawName)).put("effortLowerLimit", -190.0);
        ((Map)properties.get(RightHipYawName)).put("effortUpperLimit", 190.0);
        ((Map)properties.get(RightHipYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightHipYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightHipYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightHipYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(RightHipYawName)).put("damping", 0.1);
        ((Map)properties.get(RightHipYawName)).put("stiction", 0.0);
        properties.put(RightHipRollName, new HashMap());
        properties.put(RightHipRollLinkName, new HashMap());
        ((Map)properties.get(RightHipRollLinkName)).put("mass", 3.665);
        ((Map)properties.get(RightHipRollLinkName)).put("centerOfMass", new Vector3D(0.012959, -0.00755, -0.01595));
        ((Map)properties.get(RightHipRollLinkName)).put("inertia", new Matrix3D(0.00597896, 2.34823E-4, 5.53962E-4, 2.34823E-4, 0.00937265, -7.78956E-4, 5.53962E-4, -7.78956E-4, 0.00819312));
        ((Map)properties.get(RightHipRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(RightHipRollName)).put("positionLowerLimit", -0.5515);
        ((Map)properties.get(RightHipRollName)).put("positionUpperLimit", 0.467);
        ((Map)properties.get(RightHipRollName)).put("velocityLowerLimit", -7.0);
        ((Map)properties.get(RightHipRollName)).put("velocityUpperLimit", 7.0);
        ((Map)properties.get(RightHipRollName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(RightHipRollName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(RightHipRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightHipRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightHipRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightHipRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightHipRollName)).put("damping", 0.1);
        ((Map)properties.get(RightHipRollName)).put("stiction", 0.0);
        properties.put(RightHipPitchName, new HashMap());
        properties.put(RightHipPitchLinkName, new HashMap());
        ((Map)properties.get(RightHipPitchLinkName)).put("mass", 10.2);
        ((Map)properties.get(RightHipPitchLinkName)).put("centerOfMass", new Vector3D(0.016691, -0.091397, -0.207875));
        ((Map)properties.get(RightHipPitchLinkName)).put("inertia", new Matrix3D(0.240834, -3.5915E-5, 0.00369938, -3.5915E-5, 0.256897, 0.001333, 0.00369938, 0.001333, 0.0232764));
        ((Map)properties.get(RightHipPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, -0.06090000000000001));
        ((Map)properties.get(RightHipPitchName)).put("positionLowerLimit", -2.42);
        ((Map)properties.get(RightHipPitchName)).put("positionUpperLimit", 1.619);
        ((Map)properties.get(RightHipPitchName)).put("velocityLowerLimit", -6.11);
        ((Map)properties.get(RightHipPitchName)).put("velocityUpperLimit", 6.11);
        ((Map)properties.get(RightHipPitchName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(RightHipPitchName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(RightHipPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightHipPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightHipPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightHipPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightHipPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightHipPitchName)).put("stiction", 0.0);
        properties.put(RightKneePitchName, new HashMap());
        properties.put(RightKneePitchLinkName, new HashMap());
        ((Map)properties.get(RightKneePitchLinkName)).put("mass", 6.2);
        ((Map)properties.get(RightKneePitchLinkName)).put("centerOfMass", new Vector3D(-0.022183, 0.001703, -0.189418));
        ((Map)properties.get(RightKneePitchLinkName)).put("inertia", new Matrix3D(0.0869357, 9.929E-5, 5.73207E-4, 9.929E-5, 0.0915841, 3.13745E-4, 5.73207E-4, 3.13745E-4, 0.0140173));
        ((Map)properties.get(RightKneePitchName)).put("offsetFromParentJoint", new Vector3D(1.12225E-4, -0.036105, -0.430959));
        ((Map)properties.get(RightKneePitchName)).put("positionLowerLimit", -0.083);
        ((Map)properties.get(RightKneePitchName)).put("positionUpperLimit", 2.057);
        ((Map)properties.get(RightKneePitchName)).put("velocityLowerLimit", -6.11);
        ((Map)properties.get(RightKneePitchName)).put("velocityUpperLimit", 6.11);
        ((Map)properties.get(RightKneePitchName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(RightKneePitchName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(RightKneePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightKneePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightKneePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightKneePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightKneePitchName)).put("damping", 0.1);
        ((Map)properties.get(RightKneePitchName)).put("stiction", 0.0);
        properties.put(RightAnklePitchName, new HashMap());
        properties.put(RightAnklePitchLinkName, new HashMap());
        ((Map)properties.get(RightAnklePitchLinkName)).put("mass", 0.03);
        ((Map)properties.get(RightAnklePitchLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(RightAnklePitchLinkName)).put("inertia", new Matrix3D(4.377E-6, 0.0, 0.0, 0.0, 4.322E-6, 0.0, 0.0, 0.0, 7.015E-6));
        ((Map)properties.get(RightAnklePitchName)).put("offsetFromParentJoint", new Vector3D(-0.010238125, 0.0, -0.40627099999999994));
        ((Map)properties.get(RightAnklePitchName)).put("positionLowerLimit", -0.8644);
        ((Map)properties.get(RightAnklePitchName)).put("positionUpperLimit", 0.875);
        ((Map)properties.get(RightAnklePitchName)).put("velocityLowerLimit", -11.0);
        ((Map)properties.get(RightAnklePitchName)).put("velocityUpperLimit", 11.0);
        ((Map)properties.get(RightAnklePitchName)).put("effortLowerLimit", -205.0);
        ((Map)properties.get(RightAnklePitchName)).put("effortUpperLimit", 205.0);
        ((Map)properties.get(RightAnklePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightAnklePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightAnklePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightAnklePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightAnklePitchName)).put("damping", 0.1);
        ((Map)properties.get(RightAnklePitchName)).put("stiction", 0.0);
        properties.put(RightAnkleRollName, new HashMap());
        properties.put(RightFootName, new HashMap());
        ((Map)properties.get(RightFootName)).put("mass", 2.37);
        ((Map)properties.get(RightFootName)).put("centerOfMass", new Vector3D(0.0369087, 0.00494324, -0.0489279));
        ((Map)properties.get(RightFootName)).put("inertia", new Matrix3D(0.00641532, 2.0788E-4, 0.00128536, 2.0788E-4, 0.0179943, -2.02908E-4, 0.00128536, -2.02908E-4, 0.0209358));
        ((Map)properties.get(RightAnkleRollName)).put("offsetFromParentJoint", new Vector3D(0.0101259, 0.0, 0.0));
        ((Map)properties.get(RightAnkleRollName)).put("positionLowerLimit", -0.349);
        ((Map)properties.get(RightAnkleRollName)).put("positionUpperLimit", 0.348);
        ((Map)properties.get(RightAnkleRollName)).put("velocityLowerLimit", -11.0);
        ((Map)properties.get(RightAnkleRollName)).put("velocityUpperLimit", 11.0);
        ((Map)properties.get(RightAnkleRollName)).put("effortLowerLimit", -205.0);
        ((Map)properties.get(RightAnkleRollName)).put("effortUpperLimit", 205.0);
        ((Map)properties.get(RightAnkleRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightAnkleRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightAnkleRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightAnkleRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightAnkleRollName)).put("damping", 0.3);
        ((Map)properties.get(RightAnkleRollName)).put("stiction", 0.0);
        properties.put(TorsoYawName, new HashMap());
        properties.put(TorsoYawLinkName, new HashMap());
        ((Map)properties.get(TorsoYawLinkName)).put("mass", 0.5);
        ((Map)properties.get(TorsoYawLinkName)).put("centerOfMass", new Vector3D(0.0, 0.0, -0.01));
        ((Map)properties.get(TorsoYawLinkName)).put("inertia", new Matrix3D(6.08427E-4, -1.172E-6, 1.647E-6, -1.172E-6, 6.20328E-4, -2.33E-7, 1.647E-6, -2.33E-7, 0.00107811));
        ((Map)properties.get(TorsoYawName)).put("offsetFromParentJoint", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(TorsoYawName)).put("positionLowerLimit", -1.329);
        ((Map)properties.get(TorsoYawName)).put("positionUpperLimit", 1.181);
        ((Map)properties.get(TorsoYawName)).put("velocityLowerLimit", -5.89);
        ((Map)properties.get(TorsoYawName)).put("velocityUpperLimit", 5.89);
        ((Map)properties.get(TorsoYawName)).put("effortLowerLimit", -190.0);
        ((Map)properties.get(TorsoYawName)).put("effortUpperLimit", 190.0);
        ((Map)properties.get(TorsoYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(TorsoYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(TorsoYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(TorsoYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(TorsoYawName)).put("damping", 0.1);
        ((Map)properties.get(TorsoYawName)).put("stiction", 0.0);
        properties.put(TorsoPitchName, new HashMap());
        properties.put(TorsoPitchLinkName, new HashMap());
        ((Map)properties.get(TorsoPitchLinkName)).put("mass", 0.1);
        ((Map)properties.get(TorsoPitchLinkName)).put("centerOfMass", new Vector3D(0.0, 0.0, 0.005));
        ((Map)properties.get(TorsoPitchLinkName)).put("inertia", new Matrix3D(3.032E-5, 0.0, -1.145E-6, 0.0, 2.1274E-5, 0.0, -1.145E-6, 0.0, 2.8285E-5));
        ((Map)properties.get(TorsoPitchName)).put("offsetFromParentJoint", new Vector3D(0.04191, 0.0, 0.0));
        ((Map)properties.get(TorsoPitchName)).put("positionLowerLimit", -0.13);
        ((Map)properties.get(TorsoPitchName)).put("positionUpperLimit", 0.666);
        ((Map)properties.get(TorsoPitchName)).put("velocityLowerLimit", -9.0);
        ((Map)properties.get(TorsoPitchName)).put("velocityUpperLimit", 9.0);
        ((Map)properties.get(TorsoPitchName)).put("effortLowerLimit", -150.0);
        ((Map)properties.get(TorsoPitchName)).put("effortUpperLimit", 150.0);
        ((Map)properties.get(TorsoPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(TorsoPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(TorsoPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(TorsoPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(TorsoPitchName)).put("damping", 0.1);
        ((Map)properties.get(TorsoPitchName)).put("stiction", 0.0);
        properties.put(TorsoRollName, new HashMap());
        properties.put(TorsoName, new HashMap());
        ((Map)properties.get(TorsoName)).put("mass", 39.47);
        ((Map)properties.get(TorsoName)).put("centerOfMass", new Vector3D(-0.095548, -0.003337, 0.243098));
        ((Map)properties.get(TorsoName)).put("inertia", new Matrix3D(0.873269, 9.95625E-5, 0.0613452, 9.95625E-5, 1.01085, 0.00181849, 0.0613452, 0.00181849, 0.778398));
        ((Map)properties.get(TorsoRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0203));
        ((Map)properties.get(TorsoRollName)).put("positionLowerLimit", -0.23);
        ((Map)properties.get(TorsoRollName)).put("positionUpperLimit", 0.255);
        ((Map)properties.get(TorsoRollName)).put("velocityLowerLimit", -9.0);
        ((Map)properties.get(TorsoRollName)).put("velocityUpperLimit", 9.0);
        ((Map)properties.get(TorsoRollName)).put("effortLowerLimit", -150.0);
        ((Map)properties.get(TorsoRollName)).put("effortUpperLimit", 150.0);
        ((Map)properties.get(TorsoRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(TorsoRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(TorsoRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(TorsoRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(TorsoRollName)).put("damping", 0.1);
        ((Map)properties.get(TorsoRollName)).put("stiction", 0.0);
        properties.put(LeftShoulderPitchName, new HashMap());
        properties.put(LeftShoulderPitchLinkName, new HashMap());
        ((Map)properties.get(LeftShoulderPitchLinkName)).put("mass", 2.65);
        ((Map)properties.get(LeftShoulderPitchLinkName)).put("centerOfMass", new Vector3D(-0.012, 0.251, 0.0));
        ((Map)properties.get(LeftShoulderPitchLinkName)).put("inertia", new Matrix3D(0.0137182, 0.0, 0.0, 0.0, 0.0105028, 0.0, 0.0, 0.0, 0.0148064));
        ((Map)properties.get(LeftShoulderPitchName)).put("offsetFromParentJoint", new Vector3D(-0.0316, 0.0, 0.2984));
        ((Map)properties.get(LeftShoulderPitchName)).put("positionLowerLimit", -2.85);
        ((Map)properties.get(LeftShoulderPitchName)).put("positionUpperLimit", 2.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("velocityLowerLimit", -3.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("velocityUpperLimit", 3.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("effortLowerLimit", -190.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("effortUpperLimit", 190.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftShoulderPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftShoulderPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftShoulderPitchName)).put("stiction", 0.0);
        properties.put(LeftShoulderRollName, new HashMap());
        properties.put(LeftShoulderRollLinkName, new HashMap());
        ((Map)properties.get(LeftShoulderRollLinkName)).put("mass", 3.97);
        ((Map)properties.get(LeftShoulderRollLinkName)).put("centerOfMass", new Vector3D(-0.008513, 0.02068, -0.001088));
        ((Map)properties.get(LeftShoulderRollLinkName)).put("inertia", new Matrix3D(0.0145988, -6.6764E-4, -3.629E-5, -6.6764E-4, 0.00645214, -8.283E-5, -3.629E-5, -8.283E-5, 0.0168483));
        ((Map)properties.get(LeftShoulderRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.2499, 0.0));
        ((Map)properties.get(LeftShoulderRollName)).put("positionLowerLimit", -1.519);
        ((Map)properties.get(LeftShoulderRollName)).put("positionUpperLimit", 1.266);
        ((Map)properties.get(LeftShoulderRollName)).put("velocityLowerLimit", -3.5);
        ((Map)properties.get(LeftShoulderRollName)).put("velocityUpperLimit", 3.5);
        ((Map)properties.get(LeftShoulderRollName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(LeftShoulderRollName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(LeftShoulderRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftShoulderRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftShoulderRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftShoulderRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftShoulderRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftShoulderRollName)).put("stiction", 0.0);
        properties.put(LeftShoulderYawName, new HashMap());
        properties.put(LeftShoulderYawLinkName, new HashMap());
        ((Map)properties.get(LeftShoulderYawLinkName)).put("mass", 3.085);
        ((Map)properties.get(LeftShoulderYawLinkName)).put("centerOfMass", new Vector3D(-0.004304, 0.209832, 0.007295));
        ((Map)properties.get(LeftShoulderYawLinkName)).put("inertia", new Matrix3D(0.0393552, -0.00782708, -7.53947E-4, -0.00782708, 0.00490577, 0.00272387, -7.53947E-4, 0.00272387, 0.0418795));
        ((Map)properties.get(LeftShoulderYawName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(LeftShoulderYawName)).put("positionLowerLimit", -3.1);
        ((Map)properties.get(LeftShoulderYawName)).put("positionUpperLimit", 2.18);
        ((Map)properties.get(LeftShoulderYawName)).put("velocityLowerLimit", -1.5);
        ((Map)properties.get(LeftShoulderYawName)).put("velocityUpperLimit", 1.5);
        ((Map)properties.get(LeftShoulderYawName)).put("effortLowerLimit", -65.0);
        ((Map)properties.get(LeftShoulderYawName)).put("effortUpperLimit", 65.0);
        ((Map)properties.get(LeftShoulderYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftShoulderYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftShoulderYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftShoulderYawName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftShoulderYawName)).put("damping", 0.1);
        ((Map)properties.get(LeftShoulderYawName)).put("stiction", 0.0);
        properties.put(LeftElbowPitchName, new HashMap());
        properties.put(LeftElbowPitchLinkName, new HashMap());
        ((Map)properties.get(LeftElbowPitchLinkName)).put("mass", 1.83);
        ((Map)properties.get(LeftElbowPitchLinkName)).put("centerOfMass", new Vector3D(-0.020344, 0.014722, 0.0223));
        ((Map)properties.get(LeftElbowPitchLinkName)).put("inertia", new Matrix3D(0.00331452, 5.35099E-4, 7.28077E-4, 5.35099E-4, 0.00350567, -4.23865E-4, 7.28077E-4, -4.23865E-4, 0.00301128));
        ((Map)properties.get(LeftElbowPitchName)).put("offsetFromParentJoint", new Vector3D(0.0254, 0.32999999999999996, 0.0));
        ((Map)properties.get(LeftElbowPitchName)).put("positionLowerLimit", -2.174);
        ((Map)properties.get(LeftElbowPitchName)).put("positionUpperLimit", 0.12);
        ((Map)properties.get(LeftElbowPitchName)).put("velocityLowerLimit", -3.5);
        ((Map)properties.get(LeftElbowPitchName)).put("velocityUpperLimit", 3.5);
        ((Map)properties.get(LeftElbowPitchName)).put("effortLowerLimit", -65.0);
        ((Map)properties.get(LeftElbowPitchName)).put("effortUpperLimit", 65.0);
        ((Map)properties.get(LeftElbowPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftElbowPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftElbowPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftElbowPitchName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(LeftElbowPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftElbowPitchName)).put("stiction", 0.0);
        properties.put(LeftForearmYawName, new HashMap());
        properties.put(LeftForearmLinkName, new HashMap());
        ((Map)properties.get(LeftForearmLinkName)).put("mass", 2.476);
        ((Map)properties.get(LeftForearmLinkName)).put("centerOfMass", new Vector3D(0.015, 0.13, 0.019564));
        ((Map)properties.get(LeftForearmLinkName)).put("inertia", new Matrix3D(0.0117554, 0.00130085, -7.27141E-4, 0.00130085, 0.00507157, 0.00169542, -7.27141E-4, 0.00169542, 0.0113657));
        ((Map)properties.get(LeftForearmYawName)).put("offsetFromParentJoint", new Vector3D(-0.0254, 0.0, 0.0));
        ((Map)properties.get(LeftForearmYawName)).put("positionLowerLimit", -2.019);
        ((Map)properties.get(LeftForearmYawName)).put("positionUpperLimit", 3.14);
        ((Map)properties.get(LeftForearmYawName)).put("velocityLowerLimit", -0.8);
        ((Map)properties.get(LeftForearmYawName)).put("velocityUpperLimit", 0.8);
        ((Map)properties.get(LeftForearmYawName)).put("effortLowerLimit", -26.0);
        ((Map)properties.get(LeftForearmYawName)).put("effortUpperLimit", 26.0);
        ((Map)properties.get(LeftForearmYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftForearmYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftForearmYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftForearmYawName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftForearmYawName)).put("damping", 0.1);
        ((Map)properties.get(LeftForearmYawName)).put("stiction", 0.0);
        properties.put(LeftWristRollName, new HashMap());
        properties.put(LeftWristRollLinkName, new HashMap());
        ((Map)properties.get(LeftWristRollLinkName)).put("mass", 0.14);
        ((Map)properties.get(LeftWristRollLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(LeftWristRollLinkName)).put("inertia", new Matrix3D(3.0251E-5, 1.25E-7, 3.6E-8, 1.25E-7, 3.772E-5, 0.0, 3.6E-8, 0.0, 9.395E-6));
        ((Map)properties.get(LeftWristRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.2871, 0.0));
        ((Map)properties.get(LeftWristRollName)).put("positionLowerLimit", -0.35);
        ((Map)properties.get(LeftWristRollName)).put("positionUpperLimit", 0.35);
        ((Map)properties.get(LeftWristRollName)).put("velocityLowerLimit", -1.0);
        ((Map)properties.get(LeftWristRollName)).put("velocityUpperLimit", 1.0);
        ((Map)properties.get(LeftWristRollName)).put("effortLowerLimit", -14.0);
        ((Map)properties.get(LeftWristRollName)).put("effortUpperLimit", 14.0);
        ((Map)properties.get(LeftWristRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftWristRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftWristRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftWristRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftWristRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftWristRollName)).put("stiction", 0.0);
        properties.put(LeftWristPitchName, new HashMap());
        properties.put(LeftPalmName, new HashMap());
        ((Map)properties.get(LeftPalmName)).put("mass", 0.712);
        ((Map)properties.get(LeftPalmName)).put("centerOfMass", new Vector3D(0.002954, 0.052034, -2.36E-4));
        ((Map)properties.get(LeftPalmName)).put("inertia", new Matrix3D(9.43493E-4, 3.4393E-5, 3.8828E-5, 3.4393E-5, 7.11024E-4, -2.3429E-5, 3.8828E-5, -2.3429E-5, 6.10199E-4));
        ((Map)properties.get(LeftWristPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(LeftWristPitchName)).put("positionLowerLimit", -0.6);
        ((Map)properties.get(LeftWristPitchName)).put("positionUpperLimit", 0.6);
        ((Map)properties.get(LeftWristPitchName)).put("velocityLowerLimit", -1.0);
        ((Map)properties.get(LeftWristPitchName)).put("velocityUpperLimit", 1.0);
        ((Map)properties.get(LeftWristPitchName)).put("effortLowerLimit", -14.0);
        ((Map)properties.get(LeftWristPitchName)).put("effortUpperLimit", 14.0);
        ((Map)properties.get(LeftWristPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftWristPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftWristPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftWristPitchName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(LeftWristPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftWristPitchName)).put("stiction", 0.0);
        properties.put("leftIndexFingerPitch1", new HashMap());
        properties.put("leftIndexFingerPitch1Link", new HashMap());
        ((Map)properties.get("leftIndexFingerPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("leftIndexFingerPitch1Link")).put("centerOfMass", new Vector3D(0.0, 0.019696269397585765, 0.0034723150516228376));
        ((Map)properties.get("leftIndexFingerPitch1Link")).put("inertia", new Matrix3D(4.232E-6, 5.769988217210815E-8, 1.8295452913902818E-8, 5.769988217210815E-8, 1.2980849917342867E-6, -4.642891416145748E-7, 1.8295452913902818E-8, -4.642891416145748E-7, 3.8089150082657133E-6));
        ((Map)properties.get("leftIndexFingerPitch1")).put("offsetFromParentJoint", new Vector3D(0.0022000000000000006, 0.09760000000000002, 0.02350000000000002));
        ((Map)properties.get("leftIndexFingerPitch1")).put("positionLowerLimit", -1.57);
        ((Map)properties.get("leftIndexFingerPitch1")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("axis", new Vector3D(0.0, -0.17361607288187247, 0.9848134134124475));
        ((Map)properties.get("leftIndexFingerPitch1")).put("damping", 1.0);
        ((Map)properties.get("leftIndexFingerPitch1")).put("stiction", 0.0);
        properties.put("leftIndexFingerPitch2", new HashMap());
        properties.put("leftIndexFingerPitch2Link", new HashMap());
        ((Map)properties.get("leftIndexFingerPitch2Link")).put("mass", 0.018);
        ((Map)properties.get("leftIndexFingerPitch2Link")).put("centerOfMass", new Vector3D(0.0, 0.012802575108430745, 0.0022570047835548442));
        ((Map)properties.get("leftIndexFingerPitch2Link")).put("inertia", new Matrix3D(1.562E-6, 1.4484824204393054E-8, 1.575404290231016E-8, 1.4484824204393054E-8, 7.274652087801619E-7, -6.200070784124636E-8, 1.575404290231016E-8, -6.200070784124639E-8, 1.249534791219838E-6));
        ((Map)properties.get("leftIndexFingerPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, 0.037519999999999935, 0.006614999999999957));
        ((Map)properties.get("leftIndexFingerPitch2")).put("positionLowerLimit", -1.658);
        ((Map)properties.get("leftIndexFingerPitch2")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("axis", new Vector3D(0.0, -0.17361607288187247, 0.9848134134124475));
        ((Map)properties.get("leftIndexFingerPitch2")).put("damping", 1.0);
        ((Map)properties.get("leftIndexFingerPitch2")).put("stiction", 0.0);
        properties.put("leftIndexFingerPitch3", new HashMap());
        properties.put("leftIndexFingerPitch3Link", new HashMap());
        ((Map)properties.get("leftIndexFingerPitch3Link")).put("mass", 0.01);
        ((Map)properties.get("leftIndexFingerPitch3Link")).put("centerOfMass", new Vector3D(0.0, 0.009848134698792883, 0.0017361575258114188));
        ((Map)properties.get("leftIndexFingerPitch3Link")).put("inertia", new Matrix3D(6.02E-7, 2.3635523277102915E-8, 4.1667780619474044E-9, 2.3635523277102915E-8, 2.1201844137782995E-7, -3.4121728199972275E-8, 4.1667780619474044E-9, -3.412172819997229E-8, 4.989815586221701E-7));
        ((Map)properties.get("leftIndexFingerPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, 0.022550000000000042, 0.003976000000000067));
        ((Map)properties.get("leftIndexFingerPitch3")).put("positionLowerLimit", -1.92);
        ((Map)properties.get("leftIndexFingerPitch3")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("axis", new Vector3D(0.0, -0.17361607288187247, 0.9848134134124475));
        ((Map)properties.get("leftIndexFingerPitch3")).put("damping", 1.0);
        ((Map)properties.get("leftIndexFingerPitch3")).put("stiction", 0.0);
        properties.put("leftMiddleFingerPitch1", new HashMap());
        properties.put("leftMiddleFingerPitch1Link", new HashMap());
        ((Map)properties.get("leftMiddleFingerPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("leftMiddleFingerPitch1Link")).put("centerOfMass", new Vector3D(0.0, 0.019850857332287003, -0.002437921896449382));
        ((Map)properties.get("leftMiddleFingerPitch1Link")).put("inertia", new Matrix3D(5.148E-6, 4.3027657440849864E-8, 5.798335550214148E-9, 4.3027657440849864E-8, 1.369619914645733E-6, 3.91746684249759E-7, 5.798335550214148E-9, 3.9174668424975893E-7, 4.544380085354267E-6));
        ((Map)properties.get("leftMiddleFingerPitch1")).put("offsetFromParentJoint", new Vector3D(0.0022000000000000006, 0.09699999999999998, -0.011899999999999966));
        ((Map)properties.get("leftMiddleFingerPitch1")).put("positionLowerLimit", -1.658);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("axis", new Vector3D(0.0, 0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("leftMiddleFingerPitch1")).put("damping", 1.0);
        ((Map)properties.get("leftMiddleFingerPitch1")).put("stiction", 0.0);
        properties.put("leftMiddleFingerPitch2", new HashMap());
        properties.put("leftMiddleFingerPitch2Link", new HashMap());
        ((Map)properties.get("leftMiddleFingerPitch2Link")).put("mass", 0.011);
        ((Map)properties.get("leftMiddleFingerPitch2Link")).put("centerOfMass", new Vector3D(0.0, 0.012903057265986551, -0.0015846492326920985));
        ((Map)properties.get("leftMiddleFingerPitch2Link")).put("inertia", new Matrix3D(1.97E-6, -3.240560042184074E-8, 1.50624387567218E-8, -3.240560042184074E-8, 5.606531868249063E-7, 1.3217378737957825E-7, 1.50624387567218E-8, 1.321737873795783E-7, 2.265346813175094E-6));
        ((Map)properties.get("leftMiddleFingerPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, 0.037820000000000006, -0.004644000000000044));
        ((Map)properties.get("leftMiddleFingerPitch2")).put("positionLowerLimit", -1.92);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("axis", new Vector3D(0.0, 0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("leftMiddleFingerPitch2")).put("damping", 1.0);
        ((Map)properties.get("leftMiddleFingerPitch2")).put("stiction", 0.0);
        properties.put("leftMiddleFingerPitch3", new HashMap());
        properties.put("leftMiddleFingerPitch3Link", new HashMap());
        ((Map)properties.get("leftMiddleFingerPitch3Link")).put("mass", 0.006);
        ((Map)properties.get("leftMiddleFingerPitch3Link")).put("centerOfMass", new Vector3D(0.0, 0.009925428666143501, -0.001218960948224691));
        ((Map)properties.get("leftMiddleFingerPitch3Link")).put("inertia", new Matrix3D(3.96E-7, 9.05478189435162E-9, -1.0452198678787192E-10, 9.05478189435162E-9, 1.659963752647085E-7, 3.2825678158083905E-8, -1.0452198678787192E-10, 3.282567815808391E-8, 2.9700362473529145E-7));
        ((Map)properties.get("leftMiddleFingerPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, 0.022730000000000167, -0.002791999999999949));
        ((Map)properties.get("leftMiddleFingerPitch3")).put("positionLowerLimit", -1.57);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("axis", new Vector3D(0.0, 0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("leftMiddleFingerPitch3")).put("damping", 1.0);
        ((Map)properties.get("leftMiddleFingerPitch3")).put("stiction", 0.0);
        properties.put("leftPinkyPitch1", new HashMap());
        properties.put("leftPinkyPitch1Link", new HashMap());
        ((Map)properties.get("leftPinkyPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("leftPinkyPitch1Link")).put("centerOfMass", new Vector3D(0.0, 0.019850857332287003, -0.002437921896449382));
        ((Map)properties.get("leftPinkyPitch1Link")).put("inertia", new Matrix3D(5.148E-6, 4.3027657440849864E-8, 5.798335550214148E-9, 4.3027657440849864E-8, 1.369619914645733E-6, 3.91746684249759E-7, 5.798335550214148E-9, 3.9174668424975893E-7, 4.544380085354267E-6));
        ((Map)properties.get("leftPinkyPitch1")).put("offsetFromParentJoint", new Vector3D(0.0022000000000000006, 0.08379999999999999, -0.04099999999999998));
        ((Map)properties.get("leftPinkyPitch1")).put("positionLowerLimit", -1.57);
        ((Map)properties.get("leftPinkyPitch1")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftPinkyPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftPinkyPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftPinkyPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftPinkyPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftPinkyPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftPinkyPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftPinkyPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftPinkyPitch1")).put("axis", new Vector3D(0.0, 0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("leftPinkyPitch1")).put("damping", 1.0);
        ((Map)properties.get("leftPinkyPitch1")).put("stiction", 0.0);
        properties.put("leftPinkyPitch2", new HashMap());
        properties.put("leftPinkyPitch2Link", new HashMap());
        ((Map)properties.get("leftPinkyPitch2Link")).put("mass", 0.011);
        ((Map)properties.get("leftPinkyPitch2Link")).put("centerOfMass", new Vector3D(0.0, 0.012903057265986551, -0.0015846492326920985));
        ((Map)properties.get("leftPinkyPitch2Link")).put("inertia", new Matrix3D(1.97E-6, -3.240560042184074E-8, 1.50624387567218E-8, -3.240560042184074E-8, 5.606531868249063E-7, 1.3217378737957825E-7, 1.50624387567218E-8, 1.321737873795783E-7, 2.265346813175094E-6));
        ((Map)properties.get("leftPinkyPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, 0.037816000000000016, -0.0046439999999999025));
        ((Map)properties.get("leftPinkyPitch2")).put("positionLowerLimit", -1.658);
        ((Map)properties.get("leftPinkyPitch2")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftPinkyPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftPinkyPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftPinkyPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftPinkyPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftPinkyPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftPinkyPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftPinkyPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftPinkyPitch2")).put("axis", new Vector3D(0.0, 0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("leftPinkyPitch2")).put("damping", 1.0);
        ((Map)properties.get("leftPinkyPitch2")).put("stiction", 0.0);
        properties.put("leftPinkyPitch3", new HashMap());
        properties.put("leftPinkyPitch3Link", new HashMap());
        ((Map)properties.get("leftPinkyPitch3Link")).put("mass", 0.006);
        ((Map)properties.get("leftPinkyPitch3Link")).put("centerOfMass", new Vector3D(0.0, 0.009925428666143501, -0.001218960948224691));
        ((Map)properties.get("leftPinkyPitch3Link")).put("inertia", new Matrix3D(3.96E-7, 9.05478189435162E-9, -1.0452198678787192E-10, 9.05478189435162E-9, 1.659963752647085E-7, 3.2825678158083905E-8, -1.0452198678787192E-10, 3.282567815808391E-8, 2.9700362473529145E-7));
        ((Map)properties.get("leftPinkyPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, 0.022734000000000056, -0.0027920000000000765));
        ((Map)properties.get("leftPinkyPitch3")).put("positionLowerLimit", -1.92);
        ((Map)properties.get("leftPinkyPitch3")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftPinkyPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftPinkyPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftPinkyPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftPinkyPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftPinkyPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftPinkyPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftPinkyPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftPinkyPitch3")).put("axis", new Vector3D(0.0, 0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("leftPinkyPitch3")).put("damping", 1.0);
        ((Map)properties.get("leftPinkyPitch3")).put("stiction", 0.0);
        properties.put("leftThumbRoll", new HashMap());
        properties.put("leftThumbRollLink", new HashMap());
        ((Map)properties.get("leftThumbRollLink")).put("mass", 0.017);
        ((Map)properties.get("leftThumbRollLink")).put("centerOfMass", new Vector3D(0.0, 0.003420522332544199, 0.009396809403865038));
        ((Map)properties.get("leftThumbRollLink")).put("inertia", new Matrix3D(2.77788E-6, 3.800365322933979E-8, 8.7821261445544E-8, 3.800365322933979E-8, 3.2663699259248467E-6, -7.322727571414368E-7, 8.7821261445544E-8, -7.322727571414366E-7, 1.6352200740751536E-6));
        ((Map)properties.get("leftThumbRoll")).put("offsetFromParentJoint", new Vector3D(0.0049, 0.03510000000000002, 0.022800000000000042));
        ((Map)properties.get("leftThumbRoll")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("leftThumbRoll")).put("positionUpperLimit", 2.356);
        ((Map)properties.get("leftThumbRoll")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftThumbRoll")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftThumbRoll")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftThumbRoll")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftThumbRoll")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftThumbRoll")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftThumbRoll")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftThumbRoll")).put("axis", new Vector3D(0.0, 0.939681022333869, -0.34205200812972125));
        ((Map)properties.get("leftThumbRoll")).put("damping", 1.0);
        ((Map)properties.get("leftThumbRoll")).put("stiction", 0.0);
        properties.put("leftThumbPitch1", new HashMap());
        properties.put("leftThumbPitch1Link", new HashMap());
        ((Map)properties.get("leftThumbPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("leftThumbPitch1Link")).put("centerOfMass", new Vector3D(0.0, 0.005, 0.02));
        ((Map)properties.get("leftThumbPitch1Link")).put("inertia", new Matrix3D(4.239E-6, 0.0, 0.0, 0.0, 4.582E-6, -0.0, 0.0, -0.0, 1.47E-6));
        ((Map)properties.get("leftThumbPitch1")).put("offsetFromParentJoint", new Vector3D(0.0, 0.007832999999999965, 0.021518999999999993));
        ((Map)properties.get("leftThumbPitch1")).put("positionLowerLimit", -1.658);
        ((Map)properties.get("leftThumbPitch1")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftThumbPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftThumbPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftThumbPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftThumbPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftThumbPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftThumbPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftThumbPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftThumbPitch1")).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get("leftThumbPitch1")).put("damping", 1.0);
        ((Map)properties.get("leftThumbPitch1")).put("stiction", 0.0);
        properties.put("leftThumbPitch2", new HashMap());
        properties.put("leftThumbPitch2Link", new HashMap());
        ((Map)properties.get("leftThumbPitch2Link")).put("mass", 0.013);
        ((Map)properties.get("leftThumbPitch2Link")).put("centerOfMass", new Vector3D(0.0, 0.004, 0.017));
        ((Map)properties.get("leftThumbPitch2Link")).put("inertia", new Matrix3D(1.266E-6, 0.0, 0.0, 0.0, 1.503E-6, 0.0, 0.0, 0.0, 6.99E-7));
        ((Map)properties.get("leftThumbPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, 0.00660000000000005, 0.03750000000000003));
        ((Map)properties.get("leftThumbPitch2")).put("positionLowerLimit", -1.92);
        ((Map)properties.get("leftThumbPitch2")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftThumbPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftThumbPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftThumbPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftThumbPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftThumbPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftThumbPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftThumbPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftThumbPitch2")).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get("leftThumbPitch2")).put("damping", 1.0);
        ((Map)properties.get("leftThumbPitch2")).put("stiction", 0.0);
        properties.put("leftThumbPitch3", new HashMap());
        properties.put("leftThumbPitch3Link", new HashMap());
        ((Map)properties.get("leftThumbPitch3Link")).put("mass", 0.006);
        ((Map)properties.get("leftThumbPitch3Link")).put("centerOfMass", new Vector3D(0.0, 0.004, 0.01));
        ((Map)properties.get("leftThumbPitch3Link")).put("inertia", new Matrix3D(3.22E-7, 0.0, 0.0, 0.0, 4.06E-7, 0.0, 0.0, 0.0, 2.1E-7));
        ((Map)properties.get("leftThumbPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, 0.004899999999999904, 0.02749999999999997));
        ((Map)properties.get("leftThumbPitch3")).put("positionLowerLimit", -1.57);
        ((Map)properties.get("leftThumbPitch3")).put("positionUpperLimit", -0.0);
        ((Map)properties.get("leftThumbPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("leftThumbPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("leftThumbPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("leftThumbPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("leftThumbPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("leftThumbPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("leftThumbPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("leftThumbPitch3")).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get("leftThumbPitch3")).put("damping", 1.0);
        ((Map)properties.get("leftThumbPitch3")).put("stiction", 0.0);
        properties.put(NeckLowerPitchName, new HashMap());
        properties.put(NeckLowerPitchLinkName, new HashMap());
        ((Map)properties.get(NeckLowerPitchLinkName)).put("mass", 1.05);
        ((Map)properties.get(NeckLowerPitchLinkName)).put("centerOfMass", new Vector3D(-0.02, 0.0, 0.04));
        ((Map)properties.get(NeckLowerPitchLinkName)).put("inertia", new Matrix3D(0.00147072, -1.26021E-4, 6.32521E-4, -1.26021E-4, 0.00185192, 2.43012E-4, 6.32521E-4, 2.43012E-4, 8.32117E-4));
        ((Map)properties.get(NeckLowerPitchName)).put("offsetFromParentJoint", new Vector3D(0.020351799999999996, 0.0, 0.33845000000000003));
        ((Map)properties.get(NeckLowerPitchName)).put("positionLowerLimit", 0.0);
        ((Map)properties.get(NeckLowerPitchName)).put("positionUpperLimit", 1.162);
        ((Map)properties.get(NeckLowerPitchName)).put("velocityLowerLimit", -5.0);
        ((Map)properties.get(NeckLowerPitchName)).put("velocityUpperLimit", 5.0);
        ((Map)properties.get(NeckLowerPitchName)).put("effortLowerLimit", -26.0);
        ((Map)properties.get(NeckLowerPitchName)).put("effortUpperLimit", 26.0);
        ((Map)properties.get(NeckLowerPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(NeckLowerPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(NeckLowerPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(NeckLowerPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(NeckLowerPitchName)).put("damping", 0.1);
        ((Map)properties.get(NeckLowerPitchName)).put("stiction", 0.0);
        properties.put(NeckYawName, new HashMap());
        properties.put(NeckYawLinkName, new HashMap());
        ((Map)properties.get(NeckYawLinkName)).put("mass", 1.4);
        ((Map)properties.get(NeckYawLinkName)).put("centerOfMass", new Vector3D(-0.03, -0.01, 0.15));
        ((Map)properties.get(NeckYawLinkName)).put("inertia", new Matrix3D(0.0019977, -1.80062E-4, 7.23677E-4, -1.80062E-4, 0.00291993, 2.46467E-4, 7.23677E-4, 2.46467E-4, 0.00211975));
        ((Map)properties.get(NeckYawName)).put("offsetFromParentJoint", new Vector3D(-0.051924, 0.0, 0.0));
        ((Map)properties.get(NeckYawName)).put("positionLowerLimit", -1.0472);
        ((Map)properties.get(NeckYawName)).put("positionUpperLimit", 1.0472);
        ((Map)properties.get(NeckYawName)).put("velocityLowerLimit", -5.0);
        ((Map)properties.get(NeckYawName)).put("velocityUpperLimit", 5.0);
        ((Map)properties.get(NeckYawName)).put("effortLowerLimit", -26.0);
        ((Map)properties.get(NeckYawName)).put("effortUpperLimit", 26.0);
        ((Map)properties.get(NeckYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(NeckYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(NeckYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(NeckYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(NeckYawName)).put("damping", 0.1);
        ((Map)properties.get(NeckYawName)).put("stiction", 0.0);
        properties.put(NeckUpperPitchName, new HashMap());
        properties.put(NeckUpperPitchLinkName, new HashMap());
        ((Map)properties.get(NeckUpperPitchLinkName)).put("mass", 5.30991);
        ((Map)properties.get(NeckUpperPitchLinkName)).put("centerOfMass", new Vector3D(0.102036, 0.00422754, 0.0409152));
        ((Map)properties.get(NeckUpperPitchLinkName)).put("inertia", new Matrix3D(0.0446288, -4.43568E-4, -0.0021252, -4.43568E-4, 0.0461084, -6.44772E-4, -0.0021252, -6.44772E-4, 0.0402031));
        ((Map)properties.get(NeckUpperPitchName)).put("offsetFromParentJoint", new Vector3D(-0.06, 0.0, 0.19599699999999998));
        ((Map)properties.get(NeckUpperPitchName)).put("positionLowerLimit", -0.872);
        ((Map)properties.get(NeckUpperPitchName)).put("positionUpperLimit", 0.0);
        ((Map)properties.get(NeckUpperPitchName)).put("velocityLowerLimit", -5.0);
        ((Map)properties.get(NeckUpperPitchName)).put("velocityUpperLimit", 5.0);
        ((Map)properties.get(NeckUpperPitchName)).put("effortLowerLimit", -26.0);
        ((Map)properties.get(NeckUpperPitchName)).put("effortUpperLimit", 26.0);
        ((Map)properties.get(NeckUpperPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(NeckUpperPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(NeckUpperPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(NeckUpperPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(NeckUpperPitchName)).put("damping", 0.1);
        ((Map)properties.get(NeckUpperPitchName)).put("stiction", 0.0);
        properties.put(HokuyoJointName, new HashMap());
        properties.put(HokuyoLinkName, new HashMap());
        ((Map)properties.get(HokuyoLinkName)).put("mass", 0.057664);
        ((Map)properties.get(HokuyoLinkName)).put("centerOfMass", new Vector3D(0.03270279235379761, -4.084110874927957E-4, -9.106101256784079E-5));
        ((Map)properties.get(HokuyoLinkName)).put("inertia", new Matrix3D(3.541192586390836E-5, -5.075197116557559E-8, -1.004534784646333E-5, -5.075197116557559E-8, 4.343700005209264E-5, -3.2175569823047584E-9, -1.0045347846463328E-5, -3.217556982304757E-9, 4.545707408399899E-5));
        ((Map)properties.get(HokuyoJointName)).put("offsetFromParentJoint", new Vector3D(0.1278812, 2.33516E-7, -0.006071999999999966));
        ((Map)properties.get(HokuyoJointName)).put("positionLowerLimit", -1.0E16);
        ((Map)properties.get(HokuyoJointName)).put("positionUpperLimit", 1.0E16);
        ((Map)properties.get(HokuyoJointName)).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("effortLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("effortUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(HokuyoJointName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(HokuyoJointName)).put("kpVelocityLimit", 0.0);
        ((Map)properties.get(HokuyoJointName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(HokuyoJointName)).put("damping", 0.01);
        ((Map)properties.get(HokuyoJointName)).put("stiction", 0.0);
        properties.put(RightShoulderPitchName, new HashMap());
        properties.put(RightShoulderPitchLinkName, new HashMap());
        ((Map)properties.get(RightShoulderPitchLinkName)).put("mass", 2.65);
        ((Map)properties.get(RightShoulderPitchLinkName)).put("centerOfMass", new Vector3D(0.012, -0.251, 0.0));
        ((Map)properties.get(RightShoulderPitchLinkName)).put("inertia", new Matrix3D(0.0137182, 0.0, 0.0, 0.0, 0.0105028, 0.0, 0.0, 0.0, 0.0148064));
        ((Map)properties.get(RightShoulderPitchName)).put("offsetFromParentJoint", new Vector3D(-0.0316, 0.0, 0.2984));
        ((Map)properties.get(RightShoulderPitchName)).put("positionLowerLimit", -2.85);
        ((Map)properties.get(RightShoulderPitchName)).put("positionUpperLimit", 2.0);
        ((Map)properties.get(RightShoulderPitchName)).put("velocityLowerLimit", -3.0);
        ((Map)properties.get(RightShoulderPitchName)).put("velocityUpperLimit", 3.0);
        ((Map)properties.get(RightShoulderPitchName)).put("effortLowerLimit", -190.0);
        ((Map)properties.get(RightShoulderPitchName)).put("effortUpperLimit", 190.0);
        ((Map)properties.get(RightShoulderPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightShoulderPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightShoulderPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightShoulderPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightShoulderPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightShoulderPitchName)).put("stiction", 0.0);
        properties.put(RightShoulderRollName, new HashMap());
        properties.put(RightShoulderRollLinkName, new HashMap());
        ((Map)properties.get(RightShoulderRollLinkName)).put("mass", 3.97);
        ((Map)properties.get(RightShoulderRollLinkName)).put("centerOfMass", new Vector3D(0.008513, -0.02068, -0.001088));
        ((Map)properties.get(RightShoulderRollLinkName)).put("inertia", new Matrix3D(0.0145988, -6.6764E-4, 3.629E-5, -6.6764E-4, 0.00645214, 8.283E-5, 3.629E-5, 8.283E-5, 0.0168483));
        ((Map)properties.get(RightShoulderRollName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.2499, 0.0));
        ((Map)properties.get(RightShoulderRollName)).put("positionLowerLimit", -1.266);
        ((Map)properties.get(RightShoulderRollName)).put("positionUpperLimit", 1.519);
        ((Map)properties.get(RightShoulderRollName)).put("velocityLowerLimit", -3.5);
        ((Map)properties.get(RightShoulderRollName)).put("velocityUpperLimit", 3.5);
        ((Map)properties.get(RightShoulderRollName)).put("effortLowerLimit", -350.0);
        ((Map)properties.get(RightShoulderRollName)).put("effortUpperLimit", 350.0);
        ((Map)properties.get(RightShoulderRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightShoulderRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightShoulderRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightShoulderRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightShoulderRollName)).put("damping", 0.1);
        ((Map)properties.get(RightShoulderRollName)).put("stiction", 0.0);
        properties.put(RightShoulderYawName, new HashMap());
        properties.put(RightShoulderYawLinkName, new HashMap());
        ((Map)properties.get(RightShoulderYawLinkName)).put("mass", 3.085);
        ((Map)properties.get(RightShoulderYawLinkName)).put("centerOfMass", new Vector3D(-0.004304, -0.209832, -0.007295));
        ((Map)properties.get(RightShoulderYawLinkName)).put("inertia", new Matrix3D(0.0393552, 0.00782708, 7.53947E-4, 0.00782708, 0.00490577, -0.00272387, 7.53947E-4, -0.00272387, 0.0418795));
        ((Map)properties.get(RightShoulderYawName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(RightShoulderYawName)).put("positionLowerLimit", -3.1);
        ((Map)properties.get(RightShoulderYawName)).put("positionUpperLimit", 2.18);
        ((Map)properties.get(RightShoulderYawName)).put("velocityLowerLimit", -1.5);
        ((Map)properties.get(RightShoulderYawName)).put("velocityUpperLimit", 1.5);
        ((Map)properties.get(RightShoulderYawName)).put("effortLowerLimit", -65.0);
        ((Map)properties.get(RightShoulderYawName)).put("effortUpperLimit", 65.0);
        ((Map)properties.get(RightShoulderYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightShoulderYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightShoulderYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightShoulderYawName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightShoulderYawName)).put("damping", 0.1);
        ((Map)properties.get(RightShoulderYawName)).put("stiction", 0.0);
        properties.put(RightElbowPitchName, new HashMap());
        properties.put(RightElbowPitchLinkName, new HashMap());
        ((Map)properties.get(RightElbowPitchLinkName)).put("mass", 1.83);
        ((Map)properties.get(RightElbowPitchLinkName)).put("centerOfMass", new Vector3D(-0.020344, -0.014722, -0.0223));
        ((Map)properties.get(RightElbowPitchLinkName)).put("inertia", new Matrix3D(0.00331452, -5.35099E-4, -7.28077E-4, -5.35099E-4, 0.00350567, -4.23865E-4, -7.28077E-4, -4.23865E-4, 0.00301128));
        ((Map)properties.get(RightElbowPitchName)).put("offsetFromParentJoint", new Vector3D(0.0254, -0.32999999999999996, 0.0));
        ((Map)properties.get(RightElbowPitchName)).put("positionLowerLimit", -0.12);
        ((Map)properties.get(RightElbowPitchName)).put("positionUpperLimit", 2.174);
        ((Map)properties.get(RightElbowPitchName)).put("velocityLowerLimit", -3.5);
        ((Map)properties.get(RightElbowPitchName)).put("velocityUpperLimit", 3.5);
        ((Map)properties.get(RightElbowPitchName)).put("effortLowerLimit", -65.0);
        ((Map)properties.get(RightElbowPitchName)).put("effortUpperLimit", 65.0);
        ((Map)properties.get(RightElbowPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightElbowPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightElbowPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightElbowPitchName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(RightElbowPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightElbowPitchName)).put("stiction", 0.0);
        properties.put(RightForearmYawName, new HashMap());
        properties.put(RightForearmLinkName, new HashMap());
        ((Map)properties.get(RightForearmLinkName)).put("mass", 2.476);
        ((Map)properties.get(RightForearmLinkName)).put("centerOfMass", new Vector3D(0.015, -0.13, 0.019564));
        ((Map)properties.get(RightForearmLinkName)).put("inertia", new Matrix3D(0.0117554, -0.00130085, -7.27141E-4, -0.00130085, 0.00507157, -0.00169542, -7.27141E-4, -0.00169542, 0.0113657));
        ((Map)properties.get(RightForearmYawName)).put("offsetFromParentJoint", new Vector3D(-0.0254, 0.0, 0.0));
        ((Map)properties.get(RightForearmYawName)).put("positionLowerLimit", -2.019);
        ((Map)properties.get(RightForearmYawName)).put("positionUpperLimit", 3.14);
        ((Map)properties.get(RightForearmYawName)).put("velocityLowerLimit", -0.8);
        ((Map)properties.get(RightForearmYawName)).put("velocityUpperLimit", 0.8);
        ((Map)properties.get(RightForearmYawName)).put("effortLowerLimit", -26.0);
        ((Map)properties.get(RightForearmYawName)).put("effortUpperLimit", 26.0);
        ((Map)properties.get(RightForearmYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightForearmYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightForearmYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightForearmYawName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightForearmYawName)).put("damping", 0.1);
        ((Map)properties.get(RightForearmYawName)).put("stiction", 0.0);
        properties.put(RightWristRollName, new HashMap());
        properties.put(RightWristRollLinkName, new HashMap());
        ((Map)properties.get(RightWristRollLinkName)).put("mass", 0.14);
        ((Map)properties.get(RightWristRollLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(RightWristRollLinkName)).put("inertia", new Matrix3D(3.0251E-5, -1.25E-7, -3.6E-8, -1.25E-7, 3.772E-5, 0.0, -3.6E-8, 0.0, 9.395E-6));
        ((Map)properties.get(RightWristRollName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.2871, 0.0));
        ((Map)properties.get(RightWristRollName)).put("positionLowerLimit", -0.35);
        ((Map)properties.get(RightWristRollName)).put("positionUpperLimit", 0.35);
        ((Map)properties.get(RightWristRollName)).put("velocityLowerLimit", -1.0);
        ((Map)properties.get(RightWristRollName)).put("velocityUpperLimit", 1.0);
        ((Map)properties.get(RightWristRollName)).put("effortLowerLimit", -14.0);
        ((Map)properties.get(RightWristRollName)).put("effortUpperLimit", 14.0);
        ((Map)properties.get(RightWristRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightWristRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightWristRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightWristRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightWristRollName)).put("damping", 0.1);
        ((Map)properties.get(RightWristRollName)).put("stiction", 0.0);
        properties.put(RightWristPitchName, new HashMap());
        properties.put(RightPalmName, new HashMap());
        ((Map)properties.get(RightPalmName)).put("mass", 0.712);
        ((Map)properties.get(RightPalmName)).put("centerOfMass", new Vector3D(0.002954, -0.052034, -2.36E-4));
        ((Map)properties.get(RightPalmName)).put("inertia", new Matrix3D(9.43493E-4, 3.4393E-5, -3.8828E-5, 3.4393E-5, 7.11024E-4, 2.3429E-5, -3.8828E-5, 2.3429E-5, 6.10199E-4));
        ((Map)properties.get(RightWristPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(RightWristPitchName)).put("positionLowerLimit", -0.6);
        ((Map)properties.get(RightWristPitchName)).put("positionUpperLimit", 0.6);
        ((Map)properties.get(RightWristPitchName)).put("velocityLowerLimit", -1.0);
        ((Map)properties.get(RightWristPitchName)).put("velocityUpperLimit", 1.0);
        ((Map)properties.get(RightWristPitchName)).put("effortLowerLimit", -14.0);
        ((Map)properties.get(RightWristPitchName)).put("effortUpperLimit", 14.0);
        ((Map)properties.get(RightWristPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightWristPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightWristPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightWristPitchName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(RightWristPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightWristPitchName)).put("stiction", 0.0);
        properties.put("rightIndexFingerPitch1", new HashMap());
        properties.put("rightIndexFingerPitch1Link", new HashMap());
        ((Map)properties.get("rightIndexFingerPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("rightIndexFingerPitch1Link")).put("centerOfMass", new Vector3D(0.0, -0.019696269397585765, 0.0034723150516228376));
        ((Map)properties.get("rightIndexFingerPitch1Link")).put("inertia", new Matrix3D(4.232E-6, -6.047773421340643E-8, 2.5384373958342057E-9, -6.047773421340643E-8, 1.2932975760459825E-6, 4.511331296418157E-7, 2.5384373958342057E-9, 4.511331296418157E-7, 3.813702423954017E-6));
        ((Map)properties.get("rightIndexFingerPitch1")).put("offsetFromParentJoint", new Vector3D(0.0022000000000000006, -0.09760000000000002, 0.02350000000000002));
        ((Map)properties.get("rightIndexFingerPitch1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("positionUpperLimit", 1.57);
        ((Map)properties.get("rightIndexFingerPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("axis", new Vector3D(0.0, 0.17361607288187247, 0.9848134134124475));
        ((Map)properties.get("rightIndexFingerPitch1")).put("damping", 1.0);
        ((Map)properties.get("rightIndexFingerPitch1")).put("stiction", 0.0);
        properties.put("rightIndexFingerPitch2", new HashMap());
        properties.put("rightIndexFingerPitch2Link", new HashMap());
        ((Map)properties.get("rightIndexFingerPitch2Link")).put("mass", 0.018);
        ((Map)properties.get("rightIndexFingerPitch2Link")).put("centerOfMass", new Vector3D(0.0, -0.012802575108430745, 0.0022570047835548442));
        ((Map)properties.get("rightIndexFingerPitch2Link")).put("inertia", new Matrix3D(1.562E-6, -1.8998833771502745E-8, -9.851107314551334E-9, -1.8998833771502745E-8, 7.486666211140791E-7, 1.2026304657775112E-7, -9.851107314551334E-9, 1.2026304657775112E-7, 1.2283333788859208E-6));
        ((Map)properties.get("rightIndexFingerPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, -0.037519999999999935, 0.006614999999999957));
        ((Map)properties.get("rightIndexFingerPitch2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("positionUpperLimit", 1.658);
        ((Map)properties.get("rightIndexFingerPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("axis", new Vector3D(0.0, 0.17361607288187247, 0.9848134134124475));
        ((Map)properties.get("rightIndexFingerPitch2")).put("damping", 1.0);
        ((Map)properties.get("rightIndexFingerPitch2")).put("stiction", 0.0);
        properties.put("rightIndexFingerPitch3", new HashMap());
        properties.put("rightIndexFingerPitch3Link", new HashMap());
        ((Map)properties.get("rightIndexFingerPitch3Link")).put("mass", 0.01);
        ((Map)properties.get("rightIndexFingerPitch3Link")).put("centerOfMass", new Vector3D(0.0, -0.009848134698792883, 0.0017361575258114188));
        ((Map)properties.get("rightIndexFingerPitch3Link")).put("inertia", new Matrix3D(6.02E-7, -2.3635523277102915E-8, 4.1667780619474044E-9, -2.3635523277102915E-8, 2.2364502233513937E-7, 6.607204299095878E-8, 4.1667780619474044E-9, 6.607204299095878E-8, 4.873549776648605E-7));
        ((Map)properties.get("rightIndexFingerPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, -0.022550000000000042, 0.003976000000000067));
        ((Map)properties.get("rightIndexFingerPitch3")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("positionUpperLimit", 1.92);
        ((Map)properties.get("rightIndexFingerPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("axis", new Vector3D(0.0, 0.17361607288187247, 0.9848134134124475));
        ((Map)properties.get("rightIndexFingerPitch3")).put("damping", 1.0);
        ((Map)properties.get("rightIndexFingerPitch3")).put("stiction", 0.0);
        properties.put("rightMiddleFingerPitch1", new HashMap());
        properties.put("rightMiddleFingerPitch1Link", new HashMap());
        ((Map)properties.get("rightMiddleFingerPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("rightMiddleFingerPitch1Link")).put("centerOfMass", new Vector3D(0.0, -0.019850857332287003, -0.002437921896449382));
        ((Map)properties.get("rightMiddleFingerPitch1Link")).put("inertia", new Matrix3D(5.148E-6, -4.034594335475554E-8, -1.6037607515301554E-8, -4.034594335475554E-8, 1.37155570823588E-6, -3.995089457228315E-7, -1.6037607515301554E-8, -3.995089457228316E-7, 4.542444291764121E-6));
        ((Map)properties.get("rightMiddleFingerPitch1")).put("offsetFromParentJoint", new Vector3D(0.0022000000000000006, -0.09699999999999998, -0.011899999999999966));
        ((Map)properties.get("rightMiddleFingerPitch1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("positionUpperLimit", 1.658);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("axis", new Vector3D(0.0, -0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("rightMiddleFingerPitch1")).put("damping", 1.0);
        ((Map)properties.get("rightMiddleFingerPitch1")).put("stiction", 0.0);
        properties.put("rightMiddleFingerPitch2", new HashMap());
        properties.put("rightMiddleFingerPitch2Link", new HashMap());
        ((Map)properties.get("rightMiddleFingerPitch2Link")).put("mass", 0.011);
        ((Map)properties.get("rightMiddleFingerPitch2Link")).put("centerOfMass", new Vector3D(0.0, -0.012903057265986551, -0.0015846492326920985));
        ((Map)properties.get("rightMiddleFingerPitch2Link")).put("inertia", new Matrix3D(1.97E-6, 3.508731450793507E-8, -6.773504308793901E-9, 3.508731450793507E-8, 5.98401161832773E-7, -2.835378861044921E-7, -6.773504308793901E-9, -2.835378861044921E-7, 2.2275988381672266E-6));
        ((Map)properties.get("rightMiddleFingerPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, -0.037820000000000006, -0.004644000000000044));
        ((Map)properties.get("rightMiddleFingerPitch2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("positionUpperLimit", 1.92);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("axis", new Vector3D(0.0, -0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("rightMiddleFingerPitch2")).put("damping", 1.0);
        ((Map)properties.get("rightMiddleFingerPitch2")).put("stiction", 0.0);
        properties.put("rightMiddleFingerPitch3", new HashMap());
        properties.put("rightMiddleFingerPitch3Link", new HashMap());
        ((Map)properties.get("rightMiddleFingerPitch3Link")).put("mass", 0.006);
        ((Map)properties.get("rightMiddleFingerPitch3Link")).put("centerOfMass", new Vector3D(0.0, -0.009925428666143501, -0.001218960948224691));
        ((Map)properties.get("rightMiddleFingerPitch3Link")).put("inertia", new Matrix3D(3.96E-7, -8.810989704706681E-9, -2.089607720016572E-9, -8.810989704706681E-9, 1.5825320090412047E-7, -1.7766322657938948E-9, -2.089607720016572E-9, -1.7766322657938948E-9, 3.0474679909587953E-7));
        ((Map)properties.get("rightMiddleFingerPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, -0.022730000000000167, -0.002791999999999949));
        ((Map)properties.get("rightMiddleFingerPitch3")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("positionUpperLimit", 1.57);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("axis", new Vector3D(0.0, -0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("rightMiddleFingerPitch3")).put("damping", 1.0);
        ((Map)properties.get("rightMiddleFingerPitch3")).put("stiction", 0.0);
        properties.put("rightPinkyPitch1", new HashMap());
        properties.put("rightPinkyPitch1Link", new HashMap());
        ((Map)properties.get("rightPinkyPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("rightPinkyPitch1Link")).put("centerOfMass", new Vector3D(0.0, -0.019850857332287003, -0.002437921896449382));
        ((Map)properties.get("rightPinkyPitch1Link")).put("inertia", new Matrix3D(5.148E-6, -4.034594335475554E-8, -1.6037607515301554E-8, -4.034594335475554E-8, 1.37155570823588E-6, -3.995089457228315E-7, -1.6037607515301554E-8, -3.995089457228316E-7, 4.542444291764121E-6));
        ((Map)properties.get("rightPinkyPitch1")).put("offsetFromParentJoint", new Vector3D(0.0022000000000000006, -0.08379999999999999, -0.04099999999999998));
        ((Map)properties.get("rightPinkyPitch1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightPinkyPitch1")).put("positionUpperLimit", 1.57);
        ((Map)properties.get("rightPinkyPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightPinkyPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightPinkyPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightPinkyPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightPinkyPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightPinkyPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightPinkyPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightPinkyPitch1")).put("axis", new Vector3D(0.0, -0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("rightPinkyPitch1")).put("damping", 1.0);
        ((Map)properties.get("rightPinkyPitch1")).put("stiction", 0.0);
        properties.put("rightPinkyPitch2", new HashMap());
        properties.put("rightPinkyPitch2Link", new HashMap());
        ((Map)properties.get("rightPinkyPitch2Link")).put("mass", 0.011);
        ((Map)properties.get("rightPinkyPitch2Link")).put("centerOfMass", new Vector3D(0.0, -0.012903057265986551, -0.0015846492326920985));
        ((Map)properties.get("rightPinkyPitch2Link")).put("inertia", new Matrix3D(1.97E-6, 3.508731450793507E-8, -6.773504308793901E-9, 3.508731450793507E-8, 5.98401161832773E-7, -2.835378861044921E-7, -6.773504308793901E-9, -2.835378861044921E-7, 2.2275988381672266E-6));
        ((Map)properties.get("rightPinkyPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, -0.037816000000000016, -0.0046439999999999025));
        ((Map)properties.get("rightPinkyPitch2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightPinkyPitch2")).put("positionUpperLimit", 1.658);
        ((Map)properties.get("rightPinkyPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightPinkyPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightPinkyPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightPinkyPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightPinkyPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightPinkyPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightPinkyPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightPinkyPitch2")).put("axis", new Vector3D(0.0, -0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("rightPinkyPitch2")).put("damping", 1.0);
        ((Map)properties.get("rightPinkyPitch2")).put("stiction", 0.0);
        properties.put("rightPinkyPitch3", new HashMap());
        properties.put("rightPinkyPitch3Link", new HashMap());
        ((Map)properties.get("rightPinkyPitch3Link")).put("mass", 0.006);
        ((Map)properties.get("rightPinkyPitch3Link")).put("centerOfMass", new Vector3D(0.0, -0.009925428666143501, -0.001218960948224691));
        ((Map)properties.get("rightPinkyPitch3Link")).put("inertia", new Matrix3D(3.96E-7, -8.810989704706681E-9, -2.089607720016572E-9, -8.810989704706681E-9, 1.5825320090412047E-7, -1.7766322657938948E-9, -2.089607720016572E-9, -1.7766322657938948E-9, 3.0474679909587953E-7));
        ((Map)properties.get("rightPinkyPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, -0.022734000000000056, -0.0027920000000000765));
        ((Map)properties.get("rightPinkyPitch3")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightPinkyPitch3")).put("positionUpperLimit", 1.92);
        ((Map)properties.get("rightPinkyPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightPinkyPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightPinkyPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightPinkyPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightPinkyPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightPinkyPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightPinkyPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightPinkyPitch3")).put("axis", new Vector3D(0.0, -0.12189598527100426, 0.9925428800685697));
        ((Map)properties.get("rightPinkyPitch3")).put("damping", 1.0);
        ((Map)properties.get("rightPinkyPitch3")).put("stiction", 0.0);
        properties.put("rightThumbRoll", new HashMap());
        properties.put("rightThumbRollLink", new HashMap());
        ((Map)properties.get("rightThumbRollLink")).put("mass", 0.017);
        ((Map)properties.get("rightThumbRollLink")).put("centerOfMass", new Vector3D(0.0, -0.003420522332544199, 0.009396809403865038));
        ((Map)properties.get("rightThumbRollLink")).put("inertia", new Matrix3D(2.77788E-6, 3.800365322933979E-8, -8.7821261445544E-8, 3.800365322933979E-8, 3.2663699259248467E-6, 7.322727571414368E-7, -8.7821261445544E-8, 7.322727571414366E-7, 1.6352200740751536E-6));
        ((Map)properties.get("rightThumbRoll")).put("offsetFromParentJoint", new Vector3D(0.0049, -0.03510000000000002, 0.022800000000000042));
        ((Map)properties.get("rightThumbRoll")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightThumbRoll")).put("positionUpperLimit", 2.356);
        ((Map)properties.get("rightThumbRoll")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightThumbRoll")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightThumbRoll")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightThumbRoll")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightThumbRoll")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightThumbRoll")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightThumbRoll")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightThumbRoll")).put("axis", new Vector3D(0.0, 0.939681022333869, 0.34205200812972125));
        ((Map)properties.get("rightThumbRoll")).put("damping", 1.0);
        ((Map)properties.get("rightThumbRoll")).put("stiction", 0.0);
        properties.put("rightThumbPitch1", new HashMap());
        properties.put("rightThumbPitch1Link", new HashMap());
        ((Map)properties.get("rightThumbPitch1Link")).put("mass", 0.02);
        ((Map)properties.get("rightThumbPitch1Link")).put("centerOfMass", new Vector3D(0.0, -0.005, 0.02));
        ((Map)properties.get("rightThumbPitch1Link")).put("inertia", new Matrix3D(4.239E-6, 0.0, -0.0, 0.0, 4.582E-6, 0.0, -0.0, 0.0, 1.47E-6));
        ((Map)properties.get("rightThumbPitch1")).put("offsetFromParentJoint", new Vector3D(0.0, -0.007832999999999965, 0.021518999999999993));
        ((Map)properties.get("rightThumbPitch1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightThumbPitch1")).put("positionUpperLimit", 1.658);
        ((Map)properties.get("rightThumbPitch1")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightThumbPitch1")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightThumbPitch1")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightThumbPitch1")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightThumbPitch1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightThumbPitch1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightThumbPitch1")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightThumbPitch1")).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get("rightThumbPitch1")).put("damping", 1.0);
        ((Map)properties.get("rightThumbPitch1")).put("stiction", 0.0);
        properties.put("rightThumbPitch2", new HashMap());
        properties.put("rightThumbPitch2Link", new HashMap());
        ((Map)properties.get("rightThumbPitch2Link")).put("mass", 0.013);
        ((Map)properties.get("rightThumbPitch2Link")).put("centerOfMass", new Vector3D(0.0, -0.004, 0.017));
        ((Map)properties.get("rightThumbPitch2Link")).put("inertia", new Matrix3D(1.266E-6, 0.0, -0.0, 0.0, 1.503E-6, -0.0, -0.0, -0.0, 6.99E-7));
        ((Map)properties.get("rightThumbPitch2")).put("offsetFromParentJoint", new Vector3D(0.0, -0.00660000000000005, 0.03750000000000003));
        ((Map)properties.get("rightThumbPitch2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightThumbPitch2")).put("positionUpperLimit", 1.92);
        ((Map)properties.get("rightThumbPitch2")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightThumbPitch2")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightThumbPitch2")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightThumbPitch2")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightThumbPitch2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightThumbPitch2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightThumbPitch2")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightThumbPitch2")).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get("rightThumbPitch2")).put("damping", 1.0);
        ((Map)properties.get("rightThumbPitch2")).put("stiction", 0.0);
        properties.put("rightThumbPitch3", new HashMap());
        properties.put("rightThumbPitch3Link", new HashMap());
        ((Map)properties.get("rightThumbPitch3Link")).put("mass", 0.006);
        ((Map)properties.get("rightThumbPitch3Link")).put("centerOfMass", new Vector3D(0.0, -0.004, 0.01));
        ((Map)properties.get("rightThumbPitch3Link")).put("inertia", new Matrix3D(3.22E-7, 0.0, 0.0, 0.0, 4.06E-7, 0.0, 0.0, 0.0, 2.1E-7));
        ((Map)properties.get("rightThumbPitch3")).put("offsetFromParentJoint", new Vector3D(0.0, -0.004899999999999904, 0.02749999999999997));
        ((Map)properties.get("rightThumbPitch3")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("rightThumbPitch3")).put("positionUpperLimit", 1.57);
        ((Map)properties.get("rightThumbPitch3")).put("velocityLowerLimit", -1.0);
        ((Map)properties.get("rightThumbPitch3")).put("velocityUpperLimit", 1.0);
        ((Map)properties.get("rightThumbPitch3")).put("effortLowerLimit", -10.0);
        ((Map)properties.get("rightThumbPitch3")).put("effortUpperLimit", 10.0);
        ((Map)properties.get("rightThumbPitch3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("rightThumbPitch3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("rightThumbPitch3")).put("kpVelocityLimit", 500.0);
        ((Map)properties.get("rightThumbPitch3")).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get("rightThumbPitch3")).put("damping", 1.0);
        ((Map)properties.get("rightThumbPitch3")).put("stiction", 0.0);
        return properties;
    }

    public static Map<String, Map<String, Object>> valkyrieSensorProperties() {
        HashMap<String, Map<String, Object>> sensorProperties = new HashMap<String, Map<String, Object>>();
        sensorProperties.put("pelvisMiddleImu", new HashMap());
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("transformToJoint", new RigidBodyTransform(1.0, 0.0, 0.0, 0.0, 0.0, -0.9999999999964793, -2.65358979335273E-6, 0.0, 0.0, 2.65358979335273E-6, -0.9999999999964793, -0.108196));
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("accelerationNoiseMean", 0.0);
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("accelerationNoiseStandardDeviation", 0.017);
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("accelerationBiasMean", 0.1);
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("accelerationBiasStandardDeviation", 0.001);
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("angularVelocityNoiseMean", 7.5E-6);
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("angularVelocityNoiseStandardDeviation", 8.0E-7);
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("angularVelocityBiasMean", 0.0);
        ((Map)sensorProperties.get("pelvisMiddleImu")).put("angularVelocityBiasStandardDeviation", 0.0);
        sensorProperties.put("pelvisRearImu", new HashMap());
        ((Map)sensorProperties.get("pelvisRearImu")).put("transformToJoint", new RigidBodyTransform(-0.8886208494403026, -1.4365406117855013E-6, 0.4586425470210231, -0.0758449, -2.358035216243522E-6, 0.999999999996188, -1.4365406117855013E-6, 0.0, -0.4586425470172111, -2.358035216243522E-6, -0.8886208494403026, -0.111056));
        ((Map)sensorProperties.get("pelvisRearImu")).put("accelerationNoiseMean", 0.0);
        ((Map)sensorProperties.get("pelvisRearImu")).put("accelerationNoiseStandardDeviation", 0.017);
        ((Map)sensorProperties.get("pelvisRearImu")).put("accelerationBiasMean", 0.1);
        ((Map)sensorProperties.get("pelvisRearImu")).put("accelerationBiasStandardDeviation", 0.001);
        ((Map)sensorProperties.get("pelvisRearImu")).put("angularVelocityNoiseMean", 7.5E-6);
        ((Map)sensorProperties.get("pelvisRearImu")).put("angularVelocityNoiseStandardDeviation", 8.0E-7);
        ((Map)sensorProperties.get("pelvisRearImu")).put("angularVelocityBiasMean", 0.0);
        ((Map)sensorProperties.get("pelvisRearImu")).put("angularVelocityBiasStandardDeviation", 0.0);
        sensorProperties.put("leftHazardCamera___default__", new HashMap());
        ((Map)sensorProperties.get("leftHazardCamera___default__")).put("transformToJoint", new RigidBodyTransform(7.963267107332633E-4, -7.963264582434141E-4, 0.9999993658637698, 0.0345, 0.9999996829318346, 6.341362301717473E-7, -7.963264582434141E-4, 0.0406, 5.55112E-17, 0.9999996829318346, 7.963267107332633E-4, 0.1135));
        ((Map)sensorProperties.get("leftHazardCamera___default__")).put("fieldOfView", 1.378);
        ((Map)sensorProperties.get("leftHazardCamera___default__")).put("clipNear", 0.1);
        ((Map)sensorProperties.get("leftHazardCamera___default__")).put("clipFar", 100.0);
        ((Map)sensorProperties.get("leftHazardCamera___default__")).put("imageWidth", 1280);
        ((Map)sensorProperties.get("leftHazardCamera___default__")).put("imageHeight", 1024);
        sensorProperties.put("rightHazardCamera___default__", new HashMap());
        ((Map)sensorProperties.get("rightHazardCamera___default__")).put("transformToJoint", new RigidBodyTransform(7.963267107332633E-4, -7.963264582434141E-4, 0.9999993658637698, 0.0345, 0.9999996829318346, 6.341362301717473E-7, -7.963264582434141E-4, -0.0406, 5.55112E-17, 0.9999996829318346, 7.963267107332633E-4, 0.1135));
        ((Map)sensorProperties.get("rightHazardCamera___default__")).put("fieldOfView", 1.378);
        ((Map)sensorProperties.get("rightHazardCamera___default__")).put("clipNear", 0.1);
        ((Map)sensorProperties.get("rightHazardCamera___default__")).put("clipFar", 100.0);
        ((Map)sensorProperties.get("rightHazardCamera___default__")).put("imageWidth", 1280);
        ((Map)sensorProperties.get("rightHazardCamera___default__")).put("imageHeight", 1024);
        sensorProperties.put("leftTorsoImu", new HashMap());
        ((Map)sensorProperties.get("leftTorsoImu")).put("transformToJoint", new RigidBodyTransform(1.0, -0.0, 0.0, -0.0627634, 0.0, 9.632679474766714E-5, 0.9999999953605743, 0.134239, -0.0, -0.9999999953605743, 9.632679474766714E-5, 0.363068));
        ((Map)sensorProperties.get("leftTorsoImu")).put("accelerationNoiseMean", 0.0);
        ((Map)sensorProperties.get("leftTorsoImu")).put("accelerationNoiseStandardDeviation", 0.017);
        ((Map)sensorProperties.get("leftTorsoImu")).put("accelerationBiasMean", 0.1);
        ((Map)sensorProperties.get("leftTorsoImu")).put("accelerationBiasStandardDeviation", 0.001);
        ((Map)sensorProperties.get("leftTorsoImu")).put("angularVelocityNoiseMean", 7.5E-6);
        ((Map)sensorProperties.get("leftTorsoImu")).put("angularVelocityNoiseStandardDeviation", 8.0E-7);
        ((Map)sensorProperties.get("leftTorsoImu")).put("angularVelocityBiasMean", 0.0);
        ((Map)sensorProperties.get("leftTorsoImu")).put("angularVelocityBiasStandardDeviation", 0.0);
        sensorProperties.put("stereo_camera_left", new HashMap());
        ((Map)sensorProperties.get("stereo_camera_left")).put("transformToJoint", new RigidBodyTransform(0.991444821419641, -3.46363776756234E-7, -0.13052649570127964, 0.183847, 5.293958426245172E-23, -0.9999999999964793, 2.65358979335273E-6, -0.035, -0.1305264957017392, -2.6308878587915793E-6, -0.9914448214161503, 0.0773366));
        ((Map)sensorProperties.get("stereo_camera_left")).put("fieldOfView", 1.39626);
        ((Map)sensorProperties.get("stereo_camera_left")).put("clipNear", 0.02);
        ((Map)sensorProperties.get("stereo_camera_left")).put("clipFar", 300.0);
        ((Map)sensorProperties.get("stereo_camera_left")).put("imageWidth", 1024);
        ((Map)sensorProperties.get("stereo_camera_left")).put("imageHeight", 544);
        sensorProperties.put("stereo_camera_right", new HashMap());
        ((Map)sensorProperties.get("stereo_camera_right")).put("transformToJoint", new RigidBodyTransform(0.991444821419641, -3.46363776756234E-7, -0.13052649570127964, 0.1838470242454644, 5.293958426245172E-23, -0.9999999999964793, 2.65358979335273E-6, 0.03499999999975355, -0.1305264957017392, -2.6308878587915793E-6, -0.9914448214161503, 0.07733678416215012));
        ((Map)sensorProperties.get("stereo_camera_right")).put("fieldOfView", 1.39626);
        ((Map)sensorProperties.get("stereo_camera_right")).put("clipNear", 0.02);
        ((Map)sensorProperties.get("stereo_camera_right")).put("clipFar", 300.0);
        ((Map)sensorProperties.get("stereo_camera_right")).put("imageWidth", 1024);
        ((Map)sensorProperties.get("stereo_camera_right")).put("imageHeight", 544);
        sensorProperties.put("head_imu_sensor", new HashMap());
        ((Map)sensorProperties.get("head_imu_sensor")).put("transformToJoint", new RigidBodyTransform(0.991444821419641, -3.46363776756234E-7, -0.13052649570127964, 0.136492, 5.293958426245172E-23, -0.9999999999964793, 2.65358979335273E-6, -0.035, -0.1305264957017392, -2.6308878587915793E-6, -0.9914448214161503, 0.0815537));
        ((Map)sensorProperties.get("head_imu_sensor")).put("accelerationNoiseMean", 0.0);
        ((Map)sensorProperties.get("head_imu_sensor")).put("accelerationNoiseStandardDeviation", 0.017);
        ((Map)sensorProperties.get("head_imu_sensor")).put("accelerationBiasMean", 0.1);
        ((Map)sensorProperties.get("head_imu_sensor")).put("accelerationBiasStandardDeviation", 0.001);
        ((Map)sensorProperties.get("head_imu_sensor")).put("angularVelocityNoiseMean", 7.5E-6);
        ((Map)sensorProperties.get("head_imu_sensor")).put("angularVelocityNoiseStandardDeviation", 8.0E-7);
        ((Map)sensorProperties.get("head_imu_sensor")).put("angularVelocityBiasMean", 0.0);
        ((Map)sensorProperties.get("head_imu_sensor")).put("angularVelocityBiasStandardDeviation", 0.0);
        sensorProperties.put("head_hokuyo_sensor", new HashMap());
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("transformToJoint", new RigidBodyTransform(0.991444821419641, -3.46363776756234E-7, -0.13052649570127964, 0.027785447207070033, 5.293958426245172E-23, -0.9999999999964793, 2.65358979335273E-6, 3.9803846900290945E-8, -0.1305264957017392, -2.6308878587915793E-6, -0.9914448214161503, -0.01878746719229443));
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("sweepYawMin", -2.35619);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("sweepYawMax", 2.35619);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("heightPitchMin", 0.0);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("heightPitchMax", 0.0);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("minRange", 0.1);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("maxRange", 30.0);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("pointsPerSweep", 1080);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("scanHeight", 1);
        return sensorProperties;
    }
}

