/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.robot.ValkyrieModelLoadingTest;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.sdf.items.SDFRoot;
import us.ihmc.scs2.definition.robot.urdf.URDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;

public class AtlasModelLoadingTest {
    private static final String LeftHipYawName = "l_leg_hpz";
    private static final String LeftHipRollName = "l_leg_hpx";
    private static final String LeftHipPitchName = "l_leg_hpy";
    private static final String LeftKneePitchName = "l_leg_kny";
    private static final String LeftAnklePitchName = "l_leg_aky";
    private static final String LeftAnkleRollName = "l_leg_akx";
    private static final String RightHipYawName = "r_leg_hpz";
    private static final String RightHipRollName = "r_leg_hpx";
    private static final String RightHipPitchName = "r_leg_hpy";
    private static final String RightKneePitchName = "r_leg_kny";
    private static final String RightAnklePitchName = "r_leg_aky";
    private static final String RightAnkleRollName = "r_leg_akx";
    private static final String TorsoYawName = "back_bkz";
    private static final String TorsoPitchName = "back_bky";
    private static final String TorsoRollName = "back_bkx";
    private static final String NeckPitchName = "neck_ry";
    private static final String HokuyoJointName = "hokuyo_joint";
    private static final String LeftShoulderYawName = "l_arm_shz";
    private static final String LeftShoulderRollName = "l_arm_shx";
    private static final String LeftElbowPitchName = "l_arm_ely";
    private static final String LeftElbowRollName = "l_arm_elx";
    private static final String LeftWristPitchName = "l_arm_wry";
    private static final String LeftWristRollName = "l_arm_wrx";
    private static final String LeftWristSecondPitchName = "l_arm_wry2";
    private static final String RightShoulderYawName = "r_arm_shz";
    private static final String RightShoulderRollName = "r_arm_shx";
    private static final String RightElbowPitchName = "r_arm_ely";
    private static final String RightElbowRollName = "r_arm_elx";
    private static final String RightWristPitchName = "r_arm_wry";
    private static final String RightWristRollName = "r_arm_wrx";
    private static final String RightWristSecondPitchName = "r_arm_wry2";
    private static final String PelvisName = "pelvis";
    private static final String LeftHipYawLinkName = "l_uglut";
    private static final String LeftHipRollLinkName = "l_lglut";
    private static final String LeftHipPitchLinkName = "l_uleg";
    private static final String LeftKneePitchLinkName = "l_lleg";
    private static final String LeftAnklePitchLinkName = "l_talus";
    private static final String LeftFootName = "l_foot";
    private static final String RightHipYawLinkName = "r_uglut";
    private static final String RightHipRollLinkName = "r_lglut";
    private static final String RightHipPitchLinkName = "r_uleg";
    private static final String RightKneePitchLinkName = "r_lleg";
    private static final String RightAnklePitchLinkName = "r_talus";
    private static final String RightFootName = "r_foot";
    private static final String TorsoYawLinkName = "ltorso";
    private static final String TorsoPitchLinkName = "mtorso";
    private static final String TorsoRollLinkName = "utorso";
    private static final String NeckPitchLinkName = "head";
    private static final String HokuyoLinkName = "hokuyo_link";
    private static final String LeftShoulderYawLinkName = "l_clav";
    private static final String LeftShoulderRollLinkName = "l_scap";
    private static final String LeftElbowPitchLinkName = "l_uarm";
    private static final String LeftElbowRollLinkName = "l_larm";
    private static final String LeftWristPitchLinkName = "l_ufarm";
    private static final String LeftWristRollLinkName = "l_lfarm";
    private static final String LeftWristSecondPitchLinkName = "l_hand";
    private static final String RightShoulderYawLinkName = "r_clav";
    private static final String RightShoulderRollLinkName = "r_scap";
    private static final String RightElbowPitchLinkName = "r_uarm";
    private static final String RightElbowRollLinkName = "r_larm";
    private static final String RightWristPitchLinkName = "r_ufarm";
    private static final String RightWristRollLinkName = "r_lfarm";
    private static final String RightWristSecondPitchLinkName = "r_hand";
    private static final String[] LeftLegJointNames = new String[]{"l_leg_hpz", "l_leg_hpx", "l_leg_hpy", "l_leg_kny", "l_leg_aky", "l_leg_akx"};
    private static final String[] RightLegJointNames = new String[]{"r_leg_hpz", "r_leg_hpx", "r_leg_hpy", "r_leg_kny", "r_leg_aky", "r_leg_akx"};
    private static final String[] TorsoJointNames = new String[]{"back_bkz", "back_bky", "back_bkx"};
    private static final String[] NeckJointNames = new String[]{"neck_ry"};
    private static final String[] LeftArmJointNames = new String[]{"l_arm_shz", "l_arm_shx", "l_arm_ely", "l_arm_elx", "l_arm_wry", "l_arm_wrx", "l_arm_wry2"};
    private static final String[] LeftFinger1JointNames = new String[]{"l_palm_finger_1_joint", "l_finger_1_joint_1", "l_finger_1_joint_2", "l_finger_1_joint_3"};
    private static final String[] LeftFinger2JointNames = new String[]{"l_palm_finger_2_joint", "l_finger_2_joint_1", "l_finger_2_joint_2", "l_finger_2_joint_3"};
    private static final String[] LeftMiddleFingerJointNames = new String[]{"l_palm_finger_middle_joint", "l_finger_middle_joint_1", "l_finger_middle_joint_2", "l_finger_middle_joint_3"};
    private static final String[] RightFinger1JointNames = new String[]{"r_palm_finger_1_joint", "r_finger_1_joint_1", "r_finger_1_joint_2", "r_finger_1_joint_3"};
    private static final String[] RightFinger2JointNames = new String[]{"r_palm_finger_2_joint", "r_finger_2_joint_1", "r_finger_2_joint_2", "r_finger_2_joint_3"};
    private static final String[] RightMiddleFingerJointNames = new String[]{"r_palm_finger_middle_joint", "r_finger_middle_joint_1", "r_finger_middle_joint_2", "r_finger_middle_joint_3"};
    private static final String[] RightArmJointNames = new String[]{"r_arm_shz", "r_arm_shx", "r_arm_ely", "r_arm_elx", "r_arm_wry", "r_arm_wrx", "r_arm_wry2"};
    private static final String[] AllJointNames = ValkyrieModelLoadingTest.concatenate({"pelvis", "hokuyo_joint"}, LeftLegJointNames, RightLegJointNames, TorsoJointNames, NeckJointNames, LeftArmJointNames, LeftFinger1JointNames, LeftFinger2JointNames, LeftMiddleFingerJointNames, RightArmJointNames, RightFinger1JointNames, RightFinger2JointNames, RightMiddleFingerJointNames);
    private static final String[] LeftLegLinkNames = new String[]{"l_uglut", "l_lglut", "l_uleg", "l_lleg", "l_talus", "l_foot"};
    private static final String[] RightLegLinkNames = new String[]{"r_uglut", "r_lglut", "r_uleg", "r_lleg", "r_talus", "r_foot"};
    private static final String[] TorsoLinkNames = new String[]{"ltorso", "mtorso", "utorso"};
    private static final String[] NeckLinkNames = new String[]{"head"};
    private static final String[] LeftArmLinkNames = new String[]{"l_clav", "l_scap", "l_uarm", "l_larm", "l_ufarm", "l_lfarm", "l_hand"};
    private static final String[] LeftFinger1LinkNames = new String[]{"l_finger_1_link_0", "l_finger_1_link_1", "l_finger_1_link_2", "l_finger_1_link_3"};
    private static final String[] LeftFinger2LinkNames = new String[]{"l_finger_2_link_0", "l_finger_2_link_1", "l_finger_2_link_2", "l_finger_2_link_3"};
    private static final String[] LeftMiddleFingerLinkNames = new String[]{"l_finger_middle_link_0", "l_finger_middle_link_1", "l_finger_middle_link_2", "l_finger_middle_link_3"};
    private static final String[] RightFinger1LinkNames = new String[]{"r_finger_1_link_0", "r_finger_1_link_1", "r_finger_1_link_2", "r_finger_1_link_3"};
    private static final String[] RightFinger2LinkNames = new String[]{"r_finger_2_link_0", "r_finger_2_link_1", "r_finger_2_link_2", "r_finger_2_link_3"};
    private static final String[] RightMiddleFingerLinkNames = new String[]{"r_finger_middle_link_0", "r_finger_middle_link_1", "r_finger_middle_link_2", "r_finger_middle_link_3"};
    private static final String[] RightArmLinkNames = new String[]{"r_clav", "r_scap", "r_uarm", "r_larm", "r_ufarm", "r_lfarm", "r_hand"};
    private static final String[] AllLinkNames = ValkyrieModelLoadingTest.concatenate({"pelvis", "hokuyo_link"}, LeftLegLinkNames, RightLegLinkNames, TorsoLinkNames, NeckLinkNames, LeftArmLinkNames, LeftFinger1LinkNames, LeftFinger2LinkNames, LeftMiddleFingerLinkNames, RightArmLinkNames, RightFinger1LinkNames, RightFinger2LinkNames, RightMiddleFingerLinkNames);
    private static final double Infinity = Double.POSITIVE_INFINITY;

    @Test
    public void testSDFTools() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/atlas/atlas_unplugged_v5_dual_robotiq.sdf");
        SDFRoot sdfRoot = SDFTools.loadSDFRoot((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition robotDefinition = SDFTools.toFloatingRobotDefinition((SDFModel)((SDFModel)sdfRoot.getModels().get(0)));
        this.performAssertionsOnRobotDefinition(robotDefinition);
    }

    @Test
    public void testURDFTools() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/atlas/atlas_unplugged_v5_dual_robotiq_with_head.urdf");
        URDFModel urdfModel = URDFTools.loadURDFModel((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition robotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfModel);
        this.performAssertionsOnRobotDefinition(robotDefinition);
    }

    @Test
    public void testSaveLoadRobotDefinitionXML() throws JAXBException, FileNotFoundException, IOException {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("models/atlas/atlas_unplugged_v5_dual_robotiq_with_head.urdf");
        URDFModel urdfModel = URDFTools.loadURDFModel((InputStream)resourceAsStream, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader());
        RobotDefinition exportedRobotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfModel);
        File testFile = new File("test.xml");
        DefinitionIOTools.saveRobotDefinition((OutputStream)new FileOutputStream(testFile), (RobotDefinition)exportedRobotDefinition);
        RobotDefinition importedRobotDefinition = DefinitionIOTools.loadRobotDefinition((InputStream)new FileInputStream(testFile));
        this.performAssertionsOnRobotDefinition(importedRobotDefinition);
        testFile.delete();
    }

    private void performAssertionsOnRobotDefinition(RobotDefinition robotDefinition) {
        for (String jointName : AllJointNames) {
            Assertions.assertNotNull((Object)robotDefinition.getJointDefinition(jointName));
            if (jointName.equals(PelvisName)) continue;
            Assertions.assertEquals(RevoluteJointDefinition.class, robotDefinition.getJointDefinition(jointName).getClass());
        }
        for (String linkName : AllLinkNames) {
            Assertions.assertNotNull((Object)robotDefinition.getRigidBodyDefinition(linkName), (String)("Link: " + linkName));
        }
        Assertions.assertEquals((int)1, (int)robotDefinition.getRootJointDefinitions().size());
        Assertions.assertEquals(SixDoFJointDefinition.class, ((JointDefinition)robotDefinition.getRootJointDefinitions().get(0)).getClass());
        Assertions.assertEquals((Object)PelvisName, (Object)((JointDefinition)robotDefinition.getRootJointDefinitions().get(0)).getName());
        ValkyrieModelLoadingTest.assertKinematicsContinuity((JointDefinition)robotDefinition.getRootJointDefinitions().get(0), LeftLegJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity((JointDefinition)robotDefinition.getRootJointDefinitions().get(0), RightLegJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity((JointDefinition)robotDefinition.getRootJointDefinitions().get(0), TorsoJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(TorsoRollName), NeckJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(TorsoRollName), LeftArmJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertKinematicsContinuity(robotDefinition.getJointDefinition(TorsoRollName), RightArmJointNames, robotDefinition);
        ValkyrieModelLoadingTest.assertPhysicalProperties(robotDefinition, AtlasModelLoadingTest.atlasProperties(), ValkyrieModelLoadingTest.subtract(AllJointNames, HokuyoJointName), AllLinkNames);
        ValkyrieModelLoadingTest.assertSensorsProperties(robotDefinition, AtlasModelLoadingTest.atlasSensorProperties(), AllJointNames);
    }

    private static Map<String, Map<String, Object>> atlasProperties() {
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        properties.put(PelvisName, new HashMap());
        properties.put(PelvisName, new HashMap());
        ((Map)properties.get(PelvisName)).put("mass", 9.609);
        ((Map)properties.get(PelvisName)).put("centerOfMass", new Vector3D(0.011608, 0.0, 0.0266707));
        ((Map)properties.get(PelvisName)).put("inertia", new Matrix3D(0.125568, 8.0E-4, -5.00733E-4, 8.0E-4, 0.0972042, -5.0E-4, -5.00733E-4, -5.0E-4, 0.117936));
        ((Map)properties.get(PelvisName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        properties.put(TorsoYawName, new HashMap());
        properties.put(TorsoYawLinkName, new HashMap());
        ((Map)properties.get(TorsoYawLinkName)).put("mass", 2.27);
        ((Map)properties.get(TorsoYawLinkName)).put("centerOfMass", new Vector3D(-0.0112984, -3.15366E-6, 0.0746835));
        ((Map)properties.get(TorsoYawLinkName)).put("inertia", new Matrix3D(0.0039092, -5.04491E-8, -3.42157E-4, -5.04491E-8, 0.00341694, 4.87119E-7, -3.42157E-4, 4.87119E-7, 0.00174492));
        ((Map)properties.get(TorsoYawName)).put("offsetFromParentJoint", new Vector3D(-0.0125, 0.0, 0.0));
        ((Map)properties.get(TorsoYawName)).put("positionLowerLimit", -0.663225);
        ((Map)properties.get(TorsoYawName)).put("positionUpperLimit", 0.663225);
        ((Map)properties.get(TorsoYawName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(TorsoYawName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(TorsoYawName)).put("effortLowerLimit", -106.0);
        ((Map)properties.get(TorsoYawName)).put("effortUpperLimit", 106.0);
        ((Map)properties.get(TorsoYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(TorsoYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(TorsoYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(TorsoYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(TorsoYawName)).put("damping", 0.1);
        ((Map)properties.get(TorsoYawName)).put("stiction", 0.0);
        properties.put(TorsoPitchName, new HashMap());
        properties.put(TorsoPitchLinkName, new HashMap());
        ((Map)properties.get(TorsoPitchLinkName)).put("mass", 0.799);
        ((Map)properties.get(TorsoPitchLinkName)).put("centerOfMass", new Vector3D(-0.00816266, -0.0131245, 0.0305974));
        ((Map)properties.get(TorsoPitchLinkName)).put("inertia", new Matrix3D(4.54181E-4, -6.10764E-5, 3.94009E-5, -6.10764E-5, 4.83282E-4, 5.27463E-5, 3.94009E-5, 5.27463E-5, 4.44215E-4));
        ((Map)properties.get(TorsoPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.162));
        ((Map)properties.get(TorsoPitchName)).put("positionLowerLimit", -0.219388);
        ((Map)properties.get(TorsoPitchName)).put("positionUpperLimit", 0.538783);
        ((Map)properties.get(TorsoPitchName)).put("velocityLowerLimit", -9.0);
        ((Map)properties.get(TorsoPitchName)).put("velocityUpperLimit", 9.0);
        ((Map)properties.get(TorsoPitchName)).put("effortLowerLimit", -445.0);
        ((Map)properties.get(TorsoPitchName)).put("effortUpperLimit", 445.0);
        ((Map)properties.get(TorsoPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(TorsoPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(TorsoPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(TorsoPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(TorsoPitchName)).put("damping", 0.1);
        ((Map)properties.get(TorsoPitchName)).put("stiction", 0.0);
        properties.put(TorsoRollName, new HashMap());
        properties.put(TorsoRollLinkName, new HashMap());
        ((Map)properties.get(TorsoRollLinkName)).put("mass", 84.609);
        ((Map)properties.get(TorsoRollLinkName)).put("centerOfMass", new Vector3D(-0.0616866, 0.00229456, 0.316809));
        ((Map)properties.get(TorsoRollLinkName)).put("inertia", new Matrix3D(1.62389, -0.0319003, 0.0816618, -0.0319003, 1.65538, 0.0472154, 0.0816618, 0.0472154, 0.577362));
        ((Map)properties.get(TorsoRollName)).put("offsetFromParentJoint", new Vector3D(0.005705000000000001, 0.0, 0.04999999999999999));
        ((Map)properties.get(TorsoRollName)).put("positionLowerLimit", -0.4);
        ((Map)properties.get(TorsoRollName)).put("positionUpperLimit", 0.4);
        ((Map)properties.get(TorsoRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(TorsoRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(TorsoRollName)).put("effortLowerLimit", -300.0);
        ((Map)properties.get(TorsoRollName)).put("effortUpperLimit", 300.0);
        ((Map)properties.get(TorsoRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(TorsoRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(TorsoRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(TorsoRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(TorsoRollName)).put("damping", 0.1);
        ((Map)properties.get(TorsoRollName)).put("stiction", 0.0);
        properties.put(LeftShoulderYawName, new HashMap());
        properties.put(LeftShoulderYawLinkName, new HashMap());
        ((Map)properties.get(LeftShoulderYawLinkName)).put("mass", 4.466);
        ((Map)properties.get(LeftShoulderYawLinkName)).put("centerOfMass", new Vector3D(0.0, 0.0, -0.084));
        ((Map)properties.get(LeftShoulderYawLinkName)).put("inertia", new Matrix3D(0.011, 0.0, 0.0, 0.0, 0.009, -0.004, 0.0, -0.004, 0.004));
        ((Map)properties.get(LeftShoulderYawName)).put("offsetFromParentJoint", new Vector3D(0.134895, 0.2256, 0.4776));
        ((Map)properties.get(LeftShoulderYawName)).put("positionLowerLimit", -1.5708);
        ((Map)properties.get(LeftShoulderYawName)).put("positionUpperLimit", 0.785398);
        ((Map)properties.get(LeftShoulderYawName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftShoulderYawName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftShoulderYawName)).put("effortLowerLimit", -87.0);
        ((Map)properties.get(LeftShoulderYawName)).put("effortUpperLimit", 87.0);
        ((Map)properties.get(LeftShoulderYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftShoulderYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftShoulderYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftShoulderYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(LeftShoulderYawName)).put("damping", 0.1);
        ((Map)properties.get(LeftShoulderYawName)).put("stiction", 0.0);
        properties.put(LeftShoulderRollName, new HashMap());
        properties.put(LeftShoulderRollLinkName, new HashMap());
        ((Map)properties.get(LeftShoulderRollLinkName)).put("mass", 3.899);
        ((Map)properties.get(LeftShoulderRollLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(LeftShoulderRollLinkName)).put("inertia", new Matrix3D(0.00319, 0.0, 0.0, 0.0, 0.00583, 0.0, 0.0, 0.0, 0.00583));
        ((Map)properties.get(LeftShoulderRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.11000000000000001, -0.245));
        ((Map)properties.get(LeftShoulderRollName)).put("positionLowerLimit", -1.5708);
        ((Map)properties.get(LeftShoulderRollName)).put("positionUpperLimit", 1.5708);
        ((Map)properties.get(LeftShoulderRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftShoulderRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftShoulderRollName)).put("effortLowerLimit", -99.0);
        ((Map)properties.get(LeftShoulderRollName)).put("effortUpperLimit", 99.0);
        ((Map)properties.get(LeftShoulderRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftShoulderRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftShoulderRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftShoulderRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftShoulderRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftShoulderRollName)).put("stiction", 0.0);
        properties.put(LeftElbowPitchName, new HashMap());
        properties.put(LeftElbowPitchLinkName, new HashMap());
        ((Map)properties.get(LeftElbowPitchLinkName)).put("mass", 4.386);
        ((Map)properties.get(LeftElbowPitchLinkName)).put("centerOfMass", new Vector3D(0.0, -0.065, 0.0));
        ((Map)properties.get(LeftElbowPitchLinkName)).put("inertia", new Matrix3D(0.00656, 0.0, 0.0, 0.0, 0.00358, 0.0, 0.0, 0.0, 0.00656));
        ((Map)properties.get(LeftElbowPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.18699999999999994, -0.016000000000000014));
        ((Map)properties.get(LeftElbowPitchName)).put("positionLowerLimit", 0.0);
        ((Map)properties.get(LeftElbowPitchName)).put("positionUpperLimit", 3.14159);
        ((Map)properties.get(LeftElbowPitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftElbowPitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftElbowPitchName)).put("effortLowerLimit", -63.0);
        ((Map)properties.get(LeftElbowPitchName)).put("effortUpperLimit", 63.0);
        ((Map)properties.get(LeftElbowPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftElbowPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftElbowPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftElbowPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftElbowPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftElbowPitchName)).put("stiction", 0.0);
        properties.put(LeftElbowRollName, new HashMap());
        properties.put(LeftElbowRollLinkName, new HashMap());
        ((Map)properties.get(LeftElbowRollLinkName)).put("mass", 3.248);
        ((Map)properties.get(LeftElbowRollLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(LeftElbowRollLinkName)).put("inertia", new Matrix3D(0.00265, 0.0, 0.0, 0.0, 0.00446, 0.0, 0.0, 0.0, 0.00446));
        ((Map)properties.get(LeftElbowRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.119, 0.009200000000000041));
        ((Map)properties.get(LeftElbowRollName)).put("positionLowerLimit", 0.0);
        ((Map)properties.get(LeftElbowRollName)).put("positionUpperLimit", 2.35619);
        ((Map)properties.get(LeftElbowRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftElbowRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftElbowRollName)).put("effortLowerLimit", -112.0);
        ((Map)properties.get(LeftElbowRollName)).put("effortUpperLimit", 112.0);
        ((Map)properties.get(LeftElbowRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftElbowRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftElbowRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftElbowRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftElbowRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftElbowRollName)).put("stiction", 0.0);
        properties.put(LeftWristPitchName, new HashMap());
        properties.put(LeftWristPitchLinkName, new HashMap());
        ((Map)properties.get(LeftWristPitchLinkName)).put("mass", 2.4798);
        ((Map)properties.get(LeftWristPitchLinkName)).put("centerOfMass", new Vector3D(1.5E-4, -0.08296, 3.7E-4));
        ((Map)properties.get(LeftWristPitchLinkName)).put("inertia", new Matrix3D(0.012731, 0.0, 0.0, 0.0, 0.002857, 0.0, 0.0, 0.0, 0.011948));
        ((Map)properties.get(LeftWristPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.2995500000000001, -0.009209999999999996));
        ((Map)properties.get(LeftWristPitchName)).put("positionLowerLimit", -3.011);
        ((Map)properties.get(LeftWristPitchName)).put("positionUpperLimit", 3.011);
        ((Map)properties.get(LeftWristPitchName)).put("velocityLowerLimit", -10.0);
        ((Map)properties.get(LeftWristPitchName)).put("velocityUpperLimit", 10.0);
        ((Map)properties.get(LeftWristPitchName)).put("effortLowerLimit", -25.0);
        ((Map)properties.get(LeftWristPitchName)).put("effortUpperLimit", 25.0);
        ((Map)properties.get(LeftWristPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftWristPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftWristPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftWristPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftWristPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftWristPitchName)).put("stiction", 0.0);
        properties.put(LeftWristRollName, new HashMap());
        properties.put(LeftWristRollLinkName, new HashMap());
        ((Map)properties.get(LeftWristRollLinkName)).put("mass", 0.648);
        ((Map)properties.get(LeftWristRollLinkName)).put("centerOfMass", new Vector3D(1.7E-4, 0.02515, 0.00163));
        ((Map)properties.get(LeftWristRollLinkName)).put("inertia", new Matrix3D(7.64E-4, 0.0, 0.0, 0.0, 4.29E-4, 0.0, 0.0, 0.0, 8.25E-4));
        ((Map)properties.get(LeftWristRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(LeftWristRollName)).put("positionLowerLimit", -1.7628);
        ((Map)properties.get(LeftWristRollName)).put("positionUpperLimit", 1.7628);
        ((Map)properties.get(LeftWristRollName)).put("velocityLowerLimit", -10.0);
        ((Map)properties.get(LeftWristRollName)).put("velocityUpperLimit", 10.0);
        ((Map)properties.get(LeftWristRollName)).put("effortLowerLimit", -25.0);
        ((Map)properties.get(LeftWristRollName)).put("effortUpperLimit", 25.0);
        ((Map)properties.get(LeftWristRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftWristRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftWristRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftWristRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftWristRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftWristRollName)).put("stiction", 0.0);
        properties.put(LeftWristSecondPitchName, new HashMap());
        properties.put(LeftWristSecondPitchLinkName, new HashMap());
        ((Map)properties.get(LeftWristSecondPitchLinkName)).put("mass", 1.8839);
        ((Map)properties.get(LeftWristSecondPitchLinkName)).put("centerOfMass", new Vector3D(-0.00118561, 0.141218, 6.19884E-6));
        ((Map)properties.get(LeftWristSecondPitchLinkName)).put("inertia", new Matrix3D(0.00689651, 6.78926E-5, -1.57141E-8, 6.78926E-5, 0.00397853, 6.96335E-7, -1.57141E-8, 6.96335E-7, 0.00688905));
        ((Map)properties.get(LeftWristSecondPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(LeftWristSecondPitchName)).put("positionLowerLimit", -2.9671);
        ((Map)properties.get(LeftWristSecondPitchName)).put("positionUpperLimit", 2.9671);
        ((Map)properties.get(LeftWristSecondPitchName)).put("velocityLowerLimit", -10.0);
        ((Map)properties.get(LeftWristSecondPitchName)).put("velocityUpperLimit", 10.0);
        ((Map)properties.get(LeftWristSecondPitchName)).put("effortLowerLimit", -25.0);
        ((Map)properties.get(LeftWristSecondPitchName)).put("effortUpperLimit", 25.0);
        ((Map)properties.get(LeftWristSecondPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftWristSecondPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftWristSecondPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftWristSecondPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftWristSecondPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftWristSecondPitchName)).put("stiction", 0.0);
        properties.put("l_palm_finger_1_joint", new HashMap());
        properties.put("l_finger_1_link_0", new HashMap());
        ((Map)properties.get("l_finger_1_link_0")).put("mass", 0.1);
        ((Map)properties.get("l_finger_1_link_0")).put("centerOfMass", new Vector3D(3.673203938689571E-8, -0.00999999682924925, 7.963269158366412E-6));
        ((Map)properties.get("l_finger_1_link_0")).put("inertia", new Matrix3D(2.499999999990555E-5, 2.5712419418057096E-11, -2.0475498146155928E-14, 2.5712419418057096E-11, 1.800000443905034E-5, 5.574286643388569E-9, -2.0475498146143003E-14, 5.574286643388572E-9, 2.4999995561044105E-5));
        ((Map)properties.get("l_palm_finger_1_joint")).put("offsetFromParentJoint", new Vector3D(-0.037790299999999985, 0.21040000000000003, -0.04550000000000004));
        ((Map)properties.get("l_palm_finger_1_joint")).put("positionLowerLimit", -0.2967);
        ((Map)properties.get("l_palm_finger_1_joint")).put("positionUpperLimit", 0.2967);
        ((Map)properties.get("l_palm_finger_1_joint")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_1_joint")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_1_joint")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_palm_finger_1_joint")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_palm_finger_1_joint")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_palm_finger_1_joint")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_palm_finger_1_joint")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_palm_finger_1_joint")).put("axis", new Vector3D(6.326787993849492E-6, 7.96326747494098E-4, 0.9999996829117912));
        ((Map)properties.get("l_palm_finger_1_joint")).put("damping", 1.0);
        ((Map)properties.get("l_palm_finger_1_joint")).put("stiction", 0.0);
        properties.put("l_finger_1_joint_1", new HashMap());
        properties.put("l_finger_1_link_1", new HashMap());
        ((Map)properties.get("l_finger_1_link_1")).put("mass", 0.047);
        ((Map)properties.get("l_finger_1_link_1")).put("centerOfMass", new Vector3D(-1.6047369155512067E-7, 0.02818764799107845, -0.015522451504362931));
        ((Map)properties.get("l_finger_1_link_1")).put("inertia", new Matrix3D(6.0619200010434345E-5, -8.326117546483128E-10, 3.974703474676766E-10, -8.326117546483127E-10, 2.0475715789274972E-5, 2.6077577618842952E-5, 3.974703474676766E-10, 2.607757761884295E-5, 4.886290420029068E-5));
        ((Map)properties.get("l_finger_1_joint_1")).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get("l_finger_1_joint_1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("l_finger_1_joint_1")).put("positionUpperLimit", 1.2217);
        ((Map)properties.get("l_finger_1_joint_1")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_1_joint_1")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_1_joint_1")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_1_joint_1")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_1_joint_1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_1_joint_1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_1_joint_1")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_1_joint_1")).put("axis", new Vector3D(0.9999999999529641, 7.346409999654455E-6, -6.332649999702139E-6));
        ((Map)properties.get("l_finger_1_joint_1")).put("damping", 1.0);
        ((Map)properties.get("l_finger_1_joint_1")).put("stiction", 0.0);
        properties.put("l_finger_1_joint_2", new HashMap());
        properties.put("l_finger_1_link_2", new HashMap());
        ((Map)properties.get("l_finger_1_link_2")).put("mass", 0.03284);
        ((Map)properties.get("l_finger_1_link_2")).put("centerOfMass", new Vector3D(1.797414813764432E-4, 0.019035900919603402, -0.010365995812217704));
        ((Map)properties.get("l_finger_1_link_2")).put("inertia", new Matrix3D(1.986349688608241E-5, 1.1473033901948098E-7, -6.247058281310054E-8, 1.1473033901948098E-7, 8.460025615260552E-6, 8.362216167123803E-6, -6.247058281310054E-8, 8.362216167123803E-6, 1.7501257498657038E-5));
        ((Map)properties.get("l_finger_1_joint_2")).put("offsetFromParentJoint", new Vector3D(-4.999999999776676E-7, 0.04998000000000003, -0.02804000000000004));
        ((Map)properties.get("l_finger_1_joint_2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("l_finger_1_joint_2")).put("positionUpperLimit", 1.5708);
        ((Map)properties.get("l_finger_1_joint_2")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_1_joint_2")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_1_joint_2")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_1_joint_2")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_1_joint_2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_1_joint_2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_1_joint_2")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_1_joint_2")).put("axis", new Vector3D(0.9999999999529641, 7.346409999654455E-6, -6.332649999702139E-6));
        ((Map)properties.get("l_finger_1_joint_2")).put("damping", 1.0);
        ((Map)properties.get("l_finger_1_joint_2")).put("stiction", 0.0);
        properties.put("l_finger_1_joint_3", new HashMap());
        properties.put("l_finger_1_link_3", new HashMap());
        ((Map)properties.get("l_finger_1_link_3")).put("mass", 0.03354);
        ((Map)properties.get("l_finger_1_link_3")).put("centerOfMass", new Vector3D(1.9994207213847587E-4, 0.016260385778610654, 4.7705083434092173E-4));
        ((Map)properties.get("l_finger_1_link_3")).put("inertia", new Matrix3D(1.2641299894149845E-5, 2.5190379789924503E-9, -1.1909294242819402E-8, 2.5190379789924495E-9, 3.0529472139062597E-6, 9.068601950811619E-7, -1.1909294242819402E-8, 9.068601950811619E-7, 1.4278362891943894E-5));
        ((Map)properties.get("l_finger_1_joint_3")).put("offsetFromParentJoint", new Vector3D(-4.0000000001082607E-7, 0.03383000000000005, -0.019404999999999954));
        ((Map)properties.get("l_finger_1_joint_3")).put("positionLowerLimit", -0.6632);
        ((Map)properties.get("l_finger_1_joint_3")).put("positionUpperLimit", 1.0471);
        ((Map)properties.get("l_finger_1_joint_3")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_1_joint_3")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_1_joint_3")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_1_joint_3")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_1_joint_3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_1_joint_3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_1_joint_3")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_1_joint_3")).put("axis", new Vector3D(0.9999999999529641, 7.346409999654455E-6, -6.332649999702139E-6));
        ((Map)properties.get("l_finger_1_joint_3")).put("damping", 1.0);
        ((Map)properties.get("l_finger_1_joint_3")).put("stiction", 0.0);
        properties.put("l_palm_finger_2_joint", new HashMap());
        properties.put("l_finger_2_link_0", new HashMap());
        ((Map)properties.get("l_finger_2_link_0")).put("mass", 0.1);
        ((Map)properties.get("l_finger_2_link_0")).put("centerOfMass", new Vector3D(3.673203938689571E-8, -0.00999999682924925, 7.963269158366412E-6));
        ((Map)properties.get("l_finger_2_link_0")).put("inertia", new Matrix3D(2.499999999990555E-5, 2.5712419418057096E-11, -2.0475498146155928E-14, 2.5712419418057096E-11, 1.800000443905034E-5, 5.574286643388569E-9, -2.0475498146143003E-14, 5.574286643388572E-9, 2.4999995561044105E-5));
        ((Map)properties.get("l_palm_finger_2_joint")).put("offsetFromParentJoint", new Vector3D(0.03421000000000002, 0.21040000000000003, -0.04550000000000004));
        ((Map)properties.get("l_palm_finger_2_joint")).put("positionLowerLimit", -0.2967);
        ((Map)properties.get("l_palm_finger_2_joint")).put("positionUpperLimit", 0.2967);
        ((Map)properties.get("l_palm_finger_2_joint")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_2_joint")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_2_joint")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_palm_finger_2_joint")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_palm_finger_2_joint")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_palm_finger_2_joint")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_palm_finger_2_joint")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_palm_finger_2_joint")).put("axis", new Vector3D(6.326787993849492E-6, 7.96326747494098E-4, 0.9999996829117912));
        ((Map)properties.get("l_palm_finger_2_joint")).put("damping", 1.0);
        ((Map)properties.get("l_palm_finger_2_joint")).put("stiction", 0.0);
        properties.put("l_finger_2_joint_1", new HashMap());
        properties.put("l_finger_2_link_1", new HashMap());
        ((Map)properties.get("l_finger_2_link_1")).put("mass", 0.047);
        ((Map)properties.get("l_finger_2_link_1")).put("centerOfMass", new Vector3D(-1.6047369155512067E-7, 0.02818764799107845, -0.015522451504362931));
        ((Map)properties.get("l_finger_2_link_1")).put("inertia", new Matrix3D(6.0619200010434345E-5, -8.326117546483128E-10, 3.974703474676766E-10, -8.326117546483127E-10, 2.0475715789274972E-5, 2.6077577618842952E-5, 3.974703474676766E-10, 2.607757761884295E-5, 4.886290420029068E-5));
        ((Map)properties.get("l_finger_2_joint_1")).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get("l_finger_2_joint_1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("l_finger_2_joint_1")).put("positionUpperLimit", 1.2217);
        ((Map)properties.get("l_finger_2_joint_1")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_2_joint_1")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_2_joint_1")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_2_joint_1")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_2_joint_1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_2_joint_1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_2_joint_1")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_2_joint_1")).put("axis", new Vector3D(0.9999999999529641, 7.346409999654455E-6, -6.332649999702139E-6));
        ((Map)properties.get("l_finger_2_joint_1")).put("damping", 1.0);
        ((Map)properties.get("l_finger_2_joint_1")).put("stiction", 0.0);
        properties.put("l_finger_2_joint_2", new HashMap());
        properties.put("l_finger_2_link_2", new HashMap());
        ((Map)properties.get("l_finger_2_link_2")).put("mass", 0.03284);
        ((Map)properties.get("l_finger_2_link_2")).put("centerOfMass", new Vector3D(1.797414813764432E-4, 0.019035900919603402, -0.010365995812217704));
        ((Map)properties.get("l_finger_2_link_2")).put("inertia", new Matrix3D(1.986349688608241E-5, 1.1473033901948098E-7, -6.247058281310054E-8, 1.1473033901948098E-7, 8.460025615260552E-6, 8.362216167123803E-6, -6.247058281310054E-8, 8.362216167123803E-6, 1.7501257498657038E-5));
        ((Map)properties.get("l_finger_2_joint_2")).put("offsetFromParentJoint", new Vector3D(-1.0000000000126629E-6, 0.04997999999999974, -0.028039999999999985));
        ((Map)properties.get("l_finger_2_joint_2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("l_finger_2_joint_2")).put("positionUpperLimit", 1.5708);
        ((Map)properties.get("l_finger_2_joint_2")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_2_joint_2")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_2_joint_2")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_2_joint_2")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_2_joint_2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_2_joint_2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_2_joint_2")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_2_joint_2")).put("axis", new Vector3D(0.9999999999529641, 7.346409999654455E-6, -6.332649999702139E-6));
        ((Map)properties.get("l_finger_2_joint_2")).put("damping", 1.0);
        ((Map)properties.get("l_finger_2_joint_2")).put("stiction", 0.0);
        properties.put("l_finger_2_joint_3", new HashMap());
        properties.put("l_finger_2_link_3", new HashMap());
        ((Map)properties.get("l_finger_2_link_3")).put("mass", 0.03354);
        ((Map)properties.get("l_finger_2_link_3")).put("centerOfMass", new Vector3D(1.9994207213847587E-4, 0.016260385778610654, 4.7705083434092173E-4));
        ((Map)properties.get("l_finger_2_link_3")).put("inertia", new Matrix3D(1.2641299894149845E-5, 2.5190379789924503E-9, -1.1909294242819402E-8, 2.5190379789924495E-9, 3.0529472139062597E-6, 9.068601950811619E-7, -1.1909294242819402E-8, 9.068601950811619E-7, 1.4278362891943894E-5));
        ((Map)properties.get("l_finger_2_joint_3")).put("offsetFromParentJoint", new Vector3D(3.014749077955665E-18, 0.03383000000000001, -0.01940499999999997));
        ((Map)properties.get("l_finger_2_joint_3")).put("positionLowerLimit", -0.6632);
        ((Map)properties.get("l_finger_2_joint_3")).put("positionUpperLimit", 1.0471);
        ((Map)properties.get("l_finger_2_joint_3")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_2_joint_3")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_2_joint_3")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_2_joint_3")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_2_joint_3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_2_joint_3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_2_joint_3")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_2_joint_3")).put("axis", new Vector3D(0.9999999999529641, 7.346409999654455E-6, -6.332649999702139E-6));
        ((Map)properties.get("l_finger_2_joint_3")).put("damping", 1.0);
        ((Map)properties.get("l_finger_2_joint_3")).put("stiction", 0.0);
        properties.put("l_palm_finger_middle_joint", new HashMap());
        properties.put("l_finger_middle_link_0", new HashMap());
        ((Map)properties.get("l_finger_middle_link_0")).put("mass", 0.1);
        ((Map)properties.get("l_finger_middle_link_0")).put("centerOfMass", new Vector3D(3.673203938689571E-8, -0.00999999682924925, -7.963269158366412E-6));
        ((Map)properties.get("l_finger_middle_link_0")).put("inertia", new Matrix3D(2.499999999990555E-5, 2.571241941805711E-11, 2.0475498146117154E-14, 2.571241941805711E-11, 1.8000004439050344E-5, -5.5742866433885716E-9, 2.0475498146168852E-14, -5.5742866433885716E-9, 2.4999995561044105E-5));
        ((Map)properties.get("l_palm_finger_middle_joint")).put("offsetFromParentJoint", new Vector3D(-0.001789999999999986, 0.21040000000000003, 0.045499999999999985));
        ((Map)properties.get("l_palm_finger_middle_joint")).put("positionLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("positionUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("kpPositionLimit", 0.0);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("kdPositionLimit", 0.0);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("axis", new Vector3D(-6.326787993849492E-6, 7.96326747494098E-4, -0.9999996829117912));
        ((Map)properties.get("l_palm_finger_middle_joint")).put("damping", 1.0);
        ((Map)properties.get("l_palm_finger_middle_joint")).put("stiction", 0.0);
        properties.put("l_finger_middle_joint_1", new HashMap());
        properties.put("l_finger_middle_link_1", new HashMap());
        ((Map)properties.get("l_finger_middle_link_1")).put("mass", 0.047);
        ((Map)properties.get("l_finger_middle_link_1")).put("centerOfMass", new Vector3D(-5.47369155593376E-9, 0.02818764799164796, 0.015522451504157278));
        ((Map)properties.get("l_finger_middle_link_1")).put("inertia", new Matrix3D(6.06191999990733E-5, 1.0584079131103385E-9, 5.579056583633519E-10, 1.0584079131103385E-9, 2.047571580317117E-5, -2.6077577617841644E-5, 5.579056583633521E-10, -2.607757761784164E-5, 4.886290419775551E-5));
        ((Map)properties.get("l_finger_middle_joint_1")).put("offsetFromParentJoint", new Vector3D(-0.0, 0.0, 0.0));
        ((Map)properties.get("l_finger_middle_joint_1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("l_finger_middle_joint_1")).put("positionUpperLimit", 1.2217);
        ((Map)properties.get("l_finger_middle_joint_1")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_middle_joint_1")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_middle_joint_1")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_middle_joint_1")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_middle_joint_1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_middle_joint_1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_middle_joint_1")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_middle_joint_1")).put("axis", new Vector3D(-0.999999999979986, 0.0, 6.326789999873376E-6));
        ((Map)properties.get("l_finger_middle_joint_1")).put("damping", 1.0);
        ((Map)properties.get("l_finger_middle_joint_1")).put("stiction", 0.0);
        properties.put("l_finger_middle_joint_2", new HashMap());
        properties.put("l_finger_middle_link_2", new HashMap());
        ((Map)properties.get("l_finger_middle_link_2")).put("mass", 0.03284);
        ((Map)properties.get("l_finger_middle_link_2")).put("centerOfMass", new Vector3D(-1.7988260063061753E-4, 0.019035899360977188, 0.010365996226544681));
        ((Map)properties.get("l_finger_middle_link_2")).put("inertia", new Matrix3D(1.9863498586639554E-5, -1.1465075589699571E-7, -6.240354687389753E-8, -1.1465075589699573E-7, 8.460023627654863E-6, -8.362216444465822E-6, -6.240354687389753E-8, -8.362216444465819E-6, 1.750125778570558E-5));
        ((Map)properties.get("l_finger_middle_joint_2")).put("offsetFromParentJoint", new Vector3D(5.122938644799754E-17, 0.04997999999999988, 0.028040000000000002));
        ((Map)properties.get("l_finger_middle_joint_2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("l_finger_middle_joint_2")).put("positionUpperLimit", 1.5708);
        ((Map)properties.get("l_finger_middle_joint_2")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_middle_joint_2")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_middle_joint_2")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_middle_joint_2")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_middle_joint_2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_middle_joint_2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_middle_joint_2")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_middle_joint_2")).put("axis", new Vector3D(-0.999999999979986, -2.77555999994445E-17, 6.326789999873376E-6));
        ((Map)properties.get("l_finger_middle_joint_2")).put("damping", 1.0);
        ((Map)properties.get("l_finger_middle_joint_2")).put("stiction", 0.0);
        properties.put("l_finger_middle_joint_3", new HashMap());
        properties.put("l_finger_middle_link_3", new HashMap());
        ((Map)properties.get("l_finger_middle_link_3")).put("mass", 0.03354);
        ((Map)properties.get("l_finger_middle_link_3")).put("centerOfMass", new Vector3D(-2.0006282785347198E-4, 0.016260384308887984, -4.7705030361663007E-4));
        ((Map)properties.get("l_finger_middle_link_3")).put("inertia", new Matrix3D(1.2641299867496634E-5, -2.4509841798737985E-9, -1.1898286066816504E-8, -2.4509841798737985E-9, 3.0529471773839354E-6, -9.068602759622438E-7, -1.1898286066816505E-8, -9.068602759622438E-7, 1.4278362955119426E-5));
        ((Map)properties.get("l_finger_middle_joint_3")).put("offsetFromParentJoint", new Vector3D(1.0000000000064088E-6, 0.03383000000000013, 0.01940499999999993));
        ((Map)properties.get("l_finger_middle_joint_3")).put("positionLowerLimit", -0.6632);
        ((Map)properties.get("l_finger_middle_joint_3")).put("positionUpperLimit", 1.0471);
        ((Map)properties.get("l_finger_middle_joint_3")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("l_finger_middle_joint_3")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("l_finger_middle_joint_3")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("l_finger_middle_joint_3")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("l_finger_middle_joint_3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("l_finger_middle_joint_3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("l_finger_middle_joint_3")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("l_finger_middle_joint_3")).put("axis", new Vector3D(-0.999999999979986, -5.5511199998889E-17, 6.326789999873376E-6));
        ((Map)properties.get("l_finger_middle_joint_3")).put("damping", 1.0);
        ((Map)properties.get("l_finger_middle_joint_3")).put("stiction", 0.0);
        properties.put(NeckPitchName, new HashMap());
        properties.put(NeckPitchLinkName, new HashMap());
        ((Map)properties.get(NeckPitchLinkName)).put("mass", 1.41991);
        ((Map)properties.get(NeckPitchLinkName)).put("centerOfMass", new Vector3D(-0.0754942, 3.38765E-5, 0.0277411));
        ((Map)properties.get(NeckPitchLinkName)).put("inertia", new Matrix3D(0.00397627, -1.51324E-6, -8.92818E-4, -1.51324E-6, 0.00412515, -6.83342E-7, -8.92818E-4, -6.83342E-7, 0.00353178));
        ((Map)properties.get(NeckPitchName)).put("offsetFromParentJoint", new Vector3D(0.288895, 0.0, 0.6215));
        ((Map)properties.get(NeckPitchName)).put("positionLowerLimit", -0.602139);
        ((Map)properties.get(NeckPitchName)).put("positionUpperLimit", 1.14319);
        ((Map)properties.get(NeckPitchName)).put("velocityLowerLimit", -6.28);
        ((Map)properties.get(NeckPitchName)).put("velocityUpperLimit", 6.28);
        ((Map)properties.get(NeckPitchName)).put("effortLowerLimit", -25.0);
        ((Map)properties.get(NeckPitchName)).put("effortUpperLimit", 25.0);
        ((Map)properties.get(NeckPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(NeckPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(NeckPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(NeckPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(NeckPitchName)).put("damping", 0.1);
        ((Map)properties.get(NeckPitchName)).put("stiction", 0.0);
        properties.put(HokuyoJointName, new HashMap());
        properties.put(HokuyoLinkName, new HashMap());
        ((Map)properties.get(HokuyoLinkName)).put("mass", 0.057664);
        ((Map)properties.get(HokuyoLinkName)).put("centerOfMass", new Vector3D(0.0324349, 4.084E-4, -0.0041783));
        ((Map)properties.get(HokuyoLinkName)).put("inertia", new Matrix3D(3.8183E-5, 4.9927E-8, 1.1003E-5, 4.9927E-8, 4.3437E-5, -9.8165E-9, 1.1003E-5, -9.8165E-9, 4.2686E-5));
        ((Map)properties.get(HokuyoJointName)).put("offsetFromParentJoint", new Vector3D(-0.08460000000000001, 0.0, 0.08799999999999997));
        ((Map)properties.get(HokuyoJointName)).put("positionLowerLimit", -1.0E16);
        ((Map)properties.get(HokuyoJointName)).put("positionUpperLimit", 1.0E16);
        ((Map)properties.get(HokuyoJointName)).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("effortLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("effortUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get(HokuyoJointName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(HokuyoJointName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(HokuyoJointName)).put("kpVelocityLimit", 0.0);
        ((Map)properties.get(HokuyoJointName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(HokuyoJointName)).put("damping", 0.01);
        ((Map)properties.get(HokuyoJointName)).put("stiction", 0.0);
        properties.put(RightShoulderYawName, new HashMap());
        properties.put(RightShoulderYawLinkName, new HashMap());
        ((Map)properties.get(RightShoulderYawLinkName)).put("mass", 4.466);
        ((Map)properties.get(RightShoulderYawLinkName)).put("centerOfMass", new Vector3D(0.0, 0.0, -0.084));
        ((Map)properties.get(RightShoulderYawLinkName)).put("inertia", new Matrix3D(0.011, 0.0, 0.0, 0.0, 0.009, 0.004, 0.0, 0.004, 0.004));
        ((Map)properties.get(RightShoulderYawName)).put("offsetFromParentJoint", new Vector3D(0.134895, -0.2256, 0.4776));
        ((Map)properties.get(RightShoulderYawName)).put("positionLowerLimit", -0.785398);
        ((Map)properties.get(RightShoulderYawName)).put("positionUpperLimit", 1.5708);
        ((Map)properties.get(RightShoulderYawName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightShoulderYawName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightShoulderYawName)).put("effortLowerLimit", -87.0);
        ((Map)properties.get(RightShoulderYawName)).put("effortUpperLimit", 87.0);
        ((Map)properties.get(RightShoulderYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightShoulderYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightShoulderYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightShoulderYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(RightShoulderYawName)).put("damping", 0.1);
        ((Map)properties.get(RightShoulderYawName)).put("stiction", 0.0);
        properties.put(RightShoulderRollName, new HashMap());
        properties.put(RightShoulderRollLinkName, new HashMap());
        ((Map)properties.get(RightShoulderRollLinkName)).put("mass", 3.899);
        ((Map)properties.get(RightShoulderRollLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(RightShoulderRollLinkName)).put("inertia", new Matrix3D(0.00319, 0.0, 0.0, 0.0, 0.00583, 0.0, 0.0, 0.0, 0.00583));
        ((Map)properties.get(RightShoulderRollName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.11000000000000001, -0.245));
        ((Map)properties.get(RightShoulderRollName)).put("positionLowerLimit", -1.5708);
        ((Map)properties.get(RightShoulderRollName)).put("positionUpperLimit", 1.5708);
        ((Map)properties.get(RightShoulderRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightShoulderRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightShoulderRollName)).put("effortLowerLimit", -99.0);
        ((Map)properties.get(RightShoulderRollName)).put("effortUpperLimit", 99.0);
        ((Map)properties.get(RightShoulderRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightShoulderRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightShoulderRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightShoulderRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightShoulderRollName)).put("damping", 0.1);
        ((Map)properties.get(RightShoulderRollName)).put("stiction", 0.0);
        properties.put(RightElbowPitchName, new HashMap());
        properties.put(RightElbowPitchLinkName, new HashMap());
        ((Map)properties.get(RightElbowPitchLinkName)).put("mass", 4.386);
        ((Map)properties.get(RightElbowPitchLinkName)).put("centerOfMass", new Vector3D(0.0, 0.065, 0.0));
        ((Map)properties.get(RightElbowPitchLinkName)).put("inertia", new Matrix3D(0.00656, 0.0, 0.0, 0.0, 0.00358, 0.0, 0.0, 0.0, 0.00656));
        ((Map)properties.get(RightElbowPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.18699999999999994, -0.016000000000000014));
        ((Map)properties.get(RightElbowPitchName)).put("positionLowerLimit", 0.0);
        ((Map)properties.get(RightElbowPitchName)).put("positionUpperLimit", 3.14159);
        ((Map)properties.get(RightElbowPitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightElbowPitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightElbowPitchName)).put("effortLowerLimit", -63.0);
        ((Map)properties.get(RightElbowPitchName)).put("effortUpperLimit", 63.0);
        ((Map)properties.get(RightElbowPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightElbowPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightElbowPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightElbowPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightElbowPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightElbowPitchName)).put("stiction", 0.0);
        properties.put(RightElbowRollName, new HashMap());
        properties.put(RightElbowRollLinkName, new HashMap());
        ((Map)properties.get(RightElbowRollLinkName)).put("mass", 3.248);
        ((Map)properties.get(RightElbowRollLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(RightElbowRollLinkName)).put("inertia", new Matrix3D(0.00265, 0.0, 0.0, 0.0, 0.00446, 0.0, 0.0, 0.0, 0.00446));
        ((Map)properties.get(RightElbowRollName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.119, 0.009200000000000041));
        ((Map)properties.get(RightElbowRollName)).put("positionLowerLimit", -2.35619);
        ((Map)properties.get(RightElbowRollName)).put("positionUpperLimit", 0.0);
        ((Map)properties.get(RightElbowRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightElbowRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightElbowRollName)).put("effortLowerLimit", -112.0);
        ((Map)properties.get(RightElbowRollName)).put("effortUpperLimit", 112.0);
        ((Map)properties.get(RightElbowRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightElbowRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightElbowRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightElbowRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightElbowRollName)).put("damping", 0.1);
        ((Map)properties.get(RightElbowRollName)).put("stiction", 0.0);
        properties.put(RightWristPitchName, new HashMap());
        properties.put(RightWristPitchLinkName, new HashMap());
        ((Map)properties.get(RightWristPitchLinkName)).put("mass", 2.4798);
        ((Map)properties.get(RightWristPitchLinkName)).put("centerOfMass", new Vector3D(1.5E-4, 0.08296, 3.7E-4));
        ((Map)properties.get(RightWristPitchLinkName)).put("inertia", new Matrix3D(0.012731, 0.0, 0.0, 0.0, 0.002857, 0.0, 0.0, 0.0, 0.011948));
        ((Map)properties.get(RightWristPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.2995500000000001, -0.009209999999999996));
        ((Map)properties.get(RightWristPitchName)).put("positionLowerLimit", -3.011);
        ((Map)properties.get(RightWristPitchName)).put("positionUpperLimit", 3.011);
        ((Map)properties.get(RightWristPitchName)).put("velocityLowerLimit", -10.0);
        ((Map)properties.get(RightWristPitchName)).put("velocityUpperLimit", 10.0);
        ((Map)properties.get(RightWristPitchName)).put("effortLowerLimit", -25.0);
        ((Map)properties.get(RightWristPitchName)).put("effortUpperLimit", 25.0);
        ((Map)properties.get(RightWristPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightWristPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightWristPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightWristPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightWristPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightWristPitchName)).put("stiction", 0.0);
        properties.put(RightWristRollName, new HashMap());
        properties.put(RightWristRollLinkName, new HashMap());
        ((Map)properties.get(RightWristRollLinkName)).put("mass", 0.648);
        ((Map)properties.get(RightWristRollLinkName)).put("centerOfMass", new Vector3D(1.7E-4, -0.02515, 0.00163));
        ((Map)properties.get(RightWristRollLinkName)).put("inertia", new Matrix3D(7.64E-4, 0.0, 0.0, 0.0, 4.29E-4, 0.0, 0.0, 0.0, 8.25E-4));
        ((Map)properties.get(RightWristRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(RightWristRollName)).put("positionLowerLimit", -1.7628);
        ((Map)properties.get(RightWristRollName)).put("positionUpperLimit", 1.7628);
        ((Map)properties.get(RightWristRollName)).put("velocityLowerLimit", -10.0);
        ((Map)properties.get(RightWristRollName)).put("velocityUpperLimit", 10.0);
        ((Map)properties.get(RightWristRollName)).put("effortLowerLimit", -25.0);
        ((Map)properties.get(RightWristRollName)).put("effortUpperLimit", 25.0);
        ((Map)properties.get(RightWristRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightWristRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightWristRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightWristRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightWristRollName)).put("damping", 0.1);
        ((Map)properties.get(RightWristRollName)).put("stiction", 0.0);
        properties.put(RightWristSecondPitchName, new HashMap());
        properties.put(RightWristSecondPitchLinkName, new HashMap());
        ((Map)properties.get(RightWristSecondPitchLinkName)).put("mass", 1.8839);
        ((Map)properties.get(RightWristSecondPitchLinkName)).put("centerOfMass", new Vector3D(-0.00118561, -0.141218, 6.19884E-6));
        ((Map)properties.get(RightWristSecondPitchLinkName)).put("inertia", new Matrix3D(0.00689651, -6.78926E-5, -1.57141E-8, -6.78926E-5, 0.00397853, -6.96335E-7, -1.57141E-8, -6.96335E-7, 0.00688905));
        ((Map)properties.get(RightWristSecondPitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(RightWristSecondPitchName)).put("positionLowerLimit", -2.9671);
        ((Map)properties.get(RightWristSecondPitchName)).put("positionUpperLimit", 2.9671);
        ((Map)properties.get(RightWristSecondPitchName)).put("velocityLowerLimit", -10.0);
        ((Map)properties.get(RightWristSecondPitchName)).put("velocityUpperLimit", 10.0);
        ((Map)properties.get(RightWristSecondPitchName)).put("effortLowerLimit", -25.0);
        ((Map)properties.get(RightWristSecondPitchName)).put("effortUpperLimit", 25.0);
        ((Map)properties.get(RightWristSecondPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightWristSecondPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightWristSecondPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightWristSecondPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightWristSecondPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightWristSecondPitchName)).put("stiction", 0.0);
        properties.put("r_palm_finger_1_joint", new HashMap());
        properties.put("r_finger_1_link_0", new HashMap());
        ((Map)properties.get("r_finger_1_link_0")).put("mass", 0.1);
        ((Map)properties.get("r_finger_1_link_0")).put("centerOfMass", new Vector3D(-6.326792890642185E-8, 0.009999996829116571, 7.963269158366412E-6));
        ((Map)properties.get("r_finger_1_link_0")).put("inertia", new Matrix3D(2.4999999999719796E-5, 4.4287536191429364E-11, 3.526736828820462E-14, 4.428753619142938E-11, 1.8000004439236095E-5, -5.574286643314611E-9, 3.526736828820462E-14, -5.574286643314611E-9, 2.4999995561044105E-5));
        ((Map)properties.get("r_palm_finger_1_joint")).put("offsetFromParentJoint", new Vector3D(0.03421000000000002, -0.21040000000000003, -0.04550000000000004));
        ((Map)properties.get("r_palm_finger_1_joint")).put("positionLowerLimit", -0.2967);
        ((Map)properties.get("r_palm_finger_1_joint")).put("positionUpperLimit", 0.2967);
        ((Map)properties.get("r_palm_finger_1_joint")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_1_joint")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_1_joint")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_palm_finger_1_joint")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_palm_finger_1_joint")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_palm_finger_1_joint")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_palm_finger_1_joint")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_palm_finger_1_joint")).put("axis", new Vector3D(6.326267994014398E-6, -7.963267474941006E-4, 0.9999996829117945));
        ((Map)properties.get("r_palm_finger_1_joint")).put("damping", 1.0);
        ((Map)properties.get("r_palm_finger_1_joint")).put("stiction", 0.0);
        properties.put("r_finger_1_joint_1", new HashMap());
        properties.put("r_finger_1_link_1", new HashMap());
        ((Map)properties.get("r_finger_1_link_1")).put("mass", 0.047);
        ((Map)properties.get("r_finger_1_link_1")).put("centerOfMass", new Vector3D(8.027214656517109E-8, -0.028187647991534195, -0.015522451504157278));
        ((Map)properties.get("r_finger_1_link_1")).put("inertia", new Matrix3D(6.061920000684515E-5, -9.865434347538967E-10, -4.4562641161364085E-10, -9.865434347538967E-10, 2.0475715781825436E-5, -2.607757760944979E-5, -4.4562641161364085E-10, -2.607757760944979E-5, 4.88629042113294E-5));
        ((Map)properties.get("r_finger_1_joint_1")).put("offsetFromParentJoint", new Vector3D(0.0, -0.0, 0.0));
        ((Map)properties.get("r_finger_1_joint_1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("r_finger_1_joint_1")).put("positionUpperLimit", 1.2217);
        ((Map)properties.get("r_finger_1_joint_1")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_1_joint_1")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_1_joint_1")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_1_joint_1")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_1_joint_1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_1_joint_1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_1_joint_1")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_1_joint_1")).put("axis", new Vector3D(-0.9999999999576259, -6.692819999716398E-6, 6.320939999732156E-6));
        ((Map)properties.get("r_finger_1_joint_1")).put("damping", 1.0);
        ((Map)properties.get("r_finger_1_joint_1")).put("stiction", 0.0);
        properties.put("r_finger_1_joint_2", new HashMap());
        properties.put("r_finger_1_link_2", new HashMap());
        ((Map)properties.get("r_finger_1_link_2")).put("mass", 0.03284);
        ((Map)properties.get("r_finger_1_link_2")).put("centerOfMass", new Vector3D(-1.7987652690034674E-4, -0.019035900494228906, -0.01036599425086113));
        ((Map)properties.get("r_finger_1_link_2")).put("inertia", new Matrix3D(1.9863498513248567E-5, 1.1463076896000476E-7, 6.243026784582213E-8, 1.1463076896000474E-7, 8.46002507006287E-6, -8.362217309156877E-6, 6.243026784582213E-8, -8.362217309156874E-6, 1.7501256416688562E-5));
        ((Map)properties.get("r_finger_1_joint_2")).put("offsetFromParentJoint", new Vector3D(-3.961228987173541E-18, -0.04997999999999999, -0.02803999999999998));
        ((Map)properties.get("r_finger_1_joint_2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("r_finger_1_joint_2")).put("positionUpperLimit", 1.5708);
        ((Map)properties.get("r_finger_1_joint_2")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_1_joint_2")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_1_joint_2")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_1_joint_2")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_1_joint_2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_1_joint_2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_1_joint_2")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_1_joint_2")).put("axis", new Vector3D(-0.9999999999576259, -6.692819999716398E-6, 6.320939999732156E-6));
        ((Map)properties.get("r_finger_1_joint_2")).put("damping", 1.0);
        ((Map)properties.get("r_finger_1_joint_2")).put("stiction", 0.0);
        properties.put("r_finger_1_joint_3", new HashMap());
        properties.put("r_finger_1_link_3", new HashMap());
        ((Map)properties.get("r_finger_1_link_3")).put("mass", 0.03354);
        ((Map)properties.get("r_finger_1_link_3")).put("centerOfMass", new Vector3D(-1.9989402374137025E-4, -0.016260386310679293, 4.770528343337863E-4));
        ((Map)properties.get("r_finger_1_link_3")).put("inertia", new Matrix3D(1.2641300119070603E-5, 2.5354892902699895E-9, 1.1928078521684928E-8, 2.5354892902699895E-9, 3.0529472272684657E-6, -9.068601880703036E-7, 1.1928078521684928E-8, -9.068601880703036E-7, 1.4278362653660927E-5));
        ((Map)properties.get("r_finger_1_joint_3")).put("offsetFromParentJoint", new Vector3D(-3.3714452399562916E-17, -0.03382999999999998, -0.01940500000000009));
        ((Map)properties.get("r_finger_1_joint_3")).put("positionLowerLimit", -0.6632);
        ((Map)properties.get("r_finger_1_joint_3")).put("positionUpperLimit", 1.0471);
        ((Map)properties.get("r_finger_1_joint_3")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_1_joint_3")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_1_joint_3")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_1_joint_3")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_1_joint_3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_1_joint_3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_1_joint_3")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_1_joint_3")).put("axis", new Vector3D(-0.9999999999576259, -6.692819999716398E-6, 6.320939999732156E-6));
        ((Map)properties.get("r_finger_1_joint_3")).put("damping", 1.0);
        ((Map)properties.get("r_finger_1_joint_3")).put("stiction", 0.0);
        properties.put("r_palm_finger_2_joint", new HashMap());
        properties.put("r_finger_2_link_0", new HashMap());
        ((Map)properties.get("r_finger_2_link_0")).put("mass", 0.1);
        ((Map)properties.get("r_finger_2_link_0")).put("centerOfMass", new Vector3D(-6.326792890642185E-8, 0.009999996829116571, 7.963269158366412E-6));
        ((Map)properties.get("r_finger_2_link_0")).put("inertia", new Matrix3D(2.4999999999719796E-5, 4.4287536191429364E-11, 3.526736828820462E-14, 4.428753619142938E-11, 1.8000004439236095E-5, -5.574286643314611E-9, 3.526736828820462E-14, -5.574286643314611E-9, 2.4999995561044105E-5));
        ((Map)properties.get("r_palm_finger_2_joint")).put("offsetFromParentJoint", new Vector3D(-0.037790299999999985, -0.21040000000000003, -0.04550000000000004));
        ((Map)properties.get("r_palm_finger_2_joint")).put("positionLowerLimit", -0.2967);
        ((Map)properties.get("r_palm_finger_2_joint")).put("positionUpperLimit", 0.2967);
        ((Map)properties.get("r_palm_finger_2_joint")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_2_joint")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_2_joint")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_palm_finger_2_joint")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_palm_finger_2_joint")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_palm_finger_2_joint")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_palm_finger_2_joint")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_palm_finger_2_joint")).put("axis", new Vector3D(6.326267994014398E-6, -7.963267474941006E-4, 0.9999996829117945));
        ((Map)properties.get("r_palm_finger_2_joint")).put("damping", 1.0);
        ((Map)properties.get("r_palm_finger_2_joint")).put("stiction", 0.0);
        properties.put("r_finger_2_joint_1", new HashMap());
        properties.put("r_finger_2_link_1", new HashMap());
        ((Map)properties.get("r_finger_2_link_1")).put("mass", 0.047);
        ((Map)properties.get("r_finger_2_link_1")).put("centerOfMass", new Vector3D(8.027214656517109E-8, -0.028187647991534195, -0.015522451504157278));
        ((Map)properties.get("r_finger_2_link_1")).put("inertia", new Matrix3D(6.061920000684515E-5, -9.865434347538967E-10, -4.4562641161364085E-10, -9.865434347538967E-10, 2.0475715781825436E-5, -2.607757760944979E-5, -4.4562641161364085E-10, -2.607757760944979E-5, 4.88629042113294E-5));
        ((Map)properties.get("r_finger_2_joint_1")).put("offsetFromParentJoint", new Vector3D(0.0, -0.0, 0.0));
        ((Map)properties.get("r_finger_2_joint_1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("r_finger_2_joint_1")).put("positionUpperLimit", 1.2217);
        ((Map)properties.get("r_finger_2_joint_1")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_2_joint_1")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_2_joint_1")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_2_joint_1")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_2_joint_1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_2_joint_1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_2_joint_1")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_2_joint_1")).put("axis", new Vector3D(-0.9999999999576259, -6.692819999716398E-6, 6.320939999732156E-6));
        ((Map)properties.get("r_finger_2_joint_1")).put("damping", 1.0);
        ((Map)properties.get("r_finger_2_joint_1")).put("stiction", 0.0);
        properties.put("r_finger_2_joint_2", new HashMap());
        properties.put("r_finger_2_link_2", new HashMap());
        ((Map)properties.get("r_finger_2_link_2")).put("mass", 0.03284);
        ((Map)properties.get("r_finger_2_link_2")).put("centerOfMass", new Vector3D(-1.7987652690034674E-4, -0.019035900494228906, -0.01036599425086113));
        ((Map)properties.get("r_finger_2_link_2")).put("inertia", new Matrix3D(1.9863498513248567E-5, 1.1463076896000476E-7, 6.243026784582213E-8, 1.1463076896000474E-7, 8.46002507006287E-6, -8.362217309156877E-6, 6.243026784582213E-8, -8.362217309156874E-6, 1.7501256416688562E-5));
        ((Map)properties.get("r_finger_2_joint_2")).put("offsetFromParentJoint", new Vector3D(1.9999999998204655E-7, -0.04998000000000006, -0.028040000000000027));
        ((Map)properties.get("r_finger_2_joint_2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("r_finger_2_joint_2")).put("positionUpperLimit", 1.5708);
        ((Map)properties.get("r_finger_2_joint_2")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_2_joint_2")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_2_joint_2")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_2_joint_2")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_2_joint_2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_2_joint_2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_2_joint_2")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_2_joint_2")).put("axis", new Vector3D(-0.9999999999576259, -6.692819999716398E-6, 6.320939999732156E-6));
        ((Map)properties.get("r_finger_2_joint_2")).put("damping", 1.0);
        ((Map)properties.get("r_finger_2_joint_2")).put("stiction", 0.0);
        properties.put("r_finger_2_joint_3", new HashMap());
        properties.put("r_finger_2_link_3", new HashMap());
        ((Map)properties.get("r_finger_2_link_3")).put("mass", 0.03354);
        ((Map)properties.get("r_finger_2_link_3")).put("centerOfMass", new Vector3D(-1.9989402374137025E-4, -0.016260386310679293, 4.770528343337863E-4));
        ((Map)properties.get("r_finger_2_link_3")).put("inertia", new Matrix3D(1.2641300119070603E-5, 2.5354892902699895E-9, 1.1928078521684928E-8, 2.5354892902699895E-9, 3.0529472272684657E-6, -9.068601880703036E-7, 1.1928078521684928E-8, -9.068601880703036E-7, 1.4278362653660927E-5));
        ((Map)properties.get("r_finger_2_joint_3")).put("offsetFromParentJoint", new Vector3D(1.0000000000291364E-7, -0.033830000000000165, -0.01940499999999996));
        ((Map)properties.get("r_finger_2_joint_3")).put("positionLowerLimit", -0.6632);
        ((Map)properties.get("r_finger_2_joint_3")).put("positionUpperLimit", 1.0471);
        ((Map)properties.get("r_finger_2_joint_3")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_2_joint_3")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_2_joint_3")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_2_joint_3")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_2_joint_3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_2_joint_3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_2_joint_3")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_2_joint_3")).put("axis", new Vector3D(-0.9999999999576259, -6.692819999716398E-6, 6.320939999732156E-6));
        ((Map)properties.get("r_finger_2_joint_3")).put("damping", 1.0);
        ((Map)properties.get("r_finger_2_joint_3")).put("stiction", 0.0);
        properties.put("r_palm_finger_middle_joint", new HashMap());
        properties.put("r_finger_middle_link_0", new HashMap());
        ((Map)properties.get("r_finger_middle_link_0")).put("mass", 0.1);
        ((Map)properties.get("r_finger_middle_link_0")).put("centerOfMass", new Vector3D(3.673203938689571E-8, 0.00999999682924925, -7.963269158366412E-6));
        ((Map)properties.get("r_finger_middle_link_0")).put("inertia", new Matrix3D(2.4999999999905547E-5, -2.5712419418057083E-11, 2.0475498146155928E-14, -2.5712419418057083E-11, 1.800000443905034E-5, 5.574286643388574E-9, 2.0475498146143003E-14, 5.574286643388574E-9, 2.4999995561044105E-5));
        ((Map)properties.get("r_palm_finger_middle_joint")).put("offsetFromParentJoint", new Vector3D(-0.001789999999999986, -0.21040000000000003, 0.045499999999999985));
        ((Map)properties.get("r_palm_finger_middle_joint")).put("positionLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("positionUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("kpPositionLimit", 0.0);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("kdPositionLimit", 0.0);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("axis", new Vector3D(-6.327307993684585E-6, -7.963267474940952E-4, -0.9999996829117879));
        ((Map)properties.get("r_palm_finger_middle_joint")).put("damping", 1.0);
        ((Map)properties.get("r_palm_finger_middle_joint")).put("stiction", 0.0);
        properties.put("r_finger_middle_joint_1", new HashMap());
        properties.put("r_finger_middle_link_1", new HashMap());
        ((Map)properties.get("r_finger_middle_link_1")).put("mass", 0.047);
        ((Map)properties.get("r_finger_middle_link_1")).put("centerOfMass", new Vector3D(-4.6604333352145056E-8, -0.028187647991496718, 0.015522451504362931));
        ((Map)properties.get("r_finger_middle_link_1")).put("inertia", new Matrix3D(6.061920000397187E-5, 1.0239534311037176E-9, -4.836843339505656E-10, 1.0239534311037174E-9, 2.0475715787856707E-5, 2.607757761125996E-5, -4.836843339505654E-10, 2.607757761125996E-5, 4.8862904208171405E-5));
        ((Map)properties.get("r_finger_middle_joint_1")).put("offsetFromParentJoint", new Vector3D(0.0, -0.0, 0.0));
        ((Map)properties.get("r_finger_middle_joint_1")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("r_finger_middle_joint_1")).put("positionUpperLimit", 1.2217);
        ((Map)properties.get("r_finger_middle_joint_1")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_middle_joint_1")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_middle_joint_1")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_middle_joint_1")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_middle_joint_1")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_middle_joint_1")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_middle_joint_1")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_middle_joint_1")).put("axis", new Vector3D(0.9999999999797724, -6.535899999867794E-7, -6.326789999872025E-6));
        ((Map)properties.get("r_finger_middle_joint_1")).put("damping", 1.0);
        ((Map)properties.get("r_finger_middle_joint_1")).put("stiction", 0.0);
        properties.put("r_finger_middle_joint_2", new HashMap());
        properties.put("r_finger_middle_link_2", new HashMap());
        ((Map)properties.get("r_finger_middle_link_2")).put("mass", 0.03284);
        ((Map)properties.get("r_finger_middle_link_2")).put("centerOfMass", new Vector3D(1.801186730861277E-4, -0.01903589797895351, 0.010365994665177057));
        ((Map)properties.get("r_finger_middle_link_2")).put("inertia", new Matrix3D(1.986350142783164E-5, -1.144906655149054E-7, 6.231885210966547E-8, -1.144906655149054E-7, 8.460021868334035E-6, 8.362217917080904E-6, 6.231885210966547E-8, 8.3622179170809E-6, 1.750125670383432E-5));
        ((Map)properties.get("r_finger_middle_joint_2")).put("offsetFromParentJoint", new Vector3D(1.9906955091480766E-17, -0.04997999999999988, 0.02803999999999992));
        ((Map)properties.get("r_finger_middle_joint_2")).put("positionLowerLimit", 0.0);
        ((Map)properties.get("r_finger_middle_joint_2")).put("positionUpperLimit", 1.5708);
        ((Map)properties.get("r_finger_middle_joint_2")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_middle_joint_2")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_middle_joint_2")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_middle_joint_2")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_middle_joint_2")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_middle_joint_2")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_middle_joint_2")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_middle_joint_2")).put("axis", new Vector3D(0.9999999999797724, -6.535899999867794E-7, -6.326789999872025E-6));
        ((Map)properties.get("r_finger_middle_joint_2")).put("damping", 1.0);
        ((Map)properties.get("r_finger_middle_joint_2")).put("stiction", 0.0);
        properties.put("r_finger_middle_joint_3", new HashMap());
        properties.put("r_finger_middle_link_3", new HashMap());
        ((Map)properties.get("r_finger_middle_link_3")).put("mass", 0.03354);
        ((Map)properties.get("r_finger_middle_link_3")).put("centerOfMass", new Vector3D(1.999384723974703E-4, -0.01626038577976746, -4.7705230362249726E-4));
        ((Map)properties.get("r_finger_middle_link_3")).put("inertia", new Matrix3D(1.2641300069189865E-5, -2.512431907612802E-9, 1.192132607923154E-8, -2.5124319076128012E-9, 3.0529472138867517E-6, 9.068602131901544E-7, 1.1921326079231539E-8, 9.068602131901544E-7, 1.4278362716923379E-5));
        ((Map)properties.get("r_finger_middle_joint_3")).put("offsetFromParentJoint", new Vector3D(9.999999999810156E-7, -0.03383000000000006, 0.019405000000000044));
        ((Map)properties.get("r_finger_middle_joint_3")).put("positionLowerLimit", -0.6632);
        ((Map)properties.get("r_finger_middle_joint_3")).put("positionUpperLimit", 1.0471);
        ((Map)properties.get("r_finger_middle_joint_3")).put("velocityLowerLimit", Double.NEGATIVE_INFINITY);
        ((Map)properties.get("r_finger_middle_joint_3")).put("velocityUpperLimit", Double.POSITIVE_INFINITY);
        ((Map)properties.get("r_finger_middle_joint_3")).put("effortLowerLimit", -60.0);
        ((Map)properties.get("r_finger_middle_joint_3")).put("effortUpperLimit", 60.0);
        ((Map)properties.get("r_finger_middle_joint_3")).put("kpPositionLimit", 100.0);
        ((Map)properties.get("r_finger_middle_joint_3")).put("kdPositionLimit", 20.0);
        ((Map)properties.get("r_finger_middle_joint_3")).put("kpVelocityLimit", 0.0);
        ((Map)properties.get("r_finger_middle_joint_3")).put("axis", new Vector3D(0.9999999999797724, -6.535899999867794E-7, -6.326789999872025E-6));
        ((Map)properties.get("r_finger_middle_joint_3")).put("damping", 1.0);
        ((Map)properties.get("r_finger_middle_joint_3")).put("stiction", 0.0);
        properties.put(LeftHipYawName, new HashMap());
        properties.put(LeftHipYawLinkName, new HashMap());
        ((Map)properties.get(LeftHipYawLinkName)).put("mass", 1.959);
        ((Map)properties.get(LeftHipYawLinkName)).put("centerOfMass", new Vector3D(0.00529262, -0.00344732, 0.00313046));
        ((Map)properties.get(LeftHipYawLinkName)).put("inertia", new Matrix3D(7.4276E-4, -3.79607E-8, -2.79549E-5, -3.79607E-8, 6.88179E-4, -3.2735E-8, -2.79549E-5, -3.2735E-8, 4.1242E-4));
        ((Map)properties.get(LeftHipYawName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.089, 0.0));
        ((Map)properties.get(LeftHipYawName)).put("positionLowerLimit", -0.174358);
        ((Map)properties.get(LeftHipYawName)).put("positionUpperLimit", 0.786794);
        ((Map)properties.get(LeftHipYawName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftHipYawName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftHipYawName)).put("effortLowerLimit", -275.0);
        ((Map)properties.get(LeftHipYawName)).put("effortUpperLimit", 275.0);
        ((Map)properties.get(LeftHipYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftHipYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftHipYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftHipYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(LeftHipYawName)).put("damping", 0.1);
        ((Map)properties.get(LeftHipYawName)).put("stiction", 0.0);
        properties.put(LeftHipRollName, new HashMap());
        properties.put(LeftHipRollLinkName, new HashMap());
        ((Map)properties.get(LeftHipRollLinkName)).put("mass", 0.898);
        ((Map)properties.get(LeftHipRollLinkName)).put("centerOfMass", new Vector3D(0.0133341, 0.0170484, -0.0312052));
        ((Map)properties.get(LeftHipRollLinkName)).put("inertia", new Matrix3D(6.91326E-4, -2.24344E-5, 2.50508E-6, -2.24344E-5, 0.00126856, 1.37862E-4, 2.50508E-6, 1.37862E-4, 0.00106487));
        ((Map)properties.get(LeftHipRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(LeftHipRollName)).put("positionLowerLimit", -0.523599);
        ((Map)properties.get(LeftHipRollName)).put("positionUpperLimit", 0.523599);
        ((Map)properties.get(LeftHipRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftHipRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftHipRollName)).put("effortLowerLimit", -530.0);
        ((Map)properties.get(LeftHipRollName)).put("effortUpperLimit", 530.0);
        ((Map)properties.get(LeftHipRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftHipRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftHipRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftHipRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftHipRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftHipRollName)).put("stiction", 0.0);
        properties.put(LeftHipPitchName, new HashMap());
        properties.put(LeftHipPitchLinkName, new HashMap());
        ((Map)properties.get(LeftHipPitchLinkName)).put("mass", 8.204);
        ((Map)properties.get(LeftHipPitchLinkName)).put("centerOfMass", new Vector3D(0.0, 0.0, -0.21));
        ((Map)properties.get(LeftHipPitchLinkName)).put("inertia", new Matrix3D(0.09, 0.0, 0.0, 0.0, 0.09, 0.0, 0.0, 0.0, 0.02));
        ((Map)properties.get(LeftHipPitchName)).put("offsetFromParentJoint", new Vector3D(0.05, 0.022500000000000006, -0.066));
        ((Map)properties.get(LeftHipPitchName)).put("positionLowerLimit", -1.61234);
        ((Map)properties.get(LeftHipPitchName)).put("positionUpperLimit", 0.65764);
        ((Map)properties.get(LeftHipPitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftHipPitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftHipPitchName)).put("effortLowerLimit", -840.0);
        ((Map)properties.get(LeftHipPitchName)).put("effortUpperLimit", 840.0);
        ((Map)properties.get(LeftHipPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftHipPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftHipPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftHipPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftHipPitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftHipPitchName)).put("stiction", 0.0);
        properties.put(LeftKneePitchName, new HashMap());
        properties.put(LeftKneePitchLinkName, new HashMap());
        ((Map)properties.get(LeftKneePitchLinkName)).put("mass", 4.515);
        ((Map)properties.get(LeftKneePitchLinkName)).put("centerOfMass", new Vector3D(0.001, 0.0, -0.187));
        ((Map)properties.get(LeftKneePitchLinkName)).put("inertia", new Matrix3D(0.077, 0.0, -0.003, 0.0, 0.076, 0.0, -0.003, 0.0, 0.01));
        ((Map)properties.get(LeftKneePitchName)).put("offsetFromParentJoint", new Vector3D(-0.05, 0.0, -0.374));
        ((Map)properties.get(LeftKneePitchName)).put("positionLowerLimit", 0.0);
        ((Map)properties.get(LeftKneePitchName)).put("positionUpperLimit", 2.35637);
        ((Map)properties.get(LeftKneePitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftKneePitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftKneePitchName)).put("effortLowerLimit", -890.0);
        ((Map)properties.get(LeftKneePitchName)).put("effortUpperLimit", 890.0);
        ((Map)properties.get(LeftKneePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftKneePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftKneePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftKneePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftKneePitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftKneePitchName)).put("stiction", 0.0);
        properties.put(LeftAnklePitchName, new HashMap());
        properties.put(LeftAnklePitchLinkName, new HashMap());
        ((Map)properties.get(LeftAnklePitchLinkName)).put("mass", 0.125);
        ((Map)properties.get(LeftAnklePitchLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(LeftAnklePitchLinkName)).put("inertia", new Matrix3D(1.01674E-5, 0.0, 0.0, 0.0, 8.42775E-6, 0.0, 0.0, 0.0, 1.30101E-5));
        ((Map)properties.get(LeftAnklePitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, -0.422));
        ((Map)properties.get(LeftAnklePitchName)).put("positionLowerLimit", -1.0);
        ((Map)properties.get(LeftAnklePitchName)).put("positionUpperLimit", 0.7);
        ((Map)properties.get(LeftAnklePitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftAnklePitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftAnklePitchName)).put("effortLowerLimit", -740.0);
        ((Map)properties.get(LeftAnklePitchName)).put("effortUpperLimit", 740.0);
        ((Map)properties.get(LeftAnklePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftAnklePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftAnklePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftAnklePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(LeftAnklePitchName)).put("damping", 0.1);
        ((Map)properties.get(LeftAnklePitchName)).put("stiction", 0.0);
        properties.put(LeftAnkleRollName, new HashMap());
        properties.put(LeftFootName, new HashMap());
        ((Map)properties.get(LeftFootName)).put("mass", 2.41);
        ((Map)properties.get(LeftFootName)).put("centerOfMass", new Vector3D(0.027, 0.0, -0.067));
        ((Map)properties.get(LeftFootName)).put("inertia", new Matrix3D(0.002, 0.0, 0.0, 0.0, 0.007, 0.0, 0.0, 0.0, 0.008));
        ((Map)properties.get(LeftAnkleRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(LeftAnkleRollName)).put("positionLowerLimit", -0.8);
        ((Map)properties.get(LeftAnkleRollName)).put("positionUpperLimit", 0.8);
        ((Map)properties.get(LeftAnkleRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(LeftAnkleRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(LeftAnkleRollName)).put("effortLowerLimit", -360.0);
        ((Map)properties.get(LeftAnkleRollName)).put("effortUpperLimit", 360.0);
        ((Map)properties.get(LeftAnkleRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(LeftAnkleRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(LeftAnkleRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(LeftAnkleRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(LeftAnkleRollName)).put("damping", 0.1);
        ((Map)properties.get(LeftAnkleRollName)).put("stiction", 0.0);
        properties.put(RightHipYawName, new HashMap());
        properties.put(RightHipYawLinkName, new HashMap());
        ((Map)properties.get(RightHipYawLinkName)).put("mass", 1.959);
        ((Map)properties.get(RightHipYawLinkName)).put("centerOfMass", new Vector3D(0.00529262, 0.00344732, 0.00313046));
        ((Map)properties.get(RightHipYawLinkName)).put("inertia", new Matrix3D(7.4276E-4, 3.79607E-8, -2.79549E-5, 3.79607E-8, 6.88179E-4, 3.2735E-8, -2.79549E-5, 3.2735E-8, 4.1242E-4));
        ((Map)properties.get(RightHipYawName)).put("offsetFromParentJoint", new Vector3D(0.0, -0.089, 0.0));
        ((Map)properties.get(RightHipYawName)).put("positionLowerLimit", -0.786794);
        ((Map)properties.get(RightHipYawName)).put("positionUpperLimit", 0.174358);
        ((Map)properties.get(RightHipYawName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightHipYawName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightHipYawName)).put("effortLowerLimit", -275.0);
        ((Map)properties.get(RightHipYawName)).put("effortUpperLimit", 275.0);
        ((Map)properties.get(RightHipYawName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightHipYawName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightHipYawName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightHipYawName)).put("axis", new Vector3D(0.0, 0.0, 1.0));
        ((Map)properties.get(RightHipYawName)).put("damping", 0.1);
        ((Map)properties.get(RightHipYawName)).put("stiction", 0.0);
        properties.put(RightHipRollName, new HashMap());
        properties.put(RightHipRollLinkName, new HashMap());
        ((Map)properties.get(RightHipRollLinkName)).put("mass", 0.898);
        ((Map)properties.get(RightHipRollLinkName)).put("centerOfMass", new Vector3D(0.0133341, -0.0170484, -0.0312052));
        ((Map)properties.get(RightHipRollLinkName)).put("inertia", new Matrix3D(6.91326E-4, 2.24344E-5, 2.50508E-6, 2.24344E-5, 0.00126856, -1.37862E-4, 2.50508E-6, -1.37862E-4, 0.00106487));
        ((Map)properties.get(RightHipRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(RightHipRollName)).put("positionLowerLimit", -0.523599);
        ((Map)properties.get(RightHipRollName)).put("positionUpperLimit", 0.523599);
        ((Map)properties.get(RightHipRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightHipRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightHipRollName)).put("effortLowerLimit", -530.0);
        ((Map)properties.get(RightHipRollName)).put("effortUpperLimit", 530.0);
        ((Map)properties.get(RightHipRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightHipRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightHipRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightHipRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightHipRollName)).put("damping", 0.1);
        ((Map)properties.get(RightHipRollName)).put("stiction", 0.0);
        properties.put(RightHipPitchName, new HashMap());
        properties.put(RightHipPitchLinkName, new HashMap());
        ((Map)properties.get(RightHipPitchLinkName)).put("mass", 8.204);
        ((Map)properties.get(RightHipPitchLinkName)).put("centerOfMass", new Vector3D(0.0, 0.0, -0.21));
        ((Map)properties.get(RightHipPitchLinkName)).put("inertia", new Matrix3D(0.09, 0.0, 0.0, 0.0, 0.09, 0.0, 0.0, 0.0, 0.02));
        ((Map)properties.get(RightHipPitchName)).put("offsetFromParentJoint", new Vector3D(0.05, -0.022500000000000006, -0.066));
        ((Map)properties.get(RightHipPitchName)).put("positionLowerLimit", -1.61234);
        ((Map)properties.get(RightHipPitchName)).put("positionUpperLimit", 0.65764);
        ((Map)properties.get(RightHipPitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightHipPitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightHipPitchName)).put("effortLowerLimit", -840.0);
        ((Map)properties.get(RightHipPitchName)).put("effortUpperLimit", 840.0);
        ((Map)properties.get(RightHipPitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightHipPitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightHipPitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightHipPitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightHipPitchName)).put("damping", 0.1);
        ((Map)properties.get(RightHipPitchName)).put("stiction", 0.0);
        properties.put(RightKneePitchName, new HashMap());
        properties.put(RightKneePitchLinkName, new HashMap());
        ((Map)properties.get(RightKneePitchLinkName)).put("mass", 4.515);
        ((Map)properties.get(RightKneePitchLinkName)).put("centerOfMass", new Vector3D(0.001, 0.0, -0.187));
        ((Map)properties.get(RightKneePitchLinkName)).put("inertia", new Matrix3D(0.077, -0.0, -0.003, -0.0, 0.076, -0.0, -0.003, -0.0, 0.01));
        ((Map)properties.get(RightKneePitchName)).put("offsetFromParentJoint", new Vector3D(-0.05, 0.0, -0.374));
        ((Map)properties.get(RightKneePitchName)).put("positionLowerLimit", 0.0);
        ((Map)properties.get(RightKneePitchName)).put("positionUpperLimit", 2.35637);
        ((Map)properties.get(RightKneePitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightKneePitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightKneePitchName)).put("effortLowerLimit", -890.0);
        ((Map)properties.get(RightKneePitchName)).put("effortUpperLimit", 890.0);
        ((Map)properties.get(RightKneePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightKneePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightKneePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightKneePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightKneePitchName)).put("damping", 0.1);
        ((Map)properties.get(RightKneePitchName)).put("stiction", 0.0);
        properties.put(RightAnklePitchName, new HashMap());
        properties.put(RightAnklePitchLinkName, new HashMap());
        ((Map)properties.get(RightAnklePitchLinkName)).put("mass", 0.125);
        ((Map)properties.get(RightAnklePitchLinkName)).put("centerOfMass", new Vector3D(-0.0, -0.0, -0.0));
        ((Map)properties.get(RightAnklePitchLinkName)).put("inertia", new Matrix3D(1.01674E-5, 0.0, 0.0, 0.0, 8.42775E-6, 0.0, 0.0, 0.0, 1.30101E-5));
        ((Map)properties.get(RightAnklePitchName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, -0.422));
        ((Map)properties.get(RightAnklePitchName)).put("positionLowerLimit", -1.0);
        ((Map)properties.get(RightAnklePitchName)).put("positionUpperLimit", 0.7);
        ((Map)properties.get(RightAnklePitchName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightAnklePitchName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightAnklePitchName)).put("effortLowerLimit", -740.0);
        ((Map)properties.get(RightAnklePitchName)).put("effortUpperLimit", 740.0);
        ((Map)properties.get(RightAnklePitchName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightAnklePitchName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightAnklePitchName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightAnklePitchName)).put("axis", new Vector3D(0.0, 1.0, 0.0));
        ((Map)properties.get(RightAnklePitchName)).put("damping", 0.1);
        ((Map)properties.get(RightAnklePitchName)).put("stiction", 0.0);
        properties.put(RightAnkleRollName, new HashMap());
        properties.put(RightFootName, new HashMap());
        ((Map)properties.get(RightFootName)).put("mass", 2.41);
        ((Map)properties.get(RightFootName)).put("centerOfMass", new Vector3D(0.027, 0.0, -0.067));
        ((Map)properties.get(RightFootName)).put("inertia", new Matrix3D(0.002, 0.0, 0.0, 0.0, 0.007, 0.0, 0.0, 0.0, 0.008));
        ((Map)properties.get(RightAnkleRollName)).put("offsetFromParentJoint", new Vector3D(0.0, 0.0, 0.0));
        ((Map)properties.get(RightAnkleRollName)).put("positionLowerLimit", -0.8);
        ((Map)properties.get(RightAnkleRollName)).put("positionUpperLimit", 0.8);
        ((Map)properties.get(RightAnkleRollName)).put("velocityLowerLimit", -12.0);
        ((Map)properties.get(RightAnkleRollName)).put("velocityUpperLimit", 12.0);
        ((Map)properties.get(RightAnkleRollName)).put("effortLowerLimit", -360.0);
        ((Map)properties.get(RightAnkleRollName)).put("effortUpperLimit", 360.0);
        ((Map)properties.get(RightAnkleRollName)).put("kpPositionLimit", 100.0);
        ((Map)properties.get(RightAnkleRollName)).put("kdPositionLimit", 20.0);
        ((Map)properties.get(RightAnkleRollName)).put("kpVelocityLimit", 500.0);
        ((Map)properties.get(RightAnkleRollName)).put("axis", new Vector3D(1.0, 0.0, 0.0));
        ((Map)properties.get(RightAnkleRollName)).put("damping", 0.1);
        ((Map)properties.get(RightAnkleRollName)).put("stiction", 0.0);
        return properties;
    }

    public static Map<String, Map<String, Object>> atlasSensorProperties() {
        HashMap<String, Map<String, Object>> sensorProperties = new HashMap<String, Map<String, Object>>();
        sensorProperties.put("pelvis_imu_sensor_at_pelvis_frame", new HashMap());
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("transformToJoint", new RigidBodyTransform(1.0, 0.0, 0.0, -0.0905, 0.0, 1.0, 0.0, -0.04, 0.0, 0.0, 1.0, -0.0125));
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("accelerationNoiseMean", 0.0);
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("accelerationNoiseStandardDeviation", 0.017);
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("accelerationBiasMean", 0.1);
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("accelerationBiasStandardDeviation", 0.001);
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("angularVelocityNoiseMean", 7.5E-6);
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("angularVelocityNoiseStandardDeviation", 8.0E-7);
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("angularVelocityBiasMean", 0.0);
        ((Map)sensorProperties.get("pelvis_imu_sensor_at_pelvis_frame")).put("angularVelocityBiasStandardDeviation", 0.0);
        sensorProperties.put("l_situational_awareness_camera_sensor_l_situational_awareness_camera", new HashMap());
        ((Map)sensorProperties.get("l_situational_awareness_camera_sensor_l_situational_awareness_camera")).put("transformToJoint", new RigidBodyTransform(0.2588160883982461, -0.9659266185307408, 0.0, 0.155, 0.9659266185307408, 0.2588160883982461, -0.0, 0.121, 0.0, 0.0, 1.0, 0.785));
        ((Map)sensorProperties.get("l_situational_awareness_camera_sensor_l_situational_awareness_camera")).put("fieldOfView", 2.0);
        ((Map)sensorProperties.get("l_situational_awareness_camera_sensor_l_situational_awareness_camera")).put("clipNear", 0.02);
        ((Map)sensorProperties.get("l_situational_awareness_camera_sensor_l_situational_awareness_camera")).put("clipFar", 300.0);
        ((Map)sensorProperties.get("l_situational_awareness_camera_sensor_l_situational_awareness_camera")).put("imageWidth", 1280);
        ((Map)sensorProperties.get("l_situational_awareness_camera_sensor_l_situational_awareness_camera")).put("imageHeight", 1024);
        sensorProperties.put("r_situational_awareness_camera_sensor_r_situational_awareness_camera", new HashMap());
        ((Map)sensorProperties.get("r_situational_awareness_camera_sensor_r_situational_awareness_camera")).put("transformToJoint", new RigidBodyTransform(0.2588160883982461, 0.9659266185307408, 0.0, 0.155, -0.9659266185307408, 0.2588160883982461, -0.0, -0.121, -0.0, 0.0, 1.0, 0.785));
        ((Map)sensorProperties.get("r_situational_awareness_camera_sensor_r_situational_awareness_camera")).put("fieldOfView", 2.0);
        ((Map)sensorProperties.get("r_situational_awareness_camera_sensor_r_situational_awareness_camera")).put("clipNear", 0.02);
        ((Map)sensorProperties.get("r_situational_awareness_camera_sensor_r_situational_awareness_camera")).put("clipFar", 300.0);
        ((Map)sensorProperties.get("r_situational_awareness_camera_sensor_r_situational_awareness_camera")).put("imageWidth", 1280);
        ((Map)sensorProperties.get("r_situational_awareness_camera_sensor_r_situational_awareness_camera")).put("imageHeight", 1024);
        sensorProperties.put("stereo_camera_left", new HashMap());
        ((Map)sensorProperties.get("stereo_camera_left")).put("transformToJoint", new RigidBodyTransform(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.035, 0.0, 0.0, 1.0, -0.002));
        ((Map)sensorProperties.get("stereo_camera_left")).put("fieldOfView", 1.39626);
        ((Map)sensorProperties.get("stereo_camera_left")).put("clipNear", 0.02);
        ((Map)sensorProperties.get("stereo_camera_left")).put("clipFar", 300.0);
        ((Map)sensorProperties.get("stereo_camera_left")).put("imageWidth", 1024);
        ((Map)sensorProperties.get("stereo_camera_left")).put("imageHeight", 544);
        sensorProperties.put("stereo_camera_right", new HashMap());
        ((Map)sensorProperties.get("stereo_camera_right")).put("transformToJoint", new RigidBodyTransform(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -0.035, 0.0, 0.0, 1.0, -0.002));
        ((Map)sensorProperties.get("stereo_camera_right")).put("fieldOfView", 1.39626);
        ((Map)sensorProperties.get("stereo_camera_right")).put("clipNear", 0.02);
        ((Map)sensorProperties.get("stereo_camera_right")).put("clipFar", 300.0);
        ((Map)sensorProperties.get("stereo_camera_right")).put("imageWidth", 1024);
        ((Map)sensorProperties.get("stereo_camera_right")).put("imageHeight", 544);
        sensorProperties.put("head_head_imu_sensor", new HashMap());
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("transformToJoint", new RigidBodyTransform(1.0, 0.0, 0.0, -0.0475, 0.0, 1.0, 0.0, 0.035, 0.0, 0.0, 1.0, 0.0));
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("accelerationNoiseMean", 0.0);
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("accelerationNoiseStandardDeviation", 0.017);
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("accelerationBiasMean", 0.1);
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("accelerationBiasStandardDeviation", 0.001);
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("angularVelocityNoiseMean", 7.5E-6);
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("angularVelocityNoiseStandardDeviation", 8.0E-7);
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("angularVelocityBiasMean", 0.0);
        ((Map)sensorProperties.get("head_head_imu_sensor")).put("angularVelocityBiasStandardDeviation", 0.0);
        sensorProperties.put("head_hokuyo_sensor", new HashMap());
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("transformToJoint", new RigidBodyTransform(1.0, 0.0, 0.0, 0.03, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.015));
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("sweepYawMin", -1.5708);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("sweepYawMax", 1.5708);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("heightPitchMin", 0.0);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("heightPitchMax", 0.0);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("minRange", 0.1);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("maxRange", 30.0);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("pointsPerSweep", 720);
        ((Map)sensorProperties.get("head_hokuyo_sensor")).put("scanHeight", 1);
        return sensorProperties;
    }
}

