/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.scs2.definition.DefinitionRandomTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;

public class ColorDefinitionTest {
    private static final double EPSILON = 1.0E-9;
    private static final double LARGE_EPSILON = 0.00392156862745098;
    private static final int ITERATIONS = 10000;

    @Test
    public void testArrayConversion() {
        Random random = new Random(304985L);
        for (int i = 0; i < 10000; ++i) {
            int redInt = random.nextInt(256);
            int greenInt = random.nextInt(256);
            int blueInt = random.nextInt(256);
            int alphaInt = random.nextInt(256);
            double red = (double)redInt / 255.0;
            double green = (double)greenInt / 255.0;
            double blue = (double)blueInt / 255.0;
            double alpha = (double)alphaInt / 255.0;
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, 1.0, ColorDefinition.rgb((double[])new double[]{red, green, blue}), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, ColorDefinition.rgba((double[])new double[]{red, green, blue, alpha}), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, 1.0, ColorDefinition.rgb((int[])new int[]{redInt, greenInt, blueInt}), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, ColorDefinition.rgba((int[])new int[]{redInt, greenInt, blueInt, alphaInt}), 1.0E-9);
            ColorDefinitionTest.assertRGBEquals(red, green, blue, new ColorDefinition(red, green, blue).toRGBDoubleArray(), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, new ColorDefinition(red, green, blue, alpha).toRGBADoubleArray(), 1.0E-9);
            ColorDefinitionTest.assertRGBEquals(redInt, greenInt, blueInt, new ColorDefinition(redInt, greenInt, blueInt).toRGBIntArray());
            ColorDefinitionTest.assertRGBAEquals(redInt, greenInt, blueInt, alphaInt, new ColorDefinition(redInt, greenInt, blueInt, alphaInt).toRGBAIntArray());
        }
    }

    @Test
    public void testConvesions() {
        Random random = new Random();
        ColorDefinition expectedColor = new ColorDefinition();
        for (int i = 0; i < 10000; ++i) {
            expectedColor = ColorDefinitions.argb((int)random.nextInt());
            int rInt = expectedColor.getRedAsInteger();
            int gInt = expectedColor.getGreenAsInteger();
            int bInt = expectedColor.getBlueAsInteger();
            int aInt = expectedColor.getAlphaAsInteger();
            double rDouble = expectedColor.getRed();
            double gDouble = expectedColor.getGreen();
            double bDouble = expectedColor.getBlue();
            double aDouble = expectedColor.getAlpha();
            int argb = ColorDefinitions.toARGB((int)rInt, (int)gInt, (int)bInt, (int)aInt);
            ColorDefinition actualColor = ColorDefinitions.argb((int)argb);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            argb = ColorDefinitions.toARGB((double)rDouble, (double)gDouble, (double)bDouble, (double)aDouble);
            actualColor = ColorDefinitions.argb((int)argb);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            int rgb = ColorDefinitions.toRGB((int)rInt, (int)gInt, (int)bInt);
            actualColor = ColorDefinitions.rgb((int)rgb);
            actualColor.setAlpha(aInt);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            rgb = ColorDefinitions.toRGB((double)rDouble, (double)gDouble, (double)bDouble);
            actualColor = ColorDefinitions.rgb((int)rgb);
            actualColor.setAlpha(aInt);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            int rgba = ColorDefinitions.toRGBA((int)rInt, (int)gInt, (int)bInt, (int)aInt);
            actualColor = ColorDefinitions.rgba((int)rgba);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            rgba = ColorDefinitions.toRGBA((double)rDouble, (double)gDouble, (double)bDouble, (double)aDouble);
            actualColor = ColorDefinitions.rgba((int)rgba);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            double[] hsba = expectedColor.toHSBADoubleArray();
            argb = ColorDefinitions.hsbaToARGB((double)hsba[0], (double)hsba[1], (double)hsba[2], (double)hsba[3]);
            actualColor = ColorDefinitions.argb((int)argb);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            rgba = ColorDefinitions.hsbaToRGBA((double)hsba[0], (double)hsba[1], (double)hsba[2], (double)hsba[3]);
            actualColor = ColorDefinitions.rgba((int)rgba);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            double[] hsla = expectedColor.toHSLADoubleArray();
            argb = ColorDefinitions.hslaToARGB((double)hsla[0], (double)hsla[1], (double)hsla[2], (double)hsla[3]);
            actualColor = ColorDefinitions.argb((int)argb);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
            rgba = ColorDefinitions.hslaToRGBA((double)hsla[0], (double)hsla[1], (double)hsla[2], (double)hsla[3]);
            actualColor = ColorDefinitions.rgba((int)rgba);
            Assertions.assertEquals((Object)expectedColor, (Object)actualColor);
        }
    }

    @Test
    public void testHexConversion() {
        int i;
        Random random = new Random(4752L);
        for (i = 0; i < 256; ++i) {
            ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, (double)i / 255.0, 1.0, ColorDefinition.rgb((int)i), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(0.0, (double)i / 255.0, 0.0, 1.0, ColorDefinition.rgb((int)(i << 8)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals((double)i / 255.0, 0.0, 0.0, 1.0, ColorDefinition.rgb((int)(i << 16)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, (double)i / 255.0, 0.0, ColorDefinition.argb((int)i), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(0.0, (double)i / 255.0, 0.0, 0.0, ColorDefinition.argb((int)(i << 8)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals((double)i / 255.0, 0.0, 0.0, 0.0, ColorDefinition.argb((int)(i << 16)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, (double)i / 255.0, ColorDefinition.argb((int)(i << 24)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, (double)i / 255.0, 0.0, ColorDefinition.rgba((int)(i << 8)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(0.0, (double)i / 255.0, 0.0, 0.0, ColorDefinition.rgba((int)(i << 16)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals((double)i / 255.0, 0.0, 0.0, 0.0, ColorDefinition.rgba((int)(i << 24)), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, (double)i / 255.0, ColorDefinition.rgba((int)i), 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            double red = (double)random.nextInt(256) / 255.0;
            double green = (double)random.nextInt(256) / 255.0;
            double blue = (double)random.nextInt(256) / 255.0;
            double alpha = 1.0;
            ColorDefinition color = ColorDefinition.rgb((int)new ColorDefinition(red, green, blue).toRGB());
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, color, 1.0E-9);
            alpha = (double)random.nextInt(256) / 255.0;
            color = ColorDefinition.argb((int)new ColorDefinition(red, green, blue, alpha).toARGB());
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, color, 1.0E-9);
            color = ColorDefinition.rgba((int)new ColorDefinition(red, green, blue, alpha).toRGBA());
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, color, 1.0E-9);
        }
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, 1.0, ColorDefinition.rgb((int)0), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(1.0, 0.0, 0.0, 1.0, ColorDefinition.rgb((int)0xFF0000), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 1.0, 0.0, 1.0, ColorDefinition.rgb((int)65280), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 1.0, 1.0, ColorDefinition.rgb((int)255), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(1.0, 1.0, 1.0, 1.0, ColorDefinition.rgb((int)0xFFFFFF), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.00392156862745098, 0.0, 0.0, 1.0, ColorDefinition.rgb((int)65536), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.00392156862745098, 0.0, 1.0, ColorDefinition.rgb((int)256), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.00392156862745098, 1.0, ColorDefinition.rgb((int)1), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, 0.0, ColorDefinition.argb((int)0), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, 1.0, ColorDefinition.argb((int)-16777216), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(1.0, 0.0, 0.0, 0.0, ColorDefinition.argb((int)0xFF0000), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 1.0, 0.0, 0.0, ColorDefinition.argb((int)65280), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 1.0, 0.0, ColorDefinition.argb((int)255), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(1.0, 1.0, 1.0, 1.0, ColorDefinition.argb((int)-1), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.00392156862745098, 0.0, 0.0, 0.0, ColorDefinition.argb((int)65536), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.00392156862745098, 0.0, 0.0, ColorDefinition.argb((int)256), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.00392156862745098, 0.0, ColorDefinition.argb((int)1), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, 0.00392156862745098, ColorDefinition.argb((int)0x1000000), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, 0.0, ColorDefinition.rgba((int)0), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(1.0, 0.0, 0.0, 0.0, ColorDefinition.rgba((int)-16777216), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 1.0, 0.0, 0.0, ColorDefinition.rgba((int)0xFF0000), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 1.0, 0.0, ColorDefinition.rgba((int)65280), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, 1.0, ColorDefinition.rgba((int)255), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(1.0, 1.0, 1.0, 1.0, ColorDefinition.rgba((int)-1), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.00392156862745098, 0.0, 0.0, 0.0, ColorDefinition.rgba((int)0x1000000), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.00392156862745098, 0.0, 0.0, ColorDefinition.rgba((int)65536), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.00392156862745098, 0.0, ColorDefinition.rgba((int)256), 1.0E-9);
        ColorDefinitionTest.assertRGBAEquals(0.0, 0.0, 0.0, 0.00392156862745098, ColorDefinition.rgba((int)1), 1.0E-9);
    }

    @Test
    public void testHSBConversion() {
        ColorDefinition color;
        double expectedBrightness;
        double blue;
        double green;
        double red;
        ColorDefinition color2;
        double brightness;
        double saturation;
        double hue;
        int i;
        Random random = new Random(23545L);
        for (i = 0; i < 10000; ++i) {
            hue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)360.0);
            saturation = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            brightness = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            ColorDefinition color3 = ColorDefinition.hsb((double)hue, (double)saturation, (double)brightness);
            ColorDefinitionTest.assertHSBAEquals(hue, saturation, brightness, 1.0, color3, 1.0E-9);
            double[] hsb = color3.toHSBDoubleArray();
            ColorDefinitionTest.assertHSBEquals(hue, saturation, brightness, hsb, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            hue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)360.0);
            saturation = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            brightness = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            color2 = ColorDefinition.hsba((double)hue, (double)saturation, (double)brightness, (double)alpha);
            ColorDefinitionTest.assertHSBAEquals(hue, saturation, brightness, alpha, color2, 1.0E-9);
            double[] hsba = color2.toHSBADoubleArray();
            ColorDefinitionTest.assertHSBAEquals(hue, saturation, brightness, alpha, hsba, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            green = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            blue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alpha = 1.0;
            color2 = ColorDefinition.hsb((double[])new ColorDefinition(red, green, blue).toHSBDoubleArray());
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, color2, 1.0E-9);
            alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            color2 = ColorDefinition.hsba((double[])new ColorDefinition(red, green, blue, alpha).toHSBADoubleArray());
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, color2, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = (double)i / 9999.0;
            green = 0.0;
            blue = 0.0;
            double expectedHue = 0.0;
            double expectedSaturation = red == 0.0 ? 0.0 : 1.0;
            expectedBrightness = red;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, color, 1.0E-9);
            green = 1.0;
            blue = 1.0;
            expectedHue = red == 1.0 ? 0.0 : 180.0;
            expectedSaturation = 1.0 - red;
            expectedBrightness = 1.0;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, color, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = 0.0;
            green = (double)i / 9999.0;
            blue = 0.0;
            double expectedHue = green == 0.0 ? 0.0 : 120.0;
            double expectedSaturation = green == 0.0 ? 0.0 : 1.0;
            expectedBrightness = green;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, color, 1.0E-9);
            red = 1.0;
            blue = 1.0;
            expectedHue = green == 1.0 ? 0.0 : 300.0;
            expectedSaturation = 1.0 - green;
            expectedBrightness = 1.0;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, color, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = 0.0;
            green = 0.0;
            blue = (double)i / 9999.0;
            double expectedHue = blue == 0.0 ? 0.0 : 240.0;
            double expectedSaturation = blue == 0.0 ? 0.0 : 1.0;
            expectedBrightness = blue;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, color, 1.0E-9);
            red = 1.0;
            green = 1.0;
            expectedHue = blue == 1.0 ? 0.0 : 60.0;
            expectedSaturation = 1.0 - blue;
            expectedBrightness = 1.0;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, color, 1.0E-9);
        }
    }

    @Test
    public void testHSLConversion() {
        ColorDefinition color;
        double expectedLightness;
        double blue;
        double green;
        double red;
        ColorDefinition color2;
        double lightness;
        double saturation;
        double hue;
        int i;
        Random random = new Random(23545L);
        for (i = 0; i < 10000; ++i) {
            hue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)360.0);
            saturation = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            lightness = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            ColorDefinition color3 = ColorDefinition.hsl((double)hue, (double)saturation, (double)lightness);
            ColorDefinitionTest.assertHSLAEquals(hue, saturation, lightness, 1.0, color3, 1.0E-9);
            ColorDefinitionTest.assertHSLEquals(hue, saturation, lightness, color3, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            hue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)360.0);
            saturation = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            lightness = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            color2 = ColorDefinition.hsla((double)hue, (double)saturation, (double)lightness, (double)alpha);
            ColorDefinitionTest.assertHSLAEquals(hue, saturation, lightness, alpha, color2, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            green = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            blue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alpha = 1.0;
            color2 = ColorDefinition.hsl((double[])new ColorDefinition(red, green, blue).toHSLDoubleArray());
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, color2, 1.0E-9);
            alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            color2 = ColorDefinition.hsla((double[])new ColorDefinition(red, green, blue, alpha).toHSLADoubleArray());
            ColorDefinitionTest.assertRGBAEquals(red, green, blue, alpha, color2, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = (double)i / 9999.0;
            green = 0.0;
            blue = 0.0;
            double expectedHue = 0.0;
            double expectedSaturation = red == 0.0 ? 0.0 : 1.0;
            expectedLightness = 0.5 * red;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, color, 1.0E-9);
            green = 1.0;
            blue = 1.0;
            expectedHue = red == 1.0 ? 0.0 : 180.0;
            expectedSaturation = red == 1.0 ? 0.0 : 1.0;
            expectedLightness = 0.5 * (1.0 + red);
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, color, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = 0.0;
            green = (double)i / 9999.0;
            blue = 0.0;
            double expectedHue = green == 0.0 ? 0.0 : 120.0;
            double expectedSaturation = green == 0.0 ? 0.0 : 1.0;
            expectedLightness = 0.5 * green;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, color, 1.0E-9);
            red = 1.0;
            blue = 1.0;
            expectedHue = green == 1.0 ? 0.0 : 300.0;
            expectedSaturation = green == 1.0 ? 0.0 : 1.0;
            expectedLightness = 0.5 * (1.0 + green);
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, color, 1.0E-9);
        }
        for (i = 0; i < 10000; ++i) {
            red = 0.0;
            green = 0.0;
            blue = (double)i / 9999.0;
            double expectedHue = blue == 0.0 ? 0.0 : 240.0;
            double expectedSaturation = blue == 0.0 ? 0.0 : 1.0;
            expectedLightness = 0.5 * blue;
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, color, 1.0E-9);
            red = 1.0;
            green = 1.0;
            expectedHue = blue == 1.0 ? 0.0 : 60.0;
            expectedSaturation = blue == 1.0 ? 0.0 : 1.0;
            expectedLightness = 0.5 * (1.0 + blue);
            color = new ColorDefinition(red, green, blue);
            ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, color, 1.0E-9);
        }
    }

    @Test
    public void testBasicColors() {
        ColorDefinitionTest.assertRGBEquals(1.0, 1.0, 1.0, ColorDefinitions.White(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(0.0, 0.0, 1.0, ColorDefinitions.White(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(0.0, 0.0, 1.0, ColorDefinitions.White(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.75, 0.75, 0.75, ColorDefinitions.Silver(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(0.0, 0.0, 0.75, ColorDefinitions.Silver(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(0.0, 0.0, 0.75, ColorDefinitions.Silver(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.5, 0.5, 0.5, ColorDefinitions.Gray(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(0.0, 0.0, 0.5, ColorDefinitions.Gray(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(0.0, 0.0, 0.5, ColorDefinitions.Gray(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 0.0, 0.0, ColorDefinitions.Black(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(0.0, 0.0, 0.0, ColorDefinitions.Black(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(0.0, 0.0, 0.0, ColorDefinitions.Black(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(1.0, 0.0, 0.0, ColorDefinitions.Red(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(0.0, 1.0, 0.5, ColorDefinitions.Red(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(0.0, 1.0, 1.0, ColorDefinitions.Red(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.5, 0.0, 0.0, ColorDefinitions.Maroon(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(0.0, 1.0, 0.25, ColorDefinitions.Maroon(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(0.0, 1.0, 0.5, ColorDefinitions.Maroon(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(1.0, 1.0, 0.0, ColorDefinitions.Yellow(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(60.0, 1.0, 0.5, ColorDefinitions.Yellow(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(60.0, 1.0, 1.0, ColorDefinitions.Yellow(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.5, 0.5, 0.0, ColorDefinitions.Olive(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(60.0, 1.0, 0.25, ColorDefinitions.Olive(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(60.0, 1.0, 0.5, ColorDefinitions.Olive(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 1.0, 0.0, ColorDefinitions.Lime(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(120.0, 1.0, 0.5, ColorDefinitions.Lime(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(120.0, 1.0, 1.0, ColorDefinitions.Lime(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 0.5, 0.0, ColorDefinitions.Green(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(120.0, 1.0, 0.25, ColorDefinitions.Green(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(120.0, 1.0, 0.5, ColorDefinitions.Green(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 1.0, 1.0, ColorDefinitions.Aqua(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(180.0, 1.0, 0.5, ColorDefinitions.Aqua(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(180.0, 1.0, 1.0, ColorDefinitions.Aqua(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 0.5, 0.5, ColorDefinitions.Teal(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(180.0, 1.0, 0.25, ColorDefinitions.Teal(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(180.0, 1.0, 0.5, ColorDefinitions.Teal(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 0.5, 0.5, ColorDefinitions.Teal(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(180.0, 1.0, 0.25, ColorDefinitions.Teal(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(180.0, 1.0, 0.5, ColorDefinitions.Teal(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 0.0, 1.0, ColorDefinitions.Blue(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(240.0, 1.0, 0.5, ColorDefinitions.Blue(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(240.0, 1.0, 1.0, ColorDefinitions.Blue(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.0, 0.0, 0.5, ColorDefinitions.Navy(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(240.0, 1.0, 0.25, ColorDefinitions.Navy(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(240.0, 1.0, 0.5, ColorDefinitions.Navy(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(1.0, 0.0, 1.0, ColorDefinitions.Fuchsia(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(300.0, 1.0, 0.5, ColorDefinitions.Fuchsia(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(300.0, 1.0, 1.0, ColorDefinitions.Fuchsia(), 0.00392156862745098);
        ColorDefinitionTest.assertRGBEquals(0.5, 0.0, 0.5, ColorDefinitions.Purple(), 0.00392156862745098);
        ColorDefinitionTest.assertHSLEquals(300.0, 1.0, 0.25, ColorDefinitions.Purple(), 0.00392156862745098);
        ColorDefinitionTest.assertHSBEquals(300.0, 1.0, 0.5, ColorDefinitions.Purple(), 0.00392156862745098);
    }

    @Test
    public void testParse() {
        Random random = new Random(234L);
        for (int i = 0; i < 10000; ++i) {
            ColorDefinition expected = ColorDefinition.rgb((int)random.nextInt(0x1000000));
            int rInt = expected.getRedAsInteger();
            int gInt = expected.getGreenAsInteger();
            int bInt = expected.getBlueAsInteger();
            double rDouble = expected.getRed();
            double gDouble = expected.getGreen();
            double bDouble = expected.getBlue();
            int rPercent = (int)(100.0 * rDouble);
            int gPercent = (int)(100.0 * gDouble);
            int bPercent = (int)(100.0 * bDouble);
            double hDouble = expected.getHue();
            double svDouble = expected.getSaturation();
            double vDouble = expected.getBrightness();
            double svPercent = 100.0 * svDouble;
            double vPercent = 100.0 * vDouble;
            double slDouble = expected.toHSLDoubleArray()[1];
            double lDouble = expected.toHSLDoubleArray()[2];
            double slPercent = 100.0 * slDouble;
            double lPercent = 100.0 * lDouble;
            String rgb = "RGB(" + rInt + ", " + gInt + ", " + bInt + ")";
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)rgb.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)rgb.toLowerCase()), 1.0E-9);
            rgb = "RGB(" + rPercent + "%, " + gPercent + "%, " + bPercent + "%)";
            ColorDefinitionTest.assertRGBAEquals((double)rPercent / 100.0, (double)gPercent / 100.0, (double)bPercent / 100.0, 1.0, ColorDefinition.parse((String)rgb.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertRGBAEquals((double)rPercent / 100.0, (double)gPercent / 100.0, (double)bPercent / 100.0, 1.0, ColorDefinition.parse((String)rgb.toLowerCase()), 1.0E-9);
            String hsv = "HSV(" + hDouble + ", " + svDouble + ", " + vDouble + ")";
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsv.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsv.toLowerCase()), 1.0E-9);
            hsv = "HSV(" + hDouble + ", " + svPercent + "%, " + vPercent + "%)";
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsv.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsv.toLowerCase()), 1.0E-9);
            String hsb = "HSB(" + hDouble + ", " + svDouble + ", " + vDouble + ")";
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsb.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsb.toLowerCase()), 1.0E-9);
            hsb = "HSB(" + hDouble + ", " + svPercent + "%, " + vPercent + "%)";
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsb.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsb.toLowerCase()), 1.0E-9);
            String hsl = "HSL(" + hDouble + ", " + slDouble + ", " + lDouble + ")";
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsl.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsl.toLowerCase()), 1.0E-9);
            hsl = "HSL(" + hDouble + ", " + slPercent + "%, " + lPercent + "%)";
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsl.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hsl.toLowerCase()), 1.0E-9);
            String hex = String.format("0x%02x%02x%02x", rInt, gInt, bInt);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hex.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hex.toLowerCase()), 1.0E-9);
            hex = String.format("#%02x%02x%02x", rInt, gInt, bInt);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hex.toUpperCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinition.parse((String)hex.toLowerCase()), 1.0E-9);
        }
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.AliceBlue(), ColorDefinitions.parse((String)"AliceBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.AntiqueWhite(), ColorDefinitions.parse((String)"AntiqueWhite"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Aqua(), ColorDefinitions.parse((String)"Aqua"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Aquamarine(), ColorDefinitions.parse((String)"Aquamarine"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Azure(), ColorDefinitions.parse((String)"Azure"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Beige(), ColorDefinitions.parse((String)"Beige"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Bisque(), ColorDefinitions.parse((String)"Bisque"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Black(), ColorDefinitions.parse((String)"Black"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.BlanchedAlmond(), ColorDefinitions.parse((String)"BlanchedAlmond"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Blue(), ColorDefinitions.parse((String)"Blue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.BlueViolet(), ColorDefinitions.parse((String)"BlueViolet"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Brown(), ColorDefinitions.parse((String)"Brown"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.BurlyWood(), ColorDefinitions.parse((String)"BurlyWood"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.CadetBlue(), ColorDefinitions.parse((String)"CadetBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Chartreuse(), ColorDefinitions.parse((String)"Chartreuse"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Chocolate(), ColorDefinitions.parse((String)"Chocolate"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Coral(), ColorDefinitions.parse((String)"Coral"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.CornflowerBlue(), ColorDefinitions.parse((String)"CornflowerBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Cornsilk(), ColorDefinitions.parse((String)"Cornsilk"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Crimson(), ColorDefinitions.parse((String)"Crimson"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Cyan(), ColorDefinitions.parse((String)"Cyan"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkBlue(), ColorDefinitions.parse((String)"DarkBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkCyan(), ColorDefinitions.parse((String)"DarkCyan"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkGoldenrod(), ColorDefinitions.parse((String)"DarkGoldenrod"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkGray(), ColorDefinitions.parse((String)"DarkGray"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkGreen(), ColorDefinitions.parse((String)"DarkGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkGrey(), ColorDefinitions.parse((String)"DarkGrey"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkKhaki(), ColorDefinitions.parse((String)"DarkKhaki"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkMagenta(), ColorDefinitions.parse((String)"DarkMagenta"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkOliveGreen(), ColorDefinitions.parse((String)"DarkOliveGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkOrange(), ColorDefinitions.parse((String)"DarkOrange"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkOrchid(), ColorDefinitions.parse((String)"DarkOrchid"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkRed(), ColorDefinitions.parse((String)"DarkRed"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkSalmon(), ColorDefinitions.parse((String)"DarkSalmon"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkSeaGreen(), ColorDefinitions.parse((String)"DarkSeaGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkSlateBlue(), ColorDefinitions.parse((String)"DarkSlateBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkSlateGray(), ColorDefinitions.parse((String)"DarkSlateGray"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkSlateGrey(), ColorDefinitions.parse((String)"DarkSlateGrey"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkTurquoise(), ColorDefinitions.parse((String)"DarkTurquoise"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DarkViolet(), ColorDefinitions.parse((String)"DarkViolet"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DeepPink(), ColorDefinitions.parse((String)"DeepPink"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DeepSkyBlue(), ColorDefinitions.parse((String)"DeepSkyBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DimGray(), ColorDefinitions.parse((String)"DimGray"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DimGrey(), ColorDefinitions.parse((String)"DimGrey"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.DodgerBlue(), ColorDefinitions.parse((String)"DodgerBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.FireBrick(), ColorDefinitions.parse((String)"FireBrick"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.FloralWhite(), ColorDefinitions.parse((String)"FloralWhite"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.ForestGreen(), ColorDefinitions.parse((String)"ForestGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Fuchsia(), ColorDefinitions.parse((String)"Fuchsia"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Gainsboro(), ColorDefinitions.parse((String)"Gainsboro"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.GhostWhite(), ColorDefinitions.parse((String)"GhostWhite"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Gold(), ColorDefinitions.parse((String)"Gold"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Goldenrod(), ColorDefinitions.parse((String)"Goldenrod"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Gray(), ColorDefinitions.parse((String)"Gray"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Green(), ColorDefinitions.parse((String)"Green"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.GreenYellow(), ColorDefinitions.parse((String)"GreenYellow"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Grey(), ColorDefinitions.parse((String)"Grey"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Honeydew(), ColorDefinitions.parse((String)"Honeydew"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.HotPink(), ColorDefinitions.parse((String)"HotPink"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.IndianRed(), ColorDefinitions.parse((String)"IndianRed"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Indigo(), ColorDefinitions.parse((String)"Indigo"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Ivory(), ColorDefinitions.parse((String)"Ivory"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Khaki(), ColorDefinitions.parse((String)"Khaki"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Lavender(), ColorDefinitions.parse((String)"Lavender"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LavenderBlush(), ColorDefinitions.parse((String)"LavenderBlush"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LawnGreen(), ColorDefinitions.parse((String)"LawnGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LemonChiffon(), ColorDefinitions.parse((String)"LemonChiffon"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightBlue(), ColorDefinitions.parse((String)"LightBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightCoral(), ColorDefinitions.parse((String)"LightCoral"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightCyan(), ColorDefinitions.parse((String)"LightCyan"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightGoldenrodYellow(), ColorDefinitions.parse((String)"LightGoldenrodYellow"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightGray(), ColorDefinitions.parse((String)"LightGray"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightGreen(), ColorDefinitions.parse((String)"LightGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightGrey(), ColorDefinitions.parse((String)"LightGrey"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightPink(), ColorDefinitions.parse((String)"LightPink"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightSalmon(), ColorDefinitions.parse((String)"LightSalmon"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightSeaGreen(), ColorDefinitions.parse((String)"LightSeaGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightSkyBlue(), ColorDefinitions.parse((String)"LightSkyBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightSlateGray(), ColorDefinitions.parse((String)"LightSlateGray"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightSlateGrey(), ColorDefinitions.parse((String)"LightSlateGrey"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightSteelBlue(), ColorDefinitions.parse((String)"LightSteelBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LightYellow(), ColorDefinitions.parse((String)"LightYellow"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Lime(), ColorDefinitions.parse((String)"Lime"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.LimeGreen(), ColorDefinitions.parse((String)"LimeGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Linen(), ColorDefinitions.parse((String)"Linen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Magenta(), ColorDefinitions.parse((String)"Magenta"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Maroon(), ColorDefinitions.parse((String)"Maroon"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumAquamarine(), ColorDefinitions.parse((String)"MediumAquamarine"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumBlue(), ColorDefinitions.parse((String)"MediumBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumOrchid(), ColorDefinitions.parse((String)"MediumOrchid"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumPurple(), ColorDefinitions.parse((String)"MediumPurple"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumSeaGreen(), ColorDefinitions.parse((String)"MediumSeaGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumSlateBlue(), ColorDefinitions.parse((String)"MediumSlateBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumSpringGreen(), ColorDefinitions.parse((String)"MediumSpringGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumTurquoise(), ColorDefinitions.parse((String)"MediumTurquoise"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MediumVioletRed(), ColorDefinitions.parse((String)"MediumVioletRed"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MidnightBlue(), ColorDefinitions.parse((String)"MidnightBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MintCream(), ColorDefinitions.parse((String)"MintCream"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.MistyRose(), ColorDefinitions.parse((String)"MistyRose"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Moccasin(), ColorDefinitions.parse((String)"Moccasin"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.NavajoWhite(), ColorDefinitions.parse((String)"NavajoWhite"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Navy(), ColorDefinitions.parse((String)"Navy"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.OldLace(), ColorDefinitions.parse((String)"OldLace"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Olive(), ColorDefinitions.parse((String)"Olive"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.OliveDrab(), ColorDefinitions.parse((String)"OliveDrab"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Orange(), ColorDefinitions.parse((String)"Orange"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.OrangeRed(), ColorDefinitions.parse((String)"OrangeRed"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Orchid(), ColorDefinitions.parse((String)"Orchid"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.PaleGoldenrod(), ColorDefinitions.parse((String)"PaleGoldenrod"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.PaleGreen(), ColorDefinitions.parse((String)"PaleGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.PaleTurquoise(), ColorDefinitions.parse((String)"PaleTurquoise"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.PaleVioletRed(), ColorDefinitions.parse((String)"PaleVioletRed"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.PapayaWhip(), ColorDefinitions.parse((String)"PapayaWhip"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.PeachPuff(), ColorDefinitions.parse((String)"PeachPuff"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Peru(), ColorDefinitions.parse((String)"Peru"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Pink(), ColorDefinitions.parse((String)"Pink"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Plum(), ColorDefinitions.parse((String)"Plum"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.PowderBlue(), ColorDefinitions.parse((String)"PowderBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Purple(), ColorDefinitions.parse((String)"Purple"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Red(), ColorDefinitions.parse((String)"Red"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.RosyBrown(), ColorDefinitions.parse((String)"RosyBrown"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.RoyalBlue(), ColorDefinitions.parse((String)"RoyalBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SaddleBrown(), ColorDefinitions.parse((String)"SaddleBrown"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Salmon(), ColorDefinitions.parse((String)"Salmon"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SandyBrown(), ColorDefinitions.parse((String)"SandyBrown"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SeaGreen(), ColorDefinitions.parse((String)"SeaGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SeaShell(), ColorDefinitions.parse((String)"SeaShell"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Sienna(), ColorDefinitions.parse((String)"Sienna"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Silver(), ColorDefinitions.parse((String)"Silver"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SkyBlue(), ColorDefinitions.parse((String)"SkyBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SlateBlue(), ColorDefinitions.parse((String)"SlateBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SlateGray(), ColorDefinitions.parse((String)"SlateGray"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SlateGrey(), ColorDefinitions.parse((String)"SlateGrey"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Snow(), ColorDefinitions.parse((String)"Snow"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SpringGreen(), ColorDefinitions.parse((String)"SpringGreen"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.SteelBlue(), ColorDefinitions.parse((String)"SteelBlue"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Tan(), ColorDefinitions.parse((String)"Tan"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Teal(), ColorDefinitions.parse((String)"Teal"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Thistle(), ColorDefinitions.parse((String)"Thistle"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Tomato(), ColorDefinitions.parse((String)"Tomato"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Turquoise(), ColorDefinitions.parse((String)"Turquoise"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Violet(), ColorDefinitions.parse((String)"Violet"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Wheat(), ColorDefinitions.parse((String)"Wheat"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.White(), ColorDefinitions.parse((String)"White"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.WhiteSmoke(), ColorDefinitions.parse((String)"WhiteSmoke"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.Yellow(), ColorDefinitions.parse((String)"Yellow"), 1.0E-9);
        ColorDefinitionTest.assertColorDefinitionEquals(ColorDefinitions.YellowGreen(), ColorDefinitions.parse((String)"YellowGreen"), 1.0E-9);
        for (String colorName : ColorDefinitions.namedColorLowerCaseMap.keySet()) {
            ColorDefinition expected = (ColorDefinition)ColorDefinitions.namedColorLowerCaseMap.get(colorName);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinitions.parse((String)colorName.toLowerCase()), 1.0E-9);
            ColorDefinitionTest.assertColorDefinitionEquals(expected, ColorDefinitions.parse((String)colorName.toLowerCase()), 1.0E-9);
        }
        for (int i = 0; i < 10000; ++i) {
            ColorDefinition original = DefinitionRandomTools.nextColorDefinition(random);
            ColorDefinition parsed = ColorDefinition.parse((String)original.toString());
            Assertions.assertEquals((Object)original, (Object)parsed);
        }
    }

    public static void assertColorDefinitionEquals(ColorDefinition expectedColor, ColorDefinition actualColor, double epsilon) {
        ColorDefinitionTest.assertRGBAEquals(expectedColor.getRed(), expectedColor.getGreen(), expectedColor.getBlue(), expectedColor.getAlpha(), actualColor.getRed(), actualColor.getGreen(), actualColor.getBlue(), actualColor.getAlpha(), epsilon);
    }

    public static void assertHSBEquals(double expectedHue, double expectedSaturation, double expectedBrightness, double[] actualHSB, double epsilon) {
        ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, actualHSB[0], actualHSB[1], actualHSB[2], epsilon);
    }

    public static void assertHSBEquals(double expectedHue, double expectedSaturation, double expectedBrightness, ColorDefinition actualColor, double epsilon) {
        ColorDefinitionTest.assertHSBEquals(expectedHue, expectedSaturation, expectedBrightness, actualColor.getHue(), actualColor.getSaturation(), actualColor.getBrightness(), epsilon);
    }

    private static void assertHSBEquals(double expectedHue, double expectedSaturation, double expectedBrightness, double actualHue, double actualSaturation, double actualBrightness, double epsilon) throws AssertionFailedError {
        boolean equals = EuclidCoreTools.epsilonEquals((double)expectedHue, (double)actualHue, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedSaturation, (double)actualSaturation, (double)epsilon);
        if (!(equals &= EuclidCoreTools.epsilonEquals((double)expectedBrightness, (double)actualBrightness, (double)epsilon))) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.hsbToString(expectedHue, expectedSaturation, expectedBrightness), ColorDefinitionTest.hsbToString(actualHue, actualSaturation, actualBrightness), ColorDefinitionTest.hsbToString(Math.abs(expectedHue - actualHue), Math.abs(expectedSaturation - actualSaturation), Math.abs(expectedBrightness - actualBrightness)));
            throw new AssertionFailedError(message);
        }
    }

    public static void assertHSBAEquals(double expectedHue, double expectedSaturation, double expectedBrightness, double expectedAlpha, double[] actualHSBA, double epsilon) {
        ColorDefinitionTest.assertHSBAEquals(expectedHue, expectedSaturation, expectedBrightness, expectedAlpha, actualHSBA[0], actualHSBA[1], actualHSBA[2], actualHSBA[3], epsilon);
    }

    public static void assertHSBAEquals(double expectedHue, double expectedSaturation, double expectedBrightness, double expectedAlpha, ColorDefinition actualColor, double epsilon) {
        ColorDefinitionTest.assertHSBAEquals(expectedHue, expectedSaturation, expectedBrightness, expectedAlpha, actualColor.getHue(), actualColor.getSaturation(), actualColor.getBrightness(), actualColor.getAlpha(), epsilon);
    }

    private static void assertHSBAEquals(double expectedHue, double expectedSaturation, double expectedBrightness, double expectedAlpha, double actualHue, double actualSaturation, double actualBrightness, double actualAlpha, double epsilon) throws AssertionFailedError {
        boolean equals = EuclidCoreTools.epsilonEquals((double)expectedHue, (double)actualHue, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedSaturation, (double)actualSaturation, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedBrightness, (double)actualBrightness, (double)epsilon);
        if (!(equals &= EuclidCoreTools.epsilonEquals((double)expectedAlpha, (double)actualAlpha, (double)epsilon))) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.hsbaToString(expectedHue, expectedSaturation, expectedBrightness, expectedAlpha), ColorDefinitionTest.hsbaToString(actualHue, actualSaturation, actualBrightness, actualAlpha), ColorDefinitionTest.hsbaToString(Math.abs(expectedHue - actualHue), Math.abs(expectedSaturation - actualSaturation), Math.abs(expectedBrightness - actualBrightness), Math.abs(expectedAlpha - actualAlpha)));
            throw new AssertionFailedError(message);
        }
    }

    public static void assertHSLEquals(double expectedHue, double expectedSaturation, double expectedLightness, double[] actualHSL, double epsilon) {
        ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, actualHSL[0], actualHSL[1], actualHSL[2], epsilon);
    }

    public static void assertHSLEquals(double expectedHue, double expectedSaturation, double expectedLightness, ColorDefinition actualColor, double epsilon) {
        ColorDefinitionTest.assertHSLEquals(expectedHue, expectedSaturation, expectedLightness, actualColor.toHSLDoubleArray(), epsilon);
    }

    private static void assertHSLEquals(double expectedHue, double expectedSaturation, double expectedLightness, double actualHue, double actualSaturation, double actualLightness, double epsilon) throws AssertionFailedError {
        boolean equals = EuclidCoreTools.epsilonEquals((double)expectedHue, (double)actualHue, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedSaturation, (double)actualSaturation, (double)epsilon);
        if (!(equals &= EuclidCoreTools.epsilonEquals((double)expectedLightness, (double)actualLightness, (double)epsilon))) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.hslToString(expectedHue, expectedSaturation, expectedLightness), ColorDefinitionTest.hslToString(actualHue, actualSaturation, actualLightness), ColorDefinitionTest.hslToString(Math.abs(expectedHue - actualHue), Math.abs(expectedSaturation - actualSaturation), Math.abs(expectedLightness - actualLightness)));
            throw new AssertionFailedError(message);
        }
    }

    public static void assertHSLAEquals(double expectedHue, double expectedSaturation, double expectedLightness, double expectedAlpha, double[] actualHSLA, double epsilon) {
        ColorDefinitionTest.assertHSLAEquals(expectedHue, expectedSaturation, expectedLightness, expectedAlpha, actualHSLA[0], actualHSLA[1], actualHSLA[2], actualHSLA[3], epsilon);
    }

    public static void assertHSLAEquals(double expectedHue, double expectedSaturation, double expectedLightness, double expectedAlpha, ColorDefinition actualColor, double epsilon) {
        ColorDefinitionTest.assertHSLAEquals(expectedHue, expectedSaturation, expectedLightness, expectedAlpha, actualColor.toHSLADoubleArray(), epsilon);
    }

    private static void assertHSLAEquals(double expectedHue, double expectedSaturation, double expectedLightness, double expectedAlpha, double actualHue, double actualSaturation, double actualLightness, double actualAlpha, double epsilon) throws AssertionFailedError {
        boolean equals = EuclidCoreTools.epsilonEquals((double)expectedHue, (double)actualHue, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedSaturation, (double)actualSaturation, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedLightness, (double)actualLightness, (double)epsilon);
        if (!(equals &= EuclidCoreTools.epsilonEquals((double)expectedAlpha, (double)actualAlpha, (double)epsilon))) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.hslaToString(expectedHue, expectedSaturation, expectedLightness, expectedAlpha), ColorDefinitionTest.hslaToString(actualHue, actualSaturation, actualLightness, actualAlpha), ColorDefinitionTest.hslaToString(Math.abs(expectedHue - actualHue), Math.abs(expectedSaturation - actualSaturation), Math.abs(expectedLightness - actualLightness), Math.abs(expectedAlpha - actualAlpha)));
            throw new AssertionFailedError(message);
        }
    }

    public static void assertRGBEquals(double expectedRed, double expectedGreen, double expectedBlue, double[] actualRGB, double epsilon) {
        ColorDefinitionTest.assertRGBEquals(expectedRed, expectedGreen, expectedBlue, actualRGB[0], actualRGB[1], actualRGB[2], epsilon);
    }

    public static void assertRGBEquals(double expectedRed, double expectedGreen, double expectedBlue, ColorDefinition actualColor, double epsilon) {
        ColorDefinitionTest.assertRGBEquals(expectedRed, expectedGreen, expectedBlue, actualColor.getRed(), actualColor.getGreen(), actualColor.getBlue(), epsilon);
    }

    public static void assertRGBEquals(double expectedRed, double expectedGreen, double expectedBlue, double actualRed, double actualGreen, double actualBlue, double epsilon) throws AssertionFailedError {
        boolean equals = EuclidCoreTools.epsilonEquals((double)expectedRed, (double)actualRed, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedGreen, (double)actualGreen, (double)epsilon);
        if (!(equals &= EuclidCoreTools.epsilonEquals((double)expectedBlue, (double)actualBlue, (double)epsilon))) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.rgbToString(expectedRed, expectedGreen, expectedBlue), ColorDefinitionTest.rgbToString(actualRed, actualGreen, actualBlue), ColorDefinitionTest.rgbToString(Math.abs(expectedRed - actualRed), Math.abs(expectedGreen - actualGreen), Math.abs(expectedBlue - actualBlue)));
            throw new AssertionFailedError(message);
        }
    }

    public static void assertRGBAEquals(double expectedRed, double expectedGreen, double expectedBlue, double expectedAlpha, double[] actualRGBA, double epsilon) {
        ColorDefinitionTest.assertRGBAEquals(expectedRed, expectedGreen, expectedBlue, expectedAlpha, actualRGBA[0], actualRGBA[1], actualRGBA[2], actualRGBA[3], epsilon);
    }

    public static void assertRGBAEquals(double expectedRed, double expectedGreen, double expectedBlue, double expectedAlpha, ColorDefinition actualColor, double epsilon) {
        ColorDefinitionTest.assertRGBAEquals(expectedRed, expectedGreen, expectedBlue, expectedAlpha, actualColor.getRed(), actualColor.getGreen(), actualColor.getBlue(), actualColor.getAlpha(), epsilon);
    }

    public static void assertRGBAEquals(double expectedRed, double expectedGreen, double expectedBlue, double expectedAlpha, double actualRed, double actualGreen, double actualBlue, double actualAlpha, double epsilon) throws AssertionFailedError {
        boolean equals = EuclidCoreTools.epsilonEquals((double)expectedRed, (double)actualRed, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedGreen, (double)actualGreen, (double)epsilon);
        equals &= EuclidCoreTools.epsilonEquals((double)expectedBlue, (double)actualBlue, (double)epsilon);
        if (!(equals &= EuclidCoreTools.epsilonEquals((double)expectedAlpha, (double)actualAlpha, (double)epsilon))) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.rgbaToString(expectedRed, expectedGreen, expectedBlue, expectedAlpha), ColorDefinitionTest.rgbaToString(actualRed, actualGreen, actualBlue, actualAlpha), ColorDefinitionTest.rgbaToString(Math.abs(expectedRed - actualRed), Math.abs(expectedGreen - actualGreen), Math.abs(expectedBlue - actualBlue), Math.abs(expectedAlpha - actualAlpha)));
            throw new AssertionFailedError(message);
        }
    }

    public static void assertRGBEquals(int expectedRed, int expectedGreen, int expectedBlue, int[] actualRGB) {
        ColorDefinitionTest.assertRGBEquals(expectedRed, expectedGreen, expectedBlue, actualRGB[0], actualRGB[1], actualRGB[2]);
    }

    public static void assertRGBEquals(int expectedRed, int expectedGreen, int expectedBlue, ColorDefinition actualColor) {
        ColorDefinitionTest.assertRGBEquals(expectedRed, expectedGreen, expectedBlue, actualColor.getRedAsInteger(), actualColor.getGreenAsInteger(), actualColor.getBlueAsInteger());
    }

    public static void assertRGBEquals(int expectedRed, int expectedGreen, int expectedBlue, int actualRed, int actualGreen, int actualBlue) throws AssertionFailedError {
        boolean equals = expectedRed == actualRed;
        equals &= expectedGreen == actualGreen;
        if (!(equals &= expectedBlue == actualBlue)) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.rgbToString(expectedRed, expectedGreen, expectedBlue), ColorDefinitionTest.rgbToString(actualRed, actualGreen, actualBlue), ColorDefinitionTest.rgbToString(Math.abs(expectedRed - actualRed), Math.abs(expectedGreen - actualGreen), Math.abs(expectedBlue - actualBlue)));
            throw new AssertionFailedError(message);
        }
    }

    public static void assertRGBAEquals(int expectedRed, int expectedGreen, int expectedBlue, int expectedAlpha, int[] actualRGBA) {
        ColorDefinitionTest.assertRGBAEquals(expectedRed, expectedGreen, expectedBlue, expectedAlpha, actualRGBA[0], actualRGBA[1], actualRGBA[2], actualRGBA[3]);
    }

    public static void assertRGBAEquals(int expectedRed, int expectedGreen, int expectedBlue, int expectedAlpha, ColorDefinition actualColor) {
        ColorDefinitionTest.assertRGBAEquals(expectedRed, expectedGreen, expectedBlue, expectedAlpha, actualColor.getRedAsInteger(), actualColor.getGreenAsInteger(), actualColor.getBlueAsInteger(), actualColor.getAlphaAsInteger());
    }

    public static void assertRGBAEquals(int expectedRed, int expectedGreen, int expectedBlue, int expectedAlpha, int actualRed, int actualGreen, int actualBlue, int actualAlpha) throws AssertionFailedError {
        boolean equals = expectedRed == actualRed;
        equals &= expectedGreen == actualGreen;
        equals &= expectedBlue == actualBlue;
        if (!(equals &= expectedAlpha == actualAlpha)) {
            String message = String.format("expected:\n\t<%s>\nwas:\n\t<%s>\ndifference:\n\t<%s>", ColorDefinitionTest.rgbaToString(expectedRed, expectedGreen, expectedBlue, expectedAlpha), ColorDefinitionTest.rgbaToString(actualRed, actualGreen, actualBlue, actualAlpha), ColorDefinitionTest.rgbaToString(Math.abs(expectedRed - actualRed), Math.abs(expectedGreen - actualGreen), Math.abs(expectedBlue - actualBlue), Math.abs(expectedAlpha - actualAlpha)));
            throw new AssertionFailedError(message);
        }
    }

    private static String hsbToString(double hue, double saturation, double brightness) {
        return "H=" + hue + ", S=" + saturation + ", B=" + brightness;
    }

    private static String hsbaToString(double hue, double saturation, double brightness, double alpha) {
        return ColorDefinitionTest.hsbToString(hue, saturation, brightness) + ", A=" + alpha;
    }

    private static String hslToString(double hue, double saturation, double lightness) {
        return "H=" + hue + ", S=" + saturation + ", L=" + lightness;
    }

    private static String hslaToString(double hue, double saturation, double lightness, double alpha) {
        return ColorDefinitionTest.hslToString(hue, saturation, lightness) + ", A=" + alpha;
    }

    private static String rgbToString(double red, double green, double blue) {
        return "R=" + red + ", G=" + green + ", B=" + blue;
    }

    private static String rgbaToString(double red, double green, double blue, double alpha) {
        return ColorDefinitionTest.rgbToString(red, green, blue) + ", A=" + alpha;
    }
}

