/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainObject;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public interface BulletTerrainFactory {
    public static BulletTerrainObject newInstance(TerrainObjectDefinition terrainObjectDefinition) {
        btCompoundShape bulletCompoundCollisionShape = new btCompoundShape();
        for (CollisionShapeDefinition collisionShapeDefinition : terrainObjectDefinition.getCollisionShapeDefinitions()) {
            btCollisionShape bulletCollisionShape = BulletTools.createBulletCollisionShape(collisionShapeDefinition);
            Matrix4 bulletTransformToWorld = new Matrix4();
            RigidBodyTransform collisionShapeDefinitionTransformToWorld = new RigidBodyTransform((Orientation3DReadOnly)collisionShapeDefinition.getOriginPose().getRotation(), (Tuple3DReadOnly)collisionShapeDefinition.getOriginPose().getTranslation());
            BulletTools.toBullet(collisionShapeDefinitionTransformToWorld, bulletTransformToWorld);
            bulletCompoundCollisionShape.addChildShape(bulletTransformToWorld, bulletCollisionShape);
        }
        float mass = 0.0f;
        BulletTerrainObject bulletTerrainObject = new BulletTerrainObject(mass, (btCollisionShape)bulletCompoundCollisionShape);
        return bulletTerrainObject;
    }
}

