/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.session.YoTimer;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyDynamicsWorld;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobotFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainObject;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletContactSolverInfoParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletSimulationParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletContactSolverInfoParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletSimulationParameters;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotExtension;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class BulletPhysicsEngine
implements PhysicsEngine {
    private final BulletMultiBodyDynamicsWorld bulletMultiBodyDynamicsWorld;
    private final ReferenceFrame inertialFrame;
    private final List<BulletRobot> robotList = new ArrayList<BulletRobot>();
    private final List<TerrainObjectDefinition> terrainObjectDefinitions = new ArrayList<TerrainObjectDefinition>();
    private final YoRegistry rootRegistry;
    private final YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble runTickExpectedTimeRate = new YoDouble("runTickExpectedTimeRate", this.physicsEngineRegistry);
    private final YoTimer runBulletPhysicsEngineSimulateTimer = new YoTimer("runBulletPhysicsEngineSimulateTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer runBulletStepSimulateTimer = new YoTimer("runBulletStepSimulateTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer runControllerManagerTimer = new YoTimer("runControllerManagerTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer runPullStateFromBullet = new YoTimer("runPullStateFromBulletTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer runPushStateToBulletTimer = new YoTimer("runPushStateToBullet", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer runUpdateFramesSensorsTimer = new YoTimer("runUpdateFramesSensorsTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoDouble bulletPhysicsEngineRealTimeRate = new YoDouble("bulletPhysicsEngineRealTimeRate", this.physicsEngineRegistry);
    private final ArrayList<YoPoint3D> contactPoints = new ArrayList();
    private final YoBulletMultiBodyParameters globalMultiBodyParameters;
    private final YoBulletMultiBodyJointParameters globalMultiBodyJointParameters;
    private final YoBulletContactSolverInfoParameters globalContactSolverInfoParameters;
    private final YoBoolean hasGlobalBulletSimulationParameters;
    private final YoBulletSimulationParameters globalBulletSimulationParameters;
    private boolean hasBeenInitialized;

    public BulletPhysicsEngine(ReferenceFrame inertialFrame, YoRegistry rootRegistry) {
        for (int i = 0; i < 100; ++i) {
            this.contactPoints.add(new YoPoint3D("contactPoint" + i, this.physicsEngineRegistry));
        }
        this.hasBeenInitialized = false;
        this.inertialFrame = inertialFrame;
        this.rootRegistry = rootRegistry;
        this.globalMultiBodyParameters = new YoBulletMultiBodyParameters("globalMultiBody", this.physicsEngineRegistry);
        this.globalMultiBodyJointParameters = new YoBulletMultiBodyJointParameters("globalMultiBodyJoint", this.physicsEngineRegistry);
        this.globalContactSolverInfoParameters = new YoBulletContactSolverInfoParameters("globalContactSolverInfo", this.physicsEngineRegistry);
        this.hasGlobalBulletSimulationParameters = new YoBoolean("hasGlobalSimulationParameters", this.physicsEngineRegistry);
        this.globalBulletSimulationParameters = new YoBulletSimulationParameters("globalSimulation", this.physicsEngineRegistry);
        this.setGlobalBulletMultiBodyParameters(BulletMultiBodyParameters.defaultBulletMultiBodyParameters());
        this.setGlobalBulletMultiBodyJointParameters(BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters());
        this.setGlobalContactSolverInfoParameters(BulletContactSolverInfoParameters.defaultBulletContactSolverInfoParameters());
        this.hasGlobalBulletSimulationParameters.set(false);
        this.bulletMultiBodyDynamicsWorld = new BulletMultiBodyDynamicsWorld();
    }

    public void initialize(Vector3DReadOnly gravity) {
        for (BulletRobot robot : this.robotList) {
            robot.initializeState();
            robot.updateSensors();
            robot.getControllerManager().initializeControllers();
        }
        this.hasBeenInitialized = true;
    }

    public void simulate(double currentTime, double dt, Vector3DReadOnly gravity) {
        if (!this.hasBeenInitialized) {
            this.initialize(gravity);
            return;
        }
        this.runTickExpectedTimeRate.set(dt * 1000.0);
        this.runBulletPhysicsEngineSimulateTimer.start();
        if (this.globalMultiBodyParameters.getUpdateGlobalMultiBodyParameters()) {
            this.globalMultiBodyParameters.setUpdateGlobalMultiBodyParameters(false);
            this.bulletMultiBodyDynamicsWorld.updateAllMultiBodyParameters(this.globalMultiBodyParameters);
        }
        if (this.globalMultiBodyJointParameters.getUpdateGlobalMultiBodyJointParameters()) {
            this.globalMultiBodyJointParameters.setUpdateGlobalMultiBodyJointParameters(false);
            this.bulletMultiBodyDynamicsWorld.updateAllMultiBodyJointParameters(this.globalMultiBodyJointParameters);
        }
        if (this.globalContactSolverInfoParameters.getUpdateGlobalContactSolverInfoParameters()) {
            this.globalContactSolverInfoParameters.setUpdateGlobalContactSolverInfoParameters(false);
            this.bulletMultiBodyDynamicsWorld.updateContactSolverInfoParameters(this.globalContactSolverInfoParameters);
        }
        this.runControllerManagerTimer.start();
        for (BulletRobot robot : this.robotList) {
            robot.getControllerManager().updateControllers(currentTime);
            robot.getControllerManager().writeControllerOutput(JointStateType.EFFORT);
            robot.getControllerManager().writeControllerOutputForJointsToIgnore(JointStateType.values());
            robot.saveRobotBeforePhysicsState();
        }
        this.runControllerManagerTimer.stop();
        this.runPushStateToBulletTimer.start();
        for (BulletRobot robot : this.robotList) {
            robot.pushStateToBullet();
        }
        this.runPushStateToBulletTimer.stop();
        this.runBulletStepSimulateTimer.start();
        this.bulletMultiBodyDynamicsWorld.setGravity((Tuple3DReadOnly)gravity);
        if (this.hasGlobalBulletSimulationParameters.getValue()) {
            this.bulletMultiBodyDynamicsWorld.stepSimulation((float)this.globalBulletSimulationParameters.getTimeStamp(), this.globalBulletSimulationParameters.getMaxSubSteps(), (float)this.globalBulletSimulationParameters.getFixedTimeStep());
        } else {
            this.bulletMultiBodyDynamicsWorld.stepSimulation((float)dt, 1, (float)dt);
        }
        this.runBulletStepSimulateTimer.stop();
        this.runPullStateFromBullet.start();
        for (BulletRobot robot : this.robotList) {
            robot.pullStateFromBullet(dt);
        }
        this.runPullStateFromBullet.stop();
        this.runUpdateFramesSensorsTimer.start();
        for (BulletRobot robot : this.robotList) {
            robot.updateFrames();
            robot.updateSensors();
        }
        this.runUpdateFramesSensorsTimer.stop();
        this.runBulletPhysicsEngineSimulateTimer.stop();
        this.bulletPhysicsEngineRealTimeRate.set(this.runTickExpectedTimeRate.getValue() / this.runBulletPhysicsEngineSimulateTimer.getTimer().getValue());
    }

    public void pause() {
        for (BulletRobot robot : this.robotList) {
            robot.getControllerManager().pauseControllers();
        }
    }

    public void addRobot(Robot robot) {
        this.inertialFrame.checkReferenceFrameMatch(robot.getInertialFrame());
        BulletMultiBodyRobot bulletMultiBodyRobot = BulletMultiBodyRobotFactory.newInstance(robot, this.globalMultiBodyParameters, this.globalMultiBodyJointParameters);
        this.bulletMultiBodyDynamicsWorld.addBulletMultiBodyRobot(bulletMultiBodyRobot);
        BulletRobot bulletRobot = new BulletRobot(robot, this.physicsEngineRegistry, bulletMultiBodyRobot);
        this.rootRegistry.addChild(bulletRobot.getRegistry());
        this.robotList.add(bulletRobot);
    }

    public void dispose() {
        this.bulletMultiBodyDynamicsWorld.dispose();
    }

    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        BulletTerrainObject bulletTerrainObject = BulletTerrainFactory.newInstance(terrainObjectDefinition);
        this.terrainObjectDefinitions.add(terrainObjectDefinition);
        this.bulletMultiBodyDynamicsWorld.addBulletTerrainObject(bulletTerrainObject);
    }

    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public List<? extends Robot> getRobots() {
        return this.robotList.stream().map(RobotExtension::getRobot).collect(Collectors.toList());
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotList.stream().map(RobotInterface::getRobotDefinition).collect(Collectors.toList());
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjectDefinitions;
    }

    public List<RobotStateDefinition> getBeforePhysicsRobotStateDefinitions() {
        return this.robotList.stream().map(RobotExtension::getRobotBeforePhysicsStateDefinition).collect(Collectors.toList());
    }

    public YoRegistry getPhysicsEngineRegistry() {
        return this.physicsEngineRegistry;
    }

    public void setGlobalBulletMultiBodyParameters(BulletMultiBodyParameters bulletMultiBodyParameters) {
        this.globalMultiBodyParameters.set(bulletMultiBodyParameters);
    }

    public void setGlobalBulletMultiBodyJointParameters(BulletMultiBodyJointParameters bulletMultiBodyJointParameters) {
        this.globalMultiBodyJointParameters.set(bulletMultiBodyJointParameters);
    }

    public YoBulletMultiBodyParameters getGlobalBulletMultiBodyParameters() {
        return this.globalMultiBodyParameters;
    }

    public YoBulletMultiBodyJointParameters getGlobalBulletMultiBodyJointParameters() {
        return this.globalMultiBodyJointParameters;
    }

    public void setGlobalSimulationParameters(BulletSimulationParameters bulletSimulationParameters) {
        this.globalBulletSimulationParameters.set(bulletSimulationParameters);
        this.hasGlobalBulletSimulationParameters.set(true);
    }

    public YoBulletSimulationParameters getGlobalSimulationParameters() {
        return this.globalBulletSimulationParameters;
    }

    public BulletMultiBodyDynamicsWorld getBulletMultiBodyDynamicsWorld() {
        return this.bulletMultiBodyDynamicsWorld;
    }

    public void setGlobalContactSolverInfoParameters(BulletContactSolverInfoParameters bulletContactSolverInfoParameters) {
        this.globalContactSolverInfoParameters.set(bulletContactSolverInfoParameters);
    }

    public YoBulletContactSolverInfoParameters getGlobalContactSolverInfoParameters() {
        return this.globalContactSolverInfoParameters;
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
    }
}

