/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BulletRobotLinkRoot
extends BulletRobotLinkBasics {
    private final SimFloatingRootJoint rootSimFloatingRootJoint;
    private final RigidBodyTransform bulletJointTransformToWorldEuclid = new RigidBodyTransform();
    private final YoFixedFrameTwist twistFD;
    private final Vector3D linearVelocity = new Vector3D();
    private final Vector3D angularVelocity = new Vector3D();
    private final RigidBodyTransform rootJointSuccessorBodyFixedFrameToWorldEuclid = new RigidBodyTransform();
    private final RigidBodyTransform frameAfterJointToBodyFixedFrameTransform = new RigidBodyTransform();
    private final RigidBodyTransform frameBodyFixedFrameTransformToFrameAfterTransfer = new RigidBodyTransform();
    private final Point3D point = new Point3D();
    private final Vector3D bulletBaseLinearVelocityEuclid = new Vector3D();
    private final Vector3D bulletBaseAngularVelocityEuclid = new Vector3D();
    private final Pose3D previousBasePose = new Pose3D();
    private final Twist previousBaseTwist = new Twist();
    private final Vector4D qDot = new Vector4D();
    private final Vector4D pureQuatForMultiply = new Vector4D();

    public BulletRobotLinkRoot(SimFloatingRootJoint rootSimFloatingRootJoint, RigidBodyWrenchRegistry rigidBodyWrenchRegistry, YoRegistry yoRegistry, BulletMultiBodyLinkCollider multiBodyLinkCollider) {
        super(rootSimFloatingRootJoint.getSuccessor(), rigidBodyWrenchRegistry, multiBodyLinkCollider);
        this.rootSimFloatingRootJoint = rootSimFloatingRootJoint;
        this.twistFD = new YoFixedFrameTwist("testTwistFD", (ReferenceFrame)rootSimFloatingRootJoint.getFrameAfterJoint(), (ReferenceFrame)rootSimFloatingRootJoint.getFrameBeforeJoint(), (ReferenceFrame)rootSimFloatingRootJoint.getFrameAfterJoint(), yoRegistry);
    }

    @Override
    public void pushStateToBullet() {
        this.updateBulletLinkColliderTransformFromMecanoRigidBody();
        MovingReferenceFrame bodyFixedFrame = this.rootSimFloatingRootJoint.getSuccessor().getBodyFixedFrame();
        this.linearVelocity.set((Tuple3DReadOnly)bodyFixedFrame.getTwistOfFrame().getLinearPart());
        bodyFixedFrame.transformFromThisToDesiredFrame(bodyFixedFrame.getRootFrame(), (Transformable)this.linearVelocity);
        this.getBulletMultiBodyLinkCollider().setBaseVel((Vector3DReadOnly)this.linearVelocity);
        this.angularVelocity.set((Tuple3DReadOnly)bodyFixedFrame.getTwistOfFrame().getAngularPart());
        bodyFixedFrame.transformFromThisToDesiredFrame(bodyFixedFrame.getRootFrame(), (Transformable)this.angularVelocity);
        this.getBulletMultiBodyLinkCollider().setBaseOmega((Vector3DReadOnly)this.angularVelocity);
    }

    @Override
    public void pullStateFromBullet(double dt) {
        this.getBulletMultiBodyLinkCollider().getWorldTransform(this.rootJointSuccessorBodyFixedFrameToWorldEuclid);
        this.rootSimFloatingRootJoint.getFrameAfterJoint().getTransformToDesiredFrame(this.frameAfterJointToBodyFixedFrameTransform, (ReferenceFrame)this.rootSimFloatingRootJoint.getSuccessor().getBodyFixedFrame());
        this.bulletJointTransformToWorldEuclid.set(this.rootJointSuccessorBodyFixedFrameToWorldEuclid);
        this.bulletJointTransformToWorldEuclid.multiply((RigidBodyTransformReadOnly)this.frameAfterJointToBodyFixedFrameTransform);
        this.getBulletMultiBodyLinkCollider().getBaseVel(this.bulletBaseLinearVelocityEuclid);
        this.getBulletMultiBodyLinkCollider().getBaseOmega(this.bulletBaseAngularVelocityEuclid);
        this.bulletJointTransformToWorldEuclid.inverseTransform((Vector3DBasics)this.bulletBaseLinearVelocityEuclid);
        this.bulletJointTransformToWorldEuclid.inverseTransform((Vector3DBasics)this.bulletBaseAngularVelocityEuclid);
        this.previousBasePose.set((Pose3DReadOnly)this.rootSimFloatingRootJoint.getJointPose());
        this.previousBaseTwist.setIncludingFrame((SpatialMotionReadOnly)this.rootSimFloatingRootJoint.getJointTwist());
        this.rootSimFloatingRootJoint.setJointPosition((Tuple3DReadOnly)this.bulletJointTransformToWorldEuclid.getTranslation());
        this.rootSimFloatingRootJoint.setJointOrientation((Orientation3DReadOnly)this.bulletJointTransformToWorldEuclid.getRotation());
        this.frameBodyFixedFrameTransformToFrameAfterTransfer.set((RotationMatrixReadOnly)this.frameAfterJointToBodyFixedFrameTransform.getRotation(), (Tuple3DReadOnly)this.frameAfterJointToBodyFixedFrameTransform.getTranslation());
        this.rootSimFloatingRootJoint.getSuccessor().getBodyFixedFrame().getTransformToDesiredFrame(this.frameBodyFixedFrameTransformToFrameAfterTransfer, (ReferenceFrame)this.rootSimFloatingRootJoint.getFrameAfterJoint());
        this.point.set(this.frameBodyFixedFrameTransformToFrameAfterTransfer.getTranslation().getX(), this.frameBodyFixedFrameTransformToFrameAfterTransfer.getTranslation().getY(), this.frameBodyFixedFrameTransformToFrameAfterTransfer.getTranslation().getZ());
        this.rootSimFloatingRootJoint.getJointTwist().set((Vector3DReadOnly)this.bulletBaseAngularVelocityEuclid, (Vector3DReadOnly)this.bulletBaseLinearVelocityEuclid, (Point3DReadOnly)this.point);
        this.computeJointTwist(dt, (Pose3DReadOnly)this.previousBasePose, (Pose3DReadOnly)this.rootSimFloatingRootJoint.getJointPose(), (FixedFrameTwistBasics)this.twistFD);
        BulletRobotLinkRoot.computeJointAcceleration(dt, (Pose3DReadOnly)this.previousBasePose, (Pose3DReadOnly)this.rootSimFloatingRootJoint.getJointPose(), (TwistReadOnly)this.previousBaseTwist, (TwistReadOnly)this.rootSimFloatingRootJoint.getJointTwist(), (FixedFrameSpatialAccelerationBasics)this.rootSimFloatingRootJoint.getJointAcceleration());
    }

    public void computeJointTwist(double dt, Pose3DReadOnly previousPose, Pose3DReadOnly currentPose, FixedFrameTwistBasics twistToPack) {
        twistToPack.getLinearPart().sub((Tuple3DReadOnly)currentPose.getPosition(), (Tuple3DReadOnly)previousPose.getPosition());
        twistToPack.getLinearPart().scale(1.0 / dt);
        currentPose.getOrientation().inverseTransform((Tuple3DBasics)twistToPack.getLinearPart());
        this.qDot.sub((Tuple4DReadOnly)currentPose.getOrientation(), (Tuple4DReadOnly)previousPose.getOrientation());
        this.qDot.scale(1.0 / dt);
        this.computeAngularVelocityInBodyFixedFrame(currentPose.getOrientation(), (Vector4DReadOnly)this.qDot, (Vector3DBasics)twistToPack.getAngularPart());
    }

    public static void computeJointAcceleration(double dt, Pose3DReadOnly previousPose, Pose3DReadOnly currentPose, TwistReadOnly previousTwist, TwistReadOnly currentTwist, FixedFrameSpatialAccelerationBasics accelerationToPack) {
        QuaternionReadOnly previousOrientation = previousPose.getOrientation();
        QuaternionReadOnly currentOrientation = currentPose.getOrientation();
        FixedFrameVector3DBasics angularAcceleration = accelerationToPack.getAngularPart();
        FixedFrameVector3DBasics linearAcceleration = accelerationToPack.getLinearPart();
        previousOrientation.transform((Tuple3DReadOnly)previousTwist.getAngularPart(), (Tuple3DBasics)angularAcceleration);
        currentOrientation.inverseTransform((Tuple3DBasics)angularAcceleration);
        angularAcceleration.sub((FrameTuple3DReadOnly)currentTwist.getAngularPart(), (FrameTuple3DReadOnly)angularAcceleration);
        previousOrientation.transform((Tuple3DReadOnly)previousTwist.getLinearPart(), (Tuple3DBasics)linearAcceleration);
        currentOrientation.inverseTransform((Tuple3DBasics)linearAcceleration);
        linearAcceleration.sub((FrameTuple3DReadOnly)currentTwist.getLinearPart(), (FrameTuple3DReadOnly)linearAcceleration);
        accelerationToPack.scale(1.0 / dt);
        accelerationToPack.addCrossToLinearPart((Tuple3DReadOnly)currentTwist.getLinearPart(), (Tuple3DReadOnly)currentTwist.getAngularPart());
    }

    public void computeAngularVelocityInBodyFixedFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DBasics angularVelocityToPack) {
        QuaternionTools.multiplyConjugateLeft((Tuple4DReadOnly)q, (Tuple4DReadOnly)qDot, (Vector4DBasics)this.pureQuatForMultiply);
        angularVelocityToPack.set(this.pureQuatForMultiply.getX(), this.pureQuatForMultiply.getY(), this.pureQuatForMultiply.getZ());
        angularVelocityToPack.scale(2.0);
    }
}

