/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.ArrayList;
import org.bytedeco.bullet.BulletCollision.btBroadphaseInterface;
import org.bytedeco.bullet.BulletCollision.btCollisionConfiguration;
import org.bytedeco.bullet.BulletCollision.btCollisionDispatcher;
import org.bytedeco.bullet.BulletCollision.btCollisionObject;
import org.bytedeco.bullet.BulletCollision.btDbvtBroadphase;
import org.bytedeco.bullet.BulletCollision.btDefaultCollisionConfiguration;
import org.bytedeco.bullet.BulletCollision.btDispatcher;
import org.bytedeco.bullet.BulletDynamics.btContactSolverInfo;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyConstraint;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyConstraintSolver;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyDynamicsWorld;
import org.bytedeco.bullet.LinearMath.btIDebugDraw;
import org.bytedeco.bullet.LinearMath.btVector3;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainObject;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletContactSolverInfoParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;

public class BulletMultiBodyDynamicsWorld {
    private final btCollisionConfiguration btCollisionConfiguration;
    private final btCollisionDispatcher btCollisionDispatcher;
    private final btBroadphaseInterface btBroadphaseInterface;
    private final btMultiBodyConstraintSolver btMultiBodyConstraintSolver;
    private final btMultiBodyDynamicsWorld btMultiBodyDynamicsWorld;
    private btIDebugDraw btDebugDraw = null;
    private final ArrayList<BulletTerrainObject> terrainObjects = new ArrayList();
    private final ArrayList<BulletMultiBodyRobot> multiBodyRobots = new ArrayList();
    private final btVector3 btGravity = new btVector3();
    private final btContactSolverInfo btContactSolverInfo;

    public BulletMultiBodyDynamicsWorld() {
        this.btCollisionConfiguration = new btDefaultCollisionConfiguration();
        this.btCollisionDispatcher = new btCollisionDispatcher(this.btCollisionConfiguration);
        this.btBroadphaseInterface = new btDbvtBroadphase();
        this.btMultiBodyConstraintSolver = new btMultiBodyConstraintSolver();
        this.btMultiBodyDynamicsWorld = new btMultiBodyDynamicsWorld((btDispatcher)this.btCollisionDispatcher, this.btBroadphaseInterface, this.btMultiBodyConstraintSolver, this.btCollisionConfiguration);
        this.btContactSolverInfo = this.btMultiBodyDynamicsWorld.getSolverInfo();
    }

    public void setGravity(Tuple3DReadOnly gravity) {
        this.btGravity.setValue(gravity.getX(), gravity.getY(), gravity.getZ());
        this.btMultiBodyDynamicsWorld.setGravity(this.btGravity);
    }

    public int stepSimulation(double timeStep, int maxSubSteps, double fixedTimeStep) {
        return this.btMultiBodyDynamicsWorld.stepSimulation(timeStep, maxSubSteps, fixedTimeStep);
    }

    public int stepSimulation(double timeStep, int maxSubSteps) {
        return this.btMultiBodyDynamicsWorld.stepSimulation(timeStep, maxSubSteps, timeStep);
    }

    public int stepSimulation(double timeStep) {
        return this.btMultiBodyDynamicsWorld.stepSimulation(timeStep);
    }

    public btMultiBodyDynamicsWorld getBtMultiBodyDynamicsWorld() {
        return this.btMultiBodyDynamicsWorld;
    }

    public void dispose() {
        if (!this.btMultiBodyDynamicsWorld.isNull()) {
            for (BulletTerrainObject bulletTerrainObject : this.terrainObjects) {
                bulletTerrainObject.getBtRigidBody().getCollisionShape().deallocate();
                bulletTerrainObject.getBtRigidBody().getMotionState().deallocate();
                this.btMultiBodyDynamicsWorld.removeRigidBody(bulletTerrainObject.getBtRigidBody());
                bulletTerrainObject.getBtRigidBody().deallocate();
            }
            for (BulletMultiBodyRobot bulletMultiBodyRobot : this.multiBodyRobots) {
                int i;
                for (i = 0; i < this.btMultiBodyDynamicsWorld.getNumConstraints(); ++i) {
                    this.btMultiBodyDynamicsWorld.removeConstraint(this.btMultiBodyDynamicsWorld.getConstraint(i));
                }
                for (btMultiBodyConstraint bulletMultiBodyConstraint : bulletMultiBodyRobot.getBtMultiBodyConstraintArray()) {
                    this.btMultiBodyDynamicsWorld.removeMultiBodyConstraint(bulletMultiBodyConstraint);
                    bulletMultiBodyConstraint.deallocate();
                }
                this.btMultiBodyDynamicsWorld.removeMultiBody(bulletMultiBodyRobot.getBtMultiBody());
                for (BulletMultiBodyLinkCollider multiBodyLinkCollider : bulletMultiBodyRobot.getBulletMultiBodyLinkColliderArray()) {
                    this.btMultiBodyDynamicsWorld.removeCollisionObject((btCollisionObject)multiBodyLinkCollider.getBtMultiBodyLinkCollider());
                    multiBodyLinkCollider.getBtMultiBodyLinkCollider().getCollisionShape().deallocate();
                    multiBodyLinkCollider.getBtMultiBodyLinkCollider().deallocate();
                }
                for (i = 0; bulletMultiBodyRobot.getBtMultiBody().getNumLinks() < i; ++i) {
                    bulletMultiBodyRobot.getBtMultiBody().getLink(i).deallocate();
                }
                bulletMultiBodyRobot.getBtMultiBody().deallocate();
            }
            if (this.btDebugDraw != null) {
                this.btDebugDraw.deallocate();
            }
            this.btMultiBodyDynamicsWorld.deallocate();
            this.btMultiBodyConstraintSolver.deallocate();
            this.btBroadphaseInterface.deallocate();
            this.btCollisionDispatcher.deallocate();
            this.btCollisionConfiguration.deallocate();
        }
    }

    public void addBulletMultiBodyRobot(BulletMultiBodyRobot bulletMultiBodyRobot) {
        this.multiBodyRobots.add(bulletMultiBodyRobot);
        for (BulletMultiBodyLinkCollider linkCollider : bulletMultiBodyRobot.getBulletMultiBodyLinkColliderArray()) {
            this.btMultiBodyDynamicsWorld.addCollisionObject((btCollisionObject)linkCollider.getBtMultiBodyLinkCollider(), linkCollider.getCollisionGroup(), linkCollider.getCollisionGroupMask());
        }
        for (btMultiBodyConstraint constraint : bulletMultiBodyRobot.getBtMultiBodyConstraintArray()) {
            this.btMultiBodyDynamicsWorld.addMultiBodyConstraint(constraint);
        }
        this.btMultiBodyDynamicsWorld.addMultiBody(bulletMultiBodyRobot.getBtMultiBody());
    }

    public void addBulletTerrainObject(BulletTerrainObject bulletTerrainObject) {
        this.terrainObjects.add(bulletTerrainObject);
        this.btMultiBodyDynamicsWorld.addRigidBody(bulletTerrainObject.getBtRigidBody(), bulletTerrainObject.getCollisionGroup(), bulletTerrainObject.getCollisionGroupMask());
        bulletTerrainObject.getBtRigidBody().setCollisionFlags(bulletTerrainObject.getBtRigidBody().getCollisionFlags() | 2);
        bulletTerrainObject.getBtRigidBody().setActivationState(4);
    }

    public void updateAllMultiBodyParameters(YoBulletMultiBodyParameters multiBodyParameters) {
        for (BulletMultiBodyRobot bulletMultiBodyRobot : this.multiBodyRobots) {
            bulletMultiBodyRobot.setMultiBodyParameters(multiBodyParameters);
        }
    }

    public void updateAllMultiBodyJointParameters(YoBulletMultiBodyJointParameters multiBodyJointParameters) {
        for (BulletMultiBodyRobot bulletMultiBodyRobot : this.multiBodyRobots) {
            bulletMultiBodyRobot.setMultiBodyJointParameters(multiBodyJointParameters);
        }
    }

    public void setBtDebugDrawer(btIDebugDraw btDebugDraw) {
        if (!this.btMultiBodyDynamicsWorld.isNull()) {
            this.btMultiBodyDynamicsWorld.setDebugDrawer(btDebugDraw);
        }
        this.btDebugDraw = btDebugDraw;
    }

    public void debugDrawWorld() {
        if (!this.btMultiBodyDynamicsWorld.isNull()) {
            this.btMultiBodyDynamicsWorld.debugDrawWorld();
        }
    }

    public void updateContactSolverInfoParameters(YoBulletContactSolverInfoParameters globalContactSolverInfoParameters) {
        this.btContactSolverInfo.m_tau(globalContactSolverInfoParameters.getTau());
        this.btContactSolverInfo.m_damping(globalContactSolverInfoParameters.getDamping());
        this.btContactSolverInfo.m_friction(globalContactSolverInfoParameters.getFriction());
        this.btContactSolverInfo.m_timeStep(globalContactSolverInfoParameters.getTimeStep());
        this.btContactSolverInfo.m_restitution(globalContactSolverInfoParameters.getRestitution());
        this.btContactSolverInfo.m_maxErrorReduction(globalContactSolverInfoParameters.getMaxErrorReduction());
        this.btContactSolverInfo.m_numIterations(globalContactSolverInfoParameters.getNumberOfIterations());
        this.btContactSolverInfo.m_erp(globalContactSolverInfoParameters.getErrorReductionForNonContactConstraints());
        this.btContactSolverInfo.m_erp2(globalContactSolverInfoParameters.getErrorReductionForContactConstraints());
        this.btContactSolverInfo.m_globalCfm(globalContactSolverInfoParameters.getConstraintForceMixingForContactsAndNonContacts());
        this.btContactSolverInfo.m_frictionERP(globalContactSolverInfoParameters.getErrorReductionForFrictionConstraints());
        this.btContactSolverInfo.m_frictionCFM(globalContactSolverInfoParameters.getConstraintForceMixingForFrictionConstraints());
        this.btContactSolverInfo.m_sor(globalContactSolverInfoParameters.getSuccessiveOverRelaxationTerm());
        this.btContactSolverInfo.m_splitImpulse(globalContactSolverInfoParameters.getSplitImpulse());
        this.btContactSolverInfo.m_splitImpulsePenetrationThreshold(globalContactSolverInfoParameters.getSplitImpulsePenetrationThreshold());
        this.btContactSolverInfo.m_splitImpulseTurnErp(globalContactSolverInfoParameters.getSplitImpulseTurnErp());
        this.btContactSolverInfo.m_linearSlop(globalContactSolverInfoParameters.getLinearSlop());
        this.btContactSolverInfo.m_warmstartingFactor(globalContactSolverInfoParameters.getWarmstartingFactor());
        this.btContactSolverInfo.m_solverMode(globalContactSolverInfoParameters.getSolverMode());
        this.btContactSolverInfo.m_restingContactRestitutionThreshold(globalContactSolverInfoParameters.getRestingContactRestitutionThreshold());
        this.btContactSolverInfo.m_minimumSolverBatchSize(globalContactSolverInfoParameters.getMinimumSolverBatchSize());
        this.btContactSolverInfo.m_maxGyroscopicForce(globalContactSolverInfoParameters.getMaxGyroscopicForce());
        this.btContactSolverInfo.m_singleAxisRollingFrictionThreshold(globalContactSolverInfoParameters.getSingleAxisRollingFrictionThreshold());
        this.btContactSolverInfo.m_leastSquaresResidualThreshold(globalContactSolverInfoParameters.getLeastSquaresResidualThreshold());
        this.btContactSolverInfo.m_restitutionVelocityThreshold(globalContactSolverInfoParameters.getRestitutionVelocityThreshold());
    }
}

