/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bytedeco.bullet.BulletCollision.btCollisionShape;
import org.bytedeco.bullet.BulletCollision.btCompoundShape;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyConstraint;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyJointLimitConstraint;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyLinkCollider;
import org.bytedeco.bullet.BulletDynamics.btMultibodyLink;
import org.bytedeco.bullet.LinearMath.btQuaternion;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPrismaticJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;

public class BulletMultiBodyRobotFactory {
    private static HashMap<String, Integer> jointNameToBulletJointIndexMap;
    private static int linkCountingIndex;
    private static int numberOfLinks;
    private static final btQuaternion rotationFromParentBullet;
    private static final Quaternion euclidRotationFromParent;
    private static final RigidBodyTransform parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid;
    private static final btVector3 parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationBullet;
    private static final RigidBodyTransform parentJointAfterFrameToLinkCenterOfMassTransformEuclid;
    private static final btVector3 parentJointAfterFrameToLinkCenterOfMassTranslationBullet;
    private static final btTransform bulletCollisionShapeLocalTransform;
    private static final RigidBodyTransform collisionShapeDefinitionToCenterOfMassFrameTransformEuclid;

    public static BulletMultiBodyRobot newInstance(Robot robot, YoBulletMultiBodyParameters bulletMultiBodyParameters, YoBulletMultiBodyJointParameters bulletMultiBodyJointParameters) {
        if (robot.getRootBody().getChildrenJoints().size() == 0) {
            throw new UnsupportedOperationException("Robot must have at least one joint: " + robot.getClass().getSimpleName());
        }
        JointBasics rootJoint = (JointBasics)robot.getRootBody().getChildrenJoints().get(0);
        boolean hasBaseCollider = rootJoint instanceof SimFloatingRootJoint;
        jointNameToBulletJointIndexMap = new HashMap();
        linkCountingIndex = hasBaseCollider ? 0 : 1;
        numberOfLinks = 0;
        for (JointBasics joint : robot.getRootBody().getChildrenJoints()) {
            numberOfLinks += BulletMultiBodyRobotFactory.countJointsAndCreateIndexMap(joint) - (hasBaseCollider ? 1 : 0);
        }
        RigidBodyDefinition rigidBodyDefinition = ((JointDefinition)robot.getRobotDefinition().getRootBodyDefinition().getChildrenJoints().get(0)).getSuccessor();
        double rootBodyMass = rigidBodyDefinition.getMass();
        btVector3 rootBodyIntertia = new btVector3(rigidBodyDefinition.getMomentOfInertia().getM00(), rigidBodyDefinition.getMomentOfInertia().getM11(), rigidBodyDefinition.getMomentOfInertia().getM22());
        boolean fixedBase = !hasBaseCollider;
        BulletMultiBodyRobot bulletMultiBodyRobot = new BulletMultiBodyRobot(numberOfLinks, rootBodyMass, rootBodyIntertia, fixedBase, bulletMultiBodyParameters.getCanSleep(), jointNameToBulletJointIndexMap);
        for (JointBasics joint : robot.getRootBody().getChildrenJoints()) {
            int linkIndex = bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().get(joint.getName());
            if (linkIndex == -1) {
                bulletMultiBodyRobot.getBtMultiBody().setBaseCollider(BulletMultiBodyRobotFactory.createBulletLinkCollider(bulletMultiBodyRobot, rigidBodyDefinition.getCollisionShapeDefinitions(), (ReferenceFrame)rootJoint.getSuccessor().getBodyFixedFrame(), -1, rootJoint.getName()));
            } else {
                JointDefinition rootJointDefinition = robot.getRobotDefinition().getJointDefinition(joint.getName());
                btMultibodyLink bulletLink = BulletMultiBodyRobotFactory.setupBtMultibodyLink(bulletMultiBodyRobot, joint, rootJointDefinition, linkIndex, bulletMultiBodyJointParameters.getJointDisableParentCollision());
                bulletLink.m_collider(BulletMultiBodyRobotFactory.createBulletLinkCollider(bulletMultiBodyRobot, rootJointDefinition.getSuccessor().getCollisionShapeDefinitions(), (ReferenceFrame)joint.getSuccessor().getBodyFixedFrame(), linkIndex, joint.getName()));
            }
            BulletMultiBodyRobotFactory.createBulletLinkColliderChildren(bulletMultiBodyRobot, robot, joint, bulletMultiBodyJointParameters.getJointDisableParentCollision());
        }
        bulletMultiBodyRobot.finalizeMultiDof(bulletMultiBodyParameters, bulletMultiBodyJointParameters);
        return bulletMultiBodyRobot;
    }

    private static void createBulletLinkColliderChildren(BulletMultiBodyRobot bulletMultiBodyRobot, Robot robot, JointBasics joint, boolean disableParentCollision) {
        for (JointBasics childJoint : joint.getSuccessor().getChildrenJoints()) {
            JointDefinition childJointDefinition = robot.getRobotDefinition().getJointDefinition(childJoint.getName());
            int linkIndex = bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().get(childJoint.getName());
            btMultibodyLink btMultibodyLink2 = BulletMultiBodyRobotFactory.setupBtMultibodyLink(bulletMultiBodyRobot, childJoint, childJointDefinition, linkIndex, disableParentCollision);
            btMultibodyLink2.m_collider(BulletMultiBodyRobotFactory.createBulletLinkCollider(bulletMultiBodyRobot, childJointDefinition.getSuccessor().getCollisionShapeDefinitions(), (ReferenceFrame)childJoint.getSuccessor().getBodyFixedFrame(), linkIndex, childJoint.getName()));
            BulletMultiBodyRobotFactory.createBulletLinkColliderChildren(bulletMultiBodyRobot, robot, childJoint, disableParentCollision);
        }
    }

    private static btMultibodyLink setupBtMultibodyLink(BulletMultiBodyRobot bulletMultiBodyRobot, JointBasics joint, JointDefinition jointDefinition, int bulletJointIndex, boolean disableParentCollision) {
        btVector3 linkInertiaDiagonal = new btVector3(jointDefinition.getSuccessor().getMomentOfInertia().getM00(), jointDefinition.getSuccessor().getMomentOfInertia().getM11(), jointDefinition.getSuccessor().getMomentOfInertia().getM22());
        euclidRotationFromParent.set((Orientation3DReadOnly)jointDefinition.getTransformToParent().getRotation());
        euclidRotationFromParent.invert();
        BulletTools.toBullet(euclidRotationFromParent, rotationFromParentBullet);
        joint.getPredecessor().getBodyFixedFrame().getTransformToDesiredFrame(parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid, (ReferenceFrame)joint.getFrameBeforeJoint());
        parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.invert();
        BulletTools.toBullet((Tuple3DReadOnly)parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.getTranslation(), parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationBullet);
        joint.getFrameAfterJoint().getTransformToDesiredFrame(parentJointAfterFrameToLinkCenterOfMassTransformEuclid, (ReferenceFrame)joint.getSuccessor().getBodyFixedFrame());
        parentJointAfterFrameToLinkCenterOfMassTransformEuclid.invert();
        BulletTools.toBullet((Tuple3DReadOnly)parentJointAfterFrameToLinkCenterOfMassTransformEuclid.getTranslation(), parentJointAfterFrameToLinkCenterOfMassTranslationBullet);
        double linkMass = jointDefinition.getSuccessor().getMass();
        if (joint instanceof SimRevoluteJoint) {
            RevoluteJointDefinition revoluteJointDefinition = (RevoluteJointDefinition)jointDefinition;
            int parentBulletJointIndex = joint.getPredecessor().getParentJoint() == null ? -1 : bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().get(joint.getPredecessor().getParentJoint().getName());
            btVector3 jointAxis = new btVector3();
            BulletTools.toBullet((Tuple3DReadOnly)revoluteJointDefinition.getAxis(), jointAxis);
            bulletMultiBodyRobot.getBtMultiBody().setupRevolute(bulletJointIndex, linkMass, linkInertiaDiagonal, parentBulletJointIndex, rotationFromParentBullet, jointAxis, parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationBullet, parentJointAfterFrameToLinkCenterOfMassTranslationBullet, disableParentCollision);
            btMultiBodyJointLimitConstraint multiBodyJointLimitConstraint = new btMultiBodyJointLimitConstraint(bulletMultiBodyRobot.getBtMultiBody(), bulletJointIndex, revoluteJointDefinition.getPositionLowerLimit(), revoluteJointDefinition.getPositionUpperLimit());
            bulletMultiBodyRobot.addBtMultiBodyConstraint((btMultiBodyConstraint)multiBodyJointLimitConstraint);
        } else if (joint instanceof SimPrismaticJoint) {
            PrismaticJointDefinition primaticJointDefinition = (PrismaticJointDefinition)jointDefinition;
            int parentBulletJointIndex = joint.getPredecessor().getParentJoint() == null ? -1 : bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().get(joint.getPredecessor().getParentJoint().getName());
            btVector3 jointAxis = new btVector3();
            BulletTools.toBullet((Tuple3DReadOnly)primaticJointDefinition.getAxis(), jointAxis);
            bulletMultiBodyRobot.getBtMultiBody().setupPrismatic(bulletJointIndex, linkMass, linkInertiaDiagonal, parentBulletJointIndex, rotationFromParentBullet, jointAxis, parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationBullet, parentJointAfterFrameToLinkCenterOfMassTranslationBullet, disableParentCollision);
            btMultiBodyJointLimitConstraint multiBodyJointLimitConstraint = new btMultiBodyJointLimitConstraint(bulletMultiBodyRobot.getBtMultiBody(), bulletJointIndex, primaticJointDefinition.getPositionLowerLimit(), primaticJointDefinition.getPositionUpperLimit());
            bulletMultiBodyRobot.addBtMultiBodyConstraint((btMultiBodyConstraint)multiBodyJointLimitConstraint);
        } else {
            throw new UnsupportedOperationException("Unsupported joint: " + joint.getClass().getSimpleName());
        }
        return bulletMultiBodyRobot.getBtMultiBody().getLink(bulletJointIndex);
    }

    private static btMultiBodyLinkCollider createBulletLinkCollider(BulletMultiBodyRobot bulletMultiBodyRobot, List<CollisionShapeDefinition> collisionShapeDefinitions, ReferenceFrame linkCenterOfMassFrame, int bulletJointIndex, String jointName) {
        BulletMultiBodyLinkCollider bulletMultiBodyLinkCollider = new BulletMultiBodyLinkCollider(bulletMultiBodyRobot.getBtMultiBody(), bulletJointIndex, jointName);
        btCompoundShape bulletCompoundShape = new btCompoundShape();
        int collisionGroup = 2;
        int collisionGroupMask = 3;
        if (collisionShapeDefinitions.size() > 0) {
            collisionGroupMask = (int)collisionShapeDefinitions.get(0).getCollisionGroup();
            collisionGroup = (int)collisionShapeDefinitions.get(0).getCollisionMask();
        }
        bulletMultiBodyLinkCollider.setCollisionGroupMask(collisionGroup, collisionGroupMask);
        ArrayList<btCollisionShape> btCollisionShapes = new ArrayList<btCollisionShape>();
        for (CollisionShapeDefinition shapeDefinition : collisionShapeDefinitions) {
            btCollisionShape bulletCollisionShape = BulletTools.createBulletCollisionShape(shapeDefinition);
            btTransform bulletCollisionShapeLocalTransform = BulletMultiBodyRobotFactory.bulletCollisionShapeLocalTransform(shapeDefinition, linkCenterOfMassFrame);
            bulletCompoundShape.addChildShape(bulletCollisionShapeLocalTransform, bulletCollisionShape);
            btCollisionShapes.add(bulletCollisionShape);
        }
        bulletMultiBodyLinkCollider.setCollisionShape(bulletCompoundShape, btCollisionShapes);
        bulletMultiBodyRobot.addBulletMuliBodyLinkCollider(bulletMultiBodyLinkCollider);
        return bulletMultiBodyLinkCollider.getBtMultiBodyLinkCollider();
    }

    public static btTransform bulletCollisionShapeLocalTransform(CollisionShapeDefinition shapeDefinition, ReferenceFrame linkCenterOfMassFrame) {
        collisionShapeDefinitionToCenterOfMassFrameTransformEuclid.setAndInvert((RigidBodyTransformReadOnly)linkCenterOfMassFrame.getTransformToParent());
        collisionShapeDefinitionToCenterOfMassFrameTransformEuclid.multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)shapeDefinition.getOriginPose().getRotation(), (Tuple3DReadOnly)shapeDefinition.getOriginPose().getTranslation()));
        BulletTools.toBullet(collisionShapeDefinitionToCenterOfMassFrameTransformEuclid, bulletCollisionShapeLocalTransform);
        return bulletCollisionShapeLocalTransform;
    }

    private static int countJointsAndCreateIndexMap(JointBasics joint) {
        jointNameToBulletJointIndexMap.put(joint.getName(), linkCountingIndex - 1);
        ++linkCountingIndex;
        int numberOfJoints = 1;
        for (JointBasics childrenJoint : joint.getSuccessor().getChildrenJoints()) {
            numberOfJoints += BulletMultiBodyRobotFactory.countJointsAndCreateIndexMap(childrenJoint);
        }
        return numberOfJoints;
    }

    static {
        rotationFromParentBullet = new btQuaternion();
        euclidRotationFromParent = new Quaternion();
        parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid = new RigidBodyTransform();
        parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationBullet = new btVector3();
        parentJointAfterFrameToLinkCenterOfMassTransformEuclid = new RigidBodyTransform();
        parentJointAfterFrameToLinkCenterOfMassTranslationBullet = new btVector3();
        bulletCollisionShapeLocalTransform = new btTransform();
        collisionShapeDefinitionToCenterOfMassFrameTransformEuclid = new RigidBodyTransform();
    }
}

