/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BulletRobotLinkJoint
extends BulletRobotLinkBasics {
    private final SimOneDoFJointBasics simOneDofJoint;
    private final Vector3D force = new Vector3D();
    private final Vector3D torque = new Vector3D();
    private final Wrench wrenchToAdd;
    private final YoDouble bulletLinkAppliedForceX;
    private final YoDouble bulletLinkAppliedForceY;
    private final YoDouble bulletLinkAppliedForceZ;
    private final YoDouble bulletLinkAppliedTorqueX;
    private final YoDouble bulletLinkAppliedTorqueY;
    private final YoDouble bulletLinkAppliedTorqueZ;

    public BulletRobotLinkJoint(SimOneDoFJointBasics simOneDoFJoint, int bulletJointIndex, RigidBodyWrenchRegistry rigidBodyWrenchRegistry, YoRegistry yoRegistry, BulletMultiBodyLinkCollider bulletMultiBodyLinkCollider) {
        super(simOneDoFJoint.getSuccessor(), rigidBodyWrenchRegistry, bulletMultiBodyLinkCollider);
        this.simOneDofJoint = simOneDoFJoint;
        this.wrenchToAdd = new Wrench((ReferenceFrame)this.getSimRigidBody().getBodyFixedFrame(), (ReferenceFrame)this.getSimRigidBody().getBodyFixedFrame());
        this.bulletLinkAppliedForceX = new YoDouble(simOneDoFJoint.getName() + "_btAppliedForceX", yoRegistry);
        this.bulletLinkAppliedForceY = new YoDouble(simOneDoFJoint.getName() + "_btAppliedForceY", yoRegistry);
        this.bulletLinkAppliedForceZ = new YoDouble(simOneDoFJoint.getName() + "_btAppliedForceZ", yoRegistry);
        this.bulletLinkAppliedTorqueX = new YoDouble(simOneDoFJoint.getName() + "_btAppliedTorqueX", yoRegistry);
        this.bulletLinkAppliedTorqueY = new YoDouble(simOneDoFJoint.getName() + "_btAppliedTorqueY", yoRegistry);
        this.bulletLinkAppliedTorqueZ = new YoDouble(simOneDoFJoint.getName() + "_btAppliedTorqueZ", yoRegistry);
    }

    @Override
    public void pushStateToBullet() {
        this.updateBulletLinkColliderTransformFromMecanoRigidBody();
        this.getBulletMultiBodyLinkCollider().setJointPos(this.simOneDofJoint.getQ());
        this.getBulletMultiBodyLinkCollider().setJointVel(this.simOneDofJoint.getQd());
        this.getBulletMultiBodyLinkCollider().addJointTorque(this.simOneDofJoint.getTau());
    }

    @Override
    public void pullStateFromBullet(double dt) {
        double jointPosition = this.getBulletMultiBodyLinkCollider().getJointPos();
        this.simOneDofJoint.setQ(jointPosition);
        double jointPVel = this.getBulletMultiBodyLinkCollider().getJointVel();
        this.simOneDofJoint.setQdd((jointPVel - this.simOneDofJoint.getQd()) / dt);
        this.simOneDofJoint.setQd(jointPVel);
        this.getBulletMultiBodyLinkCollider().getAppliedConstraintForce(this.force);
        this.bulletLinkAppliedForceX.set(this.force.getX());
        this.bulletLinkAppliedForceY.set(this.force.getY());
        this.bulletLinkAppliedForceZ.set(this.force.getZ());
        this.getBulletMultiBodyLinkCollider().getAppliedConstraintTorque(this.torque);
        this.bulletLinkAppliedTorqueX.set(this.torque.getX());
        this.bulletLinkAppliedTorqueY.set(this.torque.getY());
        this.bulletLinkAppliedTorqueZ.set(this.torque.getZ());
        this.wrenchToAdd.set((Vector3DReadOnly)this.torque, (Vector3DReadOnly)this.force);
        this.getRigidBodyWrenchRegistry().addWrench((RigidBodyReadOnly)this.getSimRigidBody(), (WrenchReadOnly)this.wrenchToAdd);
    }
}

