/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import org.bytedeco.bullet.BulletCollision.btBoxShape;
import org.bytedeco.bullet.BulletCollision.btCapsuleShapeZ;
import org.bytedeco.bullet.BulletCollision.btCollisionShape;
import org.bytedeco.bullet.BulletCollision.btCompoundFromGimpactShape;
import org.bytedeco.bullet.BulletCollision.btCompoundShape;
import org.bytedeco.bullet.BulletCollision.btConeShapeZ;
import org.bytedeco.bullet.BulletCollision.btConvexHullShape;
import org.bytedeco.bullet.BulletCollision.btConvexTriangleMeshShape;
import org.bytedeco.bullet.BulletCollision.btCylinderShapeZ;
import org.bytedeco.bullet.BulletCollision.btGImpactMeshShape;
import org.bytedeco.bullet.BulletCollision.btSphereShape;
import org.bytedeco.bullet.BulletCollision.btStridingMeshInterface;
import org.bytedeco.bullet.BulletCollision.btTriangleMesh;
import org.bytedeco.bullet.LinearMath.btQuaternion;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.ConvexPolytope3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;

public class BulletTools {
    public static void toBullet(RigidBodyTransform rigidBodyTransform, btTransform bulletAffineToPack) {
        bulletAffineToPack.getOrigin().setValue(rigidBodyTransform.getTranslationX(), rigidBodyTransform.getTranslationY(), rigidBodyTransform.getTranslationZ());
        bulletAffineToPack.getBasis().setValue(rigidBodyTransform.getM00(), rigidBodyTransform.getM01(), rigidBodyTransform.getM02(), rigidBodyTransform.getM10(), rigidBodyTransform.getM11(), rigidBodyTransform.getM12(), rigidBodyTransform.getM20(), rigidBodyTransform.getM21(), rigidBodyTransform.getM22());
    }

    public static void toEuclid(btTransform bulletAffine, RigidBodyTransform rigidBodyTransform) {
        rigidBodyTransform.getRotation().setAndNormalize(bulletAffine.getBasis().getRow(0).getX(), bulletAffine.getBasis().getRow(0).getY(), bulletAffine.getBasis().getRow(0).getZ(), bulletAffine.getBasis().getRow(1).getX(), bulletAffine.getBasis().getRow(1).getY(), bulletAffine.getBasis().getRow(1).getZ(), bulletAffine.getBasis().getRow(2).getX(), bulletAffine.getBasis().getRow(2).getY(), bulletAffine.getBasis().getRow(2).getZ());
        rigidBodyTransform.getTranslation().setX(bulletAffine.getOrigin().getX());
        rigidBodyTransform.getTranslation().setY(bulletAffine.getOrigin().getY());
        rigidBodyTransform.getTranslation().setZ(bulletAffine.getOrigin().getZ());
    }

    public static void toBullet(Quaternion euclidQuaternion, btQuaternion bulletQuaternion) {
        bulletQuaternion.setValue(euclidQuaternion.getX(), euclidQuaternion.getY(), euclidQuaternion.getZ(), euclidQuaternion.getS());
    }

    public static void toEuclid(btQuaternion bulletQuaternion, Quaternion euclidQuaternion) {
        euclidQuaternion.set(bulletQuaternion.getX(), bulletQuaternion.getY(), bulletQuaternion.getZ(), bulletQuaternion.getW());
    }

    public static void toBullet(Tuple3DReadOnly euclidTuple, btVector3 bulletVector3) {
        bulletVector3.setValue(euclidTuple.getX(), euclidTuple.getY(), euclidTuple.getZ());
    }

    public static void toEuclid(btVector3 bulletVector3, Vector3DBasics euclidVector3D) {
        euclidVector3D.set(bulletVector3.getX(), bulletVector3.getY(), bulletVector3.getZ());
    }

    public static void toEuclid(btVector3 bulletVector3, Point3DBasics euclidPoint3D) {
        euclidPoint3D.set(bulletVector3.getX(), bulletVector3.getY(), bulletVector3.getZ());
    }

    public static btTriangleMesh convertTriangleMesh3D(RigidBodyTransformReadOnly meshPose, TriangleMesh3DDefinition triangleMesh3DDefinition) {
        btTriangleMesh btTriangleMesh2 = new btTriangleMesh(false, false);
        int[] triangleIndices = triangleMesh3DDefinition.getTriangleIndices();
        Point3D32[] vertices = triangleMesh3DDefinition.getVertices();
        boolean ignorePose = meshPose == null || !meshPose.hasRotation() && !meshPose.hasTranslation();
        Point3D32 v0 = new Point3D32();
        Point3D32 v1 = new Point3D32();
        Point3D32 v2 = new Point3D32();
        for (int i = 0; i < triangleIndices.length; i += 3) {
            if (ignorePose) {
                v0 = vertices[triangleIndices[i]];
                v1 = vertices[triangleIndices[i + 1]];
                v2 = vertices[triangleIndices[i + 2]];
            } else {
                meshPose.transform((Point3DReadOnly)vertices[triangleIndices[i]], (Point3DBasics)v0);
                meshPose.transform((Point3DReadOnly)vertices[triangleIndices[i + 1]], (Point3DBasics)v1);
                meshPose.transform((Point3DReadOnly)vertices[triangleIndices[i + 2]], (Point3DBasics)v2);
            }
            btTriangleMesh2.addTriangle(new btVector3(v0.getX(), v0.getY(), v0.getZ()), new btVector3(v1.getX(), v1.getY(), v1.getZ()), new btVector3(v2.getX(), v2.getY(), v2.getZ()));
        }
        return btTriangleMesh2;
    }

    public static btCollisionShape createBulletCollisionShape(CollisionShapeDefinition collisionShapeDefinition) {
        btSphereShape btCollisionShape2 = null;
        if (collisionShapeDefinition.getGeometryDefinition() instanceof TriangleMesh3DDefinition) {
            TriangleMesh3DDefinition triangleMesh3DDefinition = (TriangleMesh3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btTransform identity = new btTransform();
            btTriangleMesh btTriangleMesh2 = BulletTools.convertTriangleMesh3D((RigidBodyTransformReadOnly)collisionShapeDefinition.getOriginPose(), triangleMesh3DDefinition);
            if (collisionShapeDefinition.isConcave()) {
                btGImpactMeshShape btGImpactMeshShape2 = new btGImpactMeshShape((btStridingMeshInterface)btTriangleMesh2);
                btGImpactMeshShape2.updateBound();
                btCompoundFromGimpactShape compoundFromGimpactShape = new btCompoundFromGimpactShape();
                btGImpactMeshShape2.setMargin(0.01);
                compoundFromGimpactShape.addChildShape(identity, (btCollisionShape)btGImpactMeshShape2);
                btCollisionShape2 = compoundFromGimpactShape;
            } else {
                btConvexTriangleMeshShape btConvexTriangleMeshShape2 = new btConvexTriangleMeshShape((btStridingMeshInterface)btTriangleMesh2);
                btCompoundShape btCompoundShape2 = new btCompoundShape();
                btConvexTriangleMeshShape2.setMargin(0.01);
                btCompoundShape2.addChildShape(identity, (btCollisionShape)btConvexTriangleMeshShape2);
                btCollisionShape2 = btCompoundShape2;
            }
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Box3DDefinition) {
            Box3DDefinition boxGeometryDefinition = (Box3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btBoxShape boxShape = new btBoxShape(new btVector3(boxGeometryDefinition.getSizeX() / 2.0, boxGeometryDefinition.getSizeY() / 2.0, boxGeometryDefinition.getSizeZ() / 2.0));
            btCollisionShape2 = boxShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Sphere3DDefinition) {
            btSphereShape sphereShape;
            Sphere3DDefinition sphereGeometryDefinition = (Sphere3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btCollisionShape2 = sphereShape = new btSphereShape(sphereGeometryDefinition.getRadius());
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Cylinder3DDefinition) {
            Cylinder3DDefinition cylinderGeometryDefinition = (Cylinder3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btCylinderShapeZ cylinderShape = new btCylinderShapeZ(new btVector3(cylinderGeometryDefinition.getRadius(), cylinderGeometryDefinition.getRadius(), cylinderGeometryDefinition.getLength() / 2.0));
            btCollisionShape2 = cylinderShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Cone3DDefinition) {
            Cone3DDefinition coneGeometryDefinition = (Cone3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btConeShapeZ coneShape = new btConeShapeZ(coneGeometryDefinition.getRadius(), coneGeometryDefinition.getHeight());
            btCollisionShape2 = coneShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Capsule3DDefinition) {
            Capsule3DDefinition capsuleGeometryDefinition = (Capsule3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            if (capsuleGeometryDefinition.getRadiusX() != capsuleGeometryDefinition.getRadiusY() || capsuleGeometryDefinition.getRadiusX() != capsuleGeometryDefinition.getRadiusZ() || capsuleGeometryDefinition.getRadiusY() != capsuleGeometryDefinition.getRadiusZ()) {
                LogTools.warn((String)"Bullet capsule does not fully represent the intended capsule!");
            }
            btCapsuleShapeZ capsuleShape = new btCapsuleShapeZ(capsuleGeometryDefinition.getRadiusX(), capsuleGeometryDefinition.getLength());
            btCollisionShape2 = capsuleShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof ConvexPolytope3DDefinition) {
            ConvexPolytope3DDefinition convexPolytopeDefinition = (ConvexPolytope3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btConvexHullShape convexHullShape = new btConvexHullShape();
            for (Face3DReadOnly face : convexPolytopeDefinition.getConvexPolytope().getFaces()) {
                for (Vertex3DReadOnly vertex : face.getVertices()) {
                    convexHullShape.addPoint(new btVector3(vertex.getX(), vertex.getY(), vertex.getZ()));
                }
            }
            btCollisionShape2 = convexHullShape;
        } else {
            throw new UnsupportedOperationException("Unsupported shape: " + collisionShapeDefinition.getGeometryDefinition().getClass().getSimpleName());
        }
        return btCollisionShape2;
    }

    public static enum eFeatherstoneJointType {
        eRevolute,
        ePrismatic,
        eSpherical,
        ePlanar,
        eFixed,
        eInvalid;

    }
}

