/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btBroadphaseInterface;
import com.badlogic.gdx.physics.bullet.collision.btCollisionConfiguration;
import com.badlogic.gdx.physics.bullet.collision.btCollisionDispatcher;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btDbvtBroadphase;
import com.badlogic.gdx.physics.bullet.collision.btDefaultCollisionConfiguration;
import com.badlogic.gdx.physics.bullet.collision.btDispatcher;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyConstraintSolver;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyDynamicsWorld;
import com.badlogic.gdx.physics.bullet.linearmath.btIDebugDraw;
import java.util.ArrayList;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainObject;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletContactSolverInfoParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;

public class BulletMultiBodyDynamicsWorld {
    private final btCollisionConfiguration btCollisionConfiguration;
    private final btCollisionDispatcher btCollisionDispatcher;
    private final btBroadphaseInterface btBroadphaseInterface;
    private final btMultiBodyConstraintSolver btMultiBodyConstraintSolver;
    private final btMultiBodyDynamicsWorld btMultiBodyDynamicsWorld;
    private btIDebugDraw btIDebugDraw = null;
    private final ArrayList<BulletTerrainObject> terrainObjects = new ArrayList();
    private final ArrayList<BulletMultiBodyRobot> multiBodyRobots = new ArrayList();
    private final Vector3 btGravity = new Vector3();

    public BulletMultiBodyDynamicsWorld() {
        this.btCollisionConfiguration = new btDefaultCollisionConfiguration();
        this.btCollisionDispatcher = new btCollisionDispatcher(this.btCollisionConfiguration);
        this.btBroadphaseInterface = new btDbvtBroadphase();
        this.btMultiBodyConstraintSolver = new btMultiBodyConstraintSolver();
        this.btMultiBodyDynamicsWorld = new btMultiBodyDynamicsWorld((btDispatcher)this.btCollisionDispatcher, this.btBroadphaseInterface, this.btMultiBodyConstraintSolver, this.btCollisionConfiguration);
    }

    public void setGravity(Tuple3DReadOnly gravity) {
        this.btGravity.set(gravity.getX32(), gravity.getY32(), gravity.getZ32());
        this.btMultiBodyDynamicsWorld.setGravity(this.btGravity);
    }

    public int stepSimulation(float timeStep, int maxSubSteps, float fixedTimeStep) {
        return this.btMultiBodyDynamicsWorld.stepSimulation(timeStep, maxSubSteps, fixedTimeStep);
    }

    public int stepSimulation(float timeStep, int maxSubSteps) {
        return this.btMultiBodyDynamicsWorld.stepSimulation(timeStep, maxSubSteps);
    }

    public int stepSimulation(float timeStep) {
        return this.btMultiBodyDynamicsWorld.stepSimulation(timeStep);
    }

    public btMultiBodyDynamicsWorld getBtMultiBodyDynamicsWorld() {
        return this.btMultiBodyDynamicsWorld;
    }

    public void dispose() {
        if (!this.btMultiBodyDynamicsWorld.isDisposed()) {
            for (BulletTerrainObject bulletTerrainObject : this.terrainObjects) {
                bulletTerrainObject.getBtRigidBody().getCollisionShape().dispose();
                bulletTerrainObject.getBtRigidBody().getMotionState().dispose();
                this.btMultiBodyDynamicsWorld.removeRigidBody(bulletTerrainObject.getBtRigidBody());
                bulletTerrainObject.getBtRigidBody().dispose();
            }
            for (BulletMultiBodyRobot bulletMultiBodyRobot : this.multiBodyRobots) {
                int i;
                for (i = 0; i < this.btMultiBodyDynamicsWorld.getNumConstraints(); ++i) {
                    this.btMultiBodyDynamicsWorld.removeConstraint(this.btMultiBodyDynamicsWorld.getConstraint(i));
                }
                for (btMultiBodyConstraint bulletMultiBodyConstraint : bulletMultiBodyRobot.getBtMultiBodyConstraintArray()) {
                    this.btMultiBodyDynamicsWorld.removeMultiBodyConstraint(bulletMultiBodyConstraint);
                    bulletMultiBodyConstraint.dispose();
                }
                this.btMultiBodyDynamicsWorld.removeMultiBody(bulletMultiBodyRobot.getBtMultiBody());
                for (BulletMultiBodyLinkCollider multiBodyLinkCollider : bulletMultiBodyRobot.getBulletMultiBodyLinkColliderArray()) {
                    this.btMultiBodyDynamicsWorld.removeCollisionObject((btCollisionObject)multiBodyLinkCollider.getBtMultiBodyLinkCollider());
                    multiBodyLinkCollider.getBtMultiBodyLinkCollider().getCollisionShape().dispose();
                    multiBodyLinkCollider.getBtMultiBodyLinkCollider().dispose();
                }
                for (i = 0; bulletMultiBodyRobot.getBtMultiBody().getNumLinks() < i; ++i) {
                    bulletMultiBodyRobot.getBtMultiBody().getLink(i).dispose();
                }
                bulletMultiBodyRobot.getBtMultiBody().dispose();
            }
            if (this.btIDebugDraw != null) {
                this.btIDebugDraw.dispose();
            }
            this.btMultiBodyDynamicsWorld.dispose();
            this.btMultiBodyConstraintSolver.dispose();
            this.btBroadphaseInterface.dispose();
            this.btCollisionDispatcher.dispose();
            this.btCollisionConfiguration.dispose();
        }
    }

    public void addBulletMultiBodyRobot(BulletMultiBodyRobot bulletMultiBodyRobot) {
        this.multiBodyRobots.add(bulletMultiBodyRobot);
        for (BulletMultiBodyLinkCollider linkCollider : bulletMultiBodyRobot.getBulletMultiBodyLinkColliderArray()) {
            this.btMultiBodyDynamicsWorld.addCollisionObject((btCollisionObject)linkCollider.getBtMultiBodyLinkCollider(), linkCollider.getCollisionGroup(), linkCollider.getCollisionGroupMask());
        }
        for (btMultiBodyConstraint constraint : bulletMultiBodyRobot.getBtMultiBodyConstraintArray()) {
            this.btMultiBodyDynamicsWorld.addMultiBodyConstraint(constraint);
        }
        this.btMultiBodyDynamicsWorld.addMultiBody(bulletMultiBodyRobot.getBtMultiBody());
    }

    public void addBulletTerrainObject(BulletTerrainObject bulletTerrainObject) {
        this.terrainObjects.add(bulletTerrainObject);
        this.btMultiBodyDynamicsWorld.addRigidBody(bulletTerrainObject.getBtRigidBody(), bulletTerrainObject.getCollisionGroup(), bulletTerrainObject.getCollisionGroupMask());
        bulletTerrainObject.getBtRigidBody().setCollisionFlags(bulletTerrainObject.getBtRigidBody().getCollisionFlags() | 2);
        bulletTerrainObject.getBtRigidBody().setActivationState(4);
    }

    public void updateAllMultiBodyParameters(YoBulletMultiBodyParameters multiBodyParameters) {
        for (BulletMultiBodyRobot bulletMultiBodyRobot : this.multiBodyRobots) {
            bulletMultiBodyRobot.setMultiBodyParameters(multiBodyParameters);
        }
    }

    public void updateAllMultiBodyJointParameters(YoBulletMultiBodyJointParameters multiBodyJointParameters) {
        for (BulletMultiBodyRobot bulletMultiBodyRobot : this.multiBodyRobots) {
            bulletMultiBodyRobot.setMultiBodyJointParameters(multiBodyJointParameters);
        }
    }

    public void setBtDebugDrawer(btIDebugDraw btIDebugDraw2) {
        if (!this.btMultiBodyDynamicsWorld.isDisposed()) {
            this.btMultiBodyDynamicsWorld.setDebugDrawer(btIDebugDraw2);
        }
        this.btIDebugDraw = btIDebugDraw2;
    }

    public void debugDrawWorld() {
        if (!this.btMultiBodyDynamicsWorld.isDisposed()) {
            this.btMultiBodyDynamicsWorld.debugDrawWorld();
        }
    }

    public void updateContactSolverInfoParameters(YoBulletContactSolverInfoParameters globalContactSolverInfoParameters) {
        this.btMultiBodyDynamicsWorld.getSolverInfo().setTau((float)globalContactSolverInfoParameters.getTau());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setDamping((float)globalContactSolverInfoParameters.getDamping());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setFriction((float)globalContactSolverInfoParameters.getFriction());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setTimeStep((float)globalContactSolverInfoParameters.getTimeStep());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setRestitution((float)globalContactSolverInfoParameters.getRestitution());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setMaxErrorReduction((float)globalContactSolverInfoParameters.getMaxErrorReduction());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setNumIterations(globalContactSolverInfoParameters.getNumberOfIterations());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setErp((float)globalContactSolverInfoParameters.getErrorReductionForNonContactConstraints());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setErp2((float)globalContactSolverInfoParameters.getErrorReductionForContactConstraints());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setGlobalCfm((float)globalContactSolverInfoParameters.getConstraintForceMixingForContactsAndNonContacts());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setFrictionERP((float)globalContactSolverInfoParameters.getErrorReductionForFrictionConstraints());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setFrictionCFM((float)globalContactSolverInfoParameters.getConstraintForceMixingForFrictionConstraints());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setSor((float)globalContactSolverInfoParameters.getSuccessiveOverRelaxationTerm());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setSplitImpulse(globalContactSolverInfoParameters.getSplitImpulse());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setSplitImpulsePenetrationThreshold((float)globalContactSolverInfoParameters.getSplitImpulsePenetrationThreshold());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setSplitImpulseTurnErp((float)globalContactSolverInfoParameters.getSplitImpulseTurnErp());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setLinearSlop((float)globalContactSolverInfoParameters.getLinearSlop());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setWarmstartingFactor((float)globalContactSolverInfoParameters.getWarmstartingFactor());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setSolverMode(globalContactSolverInfoParameters.getSolverMode());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setRestingContactRestitutionThreshold(globalContactSolverInfoParameters.getRestingContactRestitutionThreshold());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setMinimumSolverBatchSize(globalContactSolverInfoParameters.getMinimumSolverBatchSize());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setMaxGyroscopicForce((float)globalContactSolverInfoParameters.getMaxGyroscopicForce());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setSingleAxisRollingFrictionThreshold((float)globalContactSolverInfoParameters.getSingleAxisRollingFrictionThreshold());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setLeastSquaresResidualThreshold((float)globalContactSolverInfoParameters.getLeastSquaresResidualThreshold());
        this.btMultiBodyDynamicsWorld.getSolverInfo().setRestitutionVelocityThreshold((float)globalContactSolverInfoParameters.getRestitutionVelocityThreshold());
    }
}

