/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyLinkCollider;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public class BulletMultiBodyLinkCollider {
    private final btMultiBodyLinkCollider btMultiBodyLinkCollider;
    private final btMultiBody btMultiBody;
    private final String jointName;
    private final int linkColliderIndex;
    private final Matrix4 bulletTempConversionMatrix4 = new Matrix4();
    private final Vector3 bulletTempConversionVector3 = new Vector3();
    private final btVector3 linkForce;
    private final btVector3 linkTorque;
    private int collisionGroup;
    private int collisionGroupMask;

    public BulletMultiBodyLinkCollider(btMultiBody btMultibody, int index, String jointName) {
        this.btMultiBodyLinkCollider = new btMultiBodyLinkCollider(btMultibody, index);
        this.linkColliderIndex = index;
        this.jointName = jointName;
        this.collisionGroup = 2;
        this.collisionGroupMask = 3;
        this.btMultiBody = this.btMultiBodyLinkCollider.getMultiBody();
        this.linkForce = this.btMultiBody.getLink(this.linkColliderIndex).getAppliedConstraintForce();
        this.linkTorque = this.btMultiBody.getLink(this.linkColliderIndex).getAppliedConstraintTorque();
    }

    public void setCollisionGroupMask(int collisionGroup, int collisionGroupMask) {
        this.collisionGroup = collisionGroup;
        this.collisionGroupMask = collisionGroupMask;
    }

    public void setCollisionShape(btCollisionShape shape) {
        this.btMultiBodyLinkCollider.setCollisionShape(shape);
    }

    public void setFriction(double friction) {
        this.btMultiBodyLinkCollider.setFriction((float)friction);
    }

    public void setRestitution(double restitution) {
        this.btMultiBodyLinkCollider.setRestitution((float)restitution);
    }

    public void setHitFraction(double hitFraction) {
        this.btMultiBodyLinkCollider.setHitFraction((float)hitFraction);
    }

    public void setRollingFriction(double rollingFriction) {
        this.btMultiBodyLinkCollider.setRollingFriction((float)rollingFriction);
    }

    public void setSpinningFriction(double spinningFriction) {
        this.btMultiBodyLinkCollider.setSpinningFriction((float)spinningFriction);
    }

    public void setContactProcessingThreshold(double contactProcessingThreshold) {
        this.btMultiBodyLinkCollider.setContactProcessingThreshold((float)contactProcessingThreshold);
    }

    public btMultiBodyLinkCollider getBtMultiBodyLinkCollider() {
        return this.btMultiBodyLinkCollider;
    }

    public int getCollisionGroup() {
        return this.collisionGroup;
    }

    public int getCollisionGroupMask() {
        return this.collisionGroupMask;
    }

    public String getJointName() {
        return this.jointName;
    }

    public void getWorldTransform(RigidBodyTransform jointSuccessorBodyFixedFrameToWorldEuclid) {
        this.btMultiBodyLinkCollider.getWorldTransform(this.bulletTempConversionMatrix4);
        BulletTools.toEuclid(this.bulletTempConversionMatrix4, jointSuccessorBodyFixedFrameToWorldEuclid);
    }

    public void setWorldTransform(RigidBodyTransform bulletColliderCenterOfMassTransformToWorldEuclid) {
        BulletTools.toBullet(bulletColliderCenterOfMassTransformToWorldEuclid, this.bulletTempConversionMatrix4);
        this.btMultiBodyLinkCollider.setWorldTransform(this.bulletTempConversionMatrix4);
        if (this.linkColliderIndex == -1) {
            this.btMultiBody.setBaseWorldTransform(this.bulletTempConversionMatrix4);
        }
    }

    public void setJointPos(double jointPosition) {
        this.btMultiBody.setJointPos(this.linkColliderIndex, (float)jointPosition);
    }

    public void setJointVel(double jointVelocity) {
        this.btMultiBody.setJointVel(this.linkColliderIndex, (float)jointVelocity);
    }

    public void addJointTorque(double jointTau) {
        this.btMultiBody.addJointTorque(this.linkColliderIndex, (float)jointTau);
    }

    public float getJointPos() {
        return this.btMultiBody.getJointPos(this.linkColliderIndex);
    }

    public float getJointVel() {
        return this.btMultiBody.getJointVel(this.linkColliderIndex);
    }

    public void getAppliedConstraintForce(Vector3D force) {
        force.set((double)this.linkForce.getX(), (double)this.linkForce.getY(), (double)this.linkForce.getZ());
    }

    public void getAppliedConstraintTorque(Vector3D torque) {
        torque.set((double)this.linkTorque.getX(), (double)this.linkTorque.getY(), (double)this.linkTorque.getZ());
    }

    public void setBaseVel(Vector3DReadOnly linearVelocityEuclid) {
        BulletTools.toBullet((Tuple3DReadOnly)linearVelocityEuclid, this.bulletTempConversionVector3);
        this.btMultiBody.setBaseVel(this.bulletTempConversionVector3);
    }

    public void setBaseOmega(Vector3DReadOnly angularVelocityBulletEuclid) {
        BulletTools.toBullet((Tuple3DReadOnly)angularVelocityBulletEuclid, this.bulletTempConversionVector3);
        this.btMultiBody.setBaseOmega(this.bulletTempConversionVector3);
    }

    public void getBaseVel(Vector3D bulletBaseLinearVelocityEuclid) {
        BulletTools.toEuclid(this.btMultiBody.getBaseVel(), (Vector3DBasics)bulletBaseLinearVelocityEuclid);
    }

    public void getBaseOmega(Vector3D bulletBaseAngularVelocityEuclid) {
        BulletTools.toEuclid(this.btMultiBody.getBaseOmega(), (Vector3DBasics)bulletBaseAngularVelocityEuclid);
    }
}

