/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader;

import java.util.HashSet;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIVector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.log.LogTools;

public class AssimpVertexLoader {
    public static final int MAX_VERTICES = 65538;
    private final AIMesh assimpMesh;
    private boolean hasNormals;
    private boolean hasTangents;
    private boolean hasBitangents;
    private boolean hasColors;
    private boolean hasTextureCoordinates;
    private int numberOfVertices;
    private final HashSet<Vector3D32> uniqueVertices = new HashSet();

    public AssimpVertexLoader(AIMesh assimpMesh) {
        this.assimpMesh = assimpMesh;
    }

    public HashSet<Vector3D32> loadVertices() {
        this.numberOfVertices = this.assimpMesh.mNumVertices();
        LogTools.debug((String)"Number of vertices: {}", (Object)this.numberOfVertices);
        if (this.numberOfVertices > 65538) {
            LogTools.error((String)"Mesh contains too many vertices! {}/{}", (Object)this.numberOfVertices, (Object)65538);
        }
        this.hasNormals = this.assimpMesh.mNormals() != null;
        LogTools.debug((String)"Has normals: {}", (Object)this.hasNormals);
        this.hasTangents = this.assimpMesh.mTangents() != null;
        LogTools.debug((String)"Has tangents: {}", (Object)this.hasTangents);
        this.hasBitangents = this.assimpMesh.mTangents() != null;
        LogTools.debug((String)"Has bitangents: {}", (Object)this.hasBitangents);
        this.hasColors = this.assimpMesh.mColors(0) != null;
        LogTools.debug((String)"Has colors: {}", (Object)this.hasColors);
        this.hasTextureCoordinates = this.assimpMesh.mTextureCoords(0) != null;
        LogTools.debug((String)"Has texture coordinates: {}", (Object)this.hasTextureCoordinates);
        HashSet<Vector3D32> uniqueVertices = new HashSet<Vector3D32>();
        AIVector3D.Buffer assimpVerticesVector3DS = this.assimpMesh.mVertices();
        for (int j = 0; j < this.numberOfVertices; ++j) {
            float f;
            float x = ((AIVector3D)assimpVerticesVector3DS.get(j)).x();
            float y = ((AIVector3D)assimpVerticesVector3DS.get(j)).y();
            float z = ((AIVector3D)assimpVerticesVector3DS.get(j)).z();
            Vector3D32 vertexPosition = new Vector3D32(x, y, z);
            uniqueVertices.add(vertexPosition);
            if (this.hasNormals) {
                float normalX = ((AIVector3D)this.assimpMesh.mNormals().get(j)).x();
                float normalY = ((AIVector3D)this.assimpMesh.mNormals().get(j)).y();
                f = ((AIVector3D)this.assimpMesh.mNormals().get(j)).z();
            }
            if (this.hasTangents) {
                float tangentX = ((AIVector3D)this.assimpMesh.mTangents().get(j)).x();
                float tangentY = ((AIVector3D)this.assimpMesh.mTangents().get(j)).y();
                f = ((AIVector3D)this.assimpMesh.mTangents().get(j)).z();
            }
            if (this.hasBitangents) {
                float bitangentX = ((AIVector3D)this.assimpMesh.mBitangents().get(j)).x();
                float bitangentY = ((AIVector3D)this.assimpMesh.mBitangents().get(j)).y();
                f = ((AIVector3D)this.assimpMesh.mBitangents().get(j)).z();
            }
            if (this.hasColors) {
                float r = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).r();
                float g = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).g();
                float b = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).b();
                float f2 = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).a();
            }
            if (!this.hasTextureCoordinates) continue;
            float textureX = ((AIVector3D)this.assimpMesh.mTextureCoords(0).get(j)).x();
            float f3 = ((AIVector3D)this.assimpMesh.mTextureCoords(0).get(j)).y();
        }
        LogTools.debug((String)"Unique vertices: {}", (Object)uniqueVertices.size());
        return uniqueVertices;
    }
}

