/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIPropertyStore;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.Assimp;
import org.lwjgl.system.MemoryUtil;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader.AssimpResourceImporter;
import us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader.AssimpTriangleLoader;
import us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader.AssimpVertexLoader;

public class AssimpLoader {
    public static void iterateMeshes(String modelFilePath, Consumer<AIMesh> assimpMeshConsumer) {
        AssimpResourceImporter assimpResourceImporter = new AssimpResourceImporter();
        AIPropertyStore assimpPropertyStore = Assimp.aiCreatePropertyStore();
        int postProcessingSteps = 0;
        postProcessingSteps += 0x800000;
        postProcessingSteps += 8;
        Assimp.aiSetImportPropertyInteger((AIPropertyStore)assimpPropertyStore, (CharSequence)"PP_SLM_VERTEX_LIMIT", (int)65536);
        AIScene assimpScene = assimpResourceImporter.importScene(modelFilePath, postProcessingSteps += 128, assimpPropertyStore);
        PointerBuffer meshesPointerBuffer = assimpScene.mMeshes();
        int numberOfMeshes = assimpScene.mNumMeshes();
        for (int i = 0; i < numberOfMeshes; ++i) {
            AIMesh assimpMesh = new AIMesh(MemoryUtil.memByteBuffer((long)meshesPointerBuffer.get(i), (int)AIMesh.SIZEOF));
            assimpMeshConsumer.accept(assimpMesh);
        }
    }

    public static List<FloatBuffer> loadTriangleVertexPositionsAsFloatBuffer(String modelFilePath) {
        ArrayList<FloatBuffer> vertexBuffers = new ArrayList<FloatBuffer>();
        AssimpLoader.iterateMeshes(modelFilePath, assimpMesh -> {
            AssimpTriangleLoader assimpTriangleLoader = new AssimpTriangleLoader((AIMesh)assimpMesh);
            FloatBuffer vetricesFloatBuffer = assimpTriangleLoader.loadVerticesAsFloatBuffer();
            vertexBuffers.add(vetricesFloatBuffer);
        });
        return vertexBuffers;
    }

    public static List<List<Point3D32>> loadTriangleVertexPositionsAsList(String modelFilePath) {
        ArrayList<List<Point3D32>> vertexLists = new ArrayList<List<Point3D32>>();
        AssimpLoader.iterateMeshes(modelFilePath, assimpMesh -> {
            AssimpTriangleLoader assimpTriangleLoader = new AssimpTriangleLoader((AIMesh)assimpMesh);
            ArrayList<Point3D32> vertexList = assimpTriangleLoader.loadVerticesAsList();
            vertexLists.add(vertexList);
        });
        return vertexLists;
    }

    public static List<HashSet<Vector3D32>> loadUniqueVertexPositions(String modelFilePath) {
        ArrayList<HashSet<Vector3D32>> vertexSets = new ArrayList<HashSet<Vector3D32>>();
        AssimpLoader.iterateMeshes(modelFilePath, assimpMesh -> {
            AssimpVertexLoader assimpVertexLoader = new AssimpVertexLoader((AIMesh)assimpMesh);
            vertexSets.add(assimpVertexLoader.loadVertices());
        });
        return vertexSets;
    }
}

