/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexHullShape;
import com.badlogic.gdx.physics.bullet.collision.btCylinderShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyDynamicsWorld;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.linearmath.btMotionState;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.ConvexPolytope3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public class BulletTerrainObject {
    private final btMotionState bulletMotionState = new btMotionState(){

        public void setWorldTransform(Matrix4 transformToWorld) {
        }

        public void getWorldTransform(Matrix4 transformToWorld) {
        }
    };
    private final btRigidBody bulletRigidBody;
    private final btMultiBodyDynamicsWorld multiBodyDynamicsWorld;

    public BulletTerrainObject(TerrainObjectDefinition terrainObjectDefinition, btMultiBodyDynamicsWorld multiBodyDynamicsWorld) {
        this.multiBodyDynamicsWorld = multiBodyDynamicsWorld;
        btCompoundShape bulletCompoundCollisionShape = new btCompoundShape();
        for (CollisionShapeDefinition collisionShapeDefinition : terrainObjectDefinition.getCollisionShapeDefinitions()) {
            btSphereShape bulletCollisionShape = null;
            if (collisionShapeDefinition.getGeometryDefinition() instanceof Box3DDefinition) {
                Box3DDefinition boxGeometryDefinition = (Box3DDefinition)collisionShapeDefinition.getGeometryDefinition();
                btBoxShape boxShape = new btBoxShape(new Vector3((float)boxGeometryDefinition.getSizeX() / 2.0f, (float)boxGeometryDefinition.getSizeY() / 2.0f, (float)boxGeometryDefinition.getSizeZ() / 2.0f));
                bulletCollisionShape = boxShape;
            } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Sphere3DDefinition) {
                btSphereShape sphereShape;
                Sphere3DDefinition sphereGeometryDefinition = (Sphere3DDefinition)collisionShapeDefinition.getGeometryDefinition();
                bulletCollisionShape = sphereShape = new btSphereShape((float)sphereGeometryDefinition.getRadius());
            } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Cylinder3DDefinition) {
                Cylinder3DDefinition cylinderGeometryDefinition = (Cylinder3DDefinition)collisionShapeDefinition.getGeometryDefinition();
                btCylinderShapeZ cylinderShape = new btCylinderShapeZ(new Vector3((float)cylinderGeometryDefinition.getRadius(), (float)cylinderGeometryDefinition.getRadius(), (float)cylinderGeometryDefinition.getLength() / 2.0f));
                bulletCollisionShape = cylinderShape;
            } else if (collisionShapeDefinition.getGeometryDefinition() instanceof ConvexPolytope3DDefinition) {
                ConvexPolytope3DDefinition convexPolytopeDefinition = (ConvexPolytope3DDefinition)collisionShapeDefinition.getGeometryDefinition();
                btConvexHullShape convexHullShape = new btConvexHullShape();
                for (Face3DReadOnly face : convexPolytopeDefinition.getConvexPolytope().getFaces()) {
                    for (Vertex3DReadOnly vertex : face.getVertices()) {
                        convexHullShape.addPoint(new Vector3(vertex.getX32(), vertex.getY32(), vertex.getZ32()));
                    }
                }
                bulletCollisionShape = convexHullShape;
            } else {
                LogTools.warn((String)"Implement collision for {}", (Object)collisionShapeDefinition.getGeometryDefinition().getClass().getSimpleName());
            }
            Matrix4 bulletTransformToWorld = new Matrix4();
            RigidBodyTransform collisionShapeDefinitionTransformToWorld = new RigidBodyTransform((Orientation3DReadOnly)collisionShapeDefinition.getOriginPose().getRotation(), (Tuple3DReadOnly)collisionShapeDefinition.getOriginPose().getTranslation());
            BulletTools.toBullet(collisionShapeDefinitionTransformToWorld, bulletTransformToWorld);
            bulletCompoundCollisionShape.addChildShape(bulletTransformToWorld, (btCollisionShape)bulletCollisionShape);
        }
        this.bulletRigidBody = BulletTools.addStaticObjectToBulletWorld(multiBodyDynamicsWorld, (btCollisionShape)bulletCompoundCollisionShape, this.bulletMotionState);
    }

    public btRigidBody getBulletRigidBody() {
        return this.bulletRigidBody;
    }
}

