/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;

public class BulletRobotPhysics {
    private final RobotInterface owner;
    private final ReferenceFrame inertialFrame;
    private final RigidBodyWrenchRegistry rigidBodyWrenchRegistry = new RigidBodyWrenchRegistry();
    private final SpatialAccelerationCalculator spatialAccelerationCalculator;
    private final RobotPhysicsOutput physicsOutput;

    public BulletRobotPhysics(RobotInterface owner) {
        this.owner = owner;
        this.inertialFrame = owner.getInertialFrame();
        SimRigidBodyBasics rootBody = owner.getRootBody();
        this.spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, this.inertialFrame, false);
        this.spatialAccelerationCalculator.setGravitionalAcceleration(-9.81);
        this.physicsOutput = new RobotPhysicsOutput((RigidBodyAccelerationProvider)this.spatialAccelerationCalculator, null, (Function)this.rigidBodyWrenchRegistry, null);
    }

    public void reset() {
        this.rigidBodyWrenchRegistry.reset();
    }

    public void update(double dt) {
        this.spatialAccelerationCalculator.reset();
        this.physicsOutput.setDT(dt);
    }

    public RobotPhysicsOutput getPhysicsOutput() {
        return this.physicsOutput;
    }

    public RigidBodyWrenchRegistry getRigidBodyWrenchRegistry() {
        return this.rigidBodyWrenchRegistry;
    }
}

