/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyJointLimitConstraint;
import com.badlogic.gdx.physics.bullet.dynamics.btMultibodyLink;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import java.util.HashMap;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkBasics;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkCollisionSet;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BulletRobotLinkRevolute
extends BulletRobotLinkBasics {
    private final RevoluteJointDefinition revoluteJointDefinition;
    private final SimRevoluteJoint simRevoluteJoint;
    private int parentBulletJointIndex;
    private final RigidBodyWrenchRegistry rigidBodyWrenchRegistry;
    private btMultibodyLink bulletLink;
    private YoDouble damping;
    private YoDouble bulletJointPosition;
    private YoDouble bulletJointVelocity;
    private YoDouble bulletJointVelocityTest;
    private YoDouble bulletUserAddedTorque;
    private YoDouble bulletJointTorque;
    private YoDouble bulletLinkAppliedForceX;
    private YoDouble bulletLinkAppliedForceY;
    private YoDouble bulletLinkAppliedForceZ;
    private YoDouble bulletLinkAppliedTorqueX;
    private YoDouble bulletLinkAppliedTorqueY;
    private YoDouble bulletLinkAppliedTorqueZ;
    private btMultiBodyConstraint multiBodyJointLimitConstraint;

    public BulletRobotLinkRevolute(RevoluteJointDefinition revoluteJointDefinition, SimRevoluteJoint simRevoluteJoint, HashMap<String, Integer> jointNameToBulletJointIndexMap, RigidBodyWrenchRegistry rigidBodyWrenchRegistry, YoRegistry yoRegistry) {
        super(revoluteJointDefinition.getSuccessor(), simRevoluteJoint.getSuccessor(), jointNameToBulletJointIndexMap, rigidBodyWrenchRegistry);
        this.revoluteJointDefinition = revoluteJointDefinition;
        this.simRevoluteJoint = simRevoluteJoint;
        this.rigidBodyWrenchRegistry = rigidBodyWrenchRegistry;
        this.setBulletJointIndex(jointNameToBulletJointIndexMap.get(revoluteJointDefinition.getName()));
        this.parentBulletJointIndex = jointNameToBulletJointIndexMap.get(revoluteJointDefinition.getParentJoint().getName());
        this.addChildLinks(yoRegistry);
        this.damping = new YoDouble(simRevoluteJoint.getName() + "_damping", yoRegistry);
        this.bulletJointPosition = new YoDouble(simRevoluteJoint.getName() + "_q", yoRegistry);
        this.bulletJointVelocity = new YoDouble(simRevoluteJoint.getName() + "_qd", yoRegistry);
        this.bulletJointVelocityTest = new YoDouble(simRevoluteJoint.getName() + "_qdTest", yoRegistry);
        this.bulletUserAddedTorque = new YoDouble(simRevoluteJoint.getName() + "_btUserAddedTorque", yoRegistry);
        this.bulletJointTorque = new YoDouble(simRevoluteJoint.getName() + "_btJointTorque", yoRegistry);
        this.bulletLinkAppliedForceX = new YoDouble(simRevoluteJoint.getName() + "_btAppliedForceX", yoRegistry);
        this.bulletLinkAppliedForceY = new YoDouble(simRevoluteJoint.getName() + "_btAppliedForceY", yoRegistry);
        this.bulletLinkAppliedForceZ = new YoDouble(simRevoluteJoint.getName() + "_btAppliedForceZ", yoRegistry);
        this.bulletLinkAppliedTorqueX = new YoDouble(simRevoluteJoint.getName() + "_btAppliedTorqueX", yoRegistry);
        this.bulletLinkAppliedTorqueY = new YoDouble(simRevoluteJoint.getName() + "_btAppliedTorqueY", yoRegistry);
        this.bulletLinkAppliedTorqueZ = new YoDouble(simRevoluteJoint.getName() + "_btAppliedTorqueZ", yoRegistry);
    }

    @Override
    public void setup(BulletPhysicsEngine bulletPhysicsEngine) {
        Quaternion rotationFromParentGDX = new Quaternion();
        us.ihmc.euclid.tuple4D.Quaternion euclidRotationFromParent = new us.ihmc.euclid.tuple4D.Quaternion((Orientation3DReadOnly)this.revoluteJointDefinition.getTransformToParent().getRotation());
        euclidRotationFromParent.invert();
        BulletTools.toBullet(euclidRotationFromParent, rotationFromParentGDX);
        RigidBodyTransform parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid = new RigidBodyTransform();
        this.simRevoluteJoint.getPredecessor().getBodyFixedFrame().getTransformToDesiredFrame(parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid, (ReferenceFrame)this.simRevoluteJoint.getFrameBeforeJoint());
        parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.invert();
        Vector3 parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationGDX = new Vector3();
        BulletTools.toBullet((Tuple3DReadOnly)parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.getTranslation(), parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationGDX);
        RigidBodyTransform parentJointAfterFrameToLinkCenterOfMassTransformEuclid = new RigidBodyTransform();
        this.simRevoluteJoint.getFrameAfterJoint().getTransformToDesiredFrame(parentJointAfterFrameToLinkCenterOfMassTransformEuclid, (ReferenceFrame)this.getSimRigidBody().getBodyFixedFrame());
        parentJointAfterFrameToLinkCenterOfMassTransformEuclid.invert();
        Vector3 parentJointAfterFrameToLinkCenterOfMassTranslationGDX = new Vector3();
        BulletTools.toBullet((Tuple3DReadOnly)parentJointAfterFrameToLinkCenterOfMassTransformEuclid.getTranslation(), parentJointAfterFrameToLinkCenterOfMassTranslationGDX);
        float linkMass = (float)this.getRigidBodyDefinition().getMass();
        Vector3 baseInertiaDiagonal = new Vector3((float)this.getRigidBodyDefinition().getMomentOfInertia().getM00(), (float)this.getRigidBodyDefinition().getMomentOfInertia().getM11(), (float)this.getRigidBodyDefinition().getMomentOfInertia().getM22());
        BulletRobotLinkCollisionSet bulletCollisionSet = this.createBulletCollisionShape();
        Vector3 jointAxis = new Vector3();
        BulletTools.toBullet((Tuple3DReadOnly)this.revoluteJointDefinition.getAxis(), jointAxis);
        boolean disableParentCollision = true;
        this.getBulletMultiBody().setupRevolute(this.getBulletJointIndex(), linkMass, baseInertiaDiagonal, this.parentBulletJointIndex, rotationFromParentGDX, jointAxis, parentLinkCenterOfMassToParentJointBeforeJointFrameTranslationGDX, parentJointAfterFrameToLinkCenterOfMassTranslationGDX, disableParentCollision);
        this.multiBodyJointLimitConstraint = new btMultiBodyJointLimitConstraint(this.getBulletMultiBody(), this.getBulletJointIndex(), (float)this.revoluteJointDefinition.getPositionLowerLimit(), (float)this.revoluteJointDefinition.getPositionUpperLimit());
        this.multiBodyJointLimitConstraint.setMaxAppliedImpulse((float)this.revoluteJointDefinition.getEffortUpperLimit());
        bulletPhysicsEngine.getBulletMultiBodyDynamicsWorld().addMultiBodyConstraint(this.multiBodyJointLimitConstraint);
        this.bulletLink = this.getBulletMultiBody().getLink(this.getBulletJointIndex());
        this.createBulletCollider(bulletPhysicsEngine);
        this.bulletLink.setCollider(this.getBulletMultiBodyLinkCollider());
    }

    @Override
    public void copyDataFromSCSToBullet() {
        this.updateBulletLinkColliderTransformFromMecanoRigidBody();
        this.getBulletMultiBody().setJointPos(this.getBulletJointIndex(), (float)this.simRevoluteJoint.getQ());
        this.getBulletMultiBody().setJointVel(this.getBulletJointIndex(), (float)this.simRevoluteJoint.getQd());
        this.getBulletMultiBody().addJointTorque(this.getBulletJointIndex(), (float)this.simRevoluteJoint.getTau());
    }

    @Override
    public void copyBulletJointDataToSCS(double dt) {
        float jointPosition = this.getBulletMultiBody().getJointPos(this.getBulletJointIndex());
        this.bulletJointVelocityTest.set(((double)jointPosition - this.simRevoluteJoint.getQ()) / dt);
        this.simRevoluteJoint.setQ((double)jointPosition);
        float jointPVel = this.getBulletMultiBody().getJointVel(this.getBulletJointIndex());
        this.simRevoluteJoint.setQdd(((double)jointPVel - this.simRevoluteJoint.getQd()) / dt);
        this.simRevoluteJoint.setQd((double)jointPVel);
        this.bulletJointPosition.set((double)jointPosition);
        this.bulletJointVelocity.set((double)jointPVel);
        this.bulletUserAddedTorque.set(this.damping.getValue() * this.bulletJointVelocity.getValue());
        this.bulletJointTorque.set((double)this.getBulletMultiBody().getJointTorque(this.getBulletJointIndex()));
        btVector3 linkForce = this.getBulletMultiBody().getLink(this.getBulletJointIndex()).getAppliedConstraintForce();
        this.bulletLinkAppliedForceX.set((double)linkForce.getX());
        this.bulletLinkAppliedForceY.set((double)linkForce.getY());
        this.bulletLinkAppliedForceZ.set((double)linkForce.getZ());
        btVector3 linkTorque = this.getBulletMultiBody().getLink(this.getBulletJointIndex()).getAppliedConstraintTorque();
        this.bulletLinkAppliedTorqueX.set((double)linkTorque.getX());
        this.bulletLinkAppliedTorqueY.set((double)linkTorque.getY());
        this.bulletLinkAppliedTorqueZ.set((double)linkTorque.getZ());
        MovingReferenceFrame bodyFrame = this.getSimRigidBody().getBodyFixedFrame();
        MovingReferenceFrame expressedInFrame = this.getSimRigidBody().getBodyFixedFrame();
        Vector3D torque = new Vector3D((double)linkTorque.getX(), (double)linkTorque.getY(), (double)linkTorque.getZ());
        Vector3D force = new Vector3D((double)linkForce.getX(), (double)linkForce.getY(), (double)linkForce.getZ());
        this.rigidBodyWrenchRegistry.addWrench((RigidBodyReadOnly)this.getSimRigidBody(), (WrenchReadOnly)new Wrench((ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame, (Vector3DReadOnly)torque, (Vector3DReadOnly)force));
    }

    public boolean isSameLink(RigidBodyDefinition rigidBodyDefinition) {
        return this.getRigidBodyDefinition().getName().equals(rigidBodyDefinition.getName());
    }

    public boolean isSameLink(RigidBodyBasics rigidBodyBasics) {
        return this.getRigidBodyDefinition().getName().equals(rigidBodyBasics.getName());
    }

    public YoDouble getDamping() {
        return this.damping;
    }

    public YoDouble getBulletJointPosition() {
        return this.bulletJointPosition;
    }

    public YoDouble getBulletJointVelocity() {
        return this.bulletJointVelocity;
    }

    public YoDouble getBulletUserAddedTorque() {
        return this.bulletUserAddedTorque;
    }

    public YoDouble getBulletJointTorque() {
        return this.bulletJointTorque;
    }

    public YoDouble getBulletLinkAppliedForceX() {
        return this.bulletLinkAppliedForceX;
    }

    public YoDouble getBulletLinkAppliedForceY() {
        return this.bulletLinkAppliedForceY;
    }

    public YoDouble getBulletLinkAppliedForceZ() {
        return this.bulletLinkAppliedForceZ;
    }

    public YoDouble getBulletLinkAppliedTorqueX() {
        return this.bulletLinkAppliedTorqueX;
    }

    public YoDouble getBulletLinkAppliedTorqueY() {
        return this.bulletLinkAppliedTorqueY;
    }

    public YoDouble getBulletLinkAppliedTorqueZ() {
        return this.bulletLinkAppliedTorqueZ;
    }
}

