/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.collision.btCapsuleShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundFromGimpactShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexHullShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btCylinderShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btGImpactMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import java.util.List;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.ConvexPolytope3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.ReferenceFrameMissingTools;

public class BulletRobotLinkCollisionShape {
    private final YawPitchRollTransformDefinition collisionShapeToFrameAfterParentJoint;
    private final ReferenceFrame linkCenterOfMassFrame;
    private final Matrix4 collisionShapeDefinitionToCenterOfMassFrameTransformGDX = new Matrix4();
    private final RigidBodyTransform collisionShapeDefinitionToCenterOfMassFrameTransformEuclid = new RigidBodyTransform();
    private final ReferenceFrame collisionShapeDefinitionFrame;
    private btCollisionShape bulletCollisionShape;
    private final GeometryDefinition geometryDefinition;

    public BulletRobotLinkCollisionShape(CollisionShapeDefinition collisionShapeDefinition, ReferenceFrame frameAfterParentJoint, ReferenceFrame linkCenterOfMassFrame) {
        this.linkCenterOfMassFrame = linkCenterOfMassFrame;
        this.collisionShapeToFrameAfterParentJoint = collisionShapeDefinition.getOriginPose();
        this.collisionShapeDefinitionFrame = ReferenceFrameMissingTools.constructFrameWithUnchangingTransformToParent(frameAfterParentJoint, new RigidBodyTransform((Orientation3DReadOnly)this.collisionShapeToFrameAfterParentJoint.getRotation(), (Tuple3DReadOnly)this.collisionShapeToFrameAfterParentJoint.getTranslation()));
        this.geometryDefinition = collisionShapeDefinition.getGeometryDefinition();
        if (collisionShapeDefinition.getGeometryDefinition() instanceof ModelFileGeometryDefinition) {
            ModelFileGeometryDefinition modelFileGeometryDefinition = (ModelFileGeometryDefinition)collisionShapeDefinition.getGeometryDefinition();
            Matrix4 identity = new Matrix4();
            if (collisionShapeDefinition.isConcave()) {
                List<btGImpactMeshShape> shapes = BulletTools.loadConcaveGImpactMeshShapeFromFile(modelFileGeometryDefinition.getFileName());
                btCompoundFromGimpactShape compoundFromGimpactShape = new btCompoundFromGimpactShape();
                for (btCollisionShape btCollisionShape2 : shapes) {
                    btCollisionShape2.setMargin(0.01f);
                    compoundFromGimpactShape.addChildShape(identity, btCollisionShape2);
                }
                this.bulletCollisionShape = compoundFromGimpactShape;
            } else {
                List<btConvexTriangleMeshShape> shapes = BulletTools.loadConvexTriangleMeshShapeFromFile(modelFileGeometryDefinition.getFileName());
                btCompoundShape compoundShape = new btCompoundShape();
                for (btCollisionShape btCollisionShape3 : shapes) {
                    btCollisionShape3.setMargin(0.01f);
                    compoundShape.addChildShape(identity, btCollisionShape3);
                }
                this.bulletCollisionShape = compoundShape;
            }
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Box3DDefinition) {
            Box3DDefinition boxGeometryDefinition = (Box3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btBoxShape boxShape = new btBoxShape(new Vector3((float)boxGeometryDefinition.getSizeX() / 2.0f, (float)boxGeometryDefinition.getSizeY() / 2.0f, (float)boxGeometryDefinition.getSizeZ() / 2.0f));
            this.bulletCollisionShape = boxShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Sphere3DDefinition) {
            Sphere3DDefinition sphereGeometryDefinition = (Sphere3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btSphereShape sphereShape = new btSphereShape((float)sphereGeometryDefinition.getRadius());
            this.bulletCollisionShape = sphereShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Cylinder3DDefinition) {
            Cylinder3DDefinition cylinderGeometryDefinition = (Cylinder3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btCylinderShapeZ cylinderShape = new btCylinderShapeZ(new Vector3((float)cylinderGeometryDefinition.getRadius(), (float)cylinderGeometryDefinition.getRadius(), (float)cylinderGeometryDefinition.getLength() / 2.0f));
            this.bulletCollisionShape = cylinderShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof Capsule3DDefinition) {
            Capsule3DDefinition capsuleGeometryDefinition = (Capsule3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            if (capsuleGeometryDefinition.getRadiusX() != capsuleGeometryDefinition.getRadiusY() || capsuleGeometryDefinition.getRadiusX() != capsuleGeometryDefinition.getRadiusZ() || capsuleGeometryDefinition.getRadiusY() != capsuleGeometryDefinition.getRadiusZ()) {
                LogTools.warn((String)"Bullet capsule does not fully represent the intended capsule!");
            }
            btCapsuleShapeZ capsuleShape = new btCapsuleShapeZ((float)capsuleGeometryDefinition.getRadiusX(), (float)capsuleGeometryDefinition.getLength());
            this.bulletCollisionShape = capsuleShape;
        } else if (collisionShapeDefinition.getGeometryDefinition() instanceof ConvexPolytope3DDefinition) {
            ConvexPolytope3DDefinition convexPolytopeDefinition = (ConvexPolytope3DDefinition)collisionShapeDefinition.getGeometryDefinition();
            btConvexHullShape convexHullShape = new btConvexHullShape();
            for (Face3DReadOnly face : convexPolytopeDefinition.getConvexPolytope().getFaces()) {
                for (Vertex3DReadOnly vertex3DReadOnly : face.getVertices()) {
                    convexHullShape.addPoint(new Vector3(vertex3DReadOnly.getX32(), vertex3DReadOnly.getY32(), vertex3DReadOnly.getZ32()));
                }
            }
            this.bulletCollisionShape = convexHullShape;
        } else {
            LogTools.warn((String)"Implement collision for {}", (Object)collisionShapeDefinition.getGeometryDefinition().getClass().getSimpleName());
        }
    }

    public void addToCompoundShape(btCompoundShape bulletCompoundShape) {
        this.collisionShapeDefinitionFrame.getTransformToDesiredFrame(this.collisionShapeDefinitionToCenterOfMassFrameTransformEuclid, this.linkCenterOfMassFrame);
        BulletTools.toBullet(this.collisionShapeDefinitionToCenterOfMassFrameTransformEuclid, this.collisionShapeDefinitionToCenterOfMassFrameTransformGDX);
        if (this.bulletCollisionShape == null) {
            throw new RuntimeException("Collision shape is null! Preventing native crash.");
        }
        bulletCompoundShape.addChildShape(this.collisionShapeDefinitionToCenterOfMassFrameTransformGDX, this.bulletCollisionShape);
    }

    public btCollisionShape getBulletCollisionShape() {
        return this.bulletCollisionShape;
    }
}

