/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexHullShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexPointCloudShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btGImpactMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btStridingMeshInterface;
import com.badlogic.gdx.physics.bullet.collision.btTriangleMesh;
import com.badlogic.gdx.physics.bullet.dynamics.InternalTickCallback;
import com.badlogic.gdx.physics.bullet.dynamics.btDynamicsWorld;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyDynamicsWorld;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import com.badlogic.gdx.physics.bullet.linearmath.btMotionState;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3Array;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.scene.paint.Color;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader.AssimpLoader;

public class BulletTools {
    private static final float STATIC_OBJECT_MASS = 10000.0f;
    private static boolean bulletInitialized = false;

    public static void ensureBulletInitialized() {
        if (!bulletInitialized) {
            bulletInitialized = true;
            Bullet.init();
            LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
        }
    }

    public static void toBullet(AffineTransform euclidAffine, Matrix4 bulletAffineToPack) {
        bulletAffineToPack.val[0] = (float)euclidAffine.getM00();
        bulletAffineToPack.val[4] = (float)euclidAffine.getM01();
        bulletAffineToPack.val[8] = (float)euclidAffine.getM02();
        bulletAffineToPack.val[1] = (float)euclidAffine.getM10();
        bulletAffineToPack.val[5] = (float)euclidAffine.getM11();
        bulletAffineToPack.val[9] = (float)euclidAffine.getM12();
        bulletAffineToPack.val[2] = (float)euclidAffine.getM20();
        bulletAffineToPack.val[6] = (float)euclidAffine.getM21();
        bulletAffineToPack.val[10] = (float)euclidAffine.getM22();
        bulletAffineToPack.val[12] = (float)euclidAffine.getM03();
        bulletAffineToPack.val[13] = (float)euclidAffine.getM13();
        bulletAffineToPack.val[14] = (float)euclidAffine.getM23();
    }

    public static void toEuclid(Matrix4 bulletAffine, AffineTransform euclidAffine) {
        euclidAffine.getLinearTransform().setM00((double)bulletAffine.val[0]);
        euclidAffine.getLinearTransform().setM01((double)bulletAffine.val[4]);
        euclidAffine.getLinearTransform().setM02((double)bulletAffine.val[8]);
        euclidAffine.getLinearTransform().setM10((double)bulletAffine.val[1]);
        euclidAffine.getLinearTransform().setM11((double)bulletAffine.val[5]);
        euclidAffine.getLinearTransform().setM12((double)bulletAffine.val[9]);
        euclidAffine.getLinearTransform().setM20((double)bulletAffine.val[2]);
        euclidAffine.getLinearTransform().setM21((double)bulletAffine.val[6]);
        euclidAffine.getLinearTransform().setM22((double)bulletAffine.val[10]);
        euclidAffine.getLinearTransform().normalize();
        euclidAffine.getTranslation().setX((double)bulletAffine.val[12]);
        euclidAffine.getTranslation().setY((double)bulletAffine.val[13]);
        euclidAffine.getTranslation().setZ((double)bulletAffine.val[14]);
    }

    public static void toEuclid(Matrix4 bulletAffine, RotationMatrix euclidRotationMatrix) {
        euclidRotationMatrix.setAndNormalize((double)bulletAffine.val[0], (double)bulletAffine.val[4], (double)bulletAffine.val[8], (double)bulletAffine.val[1], (double)bulletAffine.val[5], (double)bulletAffine.val[9], (double)bulletAffine.val[2], (double)bulletAffine.val[6], (double)bulletAffine.val[10]);
    }

    public static void toBullet(RigidBodyTransform rigidBodyTransform, Matrix4 bulletAffineToPack) {
        bulletAffineToPack.val[0] = (float)rigidBodyTransform.getM00();
        bulletAffineToPack.val[4] = (float)rigidBodyTransform.getM01();
        bulletAffineToPack.val[8] = (float)rigidBodyTransform.getM02();
        bulletAffineToPack.val[1] = (float)rigidBodyTransform.getM10();
        bulletAffineToPack.val[5] = (float)rigidBodyTransform.getM11();
        bulletAffineToPack.val[9] = (float)rigidBodyTransform.getM12();
        bulletAffineToPack.val[2] = (float)rigidBodyTransform.getM20();
        bulletAffineToPack.val[6] = (float)rigidBodyTransform.getM21();
        bulletAffineToPack.val[10] = (float)rigidBodyTransform.getM22();
        bulletAffineToPack.val[12] = (float)rigidBodyTransform.getM03();
        bulletAffineToPack.val[13] = (float)rigidBodyTransform.getM13();
        bulletAffineToPack.val[14] = (float)rigidBodyTransform.getM23();
    }

    public static void toEuclid(Matrix4 bulletAffine, RigidBodyTransform rigidBodyTransform) {
        rigidBodyTransform.getRotation().setAndNormalize((double)bulletAffine.val[0], (double)bulletAffine.val[4], (double)bulletAffine.val[8], (double)bulletAffine.val[1], (double)bulletAffine.val[5], (double)bulletAffine.val[9], (double)bulletAffine.val[2], (double)bulletAffine.val[6], (double)bulletAffine.val[10]);
        rigidBodyTransform.getTranslation().setX((double)bulletAffine.val[12]);
        rigidBodyTransform.getTranslation().setY((double)bulletAffine.val[13]);
        rigidBodyTransform.getTranslation().setZ((double)bulletAffine.val[14]);
    }

    public static void toBullet(RotationMatrix euclidRotationMatrix, Matrix4 bulletRotationMatrix) {
        bulletRotationMatrix.val[0] = (float)euclidRotationMatrix.getM00();
        bulletRotationMatrix.val[4] = (float)euclidRotationMatrix.getM01();
        bulletRotationMatrix.val[8] = (float)euclidRotationMatrix.getM02();
        bulletRotationMatrix.val[1] = (float)euclidRotationMatrix.getM10();
        bulletRotationMatrix.val[5] = (float)euclidRotationMatrix.getM11();
        bulletRotationMatrix.val[9] = (float)euclidRotationMatrix.getM12();
        bulletRotationMatrix.val[2] = (float)euclidRotationMatrix.getM20();
        bulletRotationMatrix.val[6] = (float)euclidRotationMatrix.getM21();
        bulletRotationMatrix.val[10] = (float)euclidRotationMatrix.getM22();
    }

    public static void toBullet(us.ihmc.euclid.tuple4D.Quaternion euclidQuaternion, Quaternion bulletQuaternion) {
        bulletQuaternion.x = euclidQuaternion.getX32();
        bulletQuaternion.y = euclidQuaternion.getY32();
        bulletQuaternion.z = euclidQuaternion.getZ32();
        bulletQuaternion.w = euclidQuaternion.getS32();
    }

    public static Vector3 toBullet(Tuple3DReadOnly euclidTuple) {
        return new Vector3(euclidTuple.getX32(), euclidTuple.getY32(), euclidTuple.getZ32());
    }

    public static Vector2 toBullet(Tuple2DReadOnly euclidTuple) {
        return new Vector2(euclidTuple.getX32(), euclidTuple.getY32());
    }

    public static void toBullet(Tuple3DReadOnly euclidTuple, Vector3 bulletVector3) {
        bulletVector3.set(euclidTuple.getX32(), euclidTuple.getY32(), euclidTuple.getZ32());
    }

    public static void toEuclid(Vector3 bulletVector3, Vector3DBasics euclidVector3D32) {
        euclidVector3D32.set((double)bulletVector3.x, (double)bulletVector3.y, (double)bulletVector3.z);
    }

    public static void toEuclid(Vector3 bulletVector3, Point3DBasics euclidPoint3D32) {
        euclidPoint3D32.set((double)bulletVector3.x, (double)bulletVector3.y, (double)bulletVector3.z);
    }

    public static void toEuclid(Matrix4 bulletAffine, Point3DBasics euclidPoint) {
        euclidPoint.set((double)bulletAffine.val[12], (double)bulletAffine.val[13], (double)bulletAffine.val[14]);
    }

    public static void toBullet(Point3DReadOnly euclidPoint, Matrix4 bulletAffine) {
        bulletAffine.setTranslation(euclidPoint.getX32(), euclidPoint.getY32(), euclidPoint.getZ32());
    }

    public static void toBullet(Pose3DReadOnly euclidPose, RigidBodyTransform tempTransform, Matrix4 bulletAffine) {
        euclidPose.get((RigidBodyTransformBasics)tempTransform);
        BulletTools.toBullet(tempTransform, bulletAffine);
    }

    public static void toBullet(Color javaFXColor, com.badlogic.gdx.graphics.Color bulletColor) {
        bulletColor.set((float)javaFXColor.getRed(), (float)javaFXColor.getGreen(), (float)javaFXColor.getBlue(), (float)javaFXColor.getOpacity());
    }

    public static com.badlogic.gdx.graphics.Color toBullet(Color javaFXColor) {
        return new com.badlogic.gdx.graphics.Color((float)javaFXColor.getRed(), (float)javaFXColor.getGreen(), (float)javaFXColor.getBlue(), (float)javaFXColor.getOpacity());
    }

    public static List<btConvexPointCloudShape> loadConvexPointCloudShapesFromFile(String modelFilePath) {
        List<HashSet<Vector3D32>> vertexSets = AssimpLoader.loadUniqueVertexPositions(modelFilePath);
        ArrayList<btConvexPointCloudShape> shapes = new ArrayList<btConvexPointCloudShape>();
        for (HashSet<Vector3D32> vertexSet : vertexSets) {
            btVector3Array bulletVector3Array = new btVector3Array();
            for (Vector3D32 vector3D32 : vertexSet) {
                bulletVector3Array.expand(new Vector3(vector3D32.getX32(), vector3D32.getY32(), vector3D32.getZ32()));
            }
            bulletVector3Array.releaseOwnership();
            btVector3 points = new btVector3(bulletVector3Array.getCPointer(), bulletVector3Array.hasOwnership());
            int numberOfPoints = vertexSet.size();
            Vector3 localScaling = new Vector3(1.0f, 1.0f, 1.0f);
            bulletVector3Array.releaseOwnership();
            btConvexPointCloudShape bulletConvexPointCloudShape = new btConvexPointCloudShape(points, numberOfPoints, localScaling, true);
            shapes.add(bulletConvexPointCloudShape);
        }
        return shapes;
    }

    public static List<btConvexHullShape> loadConvexHullShapeFromFile(String modelFilePath) {
        List<FloatBuffer> vertexBuffers = AssimpLoader.loadTriangleVertexPositionsAsFloatBuffer(modelFilePath);
        ArrayList<btConvexHullShape> shapes = new ArrayList<btConvexHullShape>();
        for (FloatBuffer vertexBuffer : vertexBuffers) {
            int bytesPerVertex = 12;
            int numberOfPoints = vertexBuffer.limit() / bytesPerVertex;
            btConvexHullShape concaveHullShapeFromMesh = BulletTools.createConcaveHullShapeFromMesh(vertexBuffer, numberOfPoints, bytesPerVertex);
            shapes.add(concaveHullShapeFromMesh);
        }
        return shapes;
    }

    public static List<btConvexTriangleMeshShape> loadConvexTriangleMeshShapeFromFile(String modelFilePath) {
        List<List<Point3D32>> vertexLists = AssimpLoader.loadTriangleVertexPositionsAsList(modelFilePath);
        ArrayList<btConvexTriangleMeshShape> shapes = new ArrayList<btConvexTriangleMeshShape>();
        for (List<Point3D32> vertexList : vertexLists) {
            btTriangleMesh bulletTriangleMesh = new btTriangleMesh(false, false);
            for (int i = 0; i < vertexList.size(); i += 3) {
                bulletTriangleMesh.addTriangle(new Vector3(vertexList.get(i).getX32(), vertexList.get(i).getY32(), vertexList.get(i).getZ32()), new Vector3(vertexList.get(i + 1).getX32(), vertexList.get(i + 1).getY32(), vertexList.get(i + 1).getZ32()), new Vector3(vertexList.get(i + 2).getX32(), vertexList.get(i + 2).getY32(), vertexList.get(i + 2).getZ32()));
            }
            bulletTriangleMesh.releaseOwnership();
            btConvexTriangleMeshShape bulletConvexTriangleMeshShape = new btConvexTriangleMeshShape((btStridingMeshInterface)bulletTriangleMesh);
            shapes.add(bulletConvexTriangleMeshShape);
        }
        return shapes;
    }

    public static List<btGImpactMeshShape> loadConcaveGImpactMeshShapeFromFile(String modelFilePath) {
        List<List<Point3D32>> vertexLists = AssimpLoader.loadTriangleVertexPositionsAsList(modelFilePath);
        ArrayList<btGImpactMeshShape> shapes = new ArrayList<btGImpactMeshShape>();
        for (List<Point3D32> vertexList : vertexLists) {
            btTriangleMesh bulletTriangleMesh = new btTriangleMesh(false, false);
            for (int i = 0; i < vertexList.size(); i += 3) {
                bulletTriangleMesh.addTriangle(new Vector3(vertexList.get(i).getX32(), vertexList.get(i).getY32(), vertexList.get(i).getZ32()), new Vector3(vertexList.get(i + 1).getX32(), vertexList.get(i + 1).getY32(), vertexList.get(i + 1).getZ32()), new Vector3(vertexList.get(i + 2).getX32(), vertexList.get(i + 2).getY32(), vertexList.get(i + 2).getZ32()));
            }
            bulletTriangleMesh.releaseOwnership();
            btGImpactMeshShape bulletConvexTriangleMeshShape = new btGImpactMeshShape((btStridingMeshInterface)bulletTriangleMesh);
            bulletConvexTriangleMeshShape.updateBound();
            shapes.add(bulletConvexTriangleMeshShape);
        }
        return shapes;
    }

    public static btConvexHullShape createConcaveHullShapeFromMesh(FloatBuffer floatBuffer, int numberOfPoints, int stride) {
        floatBuffer.rewind();
        return new btConvexHullShape(floatBuffer, numberOfPoints, stride);
    }

    public static void setKinematicObject(btRigidBody btRigidBody2, boolean isKinematicObject) {
        if (isKinematicObject) {
            btRigidBody2.setCollisionFlags(btRigidBody2.getCollisionFlags() | 2);
            btRigidBody2.setActivationState(4);
        } else {
            btRigidBody2.setCollisionFlags(btRigidBody2.getCollisionFlags() & 0xFFFFFFFD);
            btRigidBody2.setActivationState(3);
        }
    }

    public static btRigidBody addStaticObjectToBulletWorld(btMultiBodyDynamicsWorld multiBodyDynamicsWorld, btCollisionShape collisionShape, btMotionState motionState) {
        Vector3 localInertia = new Vector3();
        collisionShape.calculateLocalInertia(10000.0f, localInertia);
        btRigidBody bulletRigidBody = new btRigidBody(10000.0f, motionState, collisionShape, localInertia);
        int collisionGroup = 1;
        int collisionGroupMask = -1;
        multiBodyDynamicsWorld.addRigidBody(bulletRigidBody, collisionGroup, collisionGroupMask);
        BulletTools.setKinematicObject(bulletRigidBody, true);
        return bulletRigidBody;
    }

    public static void setupPostTickCallback(btMultiBodyDynamicsWorld multiBodyDynamicsWorld, final ArrayList<Runnable> postTickCallbacks) {
        new InternalTickCallback((btDynamicsWorld)multiBodyDynamicsWorld, false){

            public void onInternalTick(btDynamicsWorld dynamicsWorld, float timeStep) {
                for (Runnable postTickRunnable : postTickCallbacks) {
                    postTickRunnable.run();
                }
            }
        };
    }
}

