/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import java.util.ArrayList;
import java.util.HashMap;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkBasics;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkRevolute;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkRoot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotPhysics;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotExtension;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BulletRobot
extends RobotExtension {
    private final BulletRobotPhysics robotPhysics;
    private final RigidBodyDefinition rootBodyDefinition;
    private final SimRigidBodyBasics rootSimRigidBodyBasics;
    private final SimFloatingRootJoint rootSimFloatingRootJoint;
    private final BulletRobotLinkRoot rootLink;
    private final HashMap<String, Integer> jointNameToBulletJointIndexMap = new HashMap();
    private final ArrayList<BulletRobotLinkBasics> allLinks = new ArrayList();
    private final ArrayList<BulletRobotLinkRevolute> afterRootLinks = new ArrayList();
    private final YoRegistry yoRegistry;

    public BulletRobot(Robot robot, YoRegistry physicsRegistry, BulletPhysicsEngine bulletPhysicsEngine) {
        super(robot, physicsRegistry);
        this.robotPhysics = new BulletRobotPhysics((RobotInterface)this);
        this.yoRegistry = new YoRegistry(this.getRobotDefinition().getName() + ((Object)((Object)this)).getClass().getSimpleName());
        robot.getRegistry().addChild(this.yoRegistry);
        this.rootBodyDefinition = robot.getRobotDefinition().getRootBodyDefinition();
        JointDefinition rootJointDefinition = (JointDefinition)this.rootBodyDefinition.getChildrenJoints().get(0);
        if (!(rootJointDefinition instanceof SixDoFJointDefinition)) {
            throw new RuntimeException("Expecting a SixDoFJointDefinition, not a " + rootJointDefinition.getClass().getSimpleName());
        }
        SixDoFJointDefinition rootSixDoFJointDefinition = (SixDoFJointDefinition)rootJointDefinition;
        this.rootSimRigidBodyBasics = robot.getRootBody();
        JointBasics rootJoint = (JointBasics)this.rootSimRigidBodyBasics.getChildrenJoints().get(0);
        if (!(rootJoint instanceof SimFloatingRootJoint)) {
            throw new RuntimeException("Expecting a SimFloatingRootJoint, not a " + rootJoint.getClass().getSimpleName());
        }
        this.rootSimFloatingRootJoint = (SimFloatingRootJoint)rootJoint;
        this.rootLink = new BulletRobotLinkRoot(rootSixDoFJointDefinition, this.rootSimFloatingRootJoint, this.jointNameToBulletJointIndexMap, this.robotPhysics.getRigidBodyWrenchRegistry(), this.yoRegistry);
        this.initializeLinkLists(this.rootLink, true);
        this.rootLink.setup(bulletPhysicsEngine);
        for (BulletRobotLinkRevolute link : this.afterRootLinks) {
            link.setBulletMultiBody(this.rootLink.getBulletMultiBody());
            link.setup(bulletPhysicsEngine);
        }
        this.rootLink.getBulletMultiBody().finalizeMultiDof();
    }

    private void initializeLinkLists(BulletRobotLinkBasics link, boolean isRootLink) {
        this.allLinks.add(link);
        if (!isRootLink) {
            this.afterRootLinks.add((BulletRobotLinkRevolute)link);
        }
        for (BulletRobotLinkBasics child : link.getChildren()) {
            this.initializeLinkLists(child, false);
        }
    }

    public void saveRobotBeforePhysicsState() {
        super.saveRobotBeforePhysicsState();
        this.copyDataFromSCSToBullet();
    }

    public void copyDataFromSCSToBullet() {
        this.robotPhysics.reset();
        this.copyDataFromSCSToBullet(this.rootLink);
    }

    private void copyDataFromSCSToBullet(BulletRobotLinkBasics link) {
        link.copyDataFromSCSToBullet();
        for (BulletRobotLinkBasics child : link.getChildren()) {
            this.copyDataFromSCSToBullet(child);
        }
    }

    public void updateFromBulletData(BulletPhysicsEngine bulletPhysicsEngine, double dt) {
        this.rootLink.copyBulletJointDataToSCS(dt);
        for (BulletRobotLinkRevolute afterRootLink : this.afterRootLinks) {
            afterRootLink.copyBulletJointDataToSCS(dt);
        }
        this.robotPhysics.update();
    }

    public BulletRobotLinkRoot getRootLink() {
        return this.rootLink;
    }

    public btMultiBody getBulletMultiBody() {
        return this.rootLink.getBulletMultiBody();
    }

    public ArrayList<BulletRobotLinkRevolute> getAfterRootLinks() {
        return this.afterRootLinks;
    }

    public ArrayList<BulletRobotLinkBasics> getAllLinks() {
        return this.allLinks;
    }

    public void updateSensors() {
        for (SimJointBasics joint : this.getRootBody().childrenSubtreeIterable()) {
            joint.getAuxialiryData().update(this.robotPhysics.getPhysicsOutput());
        }
    }
}

