/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine.modelLoader;

import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.lwjgl.assimp.AIFile;
import org.lwjgl.assimp.AIFileFlushProcI;
import org.lwjgl.assimp.AIFileReadProcI;
import org.lwjgl.assimp.AIFileSeekI;
import org.lwjgl.assimp.AIFileTellProcI;
import org.lwjgl.assimp.AIFileWriteProcI;
import org.lwjgl.system.MemoryUtil;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;

public class AssimpOpenedFile {
    private final long assimpFileStructAddress;
    private String fileName;

    public AssimpOpenedFile(long assimpFileIOAddress, long fileNameAddress, long openModeAddress) {
        this.fileName = MemoryUtil.memUTF8((long)fileNameAddress);
        String openMode = MemoryUtil.memUTF8((long)openModeAddress);
        LogTools.debug((String)"{}: Opening in mode: {}", (Object)this.fileName, (Object)openMode);
        URL url = ClassLoader.getSystemResource(Paths.get(this.fileName, new String[0]).toString());
        final byte[] byteArray = (byte[])ExceptionTools.handle(() -> IOUtils.toByteArray((URL)url), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        final MutableLong position = new MutableLong(0L);
        AIFile assimpFile = AIFile.create();
        AIFileReadProcI assimpFileReadFunction = new AIFileReadProcI(){

            public long invoke(long assimpFileAddress, long characterBufferToReadToAddress, long size, long count) {
                long desiredNumberOfBytesToRead = size * count;
                long bytesLeftInFile = (long)byteArray.length - position.getValue();
                long bytesToBeRead = Math.min(desiredNumberOfBytesToRead, bytesLeftInFile);
                LogTools.debug((String)String.format("%s: Read size: %d count: %d desired bytes: %d bytes left: %d going to be read: %d", AssimpOpenedFile.this.fileName, size, count, desiredNumberOfBytesToRead, bytesLeftInFile, bytesToBeRead));
                ByteBuffer characterBufferToReadTo = MemoryUtil.memByteBuffer((long)characterBufferToReadToAddress, (int)byteArray.length);
                characterBufferToReadTo.put(byteArray, (int)position.longValue(), (int)bytesToBeRead);
                return bytesToBeRead;
            }
        };
        AIFileWriteProcI assimpFileWriteFunction = new AIFileWriteProcI(){

            public long invoke(long assimpFileAddress, long characterBufferToWriteAddress, long memB, long count) {
                LogTools.debug((String)"{}: Write", (Object)AssimpOpenedFile.this.fileName);
                return 0L;
            }
        };
        AIFileTellProcI assimpFileTellFunction = new AIFileTellProcI(){

            public long invoke(long assimpFileAddress) {
                LogTools.debug((String)"{}: Tell", (Object)AssimpOpenedFile.this.fileName);
                return 0L;
            }
        };
        AIFileTellProcI assimpFileSizeFunction = new AIFileTellProcI(){

            public long invoke(long assimpFileAddress) {
                long size = byteArray.length;
                LogTools.debug((String)"{}: Size: {}", (Object)AssimpOpenedFile.this.fileName, (Object)size);
                return size;
            }
        };
        AIFileSeekI assimpFileSeekFunction = new AIFileSeekI(){

            public int invoke(long assimpFileAddress, long offset, int origin) {
                LogTools.debug((String)"{}: Seek offset: {} origin: {}", (Object)AssimpOpenedFile.this.fileName, (Object)offset, (Object)origin);
                if (origin == 0) {
                    position.setValue(offset);
                } else if (origin == 1) {
                    position.add(offset);
                } else if (origin == 2) {
                    position.setValue((long)byteArray.length - offset);
                }
                return -1;
            }
        };
        AIFileFlushProcI assimpFileFlushFunction = new AIFileFlushProcI(){

            public void invoke(long assimpFileAddress) {
                LogTools.debug((String)"{}: Flush", (Object)AssimpOpenedFile.this.fileName);
            }
        };
        assimpFile.ReadProc(assimpFileReadFunction);
        assimpFile.WriteProc(assimpFileWriteFunction);
        assimpFile.TellProc(assimpFileTellFunction);
        assimpFile.FileSizeProc(assimpFileSizeFunction);
        assimpFile.SeekProc(assimpFileSeekFunction);
        assimpFile.FlushProc(assimpFileFlushFunction);
        assimpFile.UserData(MemoryUtil.memAddress((ByteBuffer)MemoryUtil.memAlloc((int)1)));
        this.assimpFileStructAddress = assimpFile.address();
    }

    public long getAssimpFileStructAddress() {
        return this.assimpFileStructAddress;
    }
}

