/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import java.util.HashMap;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkBasics;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkCollisionSet;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BulletRobotLinkRoot
extends BulletRobotLinkBasics {
    private int linkCountingIndex = 0;
    private final int numberOfLinks;
    private final SimFloatingRootJoint rootSimFloatingRootJoint;
    private final Matrix4 bulletSixDoFJointTransformToWorldBullet = new Matrix4();
    private final RigidBodyTransform bulletSixDoFJointTransformToWorldEuclid = new RigidBodyTransform();
    private final Vector3D bulletBaseLinearVelocityEuclid = new Vector3D();
    private final Vector3D bulletBaseAngularVelocityEuclid = new Vector3D();
    private final Pose3D previousBasePose = new Pose3D();
    private final Twist previousBaseTwist = new Twist();
    private final YoFixedFrameTwist twistFD;
    private final RigidBodyTransform rootJointSuccessorBodyFixedFrameToWorldEuclid = new RigidBodyTransform();
    private final Matrix4 rootJointSuccessorBodyFixedFrameToWorldBullet = new Matrix4();
    private final RigidBodyTransform bodyFixedFrameToFrameAfterJointTranform = new RigidBodyTransform();

    public BulletRobotLinkRoot(SixDoFJointDefinition rootSixDoFJointDefinition, SimFloatingRootJoint rootSimFloatingRootJoint, HashMap<String, Integer> jointNameToBulletJointIndexMap, RigidBodyWrenchRegistry rigidBodyWrenchRegistry, YoRegistry yoRegistry) {
        super(rootSixDoFJointDefinition.getSuccessor(), rootSimFloatingRootJoint.getSuccessor(), jointNameToBulletJointIndexMap, rigidBodyWrenchRegistry);
        this.rootSimFloatingRootJoint = rootSimFloatingRootJoint;
        this.setBulletJointIndex(-1);
        this.numberOfLinks = this.countJoints((JointBasics)rootSimFloatingRootJoint) - 1;
        ReferenceFrame rootFrame = rootSimFloatingRootJoint.getFrameBeforeJoint().getRootFrame();
        this.twistFD = new YoFixedFrameTwist("testTwistFD", (ReferenceFrame)rootSimFloatingRootJoint.getFrameAfterJoint(), (ReferenceFrame)rootSimFloatingRootJoint.getFrameBeforeJoint(), (ReferenceFrame)rootSimFloatingRootJoint.getFrameAfterJoint(), yoRegistry);
        this.addChildLinks(yoRegistry);
    }

    @Override
    public void setup(BulletPhysicsEngine bulletPhysicsEngine) {
        boolean fixedBase = false;
        boolean canSleep = false;
        float rootBodyMass = (float)this.getRigidBodyDefinition().getMass();
        Vector3 rootBodyIntertia = new Vector3((float)this.getRigidBodyDefinition().getMomentOfInertia().getM00(), (float)this.getRigidBodyDefinition().getMomentOfInertia().getM11(), (float)this.getRigidBodyDefinition().getMomentOfInertia().getM22());
        BulletRobotLinkCollisionSet bulletCollisionSet = this.createBulletCollisionShape();
        btMultiBody bulletMultiBody = new btMultiBody(this.numberOfLinks, rootBodyMass, rootBodyIntertia, fixedBase, canSleep);
        bulletMultiBody.setHasSelfCollision(true);
        bulletMultiBody.setLinearDamping(0.1f);
        bulletMultiBody.setAngularDamping(0.9f);
        this.setBulletMultiBody(bulletMultiBody);
        this.createBulletCollider(bulletPhysicsEngine);
        this.getBulletMultiBody().setBaseCollider(this.getBulletMultiBodyLinkCollider());
    }

    @Override
    public void copyDataFromSCSToBullet() {
        this.updateBulletLinkColliderTransformFromMecanoRigidBody();
        BulletTools.toBullet(this.getbulletColliderCenterOfMassTransformToWorldEuclid(), this.rootJointSuccessorBodyFixedFrameToWorldBullet);
        this.getBulletMultiBody().setBaseWorldTransform(this.rootJointSuccessorBodyFixedFrameToWorldBullet);
    }

    @Override
    public void copyBulletJointDataToSCS(double dt) {
        this.getBulletMultiBodyLinkCollider().getWorldTransform(this.rootJointSuccessorBodyFixedFrameToWorldBullet);
        BulletTools.toEuclid(this.rootJointSuccessorBodyFixedFrameToWorldBullet, this.rootJointSuccessorBodyFixedFrameToWorldEuclid);
        this.rootSimFloatingRootJoint.getFrameAfterJoint().getTransformToDesiredFrame(this.bodyFixedFrameToFrameAfterJointTranform, (ReferenceFrame)this.rootSimFloatingRootJoint.getSuccessor().getBodyFixedFrame());
        this.bulletSixDoFJointTransformToWorldEuclid.set(this.rootJointSuccessorBodyFixedFrameToWorldEuclid);
        this.bulletSixDoFJointTransformToWorldEuclid.multiply((RigidBodyTransformReadOnly)this.bodyFixedFrameToFrameAfterJointTranform);
        BulletTools.toEuclid(this.getBulletMultiBody().getBaseVel(), (Vector3DBasics)this.bulletBaseLinearVelocityEuclid);
        BulletTools.toEuclid(this.getBulletMultiBody().getBaseOmega(), (Vector3DBasics)this.bulletBaseAngularVelocityEuclid);
        this.bulletSixDoFJointTransformToWorldEuclid.inverseTransform((Vector3DBasics)this.bulletBaseLinearVelocityEuclid);
        this.bulletSixDoFJointTransformToWorldEuclid.inverseTransform((Vector3DBasics)this.bulletBaseAngularVelocityEuclid);
        this.previousBasePose.set((Pose3DReadOnly)this.rootSimFloatingRootJoint.getJointPose());
        this.previousBaseTwist.setIncludingFrame((SpatialMotionReadOnly)this.rootSimFloatingRootJoint.getJointTwist());
        this.rootSimFloatingRootJoint.setJointPosition((Tuple3DReadOnly)this.bulletSixDoFJointTransformToWorldEuclid.getTranslation());
        this.rootSimFloatingRootJoint.setJointOrientation((Orientation3DReadOnly)this.bulletSixDoFJointTransformToWorldEuclid.getRotation());
        this.rootSimFloatingRootJoint.setJointLinearVelocity((Vector3DReadOnly)this.bulletBaseLinearVelocityEuclid);
        this.rootSimFloatingRootJoint.setJointAngularVelocity((Vector3DReadOnly)this.bulletBaseAngularVelocityEuclid);
        BulletRobotLinkRoot.computeSixDoFJointTwist(dt, (Pose3DReadOnly)this.previousBasePose, (Pose3DReadOnly)this.rootSimFloatingRootJoint.getJointPose(), (FixedFrameTwistBasics)this.twistFD);
        BulletRobotLinkRoot.computeSixDoFJointAcceleration(dt, (Pose3DReadOnly)this.previousBasePose, (Pose3DReadOnly)this.rootSimFloatingRootJoint.getJointPose(), (TwistReadOnly)this.previousBaseTwist, (TwistReadOnly)this.rootSimFloatingRootJoint.getJointTwist(), (FixedFrameSpatialAccelerationBasics)this.rootSimFloatingRootJoint.getJointAcceleration());
    }

    private int countJoints(JointBasics joint) {
        this.getJointNameToBulletJointIndexMap().put(joint.getName(), this.linkCountingIndex - 1);
        ++this.linkCountingIndex;
        int numberOfJoints = 1;
        for (JointBasics childrenJoint : joint.getSuccessor().getChildrenJoints()) {
            numberOfJoints += this.countJoints(childrenJoint);
        }
        return numberOfJoints;
    }

    public static void computeSixDoFJointTwist(double dt, Pose3DReadOnly previousPose, Pose3DReadOnly currentPose, FixedFrameTwistBasics twistToPack) {
        twistToPack.getLinearPart().sub((Tuple3DReadOnly)currentPose.getPosition(), (Tuple3DReadOnly)previousPose.getPosition());
        twistToPack.getLinearPart().scale(1.0 / dt);
        currentPose.getOrientation().inverseTransform((Tuple3DBasics)twistToPack.getLinearPart());
        Vector4D qDot = new Vector4D();
        qDot.sub((Tuple4DReadOnly)currentPose.getOrientation(), (Tuple4DReadOnly)previousPose.getOrientation());
        qDot.scale(1.0 / dt);
        BulletRobotLinkRoot.computeAngularVelocityInBodyFixedFrame(currentPose.getOrientation(), (Vector4DReadOnly)qDot, (Vector3DBasics)twistToPack.getAngularPart());
    }

    public static void computeSixDoFJointAcceleration(double dt, Pose3DReadOnly previousPose, Pose3DReadOnly currentPose, TwistReadOnly previousTwist, TwistReadOnly currentTwist, FixedFrameSpatialAccelerationBasics accelerationToPack) {
        QuaternionReadOnly previousOrientation = previousPose.getOrientation();
        QuaternionReadOnly currentOrientation = currentPose.getOrientation();
        FixedFrameVector3DBasics angularAcceleration = accelerationToPack.getAngularPart();
        FixedFrameVector3DBasics linearAcceleration = accelerationToPack.getLinearPart();
        previousOrientation.transform((Tuple3DReadOnly)previousTwist.getAngularPart(), (Tuple3DBasics)angularAcceleration);
        currentOrientation.inverseTransform((Tuple3DBasics)angularAcceleration);
        angularAcceleration.sub((FrameTuple3DReadOnly)currentTwist.getAngularPart(), (FrameTuple3DReadOnly)angularAcceleration);
        previousOrientation.transform((Tuple3DReadOnly)previousTwist.getLinearPart(), (Tuple3DBasics)linearAcceleration);
        currentOrientation.inverseTransform((Tuple3DBasics)linearAcceleration);
        linearAcceleration.sub((FrameTuple3DReadOnly)currentTwist.getLinearPart(), (FrameTuple3DReadOnly)linearAcceleration);
        accelerationToPack.scale(1.0 / dt);
        accelerationToPack.addCrossToLinearPart((Tuple3DReadOnly)currentTwist.getLinearPart(), (Tuple3DReadOnly)currentTwist.getAngularPart());
    }

    public static void computeAngularVelocityInBodyFixedFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DBasics angularVelocityToPack) {
        Vector4D pureQuatForMultiply = new Vector4D();
        QuaternionTools.multiplyConjugateLeft((Tuple4DReadOnly)q, (Tuple4DReadOnly)qDot, (Vector4DBasics)pureQuatForMultiply);
        angularVelocityToPack.set(pureQuatForMultiply.getX(), pureQuatForMultiply.getY(), pureQuatForMultiply.getZ());
        angularVelocityToPack.scale(2.0);
    }
}

