/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyLinkCollider;
import java.util.ArrayList;
import java.util.HashMap;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkCollisionSet;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkRevolute;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class BulletRobotLinkBasics {
    private final RigidBodyDefinition rigidBodyDefinition;
    private SimRigidBodyBasics simRigidBody;
    private final HashMap<String, Integer> jointNameToBulletJointIndexMap;
    private final RigidBodyWrenchRegistry rigidBodyWrenchRegistry;
    private btMultiBodyLinkCollider bulletMultiBodyLinkCollider;
    private BulletRobotLinkCollisionSet collisionSet;
    private int bulletJointIndex;
    private final ArrayList<BulletRobotLinkBasics> children = new ArrayList();
    private btMultiBody bulletMultiBody;
    private ReferenceFrame frameAfterJoint;
    private final Matrix4 bulletColliderCenterOfMassTransformToWorldBullet = new Matrix4();
    private final RigidBodyTransform bulletColliderCenterOfMassTransformToWorldEuclid = new RigidBodyTransform();
    private int collisionGroup = 2;
    private int collisionGroupMask = 3;

    public BulletRobotLinkBasics(RigidBodyDefinition rigidBodyDefinition, SimRigidBodyBasics simRigidBody, HashMap<String, Integer> jointNameToBulletJointIndexMap, RigidBodyWrenchRegistry rigidBodyWrenchRegistry) {
        this.rigidBodyDefinition = rigidBodyDefinition;
        this.simRigidBody = simRigidBody;
        this.jointNameToBulletJointIndexMap = jointNameToBulletJointIndexMap;
        this.rigidBodyWrenchRegistry = rigidBodyWrenchRegistry;
        this.frameAfterJoint = simRigidBody.getParentJoint().getFrameAfterJoint();
    }

    public void addChildLinks(YoRegistry yoRegistry) {
        for (JointBasics childJoint : this.simRigidBody.getChildrenJoints()) {
            for (JointDefinition childJointDefinition : this.rigidBodyDefinition.getChildrenJoints()) {
                if (!childJoint.getName().equals(childJointDefinition.getName())) continue;
                if (childJoint instanceof SimRevoluteJoint) {
                    SimRevoluteJoint childSimRevoluteJoint = (SimRevoluteJoint)childJoint;
                    RevoluteJointDefinition childRevoluteJointDefinition = (RevoluteJointDefinition)childJointDefinition;
                    this.getChildren().add(new BulletRobotLinkRevolute(childRevoluteJointDefinition, childSimRevoluteJoint, this.jointNameToBulletJointIndexMap, this.rigidBodyWrenchRegistry, yoRegistry));
                    continue;
                }
                throw new RuntimeException("Implement joint type: " + childJoint.getClass().getSimpleName());
            }
        }
    }

    public abstract void setup(BulletPhysicsEngine var1);

    public BulletRobotLinkCollisionSet createBulletCollisionShape() {
        if (this.rigidBodyDefinition.getCollisionShapeDefinitions().size() > 0) {
            this.setCollisionGroupMask((int)((CollisionShapeDefinition)this.rigidBodyDefinition.getCollisionShapeDefinitions().get(0)).getCollisionGroup());
            this.setCollisionGroup((int)((CollisionShapeDefinition)this.rigidBodyDefinition.getCollisionShapeDefinitions().get(0)).getCollisionMask());
        }
        this.collisionSet = new BulletRobotLinkCollisionSet(this.rigidBodyDefinition.getCollisionShapeDefinitions(), this.frameAfterJoint, (ReferenceFrame)this.simRigidBody.getBodyFixedFrame());
        return this.collisionSet;
    }

    public void createBulletCollider(BulletPhysicsEngine bulletPhysicsManager) {
        this.bulletMultiBodyLinkCollider = new btMultiBodyLinkCollider(this.bulletMultiBody, this.bulletJointIndex);
        this.bulletMultiBodyLinkCollider.setCollisionShape((btCollisionShape)this.collisionSet.getBulletCompoundShape());
        this.bulletMultiBodyLinkCollider.setFriction(0.7f);
        bulletPhysicsManager.addMultiBodyCollisionShape(this.bulletMultiBodyLinkCollider, this.collisionGroup, this.collisionGroupMask);
    }

    public void updateBulletLinkColliderTransformFromMecanoRigidBody() {
        this.simRigidBody.getBodyFixedFrame().getTransformToDesiredFrame(this.bulletColliderCenterOfMassTransformToWorldEuclid, SimulationSession.DEFAULT_INERTIAL_FRAME);
        BulletTools.toBullet(this.bulletColliderCenterOfMassTransformToWorldEuclid, this.bulletColliderCenterOfMassTransformToWorldBullet);
        this.bulletMultiBodyLinkCollider.setWorldTransform(this.bulletColliderCenterOfMassTransformToWorldBullet);
    }

    public abstract void copyDataFromSCSToBullet();

    public abstract void copyBulletJointDataToSCS(double var1);

    public void setBulletJointIndex(int bulletJointIndex) {
        this.bulletJointIndex = bulletJointIndex;
    }

    public void setBulletMultiBody(btMultiBody bulletMultiBody) {
        this.bulletMultiBody = bulletMultiBody;
    }

    public ArrayList<BulletRobotLinkBasics> getChildren() {
        return this.children;
    }

    public HashMap<String, Integer> getJointNameToBulletJointIndexMap() {
        return this.jointNameToBulletJointIndexMap;
    }

    public btMultiBody getBulletMultiBody() {
        return this.bulletMultiBody;
    }

    public RigidBodyDefinition getRigidBodyDefinition() {
        return this.rigidBodyDefinition;
    }

    public SimRigidBodyBasics getSimRigidBody() {
        return this.simRigidBody;
    }

    public int getBulletJointIndex() {
        return this.bulletJointIndex;
    }

    public btMultiBodyLinkCollider getBulletMultiBodyLinkCollider() {
        return this.bulletMultiBodyLinkCollider;
    }

    public RigidBodyTransform getbulletColliderCenterOfMassTransformToWorldEuclid() {
        return this.bulletColliderCenterOfMassTransformToWorldEuclid;
    }

    public void setCollisionGroup(int collisionGroup) {
        this.collisionGroup = collisionGroup;
    }

    public void setCollisionGroupMask(int collisionGroupMask) {
        this.collisionGroupMask = collisionGroupMask;
    }

    public int getCollisionGroup() {
        return this.collisionGroup;
    }

    public int getCollisionGroupMask() {
        return this.collisionGroupMask;
    }
}

