/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.collision.btBroadphaseInterface;
import com.badlogic.gdx.physics.bullet.collision.btCollisionConfiguration;
import com.badlogic.gdx.physics.bullet.collision.btCollisionDispatcher;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btDbvtBroadphase;
import com.badlogic.gdx.physics.bullet.collision.btDefaultCollisionConfiguration;
import com.badlogic.gdx.physics.bullet.collision.btDispatcher;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyConstraintSolver;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyDynamicsWorld;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyLinkCollider;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainObject;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotExtension;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BulletPhysicsEngine
implements PhysicsEngine {
    private btCollisionConfiguration collisionConfiguration;
    private btCollisionDispatcher collisionDispatcher;
    private btBroadphaseInterface broadphase;
    private btMultiBodyConstraintSolver solver;
    private btMultiBodyDynamicsWorld multiBodyDynamicsWorld;
    private final ArrayList<btRigidBody> rigidBodies = new ArrayList();
    private final ArrayList<btMultiBody> multiBodies = new ArrayList();
    private final ArrayList<btCollisionObject> collisionObjects = new ArrayList();
    private final ArrayList<BulletTerrainObject> terrainObjects = new ArrayList();
    private final ReferenceFrame inertialFrame;
    private final YoRegistry rootRegistry;
    private final YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
    private final ArrayList<YoPoint3D> contactPoints = new ArrayList();
    private final List<BulletRobot> robotList;
    private final List<TerrainObjectDefinition> terrainObjectDefinitions;
    private boolean initialize;
    private final ArrayList<Runnable> postTickCallbacks;

    public BulletPhysicsEngine(ReferenceFrame inertialFrame, YoRegistry rootRegistry) {
        for (int i = 0; i < 100; ++i) {
            this.contactPoints.add(new YoPoint3D("contactPoint" + i, this.physicsEngineRegistry));
        }
        this.robotList = new ArrayList<BulletRobot>();
        this.terrainObjectDefinitions = new ArrayList<TerrainObjectDefinition>();
        this.initialize = true;
        this.postTickCallbacks = new ArrayList();
        this.inertialFrame = inertialFrame;
        this.rootRegistry = rootRegistry;
        this.collisionConfiguration = new btDefaultCollisionConfiguration();
        this.collisionDispatcher = new btCollisionDispatcher(this.collisionConfiguration);
        this.broadphase = new btDbvtBroadphase();
        this.solver = new btMultiBodyConstraintSolver();
        this.multiBodyDynamicsWorld = new btMultiBodyDynamicsWorld((btDispatcher)this.collisionDispatcher, this.broadphase, this.solver, this.collisionConfiguration);
        Vector3 gravity = new Vector3(0.0f, 0.0f, -9.81f);
        this.multiBodyDynamicsWorld.setGravity(gravity);
    }

    private void setupDrawingDebugMeshes() {
    }

    public boolean initialize(Vector3DReadOnly gravity) {
        if (!this.initialize) {
            return false;
        }
        this.rootRegistry.addChild(this.physicsEngineRegistry);
        for (BulletRobot robot : this.robotList) {
            robot.initializeState();
            robot.updateSensors();
            robot.getControllerManager().initializeControllers();
        }
        this.initialize = false;
        return true;
    }

    public void simulate(double currentTime, double dt, Vector3DReadOnly gravity) {
        float fixedTimeStep;
        if (this.initialize(gravity)) {
            return;
        }
        for (BulletRobot robot : this.robotList) {
            robot.getControllerManager().updateControllers(currentTime);
            robot.getControllerManager().writeControllerOutput(JointStateType.EFFORT);
            robot.getControllerManager().writeControllerOutputForJointsToIgnore(JointStateType.values());
            robot.saveRobotBeforePhysicsState();
        }
        int maxSubSteps = 1;
        float timePassedSinceThisWasCalledLast = fixedTimeStep = (float)dt;
        this.multiBodyDynamicsWorld.stepSimulation(timePassedSinceThisWasCalledLast, maxSubSteps, fixedTimeStep);
        for (BulletRobot robot : this.robotList) {
            robot.updateFromBulletData(this, dt);
            robot.updateFrames();
            robot.updateSensors();
        }
    }

    public void pause() {
        for (BulletRobot robot : this.robotList) {
            robot.getControllerManager().pauseControllers();
        }
    }

    public void addRobot(Robot robot) {
        this.inertialFrame.checkReferenceFrameMatch(robot.getInertialFrame());
        BulletRobot bulletRobot = new BulletRobot(robot, this.physicsEngineRegistry, this);
        this.multiBodyDynamicsWorld.addMultiBody(bulletRobot.getBulletMultiBody());
        this.rootRegistry.addChild(bulletRobot.getRegistry());
        this.robotList.add(bulletRobot);
    }

    public void destroy() {
        System.out.println("Destroy");
        for (btRigidBody rigidBody : this.rigidBodies) {
            this.multiBodyDynamicsWorld.removeRigidBody(rigidBody);
            rigidBody.dispose();
        }
        for (btMultiBody multiBody : this.multiBodies) {
            this.multiBodyDynamicsWorld.removeMultiBody(multiBody);
            multiBody.dispose();
        }
        for (btCollisionObject shape : this.collisionObjects) {
            this.multiBodyDynamicsWorld.removeCollisionObject(shape);
            shape.dispose();
        }
        this.collisionObjects.clear();
        this.multiBodyDynamicsWorld.dispose();
        this.collisionConfiguration.dispose();
        this.collisionDispatcher.dispose();
        this.broadphase.dispose();
        this.solver.dispose();
    }

    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        this.terrainObjectDefinitions.add(terrainObjectDefinition);
        this.terrainObjects.add(new BulletTerrainObject(terrainObjectDefinition, this.multiBodyDynamicsWorld));
    }

    public void addMultiBodyCollisionShape(btMultiBodyLinkCollider collisionShape, int collisionGroup, int collisionGroupMask) {
        this.multiBodyDynamicsWorld.addCollisionObject((btCollisionObject)collisionShape, collisionGroup, collisionGroupMask);
    }

    public void addPostTickCallback(Runnable postTickCallback) {
        this.postTickCallbacks.add(postTickCallback);
    }

    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public List<? extends Robot> getRobots() {
        return this.robotList.stream().map(RobotExtension::getRobot).collect(Collectors.toList());
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotList.stream().map(RobotInterface::getRobotDefinition).collect(Collectors.toList());
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjectDefinitions;
    }

    public List<RobotStateDefinition> getBeforePhysicsRobotStateDefinitions() {
        return this.robotList.stream().map(RobotExtension::getRobotBeforePhysicsStateDefinition).collect(Collectors.toList());
    }

    public YoRegistry getPhysicsEngineRegistry() {
        return this.physicsEngineRegistry;
    }

    public btMultiBodyDynamicsWorld getBulletMultiBodyDynamicsWorld() {
        return this.multiBodyDynamicsWorld;
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
    }
}

