/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyDynamicsWorld;
import com.badlogic.gdx.physics.bullet.linearmath.btIDebugDraw;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.PrivateAnimationTimer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class BulletDebugDrawingNode
extends Group {
    private final btIDebugDraw btIDebugDraw;
    private int debugMode = 1;
    private final btMultiBodyDynamicsWorld multiBodyDynamicsWorld;
    private final JavaFXMultiColorMeshBuilder meshHelper = new JavaFXMultiColorMeshBuilder();
    private PrivateAnimationTimer animationTimer;
    private int lineDraws;
    private final int maxLineDrawsPerModel = 100;
    private final YoRegistry yoRegistry = new YoRegistry(((Object)((Object)this)).getClass().getSimpleName());
    private final YoBoolean updateDebugDrawings = new YoBoolean("updateDebugDrawings", this.yoRegistry);
    private final YoBoolean showDebugDrawings = new YoBoolean("showDebugDrawings", this.yoRegistry);
    private final Color phongColor = Color.LIGHTGRAY;
    private final Point3D fromEuclid = new Point3D();
    private final Point3D toEuclid = new Point3D();
    private final Point3D pointOnEuclid = new Point3D();

    public BulletDebugDrawingNode(btMultiBodyDynamicsWorld multiBodyDynamicsWorld) {
        this.multiBodyDynamicsWorld = multiBodyDynamicsWorld;
        this.updateDebugDrawings.set(true);
        this.showDebugDrawings.set(true);
        this.btIDebugDraw = new btIDebugDraw(){

            public void drawLine(Vector3 from, Vector3 to, Vector3 color) {
                if (BulletDebugDrawingNode.this.lineDraws >= 100) {
                    BulletDebugDrawingNode.this.lineDraws = 0;
                    BulletDebugDrawingNode.this.nextModel();
                }
                BulletTools.toEuclid(from, (Point3DBasics)BulletDebugDrawingNode.this.fromEuclid);
                BulletTools.toEuclid(to, (Point3DBasics)BulletDebugDrawingNode.this.toEuclid);
                Color colorJavaFX = new Color((double)color.x, (double)color.y, (double)color.z, 1.0);
                BulletDebugDrawingNode.this.meshHelper.addLine((Tuple3DReadOnly)BulletDebugDrawingNode.this.fromEuclid, (Tuple3DReadOnly)BulletDebugDrawingNode.this.toEuclid, 0.002, colorJavaFX);
                ++BulletDebugDrawingNode.this.lineDraws;
            }

            public void drawContactPoint(Vector3 pointOnB, Vector3 normalOnB, float distance, int lifeTime, Vector3 color) {
                Color colorJavaFX = new Color((double)color.x, (double)color.y, (double)color.z, 1.0);
                BulletTools.toEuclid(pointOnB, (Point3DBasics)BulletDebugDrawingNode.this.pointOnEuclid);
                BulletDebugDrawingNode.this.meshHelper.addSphere(0.005, (Tuple3DReadOnly)BulletDebugDrawingNode.this.pointOnEuclid, colorJavaFX);
                BulletTools.toEuclid(normalOnB, (Point3DBasics)BulletDebugDrawingNode.this.pointOnEuclid);
                BulletDebugDrawingNode.this.meshHelper.addSphere(0.005, (Tuple3DReadOnly)BulletDebugDrawingNode.this.pointOnEuclid, colorJavaFX);
            }

            public void drawTriangle(Vector3 v0, Vector3 v1, Vector3 v2, Vector3 color, float alpha) {
            }

            public void reportErrorWarning(String warningString) {
                LogTools.error((String)"Bullet: {}", (Object)warningString);
            }

            public void draw3dText(Vector3 location, String textString) {
            }

            public void setDebugMode(int debugMode) {
                BulletDebugDrawingNode.this.debugMode = debugMode;
            }

            public int getDebugMode() {
                return BulletDebugDrawingNode.this.debugMode;
            }
        };
        multiBodyDynamicsWorld.setDebugDrawer(this.btIDebugDraw);
    }

    public void initializeWithJavaFX() {
        this.animationTimer = new PrivateAnimationTimer(this::update);
        this.animationTimer.start();
    }

    public void update(long now) {
        if (!this.showDebugDrawings.getBooleanValue()) {
            this.getChildren().clear();
            return;
        }
        if (this.updateDebugDrawings.getBooleanValue()) {
            this.getChildren().clear();
            this.lineDraws = 0;
            this.multiBodyDynamicsWorld.debugDrawWorld();
            this.nextModel();
        }
    }

    private void nextModel() {
        MeshView meshView = new MeshView(this.meshHelper.generateMesh());
        meshView.setMaterial((Material)new PhongMaterial(this.phongColor));
        this.getChildren().add((Object)meshView);
        this.meshHelper.clear();
    }

    public YoRegistry getYoRegistry() {
        return this.yoRegistry;
    }
}

