/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.ContactResultCallback;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObjectWrapper;
import com.badlogic.gdx.physics.bullet.collision.btManifoldPoint;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyDynamicsWorld;
import java.util.ArrayList;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletInternalTickCallbackRegistry;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class BulletContactPairTest {
    private final ArrayList<btManifoldPoint> contactPoints = new ArrayList();
    private final YoRegistry yoRegistry = new YoRegistry("InteractionForcesDemo");
    private final YoInteger numberOfContactPoints = new YoInteger("numberOfContactPoints", this.yoRegistry);
    private final YoDouble pointAX = new YoDouble("pointAX", this.yoRegistry);
    private final YoDouble pointAY = new YoDouble("pointAY", this.yoRegistry);
    private final YoDouble pointAZ = new YoDouble("pointAZ", this.yoRegistry);
    private final YoDouble pointBX = new YoDouble("pointBX", this.yoRegistry);
    private final YoDouble pointBY = new YoDouble("pointBY", this.yoRegistry);
    private final YoDouble pointBZ = new YoDouble("pointBZ", this.yoRegistry);
    private final YoDouble normalX = new YoDouble("normalX", this.yoRegistry);
    private final YoDouble normalY = new YoDouble("normalY", this.yoRegistry);
    private final YoDouble normalZ = new YoDouble("normalZ", this.yoRegistry);
    private final YoDouble distance = new YoDouble("distance", this.yoRegistry);
    private final YoDouble appliedImpulse = new YoDouble("appliedImpulse", this.yoRegistry);
    private final YoDouble appliedImpulseLateral1 = new YoDouble("appliedImpulseLateral1", this.yoRegistry);
    private final YoDouble appliedImpulseLateral2 = new YoDouble("appliedImpulseLateral2", this.yoRegistry);
    private final YoDouble combinedContactDamping1 = new YoDouble("combinedContactDamping1", this.yoRegistry);
    private final YoDouble combinedFriction = new YoDouble("combinedFriction", this.yoRegistry);
    private final YoDouble combinedRestitution = new YoDouble("combinedRestitution", this.yoRegistry);
    private final YoDouble combinedRollingFriction = new YoDouble("combinedRollingFriction", this.yoRegistry);
    private final YoDouble combinedSpinningFriction = new YoDouble("combinedSpinningFriction", this.yoRegistry);
    private final YoDouble contactCFM = new YoDouble("contactCFM", this.yoRegistry);
    private final YoDouble contactERP = new YoDouble("contactERP", this.yoRegistry);
    private final YoDouble contactMotion1 = new YoDouble("contactMotion1", this.yoRegistry);
    private final YoDouble contactMotion2 = new YoDouble("contactMotion2", this.yoRegistry);
    private final YoInteger contactPointFlags = new YoInteger("contactPointFlags", this.yoRegistry);
    private final YoDouble distance1 = new YoDouble("distance1", this.yoRegistry);
    private final YoDouble frictionCFM = new YoDouble("frictionCFM", this.yoRegistry);
    private final YoDouble lateralFrictionDirection1X = new YoDouble("lateralFrictionDirection1X", this.yoRegistry);
    private final YoDouble lateralFrictionDirection1Y = new YoDouble("lateralFrictionDirection1Y", this.yoRegistry);
    private final YoDouble lateralFrictionDirection1Z = new YoDouble("lateralFrictionDirection1Z", this.yoRegistry);
    private final YoDouble lateralFrictionDirection2X = new YoDouble("lateralFrictionDirection2X", this.yoRegistry);
    private final YoDouble lateralFrictionDirection2Y = new YoDouble("lateralFrictionDirection2Y", this.yoRegistry);
    private final YoDouble lateralFrictionDirection2Z = new YoDouble("lateralFrictionDirection2Z", this.yoRegistry);
    private final YoInteger lifeTime = new YoInteger("lifeTime", this.yoRegistry);

    public BulletContactPairTest(btMultiBodyDynamicsWorld multiBodyDynamicsWorld, BulletInternalTickCallbackRegistry internalTickCallbackRegistry, btCollisionObject collisionObjectA, btCollisionObject collisionObjectB) {
        internalTickCallbackRegistry.getPostTickRunnables().add(() -> {
            ContactResultCallback contactResultCallback = new ContactResultCallback(){

                public float addSingleResult(btManifoldPoint contactPoint, btCollisionObjectWrapper collisionObjectAWrapper, int partIdA, int indexA, btCollisionObjectWrapper collisionObjectBWrapper, int partIdB, int indexB) {
                    BulletContactPairTest.this.contactPoints.add(contactPoint);
                    return 0.0f;
                }
            };
            this.contactPoints.clear();
            multiBodyDynamicsWorld.contactPairTest(collisionObjectA, collisionObjectB, contactResultCallback);
            this.numberOfContactPoints.set(this.contactPoints.size());
            for (btManifoldPoint contactPoint : this.contactPoints) {
                Vector3 pointOnA = new Vector3();
                contactPoint.getPositionWorldOnA(pointOnA);
                this.pointAX.set((double)pointOnA.x);
                this.pointAY.set((double)pointOnA.y);
                this.pointAZ.set((double)pointOnA.z);
                RigidBodyTransform arrowTransform = new RigidBodyTransform();
                Vector3 normalOnBGDX = new Vector3();
                contactPoint.getNormalWorldOnB(normalOnBGDX);
                this.normalX.set((double)normalOnBGDX.x);
                this.normalY.set((double)normalOnBGDX.y);
                this.normalZ.set((double)normalOnBGDX.z);
                Vector3D normalOnBEuclid = new Vector3D();
                BulletTools.toEuclid(normalOnBGDX, (Vector3DBasics)normalOnBEuclid);
                normalOnBEuclid.normalize();
                this.normalX.set(normalOnBEuclid.getX());
                this.normalY.set(normalOnBEuclid.getY());
                this.normalZ.set(normalOnBEuclid.getZ());
                Quaternion arrowOrientation = new Quaternion();
                EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)normalOnBEuclid, (Orientation3DBasics)arrowOrientation);
                Vector3 pointOnB = new Vector3();
                contactPoint.getPositionWorldOnB(pointOnB);
                this.pointBX.set((double)pointOnB.x);
                this.pointBY.set((double)pointOnB.y);
                this.pointBZ.set((double)pointOnB.z);
                Point3D pointOnBEuclid = new Point3D();
                BulletTools.toEuclid(pointOnB, (Point3DBasics)pointOnBEuclid);
                arrowTransform.set((Orientation3DReadOnly)arrowOrientation, (Tuple3DReadOnly)pointOnBEuclid);
                float distance = contactPoint.getDistance();
                float appliedImpulse = contactPoint.getAppliedImpulse();
                float appliedImpulseLateral1 = contactPoint.getAppliedImpulseLateral1();
                float appliedImpulseLateral2 = contactPoint.getAppliedImpulseLateral2();
                float combinedContactDamping1 = contactPoint.getCombinedContactDamping1();
                float combinedFriction = contactPoint.getCombinedFriction();
                float combinedRestitution = contactPoint.getCombinedRestitution();
                float combinedRollingFriction = contactPoint.getCombinedRollingFriction();
                float combinedSpinningFriction = contactPoint.getCombinedSpinningFriction();
                float contactCFM = contactPoint.getContactCFM();
                float contactERP = contactPoint.getContactERP();
                float contactMotion1 = contactPoint.getContactMotion1();
                float contactMotion2 = contactPoint.getContactMotion2();
                int contactPointFlags = contactPoint.getContactPointFlags();
                float distance1 = contactPoint.getDistance1();
                float frictionCFM = contactPoint.getFrictionCFM();
                Vector3 lateralFrictionDirection1 = new Vector3();
                contactPoint.getLateralFrictionDir1(lateralFrictionDirection1);
                Vector3 lateralFrictionDirection2 = new Vector3();
                contactPoint.getLateralFrictionDir2(lateralFrictionDirection2);
                int lifeTime = contactPoint.getLifeTime();
                this.distance.set((double)distance);
                this.appliedImpulse.set((double)appliedImpulse);
                this.appliedImpulseLateral1.set((double)appliedImpulseLateral1);
                this.appliedImpulseLateral2.set((double)appliedImpulseLateral2);
                this.combinedContactDamping1.set((double)combinedContactDamping1);
                this.combinedFriction.set((double)combinedFriction);
                this.combinedRestitution.set((double)combinedRestitution);
                this.combinedRollingFriction.set((double)combinedRollingFriction);
                this.combinedSpinningFriction.set((double)combinedSpinningFriction);
                this.contactCFM.set((double)contactCFM);
                this.contactERP.set((double)contactERP);
                this.contactMotion1.set((double)contactMotion1);
                this.contactMotion2.set((double)contactMotion2);
                this.contactPointFlags.set(contactPointFlags);
                this.distance1.set((double)distance1);
                this.frictionCFM.set((double)frictionCFM);
                this.lateralFrictionDirection1X.set((double)lateralFrictionDirection1.x);
                this.lateralFrictionDirection1Y.set((double)lateralFrictionDirection1.y);
                this.lateralFrictionDirection1Z.set((double)lateralFrictionDirection1.z);
                this.lateralFrictionDirection2X.set((double)lateralFrictionDirection2.x);
                this.lateralFrictionDirection2Y.set((double)lateralFrictionDirection2.y);
                this.lateralFrictionDirection2Z.set((double)lateralFrictionDirection2.z);
                this.lifeTime.set(lifeTime);
            }
        });
    }
}

