/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;

public class BulletMultiBodyParametersTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testDefaultBulletMultiBodyParameters() {
        BulletMultiBodyParameters parameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        Vector3 intertia = new Vector3();
        btMultiBody btMultiBody2 = new btMultiBody(0, 1.0f, intertia, false, parameters.getCanSleep());
        BulletMultiBodyParametersTest.assertParametersEqual(btMultiBody2.getCanSleep(), btMultiBody2.hasSelfCollision(), btMultiBody2.getUseGyroTerm(), btMultiBody2.isUsingGlobalVelocities(), btMultiBody2.isUsingRK4Integration(), btMultiBody2.getLinearDamping(), btMultiBody2.getAngularDamping(), btMultiBody2.getMaxAppliedImpulse(), btMultiBody2.getMaxCoordinateVelocity(), parameters);
    }

    @Test
    public void testConstructor() {
        Random random = new Random(9531271L);
        for (int i = 0; i < 1000; ++i) {
            boolean canSleep = random.nextBoolean();
            boolean hasSelfCollision = random.nextBoolean();
            boolean useGyroTerm = random.nextBoolean();
            boolean useGlobalVelocities = random.nextBoolean();
            boolean useRK4Integration = random.nextBoolean();
            double linearDamping = random.nextDouble();
            double angularDamping = random.nextDouble();
            double maxAppliedImpulse = random.nextDouble();
            double maxCoordinateVelocity = random.nextDouble();
            BulletMultiBodyParameters parameters = new BulletMultiBodyParameters(canSleep, hasSelfCollision, useGyroTerm, useGlobalVelocities, useRK4Integration, linearDamping, angularDamping, maxAppliedImpulse, maxCoordinateVelocity);
            BulletMultiBodyParametersTest.assertParametersEqual(canSleep, hasSelfCollision, useGyroTerm, useGlobalVelocities, useRK4Integration, linearDamping, angularDamping, maxAppliedImpulse, maxCoordinateVelocity, parameters);
        }
    }

    @Test
    public void testSetters() {
        Random random = new Random(458791L);
        for (int i = 0; i < 1000; ++i) {
            boolean canSleep = random.nextBoolean();
            boolean hasSelfCollision = random.nextBoolean();
            boolean useGyroTerm = random.nextBoolean();
            boolean useGlobalVelocities = random.nextBoolean();
            boolean useRK4Integration = random.nextBoolean();
            double linearDamping = random.nextDouble();
            double angularDamping = random.nextDouble();
            double maxAppliedImpulse = random.nextDouble();
            double maxCoordinateVelocity = random.nextDouble();
            BulletMultiBodyParameters parameters = new BulletMultiBodyParameters();
            parameters.setCanSleep(canSleep);
            parameters.setHasSelfCollision(hasSelfCollision);
            parameters.setUseGyroTerm(useGyroTerm);
            parameters.setUseGlobalVelocities(useGlobalVelocities);
            parameters.setUseRK4Integration(useRK4Integration);
            parameters.setLinearDamping(linearDamping);
            parameters.setAngularDamping(angularDamping);
            parameters.setMaxAppliedImpulse(maxAppliedImpulse);
            parameters.setMaxCoordinateVelocity(maxCoordinateVelocity);
            BulletMultiBodyParametersTest.assertParametersEqual(canSleep, hasSelfCollision, useGyroTerm, useGlobalVelocities, useRK4Integration, linearDamping, angularDamping, maxAppliedImpulse, maxCoordinateVelocity, parameters);
        }
    }

    private static void assertParametersEqual(boolean canSleep, boolean hasSelfCollision, boolean useGyroTerm, boolean useGlobalVelocities, boolean useRK4Integration, double linearDamping, double angularDamping, double maxAppliedImpulse, double maxCoordinateVelocity, BulletMultiBodyParameters parameters) {
        Assertions.assertEquals((Object)canSleep, (Object)parameters.getCanSleep());
        Assertions.assertEquals((Object)hasSelfCollision, (Object)parameters.getHasSelfCollision());
        Assertions.assertEquals((Object)useGyroTerm, (Object)parameters.getUseGyroTerm());
        Assertions.assertEquals((Object)useGlobalVelocities, (Object)parameters.getUseGlobalVelocities());
        Assertions.assertEquals((Object)useRK4Integration, (Object)parameters.getUseRK4Integration());
        Assertions.assertEquals((float)((float)linearDamping), (float)((float)parameters.getLinearDamping()));
        Assertions.assertEquals((float)((float)angularDamping), (float)((float)parameters.getAngularDamping()));
        Assertions.assertEquals((float)((float)maxAppliedImpulse), (float)((float)parameters.getMaxAppliedImpulse()));
        Assertions.assertEquals((float)((float)maxCoordinateVelocity), (float)((float)parameters.getMaxCoordinateVelocity()));
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
    }
}

