/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.collision.btCapsuleShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.collision.btConeShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btCylinderShapeZ;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainObject;

public class BulletTerrainFactoryTest {
    private static final double EPSILON = 1.0E-5;
    private static final int ITERATIONS = 1000;
    private static final Vector3 boxVertex;

    @Test
    public void testNewInstance() {
        Matrix4 childTransform;
        btCompoundShape compoundShape;
        BulletTerrainObject bulletTerrainObject;
        TerrainObjectDefinition terrain;
        RigidBodyTransform terrainPose;
        Box3DDefinition terrainGeometry;
        int i;
        Random random = new Random(223174L);
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Box3DDefinition(random.nextDouble(), random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = (btCompoundShape)bulletTerrainObject.getBtRigidBody().getCollisionShape();
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)0);
            Assertions.assertEquals((int)bulletTerrainObject.getCollisionGroup(), (int)1);
            Assertions.assertEquals((int)bulletTerrainObject.getCollisionGroupMask(), (int)-1);
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btBoxShape btBoxShape2 = (btBoxShape)compoundShape.getChildShape(0);
            for (int j = 0; j < btBoxShape2.getNumEdges(); ++j) {
                btBoxShape2.getVertex(j, boxVertex);
                Assertions.assertEquals((double)Math.abs(BulletTerrainFactoryTest.boxVertex.x), (double)((float)terrainGeometry.getSizeX() / 2.0f), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(BulletTerrainFactoryTest.boxVertex.y), (double)((float)terrainGeometry.getSizeY() / 2.0f), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(BulletTerrainFactoryTest.boxVertex.z), (double)((float)terrainGeometry.getSizeZ() / 2.0f), (double)1.0E-5);
            }
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Sphere3DDefinition(random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = (btCompoundShape)bulletTerrainObject.getBtRigidBody().getCollisionShape();
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)8);
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btSphereShape sphereShape = (btSphereShape)compoundShape.getChildShape(0);
            Assertions.assertEquals((float)sphereShape.getRadius(), (float)((float)terrainGeometry.getRadius()));
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Cylinder3DDefinition(random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = (btCompoundShape)bulletTerrainObject.getBtRigidBody().getCollisionShape();
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)13);
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btCylinderShapeZ cylinderShape = (btCylinderShapeZ)compoundShape.getChildShape(0);
            Assertions.assertEquals((double)cylinderShape.getRadius(), (double)((float)terrainGeometry.getRadius()), (double)1.0E-5);
            Assertions.assertEquals((double)cylinderShape.getHalfExtentsWithMargin().z, (double)((float)terrainGeometry.getLength() / 2.0f), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Cone3DDefinition(random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = (btCompoundShape)bulletTerrainObject.getBtRigidBody().getCollisionShape();
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)11);
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btConeShapeZ coneShape = (btConeShapeZ)compoundShape.getChildShape(0);
            Assertions.assertEquals((double)coneShape.getRadius(), (double)((float)terrainGeometry.getRadius()), (double)1.0E-5);
            Assertions.assertEquals((double)coneShape.getHeight(), (double)((float)terrainGeometry.getHeight()), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Capsule3DDefinition(random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = (btCompoundShape)bulletTerrainObject.getBtRigidBody().getCollisionShape();
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)10);
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btCapsuleShapeZ capsuleShape = (btCapsuleShapeZ)compoundShape.getChildShape(0);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)((float)terrainGeometry.getRadiusX()), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)((float)terrainGeometry.getRadiusY()), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)((float)terrainGeometry.getRadiusZ()), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getHalfHeight(), (double)((float)terrainGeometry.getLength() / 2.0f), (double)1.0E-5);
        }
    }

    private static void assertChildTransformEqualToTerrainPose(RigidBodyTransform terrainPose, Matrix4 childTransform) {
        Assertions.assertEquals((double)childTransform.val[0], (double)((float)terrainPose.getM00()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[4], (double)((float)terrainPose.getM01()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[8], (double)((float)terrainPose.getM02()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[1], (double)((float)terrainPose.getM10()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[5], (double)((float)terrainPose.getM11()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[9], (double)((float)terrainPose.getM12()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[2], (double)((float)terrainPose.getM20()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[6], (double)((float)terrainPose.getM21()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[10], (double)((float)terrainPose.getM22()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[12], (double)((float)terrainPose.getM03()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[13], (double)((float)terrainPose.getM13()), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.val[14], (double)((float)terrainPose.getM23()), (double)1.0E-5);
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
        boxVertex = new Vector3();
    }
}

