/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletSimulationParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletSimulationParameters;

public class BulletPhysicsEngineFactoryTest {
    private static final int ITERATIONS = 100;

    @Test
    public void testNewInstance() {
        Random random = new Random(21584L);
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory());
        Assertions.assertEquals(simulationSession.getPhysicsEngine().getClass(), BulletPhysicsEngine.class);
        BulletPhysicsEngine bulletPhysicsEngine = (BulletPhysicsEngine)simulationSession.getPhysicsEngine();
        YoBulletMultiBodyJointParameters globalBulletMultiBodyJointParameters = bulletPhysicsEngine.getGlobalBulletMultiBodyJointParameters();
        BulletMultiBodyJointParameters defaultJointParameters = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        YoBulletMultiBodyParameters globalBulletMultiBodyParameters = bulletPhysicsEngine.getGlobalBulletMultiBodyParameters();
        BulletMultiBodyParameters defaultParameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        YoBulletSimulationParameters globalBulletSimulationParameters = bulletPhysicsEngine.getGlobalSimulationParameters();
        BulletSimulationParameters defaultSimulationParameters = new BulletSimulationParameters();
        BulletPhysicsEngineFactoryTest.assetParametersEqual(defaultParameters, defaultJointParameters, defaultSimulationParameters, globalBulletMultiBodyParameters, globalBulletMultiBodyJointParameters, globalBulletSimulationParameters);
        bulletPhysicsEngine.dispose();
        for (int i = 0; i < 100; ++i) {
            BulletMultiBodyParameters parameters = new BulletMultiBodyParameters(random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            BulletMultiBodyJointParameters jointParameters = new BulletMultiBodyJointParameters(random.nextBoolean(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            SimulationSession simulationSessionWithParameters = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)parameters, (BulletMultiBodyJointParameters)jointParameters));
            Assertions.assertEquals(simulationSession.getPhysicsEngine().getClass(), BulletPhysicsEngine.class);
            BulletPhysicsEngine bulletPhysicsEngineWithParameters = (BulletPhysicsEngine)simulationSessionWithParameters.getPhysicsEngine();
            YoBulletMultiBodyParameters globalBulletMultiBodyParametersFromPhysicsEngine = bulletPhysicsEngineWithParameters.getGlobalBulletMultiBodyParameters();
            YoBulletMultiBodyJointParameters globalBulletMultiBodyJointParametersFromPhysicsEngine = bulletPhysicsEngineWithParameters.getGlobalBulletMultiBodyJointParameters();
            BulletSimulationParameters simulationParameters = new BulletSimulationParameters(random.nextDouble(), random.nextInt(), random.nextDouble());
            bulletPhysicsEngineWithParameters.setGlobalSimulationParameters(simulationParameters);
            YoBulletSimulationParameters globalBulletSimulationParametersFromPhysicsEngine = bulletPhysicsEngineWithParameters.getGlobalSimulationParameters();
            BulletPhysicsEngineFactoryTest.assetParametersEqual(parameters, jointParameters, simulationParameters, globalBulletMultiBodyParametersFromPhysicsEngine, globalBulletMultiBodyJointParametersFromPhysicsEngine, globalBulletSimulationParametersFromPhysicsEngine);
            bulletPhysicsEngineWithParameters.dispose();
        }
    }

    private static void assetParametersEqual(BulletMultiBodyParameters parameters, BulletMultiBodyJointParameters jointParameters, BulletSimulationParameters simulationParameters, YoBulletMultiBodyParameters globalBulletMultiBodyParameters, YoBulletMultiBodyJointParameters globalBulletMultiBodyJointParameters, YoBulletSimulationParameters globalBulletSimulationParameters) {
        Assertions.assertEquals((double)globalBulletMultiBodyParameters.getAngularDamping(), (double)parameters.getAngularDamping());
        Assertions.assertEquals((double)globalBulletMultiBodyParameters.getLinearDamping(), (double)parameters.getLinearDamping());
        Assertions.assertEquals((Object)globalBulletMultiBodyParameters.getCanSleep(), (Object)parameters.getCanSleep());
        Assertions.assertEquals((Object)globalBulletMultiBodyParameters.getHasSelfCollision(), (Object)parameters.getHasSelfCollision());
        Assertions.assertEquals((double)globalBulletMultiBodyParameters.getMaxAppliedImpulse(), (double)parameters.getMaxAppliedImpulse());
        Assertions.assertEquals((double)globalBulletMultiBodyParameters.getMaxCoordinateVelocity(), (double)parameters.getMaxCoordinateVelocity());
        Assertions.assertEquals((Object)globalBulletMultiBodyParameters.getUseGlobalVelocities(), (Object)parameters.getUseGlobalVelocities());
        Assertions.assertEquals((Object)globalBulletMultiBodyParameters.getUseGyroTerm(), (Object)parameters.getUseGyroTerm());
        Assertions.assertEquals((Object)globalBulletMultiBodyParameters.getUseRK4Integration(), (Object)parameters.getUseRK4Integration());
        Assertions.assertFalse((boolean)globalBulletMultiBodyParameters.getUpdateGlobalMultiBodyParameters());
        Assertions.assertEquals((double)globalBulletMultiBodyJointParameters.getJointContactProcessingThreshold(), (double)jointParameters.getJointContactProcessingThreshold());
        Assertions.assertEquals((Object)globalBulletMultiBodyJointParameters.getJointDisableParentCollision(), (Object)jointParameters.getJointDisableParentCollision());
        Assertions.assertEquals((double)globalBulletMultiBodyJointParameters.getJointFriction(), (double)jointParameters.getJointFriction());
        Assertions.assertEquals((double)globalBulletMultiBodyJointParameters.getJointHitFraction(), (double)jointParameters.getJointHitFraction());
        Assertions.assertEquals((double)globalBulletMultiBodyJointParameters.getJointRestitution(), (double)jointParameters.getJointRestitution());
        Assertions.assertEquals((double)globalBulletMultiBodyJointParameters.getJointRollingFriction(), (double)jointParameters.getJointRollingFriction());
        Assertions.assertEquals((double)globalBulletMultiBodyJointParameters.getJointSpinningFriction(), (double)jointParameters.getJointSpinningFriction());
        Assertions.assertFalse((boolean)globalBulletMultiBodyJointParameters.getUpdateGlobalMultiBodyJointParameters());
        Assertions.assertEquals((double)globalBulletSimulationParameters.getTimeStamp(), (double)simulationParameters.getTimeStep());
        Assertions.assertEquals((int)globalBulletSimulationParameters.getMaxSubSteps(), (int)simulationParameters.getMaxSubSteps());
        Assertions.assertEquals((double)globalBulletSimulationParameters.getFixedTimeStep(), (double)simulationParameters.getFixedTimeStep());
    }
}

