/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.Random;
import org.bytedeco.bullet.BulletCollision.btBoxShape;
import org.bytedeco.bullet.BulletCollision.btCapsuleShapeZ;
import org.bytedeco.bullet.BulletCollision.btCollisionShape;
import org.bytedeco.bullet.BulletCollision.btConeShapeZ;
import org.bytedeco.bullet.BulletCollision.btCylinderShapeZ;
import org.bytedeco.bullet.BulletCollision.btSphereShape;
import org.bytedeco.bullet.LinearMath.btQuaternion;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.PyramidBox3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletBroadphaseNativeTypes;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public class BulletToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-5;
    private final btTransform bulletAffineToPack = new btTransform();
    private final RigidBodyTransform rigidBodyTransformToPack = new RigidBodyTransform();
    private final btVector3 translation = new btVector3();
    private final btTransform bulletAffine = new btTransform();
    private final btVector3 vector1 = new btVector3();
    private final btQuaternion bulletQuaternion = new btQuaternion();
    private final Vector3DBasics euclidVector3D = new Vector3D();
    private final Point3DBasics euclidPoint3D = new Point3D();

    @Test
    public void testRigidBodyTransformToMatrix4() {
        for (int i = 0; i < 1000; ++i) {
            Random random = new Random(14474L);
            RigidBodyTransform rigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            BulletTools.toBullet((RigidBodyTransform)rigidBodyTransform, (btTransform)this.bulletAffineToPack);
            Assertions.assertEquals((double)this.bulletAffineToPack.getOrigin().getX(), (double)rigidBodyTransform.getTranslationX(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getOrigin().getY(), (double)rigidBodyTransform.getTranslationY(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getOrigin().getZ(), (double)rigidBodyTransform.getTranslationZ(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(0).getX(), (double)rigidBodyTransform.getRotation().getM00(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(0).getY(), (double)rigidBodyTransform.getRotation().getM01(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(0).getZ(), (double)rigidBodyTransform.getRotation().getM02(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(1).getX(), (double)rigidBodyTransform.getRotation().getM10(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(1).getY(), (double)rigidBodyTransform.getRotation().getM11(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(1).getZ(), (double)rigidBodyTransform.getRotation().getM12(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(2).getX(), (double)rigidBodyTransform.getRotation().getM20(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(2).getY(), (double)rigidBodyTransform.getRotation().getM21(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffineToPack.getBasis().getRow(2).getZ(), (double)rigidBodyTransform.getRotation().getM22(), (double)1.0E-5);
        }
    }

    @Test
    public void testMatrix4ToRigidBodyTransform() {
        Random random = new Random(14474L);
        for (int i = 0; i < 1000; ++i) {
            this.vector1.setX(random.nextDouble());
            this.vector1.setY(random.nextDouble());
            this.vector1.setZ(random.nextDouble());
            this.bulletQuaternion.setRotation(this.vector1, random.nextDouble());
            this.bulletAffine.setRotation(this.bulletQuaternion);
            this.translation.setX(random.nextDouble());
            this.translation.setY(random.nextDouble());
            this.translation.setZ(random.nextDouble());
            this.bulletAffine.setOrigin(this.translation);
            BulletTools.toEuclid((btTransform)this.bulletAffine, (RigidBodyTransform)this.rigidBodyTransformToPack);
            Assertions.assertEquals((double)this.bulletAffine.getOrigin().getX(), (double)this.rigidBodyTransformToPack.getTranslationX(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getOrigin().getY(), (double)this.rigidBodyTransformToPack.getTranslationY(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getOrigin().getZ(), (double)this.rigidBodyTransformToPack.getTranslationZ(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(0).getX(), (double)this.rigidBodyTransformToPack.getM00(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(0).getY(), (double)this.rigidBodyTransformToPack.getM01(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(0).getZ(), (double)this.rigidBodyTransformToPack.getM02(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(1).getX(), (double)this.rigidBodyTransformToPack.getM10(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(1).getY(), (double)this.rigidBodyTransformToPack.getM11(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(1).getZ(), (double)this.rigidBodyTransformToPack.getM12(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(2).getX(), (double)this.rigidBodyTransformToPack.getM20(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(2).getY(), (double)this.rigidBodyTransformToPack.getM21(), (double)1.0E-5);
            Assertions.assertEquals((double)this.bulletAffine.getBasis().getRow(2).getZ(), (double)this.rigidBodyTransformToPack.getM22(), (double)1.0E-5);
        }
    }

    @Test
    public void testEuclidQuaternionToBulletQuaternion() {
        Random random = new Random(21714L);
        for (int i = 0; i < 1000; ++i) {
            Quaternion euclidQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            BulletTools.toBullet((Quaternion)euclidQuaternion, (btQuaternion)this.bulletQuaternion);
            Assertions.assertEquals((double)euclidQuaternion.getX(), (double)this.bulletQuaternion.getX(), (double)1.0E-5);
            Assertions.assertEquals((double)euclidQuaternion.getY(), (double)this.bulletQuaternion.getY(), (double)1.0E-5);
            Assertions.assertEquals((double)euclidQuaternion.getZ(), (double)this.bulletQuaternion.getZ(), (double)1.0E-5);
            Assertions.assertEquals((double)euclidQuaternion.getS(), (double)this.bulletQuaternion.getW(), (double)1.0E-5);
        }
    }

    @Test
    public void testTupleToVector3() {
        Random random = new Random(42518L);
        for (int i = 0; i < 1000; ++i) {
            Point3D euclidTuple = EuclidCoreRandomTools.nextPoint3D((Random)random);
            BulletTools.toBullet((Tuple3DReadOnly)euclidTuple, (btVector3)this.vector1);
            Assertions.assertEquals((double)euclidTuple.getX(), (double)this.vector1.getX(), (double)1.0E-5);
            Assertions.assertEquals((double)euclidTuple.getY(), (double)this.vector1.getY(), (double)1.0E-5);
            Assertions.assertEquals((double)euclidTuple.getZ(), (double)this.vector1.getZ(), (double)1.0E-5);
        }
    }

    @Test
    public void testVector3ToVector3D() {
        Random random = new Random(96571L);
        for (int i = 0; i < 1000; ++i) {
            this.vector1.setX(random.nextDouble());
            this.vector1.setY(random.nextDouble());
            this.vector1.setZ(random.nextDouble());
            BulletTools.toEuclid((btVector3)this.vector1, (Vector3DBasics)this.euclidVector3D);
            Assertions.assertEquals((double)this.euclidVector3D.getX(), (double)this.vector1.getX(), (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidVector3D.getY(), (double)this.vector1.getY(), (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidVector3D.getZ(), (double)this.vector1.getZ(), (double)1.0E-5);
        }
    }

    @Test
    public void testVector3ToPoint3DBasics() {
        Random random = new Random(54214L);
        for (int i = 0; i < 1000; ++i) {
            this.vector1.setX(random.nextDouble());
            this.vector1.setY(random.nextDouble());
            this.vector1.setZ(random.nextDouble());
            BulletTools.toEuclid((btVector3)this.vector1, (Point3DBasics)this.euclidPoint3D);
            Assertions.assertEquals((double)this.euclidPoint3D.getX(), (double)this.vector1.getX(), (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidPoint3D.getY(), (double)this.vector1.getY(), (double)1.0E-5);
            Assertions.assertEquals((double)this.euclidPoint3D.getZ(), (double)this.vector1.getZ(), (double)1.0E-5);
        }
    }

    @Test
    public void testCreateBulletCollisionShape() {
        btSphereShape sphereShape;
        btCollisionShape btCollisionShape2;
        CollisionShapeDefinition collisionShapeDefinition;
        int i;
        Random random = new Random(957123L);
        for (i = 0; i < 1000; ++i) {
            Box3DDefinition boxGeometryDefinition = new Box3DDefinition(random.nextDouble(), random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)boxGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)BulletBroadphaseNativeTypes.BOX_SHAPE_PROXYTYPE.ordinal());
            btBoxShape btBoxShape2 = (btBoxShape)btCollisionShape2;
            for (int j = 0; j < btBoxShape2.getNumEdges(); ++j) {
                btBoxShape2.getVertex(j, this.vector1);
                Assertions.assertEquals((double)Math.abs(this.vector1.getX()), (double)(boxGeometryDefinition.getSizeX() / 2.0), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(this.vector1.getY()), (double)(boxGeometryDefinition.getSizeY() / 2.0), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(this.vector1.getZ()), (double)(boxGeometryDefinition.getSizeZ() / 2.0), (double)1.0E-5);
            }
        }
        for (i = 0; i < 1000; ++i) {
            Sphere3DDefinition sphereGeometryDefinition = new Sphere3DDefinition(random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)sphereGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)BulletBroadphaseNativeTypes.SPHERE_SHAPE_PROXYTYPE.ordinal());
            sphereShape = (btSphereShape)btCollisionShape2;
            Assertions.assertEquals((double)sphereShape.getRadius(), (double)sphereGeometryDefinition.getRadius());
        }
        for (i = 0; i < 1000; ++i) {
            Cylinder3DDefinition cylinderGeometryDefinition = new Cylinder3DDefinition(random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)cylinderGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)BulletBroadphaseNativeTypes.CYLINDER_SHAPE_PROXYTYPE.ordinal());
            btCylinderShapeZ cylinderShape = (btCylinderShapeZ)btCollisionShape2;
            Assertions.assertEquals((double)cylinderShape.getRadius(), (double)cylinderGeometryDefinition.getRadius(), (double)1.0E-5);
            Assertions.assertEquals((double)cylinderShape.getHalfExtentsWithMargin().getZ(), (double)(cylinderGeometryDefinition.getLength() / 2.0), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            Cone3DDefinition coneGeometryDefinition = new Cone3DDefinition(random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)coneGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)BulletBroadphaseNativeTypes.CONE_SHAPE_PROXYTYPE.ordinal());
            btConeShapeZ coneShape = (btConeShapeZ)btCollisionShape2;
            Assertions.assertEquals((double)coneShape.getRadius(), (double)coneGeometryDefinition.getRadius(), (double)1.0E-5);
            Assertions.assertEquals((double)coneShape.getHeight(), (double)coneGeometryDefinition.getHeight(), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            Capsule3DDefinition capsuleGeometryDefinition = new Capsule3DDefinition(random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)capsuleGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)BulletBroadphaseNativeTypes.CAPSULE_SHAPE_PROXYTYPE.ordinal());
            btCapsuleShapeZ capsuleShape = (btCapsuleShapeZ)btCollisionShape2;
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)capsuleGeometryDefinition.getRadiusX(), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)capsuleGeometryDefinition.getRadiusY(), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)capsuleGeometryDefinition.getRadiusZ(), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getHalfHeight(), (double)(capsuleGeometryDefinition.getLength() / 2.0), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            Ellipsoid3DDefinition ellipsoidGeometryDefinition = new Ellipsoid3DDefinition(random.nextDouble(), random.nextDouble(), random.nextDouble());
            collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)ellipsoidGeometryDefinition);
            btCollisionShape2 = BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition);
            Assertions.assertEquals((int)btCollisionShape2.getShapeType(), (int)BulletBroadphaseNativeTypes.SPHERE_SHAPE_PROXYTYPE.ordinal());
            sphereShape = (btSphereShape)btCollisionShape2;
            Assertions.assertEquals((double)sphereShape.getRadius(), (double)ellipsoidGeometryDefinition.getRadiusX(), (double)1.0E-5);
            Assertions.assertEquals((double)sphereShape.getLocalScaling().getX(), (double)ellipsoidGeometryDefinition.getRadiusX(), (double)1.0E-5);
            Assertions.assertEquals((double)sphereShape.getLocalScaling().getY(), (double)ellipsoidGeometryDefinition.getRadiusY(), (double)1.0E-5);
            Assertions.assertEquals((double)sphereShape.getLocalScaling().getZ(), (double)ellipsoidGeometryDefinition.getRadiusZ(), (double)1.0E-5);
        }
        PyramidBox3DDefinition polytypeGeometryDefinition = new PyramidBox3DDefinition(1.0, 1.0, 1.0, 1.0);
        CollisionShapeDefinition collisionShapeDefinition2 = new CollisionShapeDefinition((GeometryDefinition)polytypeGeometryDefinition);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> BulletTools.createBulletCollisionShape((CollisionShapeDefinition)collisionShapeDefinition2));
    }
}

