/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.List;
import java.util.Random;
import org.bytedeco.bullet.BulletCollision.btBoxShape;
import org.bytedeco.bullet.BulletCollision.btCapsuleShapeZ;
import org.bytedeco.bullet.BulletCollision.btCompoundShape;
import org.bytedeco.bullet.BulletCollision.btConeShapeZ;
import org.bytedeco.bullet.BulletCollision.btCylinderShape;
import org.bytedeco.bullet.BulletCollision.btSphereShape;
import org.bytedeco.bullet.BulletDynamics.btMultiBody;
import org.bytedeco.bullet.BulletDynamics.btMultiBodyLinkCollider;
import org.bytedeco.bullet.BulletDynamics.btMultibodyLink;
import org.bytedeco.bullet.LinearMath.btQuaternion;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;
import org.bytedeco.javacpp.Pointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletBroadphaseNativeTypes;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobotFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPrismaticJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BulletMultiBodyRobotFactoryTest {
    private final YawPitchRollTransformDefinition inertiaPose = new YawPitchRollTransformDefinition();
    private final YawPitchRollTransformDefinition collisionShapePose = new YawPitchRollTransformDefinition();
    private static final RigidBodyTransform collisionShapeRigidBodyTransform = new RigidBodyTransform();
    private static final btVector3 boxVertex = new btVector3();
    private static final YawPitchRollTransformDefinition TransformToParent = new YawPitchRollTransformDefinition();
    private static final RigidBodyTransform parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid = new RigidBodyTransform();
    private static final RigidBodyTransform parentJointAfterFrameToLinkCenterOfMassTransformEuclid = new RigidBodyTransform();
    private static final double EPSILON = 1.0E-5;
    private static final int ITERATIONS = 1;

    @Test
    public void testNewInstance() {
        BulletMultiBodyRobot bulletMultiBodyRobot;
        Robot robot;
        int i;
        Random random = new Random(42187L);
        String name = "TestRobot";
        YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoBulletMultiBodyParameters globalMultiBodyParameters = new YoBulletMultiBodyParameters("globalMultiBody", physicsEngineRegistry);
        globalMultiBodyParameters.set(BulletMultiBodyParameters.defaultBulletMultiBodyParameters());
        YoBulletMultiBodyJointParameters globalMultiBodyJointParameters = new YoBulletMultiBodyJointParameters("globalMultiJointBody", physicsEngineRegistry);
        globalMultiBodyJointParameters.set(BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            RobotDefinition robotDefinition = new RobotDefinition(name + "RootBody");
            RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RigidBody");
            robotDefinition.setRootBodyDefinition(rootBody);
            Robot robotNoJoints = new Robot(robotDefinition, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
            BulletMultiBodyRobotFactory.newInstance((Robot)robotNoJoints, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
        });
        for (i = 0; i < 1; ++i) {
            robot = BulletMultiBodyRobotFactoryTest.createTestRobotWithoutBaseCollider(random, name + i);
            bulletMultiBodyRobot = BulletMultiBodyRobotFactory.newInstance((Robot)robot, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
            Assertions.assertTrue((bulletMultiBodyRobot.getBtMultiBody().getBaseCollider() == null ? 1 : 0) != 0, (String)"Assert btMultiBody does not have a Base Collider");
            this.assertBulletMultiBodyRobotCreatedCorrectly(robot, bulletMultiBodyRobot, globalMultiBodyParameters, globalMultiBodyJointParameters);
            globalMultiBodyParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyParameters(random));
            globalMultiBodyJointParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyJointParameters(random));
        }
        for (i = 0; i < 1; ++i) {
            robot = BulletMultiBodyRobotFactoryTest.createTestRobotWithBaseCollider(random, name + i);
            bulletMultiBodyRobot = BulletMultiBodyRobotFactory.newInstance((Robot)robot, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
            Assertions.assertTrue((bulletMultiBodyRobot.getBtMultiBody().getBaseCollider() != null ? 1 : 0) != 0, (String)"Assert btMultiBody does not have a Base Collider");
            this.assertBulletMultiBodyRobotCreatedCorrectly(robot, bulletMultiBodyRobot, globalMultiBodyParameters, globalMultiBodyJointParameters);
            globalMultiBodyParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyParameters(random));
            globalMultiBodyJointParameters.set(BulletMultiBodyRobotFactoryTest.nextRandomMultiBodyJointParameters(random));
        }
    }

    @Test
    public void testNewInstanceRegressionTest() {
        YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoBulletMultiBodyParameters globalMultiBodyParameters = new YoBulletMultiBodyParameters("globalMultiBody", physicsEngineRegistry);
        globalMultiBodyParameters.set(BulletMultiBodyParameters.defaultBulletMultiBodyParameters());
        YoBulletMultiBodyJointParameters globalMultiBodyJointParameters = new YoBulletMultiBodyJointParameters("globalMultiJointBody", physicsEngineRegistry);
        globalMultiBodyJointParameters.set(BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters());
        Robot robot = BulletMultiBodyRobotFactoryTest.createTestRobotWithKnownValues();
        BulletMultiBodyRobot bulletMultiBodyRobot = BulletMultiBodyRobotFactory.newInstance((Robot)robot, (YoBulletMultiBodyParameters)globalMultiBodyParameters, (YoBulletMultiBodyJointParameters)globalMultiBodyJointParameters);
        btMultiBody btMultibody = bulletMultiBodyRobot.getBtMultiBody();
        Assertions.assertEquals((int)btMultibody.getNumLinks(), (int)1);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(0).getCollisionGroup(), (int)64);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(0).getCollisionGroupMask(), (int)899);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(1).getCollisionGroup(), (int)1);
        Assertions.assertEquals((int)bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(1).getCollisionGroupMask(), (int)3);
        btVector3 linkAxis = bulletMultiBodyRobot.getBtMultiBody().getLink(0).getAxisTop(0);
        Assertions.assertEquals((double)linkAxis.getX(), (double)0.0);
        Assertions.assertEquals((double)linkAxis.getY(), (double)0.0);
        Assertions.assertEquals((double)linkAxis.getZ(), (double)1.0);
        btMultiBodyLinkCollider baseCollider = bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(0).getBtMultiBodyLinkCollider();
        btMultiBodyLinkCollider linkCollider = bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(1).getBtMultiBodyLinkCollider();
        btCompoundShape baseColliderCompoundShape = new btCompoundShape((Pointer)baseCollider.getCollisionShape());
        Assertions.assertEquals((int)baseColliderCompoundShape.getChildShape(0).getShapeType(), (int)BulletBroadphaseNativeTypes.CYLINDER_SHAPE_PROXYTYPE.ordinal());
        btCylinderShape cylinderShape = new btCylinderShape((Pointer)baseColliderCompoundShape.getChildShape(0));
        Assertions.assertEquals((double)cylinderShape.getRadius(), (double)0.1175);
        Assertions.assertEquals((double)cylinderShape.getHalfExtentsWithMargin().getZ(), (double)0.03);
        Assertions.assertEquals((int)baseColliderCompoundShape.getChildShape(1).getShapeType(), (int)BulletBroadphaseNativeTypes.CYLINDER_SHAPE_PROXYTYPE.ordinal());
        cylinderShape = new btCylinderShape((Pointer)baseColliderCompoundShape.getChildShape(1));
        Assertions.assertEquals((double)cylinderShape.getRadius(), (double)0.12);
        Assertions.assertEquals((double)cylinderShape.getHalfExtentsWithMargin().getZ(), (double)0.02);
        Assertions.assertEquals((int)baseColliderCompoundShape.getChildShape(2).getShapeType(), (int)BulletBroadphaseNativeTypes.CYLINDER_SHAPE_PROXYTYPE.ordinal());
        cylinderShape = new btCylinderShape((Pointer)baseColliderCompoundShape.getChildShape(2));
        Assertions.assertEquals((double)cylinderShape.getRadius(), (double)0.16);
        Assertions.assertEquals((double)cylinderShape.getHalfExtentsWithMargin().getZ(), (double)0.025);
        btCompoundShape linkColliderCompoundShape = new btCompoundShape((Pointer)linkCollider.getCollisionShape());
        Assertions.assertEquals((int)linkColliderCompoundShape.getChildShape(0).getShapeType(), (int)BulletBroadphaseNativeTypes.BOX_SHAPE_PROXYTYPE.ordinal());
        btBoxShape boxShape = new btBoxShape((Pointer)linkColliderCompoundShape.getChildShape(0));
        boxShape.getVertex(0, boxVertex);
        Assertions.assertEquals((double)Math.abs(boxVertex.getX()), (double)0.015, (double)1.0E-5);
        Assertions.assertEquals((double)Math.abs(boxVertex.getY()), (double)0.02, (double)1.0E-5);
        Assertions.assertEquals((double)Math.abs(boxVertex.getZ()), (double)0.01, (double)1.0E-5);
        Assertions.assertEquals((double)linkCollider.getFriction(), (double)globalMultiBodyJointParameters.getJointFriction());
        Assertions.assertEquals((double)linkCollider.getRestitution(), (double)globalMultiBodyJointParameters.getJointRestitution());
        Assertions.assertEquals((double)linkCollider.getHitFraction(), (double)globalMultiBodyJointParameters.getJointHitFraction());
        Assertions.assertEquals((double)linkCollider.getRollingFriction(), (double)globalMultiBodyJointParameters.getJointRollingFriction());
        Assertions.assertEquals((double)linkCollider.getSpinningFriction(), (double)globalMultiBodyJointParameters.getJointSpinningFriction());
        Assertions.assertEquals((double)linkCollider.getContactProcessingThreshold(), (double)globalMultiBodyJointParameters.getJointContactProcessingThreshold());
        Assertions.assertEquals((double)btMultibody.getBaseMass(), (double)9.609);
        Assertions.assertEquals((double)btMultibody.getLinkMass(0), (double)2.27);
    }

    @Test
    public void testBulletCollisionShapeLocalTransform() {
        this.inertiaPose.setTranslation(0.05, 0.08, 0.09);
        this.inertiaPose.setOrientation(0.01, 0.01, 0.01);
        this.collisionShapePose.setTranslation(this.inertiaPose.getX() - 0.01, this.inertiaPose.getY() - 0.01, this.inertiaPose.getZ() - 0.01);
        this.collisionShapePose.setOrientation(this.inertiaPose.getYaw() - 0.004, this.inertiaPose.getPitch() - 0.004, this.inertiaPose.getRoll() - 0.004);
        String robotName = "Robot1";
        Robot robot1 = BulletMultiBodyRobotFactoryTest.createRobotToTestLocalTransform(robotName, this.inertiaPose, this.collisionShapePose);
        CollisionShapeDefinition shapeDefinition = (CollisionShapeDefinition)robot1.getRobotDefinition().getRigidBodyDefinition(robotName + "RigidBody").getCollisionShapeDefinitions().get(0);
        MovingReferenceFrame linkCenterOfMassFrame = ((JointBasics)robot1.getRootBody().getChildrenJoints().get(0)).getSuccessor().getBodyFixedFrame();
        btTransform bulletCollisionShapeLocalTransform = BulletMultiBodyRobotFactory.bulletCollisionShapeLocalTransform((CollisionShapeDefinition)shapeDefinition, (ReferenceFrame)linkCenterOfMassFrame);
        RigidBodyTransform rigidBodyTransformExpectedResults1 = new RigidBodyTransform(0.999984, -0.003959719, 0.004039708, 0.009999639, 0.0039757174, 0.99998426, -0.0039599594, 0.010000003, -0.004023964, 0.0039759567, 0.999984, 0.010000359);
        BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(robotName, bulletCollisionShapeLocalTransform, rigidBodyTransformExpectedResults1);
        this.inertiaPose.setTranslation(0.07, 0.02, 0.01);
        this.inertiaPose.setOrientation(0.03, 0.02, 0.04);
        this.collisionShapePose.setTranslation(0.02, 0.06, 0.03);
        this.collisionShapePose.setOrientation(0.04, 0.02, 0.01);
        robotName = "Robot2";
        Robot robot2 = BulletMultiBodyRobotFactoryTest.createRobotToTestLocalTransform(robotName, this.inertiaPose, this.collisionShapePose);
        shapeDefinition = (CollisionShapeDefinition)robot2.getRobotDefinition().getRigidBodyDefinition(robotName + "RigidBody").getCollisionShapeDefinitions().get(0);
        linkCenterOfMassFrame = ((JointBasics)robot2.getRootBody().getChildrenJoints().get(0)).getSuccessor().getBodyFixedFrame();
        bulletCollisionShapeLocalTransform = BulletMultiBodyRobotFactory.bulletCollisionShapeLocalTransform((CollisionShapeDefinition)shapeDefinition, (ReferenceFrame)linkCenterOfMassFrame);
        RigidBodyTransform rigidBodyTransformExpectedResults2 = new RigidBodyTransform(0.99995, 0.009989796, -4.0080564E-4, 0.048750732, -0.009997344, 0.9994941, -0.030193394, -0.042155657, 9.897699E-5, 0.030195892, 0.999544, -0.018608237);
        BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(robotName, bulletCollisionShapeLocalTransform, rigidBodyTransformExpectedResults2);
        this.inertiaPose.setTranslation(0.0, 0.0, 0.0);
        this.inertiaPose.setOrientation(0.0, 0.0, 0.0);
        this.collisionShapePose.setTranslation(0.0, 0.0, 0.0);
        this.collisionShapePose.setOrientation(0.0, 0.0, 0.0);
        robotName = "Robot3";
        Robot robot3 = BulletMultiBodyRobotFactoryTest.createRobotToTestLocalTransform(robotName, this.inertiaPose, this.collisionShapePose);
        shapeDefinition = (CollisionShapeDefinition)robot3.getRobotDefinition().getRigidBodyDefinition(robotName + "RigidBody").getCollisionShapeDefinitions().get(0);
        linkCenterOfMassFrame = ((JointBasics)robot3.getRootBody().getChildrenJoints().get(0)).getSuccessor().getBodyFixedFrame();
        bulletCollisionShapeLocalTransform = BulletMultiBodyRobotFactory.bulletCollisionShapeLocalTransform((CollisionShapeDefinition)shapeDefinition, (ReferenceFrame)linkCenterOfMassFrame);
        RigidBodyTransform rigidBodyTransformExpectedResults3 = new RigidBodyTransform(1.0, 0.0, 0.0, -0.0, 0.0, 1.0, 0.0, -0.0, 0.0, 0.0, 1.0, -0.0);
        BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(robotName, bulletCollisionShapeLocalTransform, rigidBodyTransformExpectedResults3);
    }

    private static BulletMultiBodyParameters nextRandomMultiBodyParameters(Random random) {
        BulletMultiBodyParameters parameters = new BulletMultiBodyParameters(random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
        return parameters;
    }

    private static BulletMultiBodyJointParameters nextRandomMultiBodyJointParameters(Random random) {
        BulletMultiBodyJointParameters jointParameters = new BulletMultiBodyJointParameters(random.nextBoolean(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
        return jointParameters;
    }

    private void assertBulletMultiBodyRobotCreatedCorrectly(Robot robot, BulletMultiBodyRobot bulletMultiBodyRobot, YoBulletMultiBodyParameters globalMultiBodyParameters, YoBulletMultiBodyJointParameters globalMultiBodyJointParameters) {
        btMultiBody btMultiBody2 = bulletMultiBodyRobot.getBtMultiBody();
        JointBasics rootJoint = (JointBasics)robot.getRootBody().getChildrenJoints().get(0);
        boolean hasBaseCollider = rootJoint instanceof SimFloatingRootJoint;
        RigidBodyDefinition rigidBodyDefinition = ((JointDefinition)robot.getRobotDefinition().getRootBodyDefinition().getChildrenJoints().get(0)).getSuccessor();
        int numberOfLinks = 0;
        for (JointBasics joint : robot.getRootBody().getChildrenJoints()) {
            numberOfLinks += BulletMultiBodyRobotFactoryTest.countJointsAndCreateIndexMap(joint);
        }
        Assertions.assertEquals((double)rigidBodyDefinition.getMass(), (double)btMultiBody2.getBaseMass(), (double)1.0E-5);
        Assertions.assertEquals((int)(hasBaseCollider ? numberOfLinks - 1 : numberOfLinks), (int)btMultiBody2.getNumDofs());
        Assertions.assertEquals((int)(hasBaseCollider ? numberOfLinks - 1 : numberOfLinks), (int)btMultiBody2.getNumLinks());
        Assertions.assertEquals((int)numberOfLinks, (int)bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().size());
        Assertions.assertEquals((int)numberOfLinks, (int)bulletMultiBodyRobot.getBulletMultiBodyLinkColliderArray().size());
        Assertions.assertEquals((Object)btMultiBody2.getCanSleep(), (Object)globalMultiBodyParameters.getCanSleep());
        Assertions.assertEquals((Object)btMultiBody2.hasSelfCollision(), (Object)globalMultiBodyParameters.getHasSelfCollision());
        Assertions.assertEquals((Object)btMultiBody2.getUseGyroTerm(), (Object)globalMultiBodyParameters.getUseGyroTerm());
        Assertions.assertEquals((Object)btMultiBody2.isUsingRK4Integration(), (Object)globalMultiBodyParameters.getUseRK4Integration());
        Assertions.assertEquals((double)btMultiBody2.getLinearDamping(), (double)globalMultiBodyParameters.getLinearDamping(), (double)1.0E-5);
        Assertions.assertEquals((double)btMultiBody2.getAngularDamping(), (double)globalMultiBodyParameters.getAngularDamping(), (double)1.0E-5);
        Assertions.assertEquals((double)btMultiBody2.getMaxAppliedImpulse(), (double)globalMultiBodyParameters.getMaxAppliedImpulse(), (double)1.0E-5);
        Assertions.assertEquals((double)btMultiBody2.getMaxCoordinateVelocity(), (double)globalMultiBodyParameters.getMaxCoordinateVelocity(), (double)1.0E-5);
        for (JointBasics joint : robot.getRootBody().getChildrenJoints()) {
            if (!(joint instanceof SimFloatingRootJoint)) {
                BulletMultiBodyRobotFactoryTest.assertJointAndLinkEqual(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, joint, hasBaseCollider);
            }
            BulletMultiBodyRobotFactoryTest.testChildJoints(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, joint, hasBaseCollider);
        }
    }

    private static void testChildJoints(Robot robot, BulletMultiBodyRobot bulletMultiBodyRobot, YoBulletMultiBodyJointParameters globalMultiBodyJointParameters, btMultiBody btMultiBody2, JointBasics jointBasics, boolean hasBaseCollider) {
        for (JointBasics childJoint : jointBasics.getSuccessor().getChildrenJoints()) {
            BulletMultiBodyRobotFactoryTest.assertJointAndLinkEqual(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, childJoint, hasBaseCollider);
            BulletMultiBodyRobotFactoryTest.testChildJoints(robot, bulletMultiBodyRobot, globalMultiBodyJointParameters, btMultiBody2, childJoint, hasBaseCollider);
        }
    }

    private static void assertJointAndLinkEqual(Robot robot, BulletMultiBodyRobot bulletMultiBodyRobot, YoBulletMultiBodyJointParameters globalMultiBodyJointParameters, btMultiBody btMultiBody2, JointBasics jointBasics, boolean hasBaseCollider) {
        int index = (Integer)bulletMultiBodyRobot.getJointNameToBulletJointIndexMap().get(jointBasics.getName());
        btMultiBodyLinkCollider linkCollider = btMultiBody2.getLinkCollider(index);
        Assertions.assertEquals((double)linkCollider.getFriction(), (double)globalMultiBodyJointParameters.getJointFriction());
        Assertions.assertEquals((double)linkCollider.getRestitution(), (double)globalMultiBodyJointParameters.getJointRestitution());
        Assertions.assertEquals((double)linkCollider.getHitFraction(), (double)globalMultiBodyJointParameters.getJointHitFraction());
        Assertions.assertEquals((double)linkCollider.getRollingFriction(), (double)globalMultiBodyJointParameters.getJointRollingFriction());
        Assertions.assertEquals((double)linkCollider.getSpinningFriction(), (double)globalMultiBodyJointParameters.getJointSpinningFriction());
        Assertions.assertEquals((double)linkCollider.getContactProcessingThreshold(), (double)globalMultiBodyJointParameters.getJointContactProcessingThreshold());
        Assertions.assertEquals((int)btMultiBody2.getLink(index).m_flags(), (int)(globalMultiBodyJointParameters.getJointDisableParentCollision() ? 1 : 0));
        JointDefinition jointDefinition = robot.getRobotDefinition().getJointDefinition(jointBasics.getName());
        RigidBodyDefinition jointRigidBodyDefinition = jointDefinition.getSuccessor();
        btMultiBodyLinkCollider btMultiBodyLinkCollider2 = bulletMultiBodyRobot.getBulletMultiBodyLinkCollider(index + (hasBaseCollider ? 1 : 0)).getBtMultiBodyLinkCollider();
        List collisionShapes = jointRigidBodyDefinition.getCollisionShapeDefinitions();
        btCompoundShape compoundShape = new btCompoundShape((Pointer)btMultiBodyLinkCollider2.getCollisionShape());
        MovingReferenceFrame linkCenterOfMassFrame = jointBasics.getSuccessor().getBodyFixedFrame();
        BulletMultiBodyRobotFactoryTest.assertCollisionShapesSame(collisionShapes, compoundShape, (ReferenceFrame)linkCenterOfMassFrame);
        Assertions.assertEquals((double)jointRigidBodyDefinition.getMass(), (double)btMultiBody2.getLinkMass(index));
        OneDoFJointDefinition oneDoFJointDefinition = (OneDoFJointDefinition)jointDefinition;
        Vector3D jointAxis = oneDoFJointDefinition.getAxis();
        btMultibodyLink link = btMultiBody2.getLink(index);
        Quaternion euclidRotationFromParent = new Quaternion((Orientation3DReadOnly)jointDefinition.getTransformToParent().getRotation());
        euclidRotationFromParent.invert();
        BulletMultiBodyRobotFactoryTest.assertQuaternionEqualsBtQuaternion(euclidRotationFromParent, link.m_zeroRotParentToThis());
        jointBasics.getPredecessor().getBodyFixedFrame().getTransformToDesiredFrame(parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid, (ReferenceFrame)jointBasics.getFrameBeforeJoint());
        parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.invert();
        BulletMultiBodyRobotFactoryTest.assertVector3DBasicsEqualsBtVector3(parentLinkCenterOfMassToParentJointBeforeJointFrameTransformEuclid.getTranslation(), link.m_eVector());
        jointBasics.getFrameAfterJoint().getTransformToDesiredFrame(parentJointAfterFrameToLinkCenterOfMassTransformEuclid, (ReferenceFrame)jointBasics.getSuccessor().getBodyFixedFrame());
        parentJointAfterFrameToLinkCenterOfMassTransformEuclid.invert();
        BulletMultiBodyRobotFactoryTest.assertVector3DBasicsEqualsBtVector3(parentJointAfterFrameToLinkCenterOfMassTransformEuclid.getTranslation(), link.m_dVector());
        if (jointBasics instanceof SimRevoluteJoint) {
            btVector3 linkAxis = link.getAxisTop(0);
            BulletMultiBodyRobotFactoryTest.assertVector3DEqualsVector3(jointAxis, linkAxis);
            Assertions.assertEquals((int)link.m_jointType(), (int)BulletTools.eFeatherstoneJointType.eRevolute.ordinal());
        } else if (jointBasics instanceof SimPrismaticJoint) {
            btVector3 linkAxis = link.getAxisBottom(0);
            BulletMultiBodyRobotFactoryTest.assertVector3DEqualsVector3(jointAxis, linkAxis);
        }
    }

    private static int countJointsAndCreateIndexMap(JointBasics joint) {
        int numberOfJoints = 1;
        for (JointBasics childrenJoint : joint.getSuccessor().getChildrenJoints()) {
            numberOfJoints += BulletMultiBodyRobotFactoryTest.countJointsAndCreateIndexMap(childrenJoint);
        }
        return numberOfJoints;
    }

    private static void assertMatrix4EqualsRigidBodyTransform(String name, btTransform bulletCollisionShapeLocalTransform, RigidBodyTransform rigidBodyTransform) {
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getOrigin().getX(), (double)rigidBodyTransform.getTranslationX(), (double)1.0E-5, (String)(name + " - X is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getOrigin().getY(), (double)rigidBodyTransform.getTranslationY(), (double)1.0E-5, (String)(name + " - Y is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getOrigin().getZ(), (double)rigidBodyTransform.getTranslationZ(), (double)1.0E-5, (String)(name + " - Z is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(0).getX(), (double)rigidBodyTransform.getRotation().getM00(), (double)1.0E-5, (String)(name + " - M00 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(0).getY(), (double)rigidBodyTransform.getRotation().getM01(), (double)1.0E-5, (String)(name + " - M01 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(0).getZ(), (double)rigidBodyTransform.getRotation().getM02(), (double)1.0E-5, (String)(name + " - M02 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(1).getX(), (double)rigidBodyTransform.getRotation().getM10(), (double)1.0E-5, (String)(name + " - M10 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(1).getY(), (double)rigidBodyTransform.getRotation().getM11(), (double)1.0E-5, (String)(name + " - M11 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(1).getZ(), (double)rigidBodyTransform.getRotation().getM12(), (double)1.0E-5, (String)(name + " - M12 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(2).getX(), (double)rigidBodyTransform.getRotation().getM20(), (double)1.0E-5, (String)(name + " - M20 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(2).getY(), (double)rigidBodyTransform.getRotation().getM21(), (double)1.0E-5, (String)(name + " - M21 is not as expected"));
        Assertions.assertEquals((double)bulletCollisionShapeLocalTransform.getBasis().getRow(2).getZ(), (double)rigidBodyTransform.getRotation().getM22(), (double)1.0E-5, (String)(name + " - M22 is not as expected"));
    }

    private static void assertQuaternionEqualsBtQuaternion(Quaternion quaterion, btQuaternion btQuaternion2) {
        Assertions.assertEquals((double)quaterion.getX(), (double)btQuaternion2.getX(), (double)1.0E-5);
        Assertions.assertEquals((double)quaterion.getY(), (double)btQuaternion2.getY(), (double)1.0E-5);
        Assertions.assertEquals((double)quaterion.getZ(), (double)btQuaternion2.getZ(), (double)1.0E-5);
        Assertions.assertEquals((double)quaterion.getS(), (double)btQuaternion2.getW(), (double)1.0E-5);
    }

    private static void assertVector3DEqualsVector3(Vector3D vector3D, btVector3 vector3) {
        Assertions.assertEquals((double)vector3D.getX(), (double)vector3.getX());
        Assertions.assertEquals((double)vector3D.getY(), (double)vector3.getY());
        Assertions.assertEquals((double)vector3D.getZ(), (double)vector3.getZ());
    }

    private static void assertVector3DBasicsEqualsBtVector3(Vector3DBasics vector3DBasics, btVector3 btVector32) {
        Assertions.assertEquals((double)vector3DBasics.getX(), (double)btVector32.getX());
        Assertions.assertEquals((double)vector3DBasics.getY(), (double)btVector32.getY());
        Assertions.assertEquals((double)vector3DBasics.getZ(), (double)btVector32.getZ());
    }

    private static void assertCollisionShapesSame(List<CollisionShapeDefinition> collisionShapes, btCompoundShape compoundShape, ReferenceFrame linkCenterOfMassFrame) {
        for (int j = 0; j < collisionShapes.size(); ++j) {
            BulletBroadphaseNativeTypes shapeType = switch (collisionShapes.get(j).getGeometryDefinition().getName()) {
                case "sphere" -> BulletBroadphaseNativeTypes.SPHERE_SHAPE_PROXYTYPE;
                case "cylinder" -> BulletBroadphaseNativeTypes.CYLINDER_SHAPE_PROXYTYPE;
                case "box" -> BulletBroadphaseNativeTypes.BOX_SHAPE_PROXYTYPE;
                case "cone" -> BulletBroadphaseNativeTypes.CONE_SHAPE_PROXYTYPE;
                case "capsule" -> BulletBroadphaseNativeTypes.CAPSULE_SHAPE_PROXYTYPE;
                default -> BulletBroadphaseNativeTypes.NOT_DEFINED_TYPE;
            };
            if (shapeType == BulletBroadphaseNativeTypes.SPHERE_SHAPE_PROXYTYPE) {
                Sphere3DDefinition sphereShape = (Sphere3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btSphereShape btSphereShape2 = new btSphereShape((Pointer)compoundShape.getChildShape(j));
                Assertions.assertEquals((double)sphereShape.getRadius(), (double)btSphereShape2.getRadius());
            } else if (shapeType == BulletBroadphaseNativeTypes.CYLINDER_SHAPE_PROXYTYPE) {
                Cylinder3DDefinition cylinderShape = (Cylinder3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btCylinderShape btCylinderShape2 = new btCylinderShape((Pointer)compoundShape.getChildShape(j));
                Assertions.assertEquals((double)cylinderShape.getRadius(), (double)btCylinderShape2.getRadius(), (double)1.0E-5);
                Assertions.assertEquals((double)btCylinderShape2.getHalfExtentsWithMargin().getZ(), (double)(cylinderShape.getLength() / 2.0), (double)1.0E-5);
            } else if (shapeType == BulletBroadphaseNativeTypes.BOX_SHAPE_PROXYTYPE) {
                Box3DDefinition boxShape = (Box3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btBoxShape btBoxShape2 = new btBoxShape((Pointer)compoundShape.getChildShape(j));
                for (int k = 0; k < btBoxShape2.getNumEdges(); ++k) {
                    btBoxShape2.getVertex(j, boxVertex);
                    Assertions.assertEquals((double)Math.abs(boxVertex.getX()), (double)(boxShape.getSizeX() / 2.0), (double)1.0E-5);
                    Assertions.assertEquals((double)Math.abs(boxVertex.getY()), (double)(boxShape.getSizeY() / 2.0), (double)1.0E-5);
                    Assertions.assertEquals((double)Math.abs(boxVertex.getZ()), (double)(boxShape.getSizeZ() / 2.0), (double)1.0E-5);
                }
            } else if (shapeType == BulletBroadphaseNativeTypes.CONE_SHAPE_PROXYTYPE) {
                Cone3DDefinition coneShape = (Cone3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btConeShapeZ btConeShape = new btConeShapeZ((Pointer)compoundShape.getChildShape(j));
                Assertions.assertEquals((double)btConeShape.getRadius(), (double)coneShape.getRadius(), (double)1.0E-5);
                Assertions.assertEquals((double)btConeShape.getHeight(), (double)coneShape.getHeight(), (double)1.0E-5);
            } else if (shapeType == BulletBroadphaseNativeTypes.CAPSULE_SHAPE_PROXYTYPE) {
                Capsule3DDefinition capsuleShape = (Capsule3DDefinition)collisionShapes.get(j).getGeometryDefinition();
                btCapsuleShapeZ btCapsuleShapeZ2 = new btCapsuleShapeZ((Pointer)compoundShape.getChildShape(j));
                Assertions.assertEquals((double)btCapsuleShapeZ2.getRadius(), (double)capsuleShape.getRadiusX(), (double)1.0E-5);
                Assertions.assertEquals((double)btCapsuleShapeZ2.getRadius(), (double)capsuleShape.getRadiusY(), (double)1.0E-5);
                Assertions.assertEquals((double)btCapsuleShapeZ2.getRadius(), (double)capsuleShape.getRadiusZ(), (double)1.0E-5);
                Assertions.assertEquals((double)btCapsuleShapeZ2.getHalfHeight(), (double)(capsuleShape.getLength() / 2.0), (double)1.0E-5);
            }
            btTransform compoundShapeChildTransform = compoundShape.getChildTransform(j);
            collisionShapeRigidBodyTransform.setAndInvert((RigidBodyTransformReadOnly)linkCenterOfMassFrame.getTransformToParent());
            collisionShapeRigidBodyTransform.multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)collisionShapes.get(j).getOriginPose().getRotation(), (Tuple3DReadOnly)collisionShapes.get(j).getOriginPose().getTranslation()));
            BulletMultiBodyRobotFactoryTest.assertMatrix4EqualsRigidBodyTransform(collisionShapes.get(j).getName(), compoundShapeChildTransform, collisionShapeRigidBodyTransform);
            Assertions.assertEquals((Object)BulletBroadphaseNativeTypes.fromNativeValue((int)compoundShape.getChildShape(j).getShapeType()), (Object)shapeType);
        }
    }

    private static Robot createRobotToTestLocalTransform(String name, YawPitchRollTransformDefinition inertiaPose, YawPitchRollTransformDefinition collisionShapePose) {
        double boxLength = 0.1;
        RobotDefinition boxRobot = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.getInertiaPose().set((RigidBodyTransformReadOnly)collisionShapePose);
        rootJoint.setSuccessor(rigidBody);
        boxRobot.setRootBodyDefinition(rootBody);
        CollisionShapeDefinition collisionShapeDefinition = new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition(boxLength, boxLength, boxLength));
        collisionShapeDefinition.getOriginPose().set((RigidBodyTransformReadOnly)inertiaPose);
        boxRobot.getRigidBodyDefinition(name + "RigidBody").addCollisionShapeDefinition(collisionShapeDefinition);
        return new Robot(boxRobot, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static Robot createTestRobotWithKnownValues() {
        String name = "TestRobot";
        RobotDefinition testRobot = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name + "RootJoint");
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBodyDefinition = new RigidBodyDefinition(name + "RigidBody");
        MomentOfInertiaDefinition momentOfInertiaRigidBody = new MomentOfInertiaDefinition();
        momentOfInertiaRigidBody.set(0.125568, 8.0E-4, -5.00733E-4, 8.0E-4, 0.0972042, -5.0E-4, -5.00733E-4, -5.0E-4, 0.117936);
        rigidBodyDefinition.setMass(9.609);
        rigidBodyDefinition.setMomentOfInertia(momentOfInertiaRigidBody);
        rigidBodyDefinition.getInertiaPose().setOrientation(0.0, -0.0, 0.0);
        rigidBodyDefinition.getInertiaPose().getTranslation().set(0.012, 0.0, 0.027);
        CollisionShapeDefinition collisionShapeDefinition1 = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(0.046, 0.0, 0.01, 0.0, -0.0, 1.571), (GeometryDefinition)new Cylinder3DDefinition(0.06, 0.1175));
        collisionShapeDefinition1.setCollisionGroup(899L);
        collisionShapeDefinition1.setCollisionMask(64L);
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition1);
        CollisionShapeDefinition collisionShapeDefinition2 = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(-0.03, 0.0, 0.01, 0.0, -0.0, 1.571), (GeometryDefinition)new Cylinder3DDefinition(0.04, 0.12));
        collisionShapeDefinition1.setCollisionGroup(899L);
        collisionShapeDefinition1.setCollisionMask(64L);
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition2);
        CollisionShapeDefinition collisionShapeDefinition3 = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(0.01, 0.042, 0.09, 0.0, -0.0, 0.0), (GeometryDefinition)new Cylinder3DDefinition(0.05, 0.16));
        collisionShapeDefinition1.setCollisionGroup(899L);
        collisionShapeDefinition1.setCollisionMask(64L);
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition3);
        RevoluteJointDefinition revoluteJointDefinition = new RevoluteJointDefinition("RevoluteJoint");
        revoluteJointDefinition.setAxis((Vector3DReadOnly)Axis3D.Z);
        TransformToParent.setTranslation(-0.013, 0.0, 0.0);
        TransformToParent.setOrientation(0.0, 0.0, 0.0);
        revoluteJointDefinition.setTransformToParent(TransformToParent);
        RigidBodyDefinition jointRigidBodyDefinition = new RigidBodyDefinition(name + "RevoluteJointBody");
        MomentOfInertiaDefinition momentOfInertiaJoint = new MomentOfInertiaDefinition();
        momentOfInertiaJoint.set(0.0039092, -5.04491E-8, -3.42157E-4, -5.04491E-8, 0.00341694, 4.87119E-7, -3.42157E-4, 4.87119E-7, 0.00174492);
        jointRigidBodyDefinition.setMass(2.27);
        jointRigidBodyDefinition.setMomentOfInertia(momentOfInertiaJoint);
        jointRigidBodyDefinition.getInertiaPose().setOrientation(0.0, 0.0, 0.0);
        jointRigidBodyDefinition.getInertiaPose().getTranslation().set(-0.0112984, -3.15366E-6, 0.0746835);
        CollisionShapeDefinition jointCollisionShapeDefinition = new CollisionShapeDefinition(new YawPitchRollTransformDefinition(0.0, 0.0, -0.02, 0.0, 0.0, 0.0), (GeometryDefinition)new Box3DDefinition(0.03, 0.04, 0.02));
        jointCollisionShapeDefinition.setCollisionGroup(3L);
        jointCollisionShapeDefinition.setCollisionMask(1L);
        jointRigidBodyDefinition.addCollisionShapeDefinition(jointCollisionShapeDefinition);
        revoluteJointDefinition.setSuccessor(jointRigidBodyDefinition);
        rigidBodyDefinition.addChildJoint((JointDefinition)revoluteJointDefinition);
        rootJoint.setSuccessor(rigidBodyDefinition);
        testRobot.setRootBodyDefinition(rootBody);
        return new Robot(testRobot, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static Robot createTestRobotWithoutBaseCollider(Random random, String name) {
        RobotDefinition robotDefinition = new RobotDefinition(name + "RootBody");
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RigidBody");
        int numberOfJoints = random.nextInt(10) + 1;
        OneDoFJointDefinition[] joints = new OneDoFJointDefinition[numberOfJoints];
        RigidBodyDefinition[] jointBodies = new RigidBodyDefinition[numberOfJoints];
        for (int i = 0; i < numberOfJoints; ++i) {
            int jointType = random.nextInt(2);
            switch (jointType) {
                case 0: {
                    joints[i] = new RevoluteJointDefinition(name + "Joint" + i);
                    break;
                }
                case 1: {
                    joints[i] = new PrismaticJointDefinition(name + "Joint" + i);
                    break;
                }
            }
            joints[i].setAxis(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
            TransformToParent.setTranslation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            TransformToParent.setOrientation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            joints[i].setTransformToParent(TransformToParent);
            jointBodies[i] = BulletMultiBodyRobotFactoryTest.createRandomShape(name + "JointBody" + i, random);
            joints[i].setSuccessor(jointBodies[i]);
            double lowerLimit = random.nextDouble();
            double upperLimit = lowerLimit + random.nextDouble();
            joints[i].setPositionLowerLimit(lowerLimit);
            joints[i].setPositionUpperLimit(upperLimit);
            if (i == 0) {
                joints[i].getTransformToParent().getTranslation().set(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
                rootBody.addChildJoint((JointDefinition)joints[i]);
                continue;
            }
            jointBodies[i - 1].addChildJoint((JointDefinition)joints[i]);
        }
        robotDefinition.setRootBodyDefinition(rootBody);
        return new Robot(robotDefinition, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static Robot createTestRobotWithBaseCollider(Random random, String name) {
        RobotDefinition robotDefinition = new RobotDefinition(name + "RootBody");
        RigidBodyDefinition rootBodyDefinition = new RigidBodyDefinition(name + "RigidBody");
        SixDoFJointDefinition rootJointDefinition = new SixDoFJointDefinition("rootJoint");
        rootBodyDefinition.addChildJoint((JointDefinition)rootJointDefinition);
        TransformToParent.setTranslation(random.nextDouble(), random.nextDouble(), random.nextDouble());
        TransformToParent.setOrientation(random.nextDouble(), random.nextDouble(), random.nextDouble());
        SixDoFJointState initialRootJointState = new SixDoFJointState((Orientation3DReadOnly)TransformToParent.getRotation(), (Tuple3DReadOnly)TransformToParent.getTranslation());
        rootJointDefinition.setInitialJointState(initialRootJointState);
        OneDoFJointState initialPinJointState = new OneDoFJointState();
        initialPinJointState.setEffort(random.nextDouble());
        RigidBodyDefinition rootJointRigidBodyDefinition = BulletMultiBodyRobotFactoryTest.createRandomShape(name + "RootJointBody", random);
        rootJointDefinition.setSuccessor(rootJointRigidBodyDefinition);
        int numberOfJoints = random.nextInt(10) + 1;
        OneDoFJointDefinition[] joints = new OneDoFJointDefinition[numberOfJoints];
        RigidBodyDefinition[] jointBodies = new RigidBodyDefinition[numberOfJoints];
        for (int i = 0; i < numberOfJoints; ++i) {
            int jointType = random.nextInt(2);
            switch (jointType) {
                case 0: {
                    joints[i] = new RevoluteJointDefinition(name + "Joint" + i);
                    break;
                }
                case 1: {
                    joints[i] = new PrismaticJointDefinition(name + "Joint" + i);
                    break;
                }
            }
            joints[i].setAxis(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
            TransformToParent.setTranslation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            TransformToParent.setOrientation(random.nextDouble(), random.nextDouble(), random.nextDouble());
            joints[i].setTransformToParent(TransformToParent);
            jointBodies[i] = BulletMultiBodyRobotFactoryTest.createRandomShape(name + "JointBody" + i, random);
            joints[i].setSuccessor(jointBodies[i]);
            double lowerLimit = random.nextDouble();
            double upperLimit = lowerLimit + random.nextDouble();
            joints[i].setPositionLowerLimit(lowerLimit);
            joints[i].setPositionUpperLimit(upperLimit);
            if (i == 0) {
                joints[i].getTransformToParent().getTranslation().set(new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble()));
                joints[i].setInitialJointState(initialPinJointState);
                rootJointRigidBodyDefinition.addChildJoint((JointDefinition)joints[i]);
                continue;
            }
            jointBodies[i - 1].addChildJoint((JointDefinition)joints[i]);
        }
        robotDefinition.setRootBodyDefinition(rootBodyDefinition);
        return new Robot(robotDefinition, ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    private static RigidBodyDefinition createRandomShape(String name, Random random) {
        RigidBodyDefinition rigidBodyDefinition = new RigidBodyDefinition(name);
        rigidBodyDefinition.setMass(random.nextDouble());
        rigidBodyDefinition.getMomentOfInertia().setToDiagonal(random.nextDouble(), random.nextDouble(), random.nextDouble());
        rigidBodyDefinition.getInertiaPose().getTranslation().set(random.nextDouble(), random.nextDouble(), random.nextDouble());
        int shapeSelection = random.nextInt(5);
        CollisionShapeDefinition collisionShapeDefinition = new CollisionShapeDefinition(rigidBodyDefinition.getInertiaPose(), (GeometryDefinition)(switch (shapeSelection) {
            case 0 -> new Sphere3DDefinition(random.nextDouble());
            case 1 -> new Cylinder3DDefinition(random.nextDouble(), random.nextDouble());
            case 2 -> new Box3DDefinition(random.nextDouble(), random.nextDouble(), random.nextDouble());
            case 3 -> new Cone3DDefinition(random.nextDouble(), random.nextDouble());
            default -> new Capsule3DDefinition(random.nextDouble(), random.nextDouble());
        }));
        rigidBodyDefinition.addCollisionShapeDefinition(collisionShapeDefinition);
        return rigidBodyDefinition;
    }
}

