/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.Random;
import org.bytedeco.bullet.BulletCollision.btBoxShape;
import org.bytedeco.bullet.BulletCollision.btCapsuleShapeZ;
import org.bytedeco.bullet.BulletCollision.btCompoundShape;
import org.bytedeco.bullet.BulletCollision.btConeShapeZ;
import org.bytedeco.bullet.BulletCollision.btCylinderShapeZ;
import org.bytedeco.bullet.BulletCollision.btSphereShape;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;
import org.bytedeco.javacpp.Pointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletBroadphaseNativeTypes;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTerrainObject;

public class BulletTerrainFactoryTest {
    private static final double EPSILON = 1.0E-5;
    private static final int ITERATIONS = 1000;
    private static final btVector3 boxVertex = new btVector3();

    @Test
    public void testNewInstance() {
        btTransform childTransform;
        btCompoundShape compoundShape;
        BulletTerrainObject bulletTerrainObject;
        TerrainObjectDefinition terrain;
        RigidBodyTransform terrainPose;
        Box3DDefinition terrainGeometry;
        int i;
        Random random = new Random(223174L);
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Box3DDefinition(random.nextDouble(), random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = new btCompoundShape((Pointer)bulletTerrainObject.getBtRigidBody().getCollisionShape());
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)BulletBroadphaseNativeTypes.BOX_SHAPE_PROXYTYPE.ordinal());
            Assertions.assertEquals((int)bulletTerrainObject.getCollisionGroup(), (int)1);
            Assertions.assertEquals((int)bulletTerrainObject.getCollisionGroupMask(), (int)-1);
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btBoxShape btBoxShape2 = new btBoxShape((Pointer)compoundShape.getChildShape(0));
            for (int j = 0; j < btBoxShape2.getNumEdges(); ++j) {
                btBoxShape2.getVertex(j, boxVertex);
                Assertions.assertEquals((double)Math.abs(boxVertex.getX()), (double)(terrainGeometry.getSizeX() / 2.0), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(boxVertex.getY()), (double)(terrainGeometry.getSizeY() / 2.0), (double)1.0E-5);
                Assertions.assertEquals((double)Math.abs(boxVertex.getZ()), (double)(terrainGeometry.getSizeZ() / 2.0), (double)1.0E-5);
            }
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Sphere3DDefinition(random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = new btCompoundShape((Pointer)bulletTerrainObject.getBtRigidBody().getCollisionShape());
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)BulletBroadphaseNativeTypes.SPHERE_SHAPE_PROXYTYPE.ordinal());
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btSphereShape sphereShape = new btSphereShape((Pointer)compoundShape.getChildShape(0));
            Assertions.assertEquals((double)sphereShape.getRadius(), (double)terrainGeometry.getRadius());
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Cylinder3DDefinition(random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = new btCompoundShape((Pointer)bulletTerrainObject.getBtRigidBody().getCollisionShape());
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)BulletBroadphaseNativeTypes.CYLINDER_SHAPE_PROXYTYPE.ordinal());
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btCylinderShapeZ cylinderShape = new btCylinderShapeZ((Pointer)compoundShape.getChildShape(0));
            Assertions.assertEquals((double)cylinderShape.getRadius(), (double)terrainGeometry.getRadius(), (double)1.0E-5);
            Assertions.assertEquals((double)cylinderShape.getHalfExtentsWithMargin().getZ(), (double)(terrainGeometry.getLength() / 2.0), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Cone3DDefinition(random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = new btCompoundShape((Pointer)bulletTerrainObject.getBtRigidBody().getCollisionShape());
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)BulletBroadphaseNativeTypes.CONE_SHAPE_PROXYTYPE.ordinal());
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btConeShapeZ coneShape = new btConeShapeZ((Pointer)compoundShape.getChildShape(0));
            Assertions.assertEquals((double)coneShape.getRadius(), (double)terrainGeometry.getRadius(), (double)1.0E-5);
            Assertions.assertEquals((double)coneShape.getHeight(), (double)terrainGeometry.getHeight(), (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            terrainGeometry = new Capsule3DDefinition(random.nextDouble(), random.nextDouble());
            terrainPose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
            bulletTerrainObject = BulletTerrainFactory.newInstance((TerrainObjectDefinition)terrain);
            compoundShape = new btCompoundShape((Pointer)bulletTerrainObject.getBtRigidBody().getCollisionShape());
            Assertions.assertEquals((int)compoundShape.getChildShape(0).getShapeType(), (int)BulletBroadphaseNativeTypes.CAPSULE_SHAPE_PROXYTYPE.ordinal());
            childTransform = compoundShape.getChildTransform(0);
            BulletTerrainFactoryTest.assertChildTransformEqualToTerrainPose(terrainPose, childTransform);
            btCapsuleShapeZ capsuleShape = new btCapsuleShapeZ((Pointer)compoundShape.getChildShape(0));
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)terrainGeometry.getRadiusX(), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)terrainGeometry.getRadiusY(), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getRadius(), (double)terrainGeometry.getRadiusZ(), (double)1.0E-5);
            Assertions.assertEquals((double)capsuleShape.getHalfHeight(), (double)(terrainGeometry.getLength() / 2.0), (double)1.0E-5);
        }
    }

    private static void assertChildTransformEqualToTerrainPose(RigidBodyTransform terrainPose, btTransform childTransform) {
        Assertions.assertEquals((double)childTransform.getOrigin().getX(), (double)terrainPose.getTranslation().getX(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getOrigin().getY(), (double)terrainPose.getTranslation().getY(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getOrigin().getZ(), (double)terrainPose.getTranslation().getZ(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(0).getX(), (double)terrainPose.getRotation().getM00(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(0).getY(), (double)terrainPose.getRotation().getM01(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(0).getZ(), (double)terrainPose.getRotation().getM02(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(1).getX(), (double)terrainPose.getRotation().getM10(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(1).getY(), (double)terrainPose.getRotation().getM11(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(1).getZ(), (double)terrainPose.getRotation().getM12(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(2).getX(), (double)terrainPose.getRotation().getM20(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(2).getY(), (double)terrainPose.getRotation().getM21(), (double)1.0E-5);
        Assertions.assertEquals((double)childTransform.getBasis().getRow(2).getZ(), (double)terrainPose.getRotation().getM22(), (double)1.0E-5);
    }
}

