/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletSimulationParameters;

public class BulletSimulationParametersTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testDefaultBulletSimulationParameters() {
        BulletSimulationParameters simulationParameters = BulletSimulationParameters.defaultBulletSimulateParameters();
        BulletSimulationParametersTest.assertSimulationParametersEqual(5.0E-4, 1, 5.0E-4, simulationParameters);
    }

    @Test
    public void testConstructor() {
        Random random = new Random(23514L);
        for (int i = 0; i < 1000; ++i) {
            double timeStep = random.nextDouble();
            int maxSubSteps = random.nextInt();
            double fixedTimeStep = random.nextDouble();
            BulletSimulationParameters simulationParameters = new BulletSimulationParameters(timeStep, maxSubSteps, fixedTimeStep);
            BulletSimulationParametersTest.assertSimulationParametersEqual(timeStep, maxSubSteps, fixedTimeStep, simulationParameters);
        }
    }

    @Test
    public void testSetters() {
        Random random = new Random(748512L);
        for (int i = 0; i < 1000; ++i) {
            double timeStep = random.nextDouble();
            int maxSubSteps = random.nextInt();
            double fixedTimeStep = random.nextDouble();
            BulletSimulationParameters simulationParameters = new BulletSimulationParameters();
            simulationParameters.setTimeStep(timeStep);
            simulationParameters.setMaxSubSteps(maxSubSteps);
            simulationParameters.setFixedTimeStep(fixedTimeStep);
            BulletSimulationParametersTest.assertSimulationParametersEqual(timeStep, maxSubSteps, fixedTimeStep, simulationParameters);
        }
    }

    private static void assertSimulationParametersEqual(double timeStep, int maxSubSteps, double fixedTimeStep, BulletSimulationParameters simulationParameters) {
        Assertions.assertEquals((double)timeStep, (double)simulationParameters.getTimeStep());
        Assertions.assertEquals((int)maxSubSteps, (int)simulationParameters.getMaxSubSteps());
        Assertions.assertEquals((double)fixedTimeStep, (double)simulationParameters.getFixedTimeStep());
    }
}

