/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyDynamicsWorld;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public class BulletFlyingBallNoSCS2Test {
    private static final double EPSILON = 0.1;

    @Test
    public void testHeightAfterSeconds() {
        double dt = 0.1;
        float ballMass = 1.0f;
        float ballRadius = 0.5f;
        double gravity = -9.81;
        Vector3 baseInertiaDiag = new Vector3();
        boolean isFixed = false;
        BulletMultiBodyDynamicsWorld bulletMultiBodyDynamicsWorld = new BulletMultiBodyDynamicsWorld();
        btSphereShape childShape = new btSphereShape(ballRadius);
        childShape.calculateLocalInertia(ballMass, baseInertiaDiag);
        BulletMultiBodyRobot bulletMultiBody = new BulletMultiBodyRobot(0, ballMass, baseInertiaDiag, isFixed, false, null);
        Matrix4 startTrans = new Matrix4();
        startTrans.set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        bulletMultiBody.getBtMultiBody().setBaseWorldTransform(startTrans);
        BulletMultiBodyLinkCollider linkCollider = new BulletMultiBodyLinkCollider(bulletMultiBody.getBtMultiBody(), -1, null);
        linkCollider.setCollisionShape((btCollisionShape)childShape);
        linkCollider.setCollisionGroupMask(1, -1);
        bulletMultiBody.addBulletMuliBodyLinkCollider(linkCollider);
        bulletMultiBody.getBtMultiBody().setBaseCollider(linkCollider.getBtMultiBodyLinkCollider());
        bulletMultiBody.getBtMultiBody().setLinearDamping(0.0f);
        bulletMultiBody.getBtMultiBody().setMaxCoordinateVelocity(1000000.0f);
        bulletMultiBody.getBtMultiBody().useRK4Integration(true);
        bulletMultiBody.getBtMultiBody().finalizeMultiDof();
        btMultiBody btMultiBody2 = bulletMultiBody.getBtMultiBody();
        bulletMultiBodyDynamicsWorld.addBulletMultiBodyRobot(bulletMultiBody);
        bulletMultiBodyDynamicsWorld.setGravity((Tuple3DReadOnly)new Vector3D(0.0, 0.0, gravity));
        Point3D initialPosition = new Point3D(0.0, 0.0, 0.0);
        Vector3D initialVelocity = new Vector3D(0.0, 0.0, 0.0);
        double seconds = dt;
        Point3D actual = new Point3D();
        Point3D expectedTest = new Point3D();
        Vector3 prevPosition = new Vector3(0.0f, 0.0f, 0.0f);
        Vector3 prevVelocity = new Vector3(0.0f, 0.0f, 0.0f);
        Vector3 gravityVector = new Vector3(0.0f, 0.0f, -9.81f);
        for (int i = 1; i < 2001; ++i) {
            int output = bulletMultiBodyDynamicsWorld.stepSimulation((float)dt, 1, (float)dt);
            Vector3D expected = BulletFlyingBallNoSCS2Test.heightAfterSeconds(initialPosition, initialVelocity, seconds, gravity);
            Vector3 expectedFloat = BulletFlyingBallNoSCS2Test.heightAfterSecondsFloat(prevPosition, prevVelocity, (float)dt, gravityVector);
            BulletTools.toEuclid((Vector3)btMultiBody2.getBasePos(), (Point3DBasics)actual);
            BulletTools.toEuclid((Vector3)expectedFloat, (Point3DBasics)expectedTest);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedTest, (Tuple3DReadOnly)actual, (double)0.1);
            System.out.println(output + " " + i + " " + btMultiBody2.getBasePos().z + " " + expected.getZ() + " : " + expectedFloat.z);
            prevPosition.set(btMultiBody2.getBasePos().x, btMultiBody2.getBasePos().y, btMultiBody2.getBasePos().z);
            prevVelocity.set(btMultiBody2.getBaseVel().x, btMultiBody2.getBaseVel().y, btMultiBody2.getBaseVel().z);
            seconds += dt;
        }
        bulletMultiBodyDynamicsWorld.dispose();
    }

    private static Vector3D heightAfterSeconds(Point3D initialPosition, Vector3D initialVelocity, double seconds, double gravity) {
        Vector3D height = new Vector3D();
        height.setX(initialVelocity.getX() * seconds + initialPosition.getX());
        height.setY(initialVelocity.getY() * seconds + initialPosition.getY());
        height.setZ(0.5 * gravity * seconds * seconds + initialVelocity.getZ() * seconds + initialPosition.getZ());
        return height;
    }

    private static Vector3 heightAfterSecondsFloat(Vector3 previousPosition, Vector3 previousVelocity, float seconds, Vector3 gravity) {
        Vector3 height = new Vector3();
        height.x = 0.5f * gravity.x * seconds * seconds + previousVelocity.x * seconds + previousPosition.x;
        height.y = 0.5f * gravity.y * seconds * seconds + previousVelocity.y * seconds + previousPosition.y;
        height.z = 0.5f * gravity.z * seconds * seconds + previousVelocity.z * seconds + previousPosition.z;
        return height;
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
    }
}

