/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletRobotLinkRoot;

class BulletRobotLinkRootTest {
    private static final int ITERATIONS = 1000;

    BulletRobotLinkRootTest() {
    }

    @Test
    public void testAccelerationCalculation() {
        double epsilon = 1.0E-5;
        Random random = new Random(4354353L);
        RigidBody rootBody = new RigidBody("root", ReferenceFrame.getWorldFrame());
        SixDoFJoint joint = MultiBodySystemRandomTools.nextSixDoFJoint((Random)random, (String)"joint", (RigidBodyBasics)rootBody);
        MovingReferenceFrame frameAfter = joint.getFrameAfterJoint();
        MovingReferenceFrame frameBefore = joint.getFrameBeforeJoint();
        Pose3D finalPose = new Pose3D();
        Twist finalTwist = new Twist((ReferenceFrame)frameAfter, (ReferenceFrame)frameBefore, (ReferenceFrame)frameAfter);
        SpatialAcceleration finalAcceleration = new SpatialAcceleration((ReferenceFrame)frameAfter, (ReferenceFrame)frameBefore, (ReferenceFrame)frameAfter);
        SpatialAcceleration estimatedAcceleration = new SpatialAcceleration((ReferenceFrame)frameAfter, (ReferenceFrame)frameBefore, (ReferenceFrame)frameAfter);
        double dt = 1.0E-5;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
        for (int i = 0; i < 1000; ++i) {
            Pose3D initialPose = EuclidGeometryRandomTools.nextPose3D((Random)random);
            Twist initialTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)frameAfter, (ReferenceFrame)frameBefore, (ReferenceFrame)frameAfter);
            SpatialAcceleration initialAcceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)frameAfter, (ReferenceFrame)frameBefore, (ReferenceFrame)frameAfter);
            joint.getJointPose().set((Pose3DReadOnly)initialPose);
            joint.getJointTwist().set((SpatialMotionReadOnly)initialTwist);
            joint.getJointAcceleration().set((SpatialMotionReadOnly)initialAcceleration);
            joint.updateFrame();
            finalPose.set(initialPose);
            finalTwist.set(initialTwist);
            finalAcceleration.set(initialAcceleration);
            integrator.doubleIntegrate((FixedFrameSpatialAccelerationBasics)finalAcceleration, (FixedFrameTwistBasics)finalTwist, (Pose3DBasics)finalPose);
            joint.updateFrame();
            BulletRobotLinkRoot.computeSixDoFJointAcceleration((double)dt, (Pose3DReadOnly)initialPose, (Pose3DReadOnly)finalPose, (TwistReadOnly)initialTwist, (TwistReadOnly)finalTwist, (FixedFrameSpatialAccelerationBasics)estimatedAcceleration);
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + i), (SpatialAccelerationReadOnly)finalAcceleration, (SpatialAccelerationReadOnly)estimatedAcceleration, (double)epsilon);
        }
    }
}

