/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2.rosidl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.idl.generator.IDLGenerator;
import us.ihmc.rosidl.Ros2MsgToIdlGenerator;
import us.ihmc.rosidl.Ros2MsgToRos1MsgGenerator;

public class RosInterfaceGenerator {
    private final Ros2MsgToRos1MsgGenerator ros2MsgToRos1MsgGenerator;
    private Ros2MsgToIdlGenerator ros2MsgToIdlGenerator;
    private final HashMap<String, Path> customIDLFiles = new HashMap();

    public RosInterfaceGenerator() throws IOException {
        this(null);
    }

    public RosInterfaceGenerator(String localEmFilePath) throws IOException {
        this.ros2MsgToIdlGenerator = new Ros2MsgToIdlGenerator(localEmFilePath);
        this.ros2MsgToRos1MsgGenerator = new Ros2MsgToRos1MsgGenerator(localEmFilePath);
    }

    public void addPackageRootToIDLGenerator(Path rootPath) throws IOException {
        this.ros2MsgToIdlGenerator.addPackageRoot(rootPath);
    }

    public void addPackageRootToROS1Generator(Path rootPath) throws IOException {
        this.ros2MsgToRos1MsgGenerator.addPackageRoot(rootPath);
    }

    public void generate(Path idlDirectory, Path ros1Directory, Path javaDirectory) throws IOException {
        this.ros2MsgToIdlGenerator.convertToIDL(idlDirectory);
        this.ros2MsgToRos1MsgGenerator.convertToROS1(ros1Directory);
        this.customIDLFiles.forEach((key, path) -> {
            try {
                FileTools.ensureDirectoryExists((Path)idlDirectory.resolve((String)key).getParent());
                Files.copy(path, idlDirectory.resolve((String)key), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Files.find(idlDirectory, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().endsWith(".idl"), new FileVisitOption[0]).forEach(file -> this.generateJava((Path)file, javaDirectory, idlDirectory));
    }

    public void addCustomIDLFiles(Path rootPath) throws IOException {
        Files.find(rootPath, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().endsWith(".idl"), new FileVisitOption[0]).forEach(file -> this.addCustomIDLFile((Path)file, rootPath));
    }

    private void addCustomIDLFile(Path path, Path rootPath) {
        String key = rootPath.relativize(path).toString();
        this.customIDLFiles.put(key, path);
    }

    private void generateJava(Path idlFile, Path javaDirectory, Path idlIncludeDirectory) {
        try {
            IDLGenerator.execute((File)idlFile.toFile(), (String)"", (File)javaDirectory.toFile(), Collections.singletonList(idlIncludeDirectory.toFile()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void convertDirectoryToUnixEOL(Path directory) {
        PathTools.walkRecursively((Path)directory, (BasicPathVisitor)new BasicPathVisitor(){

            public FileVisitResult visitPath(Path path, BasicPathVisitor.PathType pathType) {
                if (pathType == BasicPathVisitor.PathType.FILE) {
                    List lines = FileTools.readAllLines((Path)path, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
                    PrintWriter printer = FileTools.newPrintWriter((Path)path, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
                    lines.forEach(line -> printer.print(line + "\n"));
                    printer.close();
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteAllExcept(Path outputDirectory, final String ... packagesToKeep) {
        PathTools.walkFlat((Path)outputDirectory, (BasicPathVisitor)new BasicPathVisitor(){

            public FileVisitResult visitPath(Path path, BasicPathVisitor.PathType pathType) {
                if (!RosInterfaceGenerator.keep(path.getFileName().toString(), packagesToKeep)) {
                    FileTools.deleteQuietly((Path)path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static boolean keep(String candidate, String ... packagesToKeep) {
        for (String str : packagesToKeep) {
            if (!candidate.equals(str)) continue;
            return true;
        }
        return false;
    }
}

