/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2.rosidl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskAction;
import us.ihmc.ros2.rosidl.RosInterfaceGenerator;

public class Ros2MessageGenerator
extends DefaultTask {
    public FileCollection rosPackages;
    public File javaOutputDirectory;
    public File idlOutputDirectory;
    public File ros1OutputDirectory;
    public FileCollection customIDLDirectory;
    public List<Configuration> configurations = new ArrayList<Configuration>();
    public List<String> artifactIds = new ArrayList<String>();
    public List<File> locations = new ArrayList<File>();

    public void artifactDependency(Configuration configuration, String artifactId, File location) {
        this.configurations.add(configuration);
        this.artifactIds.add(artifactId);
        this.locations.add(location);
    }

    @TaskAction
    public void generateMessages() throws IOException {
        if (this.rosPackages == null) {
            throw new IOException("Please set rosPackages = files(\"path/to/package\")");
        }
        if (this.javaOutputDirectory == null) {
            throw new IOException("Please set javaOutputDirectory = files(\"path/to/java/output\")");
        }
        if (this.ros1OutputDirectory == null) {
            throw new IOException("Please set ros1OutputDirectory = files(\"path/to/ros1/output\")");
        }
        if (this.javaOutputDirectory.exists() && !this.javaOutputDirectory.isDirectory()) {
            throw new IOException("Output directory exists but is not a directory");
        }
        if (this.idlOutputDirectory == null) {
            this.idlOutputDirectory = new File(this.getTemporaryDir(), "idl");
        }
        this.getProject().delete(new Object[]{this.javaOutputDirectory});
        this.getProject().delete(new Object[]{this.idlOutputDirectory});
        RosInterfaceGenerator generator = new RosInterfaceGenerator();
        for (File rosPackage : this.rosPackages) {
            generator.addPackageRootToIDLGenerator(rosPackage.toPath());
        }
        if (this.customIDLDirectory != null) {
            for (File custom : this.customIDLDirectory) {
                generator.addCustomIDLFiles(custom.toPath());
            }
        }
        generator.generate(this.idlOutputDirectory.toPath(), this.ros1OutputDirectory.toPath(), this.javaOutputDirectory.toPath());
        RosInterfaceGenerator.convertDirectoryToUnixEOL(this.idlOutputDirectory.toPath());
        RosInterfaceGenerator.convertDirectoryToUnixEOL(this.javaOutputDirectory.toPath());
    }
}

