/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import groovy.lang.Closure;
import java.io.IOException;
import java.nio.file.Path;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import us.ihmc.ros2.ROS2PubSubGeneratorSettings;
import us.ihmc.ros2.rosidl.RosInterfaceGenerator;

public class ROS2PubSubGeneratorPlugin
implements Plugin<Project> {
    private final String TEMPORARY_DIRECTORY = "build/tmp/generateMessages/";
    private Project project;
    private Path projectPath;
    private ROS2PubSubGeneratorSettings settings = new ROS2PubSubGeneratorSettings();
    private boolean foundDependency = false;

    public void apply(Project project) {
        this.project = project;
        this.projectPath = project.getProjectDir().toPath();
        this.createExtension("messageGenerator", this.settings);
        this.createTask(project, "generateMessages");
    }

    public void generateMessages() {
        try {
            RosInterfaceGenerator generator = new RosInterfaceGenerator();
            this.settings.directoriesToClean.forEach(d -> this.project.delete(new Object[]{d}));
            this.settings.dependenciesToExtract.forEach(dependencyToExtract -> {
                this.foundDependency = false;
                this.project.getConfigurations().getByName("compile").getDependencies().forEach(dependency -> {
                    if (dependency.getName().contains((CharSequence)dependencyToExtract)) {
                        this.foundDependency = true;
                        this.project.copy(copySpec -> {
                            copySpec.from(new Object[]{this.project.zipTree(dependency)});
                            copySpec.into((Object)this.project.file((Object)("build/tmp/generateMessages/" + dependency.getName())));
                        });
                    }
                });
                if (!this.foundDependency) {
                    throw new GradleException("Could not find " + dependencyToExtract + " in configurations.compile!");
                }
            });
            this.settings.extractedDependencies.forEach(extractedDependency -> {
                try {
                    generator.addPackageRootToIDLGenerator(this.path("build/tmp/generateMessages/" + extractedDependency));
                }
                catch (IOException e) {
                    throw new GradleException("Failed to generate messages.", (Throwable)e);
                }
            });
            this.settings.sourceDependencies.forEach(sourceDependency -> {
                try {
                    generator.addPackageRootToIDLGenerator(this.path((String)sourceDependency));
                }
                catch (IOException e) {
                    throw new GradleException("Failed to generate messages.", (Throwable)e);
                }
            });
            this.settings.ros1SourceDependencies.forEach(ros1SourceDependency -> {
                try {
                    generator.addPackageRootToROS1Generator(this.path((String)ros1SourceDependency));
                }
                catch (IOException e) {
                    throw new GradleException("Failed to generate messages.", (Throwable)e);
                }
            });
            this.settings.customIDLDependencies.forEach(customIDLDependency -> {
                try {
                    generator.addCustomIDLFiles(this.path((String)customIDLDependency));
                }
                catch (IOException e) {
                    throw new GradleException("Failed to generate messages.", (Throwable)e);
                }
            });
            try {
                generator.generate(this.path("build/tmp/generateMessages/" + this.settings.idlOutputDirectory), this.path("build/tmp/generateMessages/" + this.settings.ros1OutputDirectory), this.path("build/tmp/generateMessages/" + this.settings.javaOutputDirectory));
            }
            catch (IOException e) {
                throw new GradleException("Failed to generate messages.", (Throwable)e);
            }
            this.copyTmpDirToFinalDir(this.settings.idlOutputDirectory);
            this.copyTmpDirToFinalDir(this.settings.javaOutputDirectory);
            this.copyTmpDirToFinalDir(this.settings.ros1OutputDirectory);
            RosInterfaceGenerator.convertDirectoryToUnixEOL(this.path(this.settings.idlOutputDirectory));
            RosInterfaceGenerator.convertDirectoryToUnixEOL(this.path(this.settings.javaOutputDirectory));
            RosInterfaceGenerator.convertDirectoryToUnixEOL(this.path(this.settings.ros1OutputDirectory));
        }
        catch (IOException e) {
            throw new GradleException("Failed to generate messages.", (Throwable)e);
        }
    }

    private void copyTmpDirToFinalDir(String directory) {
        this.project.copy(copySpec -> {
            copySpec.from(new Object[]{"build/tmp/generateMessages/" + directory});
            copySpec.into((Object)directory);
        });
    }

    private Path path(String pathName) {
        return this.project.file((Object)pathName).toPath();
    }

    private <T> T createExtension(String name, T pojo) {
        this.project.getExtensions().create(name, pojo.getClass(), new Object[0]);
        return (T)this.project.getExtensions().getByName(name);
    }

    private void createTask(Project project, String taskName) {
        project.task(taskName).doLast((Closure)new MethodClosure((Object)this, taskName));
    }
}

