/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.log.LogTools;
import us.ihmc.ros2.rosidl.ROS2InterfaceGenerator;

public class MessageGenerationTest {
    @Test
    public void testMessageGeneration() throws IOException {
        LogTools.info((String)("Working dir: " + Paths.get(".", new String[0]).toAbsolutePath()));
        Path startingPath = Paths.get(".", new String[0]);
        FileTools.deleteQuietly((Path)startingPath.resolve("generated-java"));
        FileTools.deleteQuietly((Path)startingPath.resolve("generated-idl"));
        ROS2InterfaceGenerator generator = new ROS2InterfaceGenerator();
        generator.addPackageRootToIDLGenerator(startingPath.resolve("ros_msgs"), new String[0]);
        generator.addPackageRootToROS1Generator(startingPath.resolve("ros_msgs"));
        generator.addCustomIDLFiles(startingPath.resolve("custom-idl"));
        Path generatedIDLPath = startingPath.resolve("generated-idl");
        Path generatedROS1Path = Paths.get("generated-ros1", new String[0]);
        Path generatedJavaPath = startingPath.resolve("generated-java");
        generator.generate(generatedIDLPath, generatedROS1Path, generatedJavaPath);
        ROS2InterfaceGenerator.convertDirectoryToUnixEOL((Path)generatedIDLPath);
        ROS2InterfaceGenerator.convertDirectoryToUnixEOL((Path)generatedROS1Path);
        ROS2InterfaceGenerator.convertDirectoryToUnixEOL((Path)generatedJavaPath);
    }
}

