/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rosidl;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;
import us.ihmc.rosidl.ROS2MsgToIdlGenerator;
import us.ihmc.rosidl.RosPackageDescription;

public class ROS2MsgToRos1MsgGenerator
extends ROS2MsgToIdlGenerator {
    private static final String MSG_TO_ROS1_EM_TEMPLATE_NAME = "msg.ros1.em";
    private final PythonInterpreter pythonInterpreter = new PythonInterpreter();
    private Path argumentsJsonFile;
    private Path templateDirectory;
    private final HashMap<String, RosPackageDescription> packages = new HashMap();

    public ROS2MsgToRos1MsgGenerator() {
        this.argumentsJsonFile = ROS2MsgToRos1MsgGenerator.createTempFile("rosInterfaceArguments", "arguments.json");
        this.templateDirectory = ROS2MsgToRos1MsgGenerator.createTempDirectory("rosInterfaceCompilerTemplates");
        ROS2MsgToRos1MsgGenerator.copyResourceToTempDirectory(this.templateDirectory, MSG_TO_ROS1_EM_TEMPLATE_NAME);
        this.pythonInterpreter.exec("from rosidl_generator_ros1 import generate_ros_msg");
    }

    public void addPackageRoot(Path rootPath) throws IOException {
        Path start = rootPath;
        int maxDepth = 2;
        Files.find(start, maxDepth, (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().equals("package.xml"), new FileVisitOption[0]).forEach(packageXmlFilePath -> ROS2MsgToRos1MsgGenerator.addPackage(packageXmlFilePath, this.packages));
    }

    public void convertToROS1(Path outputDirectory) {
        this.packages.forEach((name, pkg) -> this.convertPackageToROS1((String)name, (RosPackageDescription)pkg, outputDirectory));
    }

    private void convertPackageToROS1(String name, RosPackageDescription packageDescription, Path outputDirectory) {
        Path packageOutputDirectory = outputDirectory.resolve(name);
        ROS2MsgToRos1MsgGenerator.setupAndWriteJythonJSONFile(packageDescription, new ArrayList<Path>(), packageOutputDirectory, this.templateDirectory, this.argumentsJsonFile);
        System.out.println("[ROS2 MSG -> ROS1 MSG] Generating .msg files for " + name + " in " + String.valueOf(packageOutputDirectory));
        this.pythonInterpreter.set("argFile", (PyObject)new PyString(this.argumentsJsonFile.toAbsolutePath().toString()));
        PyList subFolderList = new PyList();
        subFolderList.add((Object)new PyString("."));
        this.pythonInterpreter.set("subFolders", (PyObject)subFolderList);
        this.pythonInterpreter.set("extension", Py.None);
        this.pythonInterpreter.exec("generate_ros_msg(argFile, subFolders, extension)");
    }
}

