/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rosidl;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;
import us.ihmc.rosidl.RosPackage;
import us.ihmc.rosidl.RosPackageDescription;

public class ROS2MsgToIdlGenerator {
    public static final boolean COMPILE_ROS_SERVICES = false;
    private static final String MSG_TO_IDL_EM_TEMPLATE_NAME = "msg.idl.em";
    private final PythonInterpreter pythonInterpreter = new PythonInterpreter();
    private final Path templateDirectory;
    private final Path argumentsJsonFile;
    private final HashMap<String, RosPackageDescription> packageNameToDescriptionMap = new HashMap();

    public ROS2MsgToIdlGenerator() {
        this.argumentsJsonFile = ROS2MsgToIdlGenerator.createTempFile("rosInterfaceArguments", "arguments.json");
        this.templateDirectory = ROS2MsgToIdlGenerator.createTempDirectory("rosInterfaceCompilerTemplates");
        ROS2MsgToIdlGenerator.copyResourceToTempDirectory(this.templateDirectory, MSG_TO_IDL_EM_TEMPLATE_NAME);
        this.pythonInterpreter.exec("from rosidl_generator_dds_idl import generate_dds_idl");
    }

    public void addPackageRoot(Path rootPath, String ... rclInterfacesToIgnore) throws IOException {
        List<Object> ignoredInterfaces = rclInterfacesToIgnore != null ? Arrays.asList(rclInterfacesToIgnore) : Collections.emptyList();
        Path start = rootPath;
        int maxDepth = 2;
        BiPredicate<Path, BasicFileAttributes> matcher = (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().equals("package.xml");
        Predicate<Path> packageIsNotIgnored = path -> !ignoredInterfaces.contains(path.getParent().getFileName().toString());
        Files.find(start, maxDepth, matcher, new FileVisitOption[0]).filter(packageIsNotIgnored).forEach(packageXmlFilePath -> ROS2MsgToIdlGenerator.addPackage(packageXmlFilePath, this.packageNameToDescriptionMap));
    }

    static void addPackage(Path packageXmlFilePath, HashMap<String, RosPackageDescription> packages) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RosPackage.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            RosPackage rosPackage = (RosPackage)unmarshaller.unmarshal(packageXmlFilePath.toFile());
            RosPackageDescription packageDescription = new RosPackageDescription(rosPackage.getName(), packageXmlFilePath.getParent());
            if (rosPackage.getBuild_depend() != null) {
                packageDescription.getDependencies().addAll(rosPackage.getBuild_depend());
            }
            try {
                Files.find(packageDescription.getPackageDirectory(), 2, (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().endsWith(".msg"), new FileVisitOption[0]).forEach(path -> packageDescription.getMsgFilePaths().add((Path)path));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot search folder " + packageDescription.getPackageDirectory() + " for package " + packageDescription.getPackageName(), e);
            }
            packages.put(packageDescription.getPackageName(), packageDescription);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot parse package.xml: " + packageXmlFilePath, e);
        }
    }

    public void convertToIDL(Path outputDirectory) {
        this.packageNameToDescriptionMap.forEach((name, pkg) -> this.convertPackageToIDL((RosPackageDescription)pkg, outputDirectory));
    }

    private void convertPackageToIDL(RosPackageDescription packageDescription, Path outputDirectory) {
        HashSet<String> dependencies = new HashSet<String>();
        this.addDependenciesRecursive(packageDescription, dependencies);
        ArrayList<Path> dependencyFiles = new ArrayList<Path>();
        for (String dependency : dependencies) {
            RosPackageDescription desc = this.packageNameToDescriptionMap.get(dependency);
            dependencyFiles.addAll(desc.getMsgFilePaths());
        }
        Path packageOutputDirectory = outputDirectory.resolve(packageDescription.getPackageName());
        ROS2MsgToIdlGenerator.setupAndWriteJythonJSONFile(packageDescription, dependencyFiles, packageOutputDirectory, this.templateDirectory, this.argumentsJsonFile);
        System.out.println("[ROS2 MSG -> IDL] Generating .idl files for " + packageDescription.getPackageName() + " in " + packageOutputDirectory);
        this.pythonInterpreter.set("argFile", (PyObject)new PyString(this.argumentsJsonFile.toAbsolutePath().toString()));
        PyList subFolderList = new PyList();
        subFolderList.add((Object)new PyString("."));
        this.pythonInterpreter.set("subFolders", (PyObject)subFolderList);
        this.pythonInterpreter.set("extension", Py.None);
        this.pythonInterpreter.exec("generate_dds_idl(argFile, subFolders, extension)");
    }

    static void setupAndWriteJythonJSONFile(RosPackageDescription packageDescription, List<Path> dependencyFiles, Path packageOutputDirectory, Path templateDirectory, Path argumentsJsonFile) {
        OutputStream outputStream;
        JsonObjectBuilder json = Json.createObjectBuilder();
        json.add("package_name", packageDescription.getPackageName());
        json.add("output_dir", packageOutputDirectory.toAbsolutePath().toString());
        json.add("template_dir", templateDirectory.toAbsolutePath().toString());
        JsonArrayBuilder rosInterfaceFiles = Json.createArrayBuilder();
        for (Path path : packageDescription.getMsgFilePaths()) {
            rosInterfaceFiles.add(path.toString());
        }
        for (Path path : packageDescription.getSrvFilePaths()) {
            rosInterfaceFiles.add(path.toString());
        }
        json.add("ros_interface_files", rosInterfaceFiles);
        JsonArrayBuilder rosInterfaceDependencies = Json.createArrayBuilder();
        for (Path dep : dependencyFiles) {
            rosInterfaceDependencies.add(dep.toString());
        }
        json.add("ros_interface_dependencies", rosInterfaceDependencies);
        json.add("target_dependencies", Json.createArrayBuilder());
        json.add("additional_files", Json.createArrayBuilder());
        try {
            outputStream = Files.newOutputStream(argumentsJsonFile, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonWriter writer = Json.createWriter((OutputStream)outputStream);
        writer.writeObject(json.build());
        writer.close();
    }

    private void addDependenciesRecursive(RosPackageDescription rosPackageDescription, HashSet<String> dependencies) {
        for (String dependency : rosPackageDescription.getDependencies()) {
            dependencies.add(dependency);
            if (this.packageNameToDescriptionMap.containsKey(dependency)) {
                this.addDependenciesRecursive(this.packageNameToDescriptionMap.get(dependency), dependencies);
                continue;
            }
            throw new RuntimeException("Cannot find dependency " + dependency + " for " + rosPackageDescription.getPackageName());
        }
    }

    static Path createTempFile(String prefix, String suffix) {
        Path tempFile;
        try {
            tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
        }
        catch (IOException e) {
            tempFile = null;
            e.printStackTrace();
        }
        return tempFile;
    }

    static Path createTempDirectory(String prefix) {
        Path tempDirectory;
        try {
            tempDirectory = Files.createTempDirectory(prefix, new FileAttribute[0]);
            tempDirectory.toFile().deleteOnExit();
        }
        catch (IOException e) {
            tempDirectory = null;
            e.printStackTrace();
        }
        return tempDirectory;
    }

    static void copyResourceToTempDirectory(Path directory, String fileName) {
        try {
            InputStream template = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            Path templateFile = directory.resolve(fileName);
            Files.copy(template, templateFile, new CopyOption[0]);
            templateFile.toFile().deleteOnExit();
            template.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$addPackage$6(RosPackageDescription packageDescription, Path path) {
        packageDescription.getSrvFilePaths().add(path);
    }

    private static /* synthetic */ boolean lambda$addPackage$5(Path path, BasicFileAttributes attrs) {
        return attrs.isRegularFile() && path.getFileName().toString().endsWith(".srv");
    }
}

