# Copyright 2019 Open Source Robotics Foundation, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import rclpy
from rclpy.executors import ExternalShutdownException
from rclpy.node import Node
from tf2_ros.buffer import Buffer
from tf2_ros.transform_listener import TransformListener


class FrameDumper(Node):
    """Print all frames to stdout at a regular interval."""

    def __init__(self):
        super().__init__('example_frame_dumper')

        self._tf_buffer = Buffer()
        self._tf_listener = TransformListener(self._tf_buffer, self, spin_thread=False)

        self._output_timer = self.create_timer(1.0, self.on_timer)

    def on_timer(self):
        print(self._tf_buffer.all_frames_as_yaml())


def main():
    try:
        with rclpy.init():
            node = FrameDumper()
            rclpy.spin(node)
    except (KeyboardInterrupt, ExternalShutdownException):
        pass
