/*
 * Decompiled with CFR 0.152.
 */
package actionlib_msgs.msg.dds;

import actionlib_msgs.msg.dds.GoalID;
import actionlib_msgs.msg.dds.GoalIDPubSubType;
import actionlib_msgs.msg.dds.GoalStatusPubSubType;
import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class GoalStatus
extends Packet<GoalStatus>
implements Settable<GoalStatus>,
EpsilonComparable<GoalStatus> {
    public static final byte PENDING = 0;
    public static final byte ACTIVE = 1;
    public static final byte PREEMPTED = 2;
    public static final byte SUCCEEDED = 3;
    public static final byte ABORTED = 4;
    public static final byte REJECTED = 5;
    public static final byte PREEMPTING = 6;
    public static final byte RECALLING = 7;
    public static final byte RECALLED = 8;
    public static final byte LOST = 9;
    public GoalID goal_id_ = new GoalID();
    public byte status_;
    public StringBuilder text_ = new StringBuilder(255);

    public GoalStatus() {
    }

    public GoalStatus(GoalStatus other) {
        this();
        this.set(other);
    }

    public void set(GoalStatus other) {
        GoalIDPubSubType.staticCopy(other.goal_id_, this.goal_id_);
        this.status_ = other.status_;
        this.text_.setLength(0);
        this.text_.append((CharSequence)other.text_);
    }

    public GoalID getGoalId() {
        return this.goal_id_;
    }

    public void setStatus(byte status) {
        this.status_ = status;
    }

    public byte getStatus() {
        return this.status_;
    }

    public void setText(String text) {
        this.text_.setLength(0);
        this.text_.append(text);
    }

    public String getTextAsString() {
        return this.getText().toString();
    }

    public StringBuilder getText() {
        return this.text_;
    }

    public static Supplier<GoalStatusPubSubType> getPubSubType() {
        return GoalStatusPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return GoalStatusPubSubType::new;
    }

    public boolean epsilonEquals(GoalStatus other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.goal_id_.epsilonEquals(other.goal_id_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.status_, (double)other.status_, (double)epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.text_, (StringBuilder)other.text_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof GoalStatus)) {
            return false;
        }
        GoalStatus otherMyClass = (GoalStatus)((Object)other);
        if (!this.goal_id_.equals((Object)otherMyClass.goal_id_)) {
            return false;
        }
        if (this.status_ != otherMyClass.status_) {
            return false;
        }
        return IDLTools.equals((StringBuilder)this.text_, (StringBuilder)otherMyClass.text_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GoalStatus {");
        builder.append("goal_id=");
        builder.append((Object)this.goal_id_);
        builder.append(", ");
        builder.append("status=");
        builder.append(this.status_);
        builder.append(", ");
        builder.append("text=");
        builder.append((CharSequence)this.text_);
        builder.append("}");
        return builder.toString();
    }
}

