/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.io.IOException;
import sensor_msgs.msg.dds.Image;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class ImagePubSubType
implements TopicDataType<Image> {
    public static final String name = "sensor_msgs::msg::dds_::Image_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "ca8161af067f9da446ceed96c46c493b3ba681001eb213abe3fcd29aac5bab44";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Image data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ImagePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Image data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ImagePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ImagePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 10000000 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Image data) {
        return ImagePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Image data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getEncoding().length() + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 10000000 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(Image data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        cdr.write_type_4(data.getHeight());
        cdr.write_type_4(data.getWidth());
        if (data.getEncoding().length() > 255) {
            throw new RuntimeException("encoding field exceeds the maximum length: %d > %d".formatted(data.getEncoding().length(), 255));
        }
        cdr.write_type_d(data.getEncoding());
        cdr.write_type_9(data.getIsBigendian());
        cdr.write_type_4(data.getStep());
        for (int i0 = 0; i0 < data.getData().length; ++i0) {
            cdr.write_type_9(data.getData()[i0]);
        }
    }

    public static void read(Image data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        data.setHeight(cdr.read_type_4());
        data.setWidth(cdr.read_type_4());
        cdr.read_type_d(data.getEncoding());
        data.setIsBigendian(cdr.read_type_9());
        data.setStep(cdr.read_type_4());
        for (int i0 = 0; i0 < data.getData().length; ++i0) {
            data.getData()[i0] = cdr.read_type_9();
        }
    }

    public final void serialize(Image data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_4("height", data.getHeight());
        ser.write_type_4("width", data.getWidth());
        ser.write_type_d("encoding", data.getEncoding());
        ser.write_type_9("is_bigendian", data.getIsBigendian());
        ser.write_type_4("step", data.getStep());
        ser.write_type_f("data", data.getData());
    }

    public final void deserialize(InterchangeSerializer ser, Image data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        data.setHeight(ser.read_type_4("height"));
        data.setWidth(ser.read_type_4("width"));
        ser.read_type_d("encoding", data.getEncoding());
        data.setIsBigendian(ser.read_type_9("is_bigendian"));
        data.setStep(ser.read_type_4("step"));
        ser.read_type_f("data", data.getData());
    }

    public static void staticCopy(Image src, Image dest) {
        dest.set(src);
    }

    public Image createData() {
        return new Image();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ImagePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Image data, CDR cdr) {
        ImagePubSubType.write(data, cdr);
    }

    public void deserialize(Image data, CDR cdr) {
        ImagePubSubType.read(data, cdr);
    }

    public void copy(Image src, Image dest) {
        ImagePubSubType.staticCopy(src, dest);
    }

    public ImagePubSubType newInstance() {
        return new ImagePubSubType();
    }
}

