/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.util.Arrays;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.ImagePubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class Image
extends Packet<Image>
implements Settable<Image>,
EpsilonComparable<Image> {
    public Header header_ = new Header();
    public long height_;
    public long width_;
    public StringBuilder encoding_ = new StringBuilder(255);
    public byte is_bigendian_;
    public long step_;
    public byte[] data_ = new byte[10000000];

    public Image() {
    }

    public Image(Image other) {
        this();
        this.set(other);
    }

    public void set(Image other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.height_ = other.height_;
        this.width_ = other.width_;
        this.encoding_.setLength(0);
        this.encoding_.append((CharSequence)other.encoding_);
        this.is_bigendian_ = other.is_bigendian_;
        this.step_ = other.step_;
        for (int i1 = 0; i1 < this.data_.length; ++i1) {
            this.data_[i1] = other.data_[i1];
        }
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setHeight(long height) {
        this.height_ = height;
    }

    public long getHeight() {
        return this.height_;
    }

    public void setWidth(long width) {
        this.width_ = width;
    }

    public long getWidth() {
        return this.width_;
    }

    public void setEncoding(String encoding) {
        this.encoding_.setLength(0);
        this.encoding_.append(encoding);
    }

    public String getEncodingAsString() {
        return this.getEncoding().toString();
    }

    public StringBuilder getEncoding() {
        return this.encoding_;
    }

    public void setIsBigendian(byte is_bigendian) {
        this.is_bigendian_ = is_bigendian;
    }

    public byte getIsBigendian() {
        return this.is_bigendian_;
    }

    public void setStep(long step) {
        this.step_ = step;
    }

    public long getStep() {
        return this.step_;
    }

    public byte[] getData() {
        return this.data_;
    }

    public static Supplier<ImagePubSubType> getPubSubType() {
        return ImagePubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return ImagePubSubType::new;
    }

    public boolean epsilonEquals(Image other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.height_, (double)other.height_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.width_, (double)other.width_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.encoding_, (StringBuilder)other.encoding_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.is_bigendian_, (double)other.is_bigendian_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.step_, (double)other.step_, (double)epsilon)) {
            return false;
        }
        for (int i3 = 0; i3 < this.data_.length; ++i3) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.data_[i3], (double)other.data_[i3], (double)epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Image)) {
            return false;
        }
        Image otherMyClass = (Image)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (this.height_ != otherMyClass.height_) {
            return false;
        }
        if (this.width_ != otherMyClass.width_) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.encoding_, (StringBuilder)otherMyClass.encoding_)) {
            return false;
        }
        if (this.is_bigendian_ != otherMyClass.is_bigendian_) {
            return false;
        }
        if (this.step_ != otherMyClass.step_) {
            return false;
        }
        for (int i5 = 0; i5 < this.data_.length; ++i5) {
            if (this.data_[i5] == otherMyClass.data_[i5]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Image {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("height=");
        builder.append(this.height_);
        builder.append(", ");
        builder.append("width=");
        builder.append(this.width_);
        builder.append(", ");
        builder.append("encoding=");
        builder.append((CharSequence)this.encoding_);
        builder.append(", ");
        builder.append("is_bigendian=");
        builder.append(this.is_bigendian_);
        builder.append(", ");
        builder.append("step=");
        builder.append(this.step_);
        builder.append(", ");
        builder.append("data=");
        builder.append(Arrays.toString(this.data_));
        builder.append("}");
        return builder.toString();
    }
}

