/*
 * Decompiled with CFR 0.152.
 */
package tf2_msgs.msg.dds;

import geometry_msgs.msg.dds.TransformStamped;
import geometry_msgs.msg.dds.TransformStampedPubSubType;
import java.io.IOException;
import tf2_msgs.msg.dds.TFMessage;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class TFMessagePubSubType
implements TopicDataType<TFMessage> {
    public static final String name = "tf2_msgs::msg::dds_::TFMessage_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "6feff138edee6fc3c16fdf9ab0b4c9e0b5ea7108ece559b00b28d4dad3fd09d6";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(TFMessage data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        TFMessagePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, TFMessage data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        TFMessagePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return TFMessagePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 100; ++i0) {
            current_alignment += TransformStampedPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(TFMessage data) {
        return TFMessagePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(TFMessage data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getTransforms().size(); ++i0) {
            current_alignment += TransformStampedPubSubType.getCdrSerializedSize((TransformStamped)((Object)data.getTransforms().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(TFMessage data, CDR cdr) {
        if (data.getTransforms().size() > 100) {
            throw new RuntimeException("transforms field exceeds the maximum length: %d > %d".formatted(data.getTransforms().size(), 100));
        }
        cdr.write_type_e(data.getTransforms());
    }

    public static void read(TFMessage data, CDR cdr) {
        cdr.read_type_e(data.getTransforms());
    }

    public final void serialize(TFMessage data, InterchangeSerializer ser) {
        ser.write_type_e("transforms", data.getTransforms());
    }

    public final void deserialize(InterchangeSerializer ser, TFMessage data) {
        ser.read_type_e("transforms", data.getTransforms());
    }

    public static void staticCopy(TFMessage src, TFMessage dest) {
        dest.set(src);
    }

    public TFMessage createData() {
        return new TFMessage();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)TFMessagePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(TFMessage data, CDR cdr) {
        TFMessagePubSubType.write(data, cdr);
    }

    public void deserialize(TFMessage data, CDR cdr) {
        TFMessagePubSubType.read(data, cdr);
    }

    public void copy(TFMessage src, TFMessage dest) {
        TFMessagePubSubType.staticCopy(src, dest);
    }

    public TFMessagePubSubType newInstance() {
        return new TFMessagePubSubType();
    }
}

